/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.source.formatter.XMLSourceProcessor;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.DirectoryScanner;

public class XMLAttributesSorter {
    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        try {
            new XMLAttributesSorter(args);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public XMLAttributesSorter(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String fileName = arguments.get("sort.xml.file.name");
        if (Validator.isNull(fileName) || fileName.startsWith("$")) {
            System.out.println("Specify file name");
            return;
        }
        String basedir = "./";
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(basedir);
        directoryScanner.setIncludes(new String[]{"**\\" + fileName});
        directoryScanner.scan();
        String[] fileNames = directoryScanner.getIncludedFiles();
        if (fileNames.length == 0) {
            System.out.println("No files found with name=" + fileName);
            return;
        }
        for (String fullFileName : fileNames) {
            String newContent;
            File file = new File(basedir + fullFileName);
            fullFileName = StringUtil.replace(fullFileName, "\\", "/");
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            if (content.equals(newContent = XMLSourceProcessor.sortAttributes(content))) continue;
            FileUtils.writeStringToFile((File)file, (String)newContent, (String)"UTF-8");
            System.out.println(fullFileName);
        }
    }
}

