/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.DirectoryScanner;

public class SourceFormatterHelper {
    private final Properties _properties = new Properties();
    private String _propertiesContent = "";
    private File _propertiesFile;
    private final boolean _useProperties;

    public SourceFormatterHelper(boolean useProperties) {
        this._useProperties = useProperties;
    }

    public void close() throws IOException {
        if (!this._useProperties) {
            return;
        }
        String newPropertiesContent = PropertiesUtil.toString(this._properties);
        if (!this._propertiesContent.equals(newPropertiesContent)) {
            FileUtils.writeStringToFile((File)this._propertiesFile, (String)newPropertiesContent, (String)"UTF-8");
        }
    }

    public void init() throws IOException {
        if (!this._useProperties) {
            return;
        }
        File basedirFile = new File("./");
        String basedirAbsolutePath = StringUtil.replace(basedirFile.getAbsolutePath(), new String[]{".", ":", "/", "\\"}, new String[]{"_", "_", "_", "_"});
        String propertiesFileName = System.getProperty("java.io.tmpdir") + "/SourceFormatter." + basedirAbsolutePath;
        this._propertiesFile = new File(propertiesFileName);
        if (this._propertiesFile.exists()) {
            this._propertiesContent = this.readFileToString(this._propertiesFile);
            PropertiesUtil.load(this._properties, this._propertiesContent);
        }
    }

    public void printError(String fileName, File file) {
        this.printError(fileName, file.toString());
    }

    public void printError(String fileName, String message) {
        if (this._useProperties) {
            String encodedFileName = StringUtil.replace(fileName, "\\", "/");
            this._properties.remove(encodedFileName);
        }
        System.out.println(message);
    }

    public String readFileToString(File file) throws IOException {
        String s = FileUtils.readFileToString((File)file, (String)"UTF-8");
        return StringUtil.replace(s, "\r\n", "\n");
    }

    public List<String> scanForFiles(DirectoryScanner directoryScanner) {
        directoryScanner.scan();
        String[] fileNamesArray = directoryScanner.getIncludedFiles();
        if (!this._useProperties) {
            return ListUtil.toList(fileNamesArray);
        }
        ArrayList<String> fileNames = new ArrayList<String>(fileNamesArray.length);
        for (String fileName : fileNamesArray) {
            File file = new File(fileName);
            String encodedFileName = StringUtil.replace(fileName, "\\", "/");
            long timestamp = GetterUtil.getLong(this._properties.getProperty(encodedFileName));
            if (timestamp >= file.lastModified()) continue;
            fileNames.add(fileName);
            this._properties.setProperty(encodedFileName, String.valueOf(file.lastModified()));
        }
        return fileNames;
    }
}

