/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.navigation.site.map.web.internal.display.context;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.LayoutDescription;
import com.liferay.portal.util.LayoutListUtil;
import com.liferay.site.navigation.site.map.web.configuration.SiteNavigationSiteMapPortletInstanceConfiguration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class SiteNavigationSiteMapDisplayContext {
    private Long _displayStyleGroupId;
    private Boolean _includeRootInTree;
    private final HttpServletRequest _request;
    private Layout _rootLayout;
    private Long _rootLayoutId;
    private final SiteNavigationSiteMapPortletInstanceConfiguration _siteNavigationSiteMapPortletInstanceConfiguration;
    private final ThemeDisplay _themeDisplay;

    public SiteNavigationSiteMapDisplayContext(HttpServletRequest request) throws ConfigurationException {
        this._request = request;
        this._themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        this._siteNavigationSiteMapPortletInstanceConfiguration = (SiteNavigationSiteMapPortletInstanceConfiguration)portletDisplay.getPortletInstanceConfiguration(SiteNavigationSiteMapPortletInstanceConfiguration.class);
    }

    public String buildSiteMap() throws Exception {
        StringBundler sb = new StringBundler();
        this._buildSiteMap(this._themeDisplay.getLayout(), this.getRootLayouts(), this.getRootLayout(), this.isIncludeRootInTree(), this._siteNavigationSiteMapPortletInstanceConfiguration.displayDepth(), this._siteNavigationSiteMapPortletInstanceConfiguration.showCurrentPage(), this._siteNavigationSiteMapPortletInstanceConfiguration.useHtmlTitle(), this._siteNavigationSiteMapPortletInstanceConfiguration.showHiddenPages(), 1, this._themeDisplay, sb);
        return sb.toString();
    }

    public Long getDisplayStyleGroupId() {
        if (this._displayStyleGroupId != null) {
            return this._displayStyleGroupId;
        }
        this._displayStyleGroupId = this._siteNavigationSiteMapPortletInstanceConfiguration.displayStyleGroupId();
        Group displayStyleGroup = GroupLocalServiceUtil.fetchGroup((long)this._displayStyleGroupId);
        if (displayStyleGroup == null) {
            this._displayStyleGroupId = this._themeDisplay.getSiteGroupId();
        }
        return this._displayStyleGroupId;
    }

    public List<LayoutDescription> getLayoutDescriptions() {
        Layout layout = this._themeDisplay.getLayout();
        String rootNodeName = "";
        return LayoutListUtil.getLayoutDescriptions((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (String)rootNodeName, (Locale)this._themeDisplay.getLocale());
    }

    public Layout getRootLayout() {
        if (this._rootLayout != null) {
            return this._rootLayout;
        }
        String rootLayoutUuid = this._siteNavigationSiteMapPortletInstanceConfiguration.rootLayoutUuid();
        if (Validator.isNotNull((String)rootLayoutUuid)) {
            Layout layout = this._themeDisplay.getLayout();
            this._rootLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId((String)rootLayoutUuid, (long)this._themeDisplay.getScopeGroupId(), (boolean)layout.isPrivateLayout());
        }
        return this._rootLayout;
    }

    public long getRootLayoutId() {
        if (this._rootLayoutId != null) {
            return this._rootLayoutId;
        }
        Layout rootLayout = this.getRootLayout();
        this._rootLayoutId = Validator.isNotNull((String)this._siteNavigationSiteMapPortletInstanceConfiguration.rootLayoutUuid()) && Validator.isNotNull((Object)rootLayout) ? Long.valueOf(rootLayout.getLayoutId()) : Long.valueOf(0L);
        return this._rootLayoutId;
    }

    public List<Layout> getRootLayouts() {
        Layout layout = this._themeDisplay.getLayout();
        return LayoutLocalServiceUtil.getLayouts((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)this.getRootLayoutId());
    }

    public SiteNavigationSiteMapPortletInstanceConfiguration getSiteNavigationSiteMapPortletInstanceConfiguration() {
        return this._siteNavigationSiteMapPortletInstanceConfiguration;
    }

    public Boolean isIncludeRootInTree() {
        if (this._includeRootInTree != null) {
            return this._includeRootInTree;
        }
        this._includeRootInTree = this._siteNavigationSiteMapPortletInstanceConfiguration.includeRootInTree();
        if (Validator.isNull((String)this._siteNavigationSiteMapPortletInstanceConfiguration.rootLayoutUuid()) || this.getRootLayoutId() == 0L) {
            this._includeRootInTree = false;
        }
        return this._includeRootInTree;
    }

    private void _buildLayoutView(Layout layout, String cssClass, boolean useHtmlTitle, ThemeDisplay themeDisplay, StringBundler sb) throws Exception {
        String layoutURL = PortalUtil.getLayoutURL((Layout)layout, (ThemeDisplay)themeDisplay);
        String target = PortalUtil.getLayoutTarget((Layout)layout);
        sb.append("<a");
        LayoutType layoutType = layout.getLayoutType();
        if (layoutType.isBrowsable()) {
            sb.append(" href=\"");
            sb.append(layoutURL);
            sb.append("\" ");
            sb.append(target);
        }
        if (Validator.isNotNull((String)cssClass)) {
            sb.append(" class=\"");
            sb.append(cssClass);
            sb.append("\" ");
        }
        sb.append("> ");
        String layoutName = HtmlUtil.escape((String)layout.getName(themeDisplay.getLocale()));
        if (useHtmlTitle) {
            layoutName = HtmlUtil.escape((String)layout.getHTMLTitle(themeDisplay.getLocale()));
        }
        sb.append(layoutName);
        sb.append("</a>");
    }

    private void _buildSiteMap(Layout layout, List<Layout> layouts, Layout rootLayout, boolean includeRootInTree, int displayDepth, boolean showCurrentPage, boolean useHtmlTitle, boolean showHiddenPages, int curDepth, ThemeDisplay themeDisplay, StringBundler sb) throws Exception {
        if (layouts.isEmpty()) {
            return;
        }
        if (rootLayout != null && !LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)rootLayout, (String)"VIEW")) {
            return;
        }
        sb.append("<ul>");
        if (includeRootInTree && rootLayout != null && curDepth == 1) {
            sb.append("<li>");
            String cssClass = "root";
            if (rootLayout.getPlid() == layout.getPlid()) {
                cssClass = cssClass + " current";
            }
            this._buildLayoutView(rootLayout, cssClass, useHtmlTitle, themeDisplay, sb);
            this._buildSiteMap(layout, layouts, rootLayout, includeRootInTree, displayDepth, showCurrentPage, useHtmlTitle, showHiddenPages, curDepth + 1, themeDisplay, sb);
            sb.append("</li>");
        } else {
            for (Layout curLayout : layouts) {
                if (!showHiddenPages && curLayout.isHidden() || !LayoutPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Layout)curLayout, (String)"VIEW")) continue;
                sb.append("<li>");
                String cssClass = "";
                if (curLayout.getPlid() == layout.getPlid()) {
                    cssClass = "current";
                }
                this._buildLayoutView(curLayout, cssClass, useHtmlTitle, themeDisplay, sb);
                if (displayDepth == 0 || displayDepth > curDepth) {
                    if (showHiddenPages) {
                        this._buildSiteMap(layout, curLayout.getChildren(), rootLayout, includeRootInTree, displayDepth, showCurrentPage, useHtmlTitle, showHiddenPages, curDepth + 1, themeDisplay, sb);
                    } else {
                        this._buildSiteMap(layout, curLayout.getChildren(themeDisplay.getPermissionChecker()), rootLayout, includeRootInTree, displayDepth, showCurrentPage, useHtmlTitle, showHiddenPages, curDepth + 1, themeDisplay, sb);
                    }
                }
                sb.append("</li>");
            }
        }
        sb.append("</ul>");
    }
}

