/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.extender.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryModel;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.account.service.AccountGroupRelService;
import com.liferay.account.service.AccountRoleLocalService;
import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryLocalService;
import com.liferay.asset.list.util.comparator.ClassNameModelResourceComparator;
import com.liferay.client.extension.service.ClientExtensionEntryLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.fragment.importer.FragmentsImporter;
import com.liferay.headless.admin.list.type.resource.v1_0.ListTypeDefinitionResource;
import com.liferay.headless.admin.list.type.resource.v1_0.ListTypeEntryResource;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyCategoryResource;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyVocabularyResource;
import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.headless.admin.user.dto.v1_0.Organization;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.resource.v1_0.AccountResource;
import com.liferay.headless.admin.user.resource.v1_0.AccountRoleResource;
import com.liferay.headless.admin.user.resource.v1_0.OrganizationResource;
import com.liferay.headless.admin.user.resource.v1_0.UserAccountResource;
import com.liferay.headless.admin.workflow.dto.v1_0.WorkflowDefinition;
import com.liferay.headless.admin.workflow.resource.v1_0.WorkflowDefinitionResource;
import com.liferay.headless.delivery.dto.v1_0.Document;
import com.liferay.headless.delivery.dto.v1_0.DocumentFolder;
import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseArticle;
import com.liferay.headless.delivery.dto.v1_0.KnowledgeBaseFolder;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentFolder;
import com.liferay.headless.delivery.resource.v1_0.DocumentFolderResource;
import com.liferay.headless.delivery.resource.v1_0.DocumentResource;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseArticleResource;
import com.liferay.headless.delivery.resource.v1_0.KnowledgeBaseFolderResource;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentFolderResource;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.layout.importer.LayoutsImporter;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.utility.page.converter.LayoutUtilityPageEntryTypeConverter;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryLocalService;
import com.liferay.list.type.model.ListTypeDefinition;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeDefinitionLocalService;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.notification.rest.dto.v1_0.NotificationTemplate;
import com.liferay.notification.rest.resource.v1_0.NotificationTemplateResource;
import com.liferay.object.admin.rest.dto.v1_0.ObjectField;
import com.liferay.object.admin.rest.dto.v1_0.ObjectRelationship;
import com.liferay.object.admin.rest.dto.v1_0.util.ObjectActionUtil;
import com.liferay.object.admin.rest.resource.v1_0.ObjectDefinitionResource;
import com.liferay.object.admin.rest.resource.v1_0.ObjectFieldResource;
import com.liferay.object.admin.rest.resource.v1_0.ObjectRelationshipResource;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.OrganizationModel;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.language.override.service.PLOEntryLocalService;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.extender.CommerceSiteInitializer;
import com.liferay.site.initializer.extender.SiteInitializerUtil;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemLocalService;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;
import com.liferay.site.navigation.type.SiteNavigationMenuItemType;
import com.liferay.site.navigation.type.SiteNavigationMenuItemTypeRegistry;
import com.liferay.style.book.zip.processor.StyleBookEntryZipProcessor;
import com.liferay.template.model.TemplateEntry;
import com.liferay.template.service.TemplateEntryLocalService;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class BundleSiteInitializer
implements SiteInitializer {
    private static final Log _log = LogFactoryUtil.getLog(BundleSiteInitializer.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private final AccountEntryLocalService _accountEntryLocalService;
    private final AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    private final AccountGroupLocalService _accountGroupLocalService;
    private final AccountGroupRelService _accountGroupRelService;
    private final AccountResource.Factory _accountResourceFactory;
    private final AccountRoleLocalService _accountRoleLocalService;
    private final AccountRoleResource.Factory _accountRoleResourceFactory;
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final AssetListEntryLocalService _assetListEntryLocalService;
    private final Bundle _bundle;
    private final ClassLoader _classLoader;
    private final Map<String, String> _classNameIdStringUtilReplaceValues;
    private final ClientExtensionEntryLocalService _clientExtensionEntryLocalService;
    private CommerceSiteInitializer _commerceSiteInitializer;
    private final ConfigurationProvider _configurationProvider;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final DDMTemplateLocalService _ddmTemplateLocalService;
    private final DefaultDDMStructureHelper _defaultDDMStructureHelper;
    private final DLURLHelper _dlURLHelper;
    private final DocumentFolderResource.Factory _documentFolderResourceFactory;
    private final DocumentResource.Factory _documentResourceFactory;
    private final FragmentsImporter _fragmentsImporter;
    private final GroupLocalService _groupLocalService;
    private final JournalArticleLocalService _journalArticleLocalService;
    private final JSONFactory _jsonFactory;
    private final KnowledgeBaseArticleResource.Factory _knowledgeBaseArticleResourceFactory;
    private final KnowledgeBaseFolderResource.Factory _knowledgeBaseFolderResourceFactory;
    private final LayoutCopyHelper _layoutCopyHelper;
    private final LayoutLocalService _layoutLocalService;
    private final LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    private final LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    private final LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;
    private final LayoutSetLocalService _layoutSetLocalService;
    private final LayoutsImporter _layoutsImporter;
    private final LayoutUtilityPageEntryLocalService _layoutUtilityPageEntryLocalService;
    private final ListTypeDefinitionLocalService _listTypeDefinitionLocalService;
    private final ListTypeDefinitionResource _listTypeDefinitionResource;
    private final ListTypeDefinitionResource.Factory _listTypeDefinitionResourceFactory;
    private final ListTypeEntryLocalService _listTypeEntryLocalService;
    private final ListTypeEntryResource _listTypeEntryResource;
    private final ListTypeEntryResource.Factory _listTypeEntryResourceFactory;
    private final NotificationTemplateResource.Factory _notificationTemplateResourceFactory;
    private final ObjectActionLocalService _objectActionLocalService;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectDefinitionResource.Factory _objectDefinitionResourceFactory;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectEntryManager _objectEntryManager;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectFieldResource.Factory _objectFieldResourceFactory;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final ObjectRelationshipResource.Factory _objectRelationshipResourceFactory;
    private final OrganizationLocalService _organizationLocalService;
    private final OrganizationResource.Factory _organizationResourceFactory;
    private final PLOEntryLocalService _ploEntryLocalService;
    private final Portal _portal;
    private final Map<String, String> _releaseInfoStringUtilReplaceValues;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;
    private final SAPEntryLocalService _sapEntryLocalService;
    private final SegmentsEntryLocalService _segmentsEntryLocalService;
    private final SegmentsExperienceLocalService _segmentsExperienceLocalService;
    private ServletContext _servletContext;
    private final SettingsFactory _settingsFactory;
    private final SiteNavigationMenuItemLocalService _siteNavigationMenuItemLocalService;
    private final SiteNavigationMenuItemTypeRegistry _siteNavigationMenuItemTypeRegistry;
    private final SiteNavigationMenuLocalService _siteNavigationMenuLocalService;
    private final StructuredContentFolderResource.Factory _structuredContentFolderResourceFactory;
    private final StyleBookEntryZipProcessor _styleBookEntryZipProcessor;
    private final TaxonomyCategoryResource.Factory _taxonomyCategoryResourceFactory;
    private final TaxonomyVocabularyResource.Factory _taxonomyVocabularyResourceFactory;
    private final TemplateEntryLocalService _templateEntryLocalService;
    private final ThemeLocalService _themeLocalService;
    private final UserAccountResource.Factory _userAccountResourceFactory;
    private final UserGroupLocalService _userGroupLocalService;
    private final UserLocalService _userLocalService;
    private final WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;
    private final WorkflowDefinitionResource.Factory _workflowDefinitionResourceFactory;

    public BundleSiteInitializer(AccountEntryLocalService accountEntryLocalService, AccountEntryOrganizationRelLocalService accountEntryOrganizationRelLocalService, AccountGroupLocalService accountGroupLocalService, AccountGroupRelService accountGroupRelService, AccountResource.Factory accountResourceFactory, AccountRoleLocalService accountRoleLocalService, AccountRoleResource.Factory accountRoleResourceFactory, AssetCategoryLocalService assetCategoryLocalService, AssetListEntryLocalService assetListEntryLocalService, Bundle bundle, ClientExtensionEntryLocalService clientExtensionEntryLocalService, ConfigurationProvider configurationProvider, DDMStructureLocalService ddmStructureLocalService, DDMTemplateLocalService ddmTemplateLocalService, DefaultDDMStructureHelper defaultDDMStructureHelper, DLURLHelper dlURLHelper, DocumentFolderResource.Factory documentFolderResourceFactory, DocumentResource.Factory documentResourceFactory, FragmentsImporter fragmentsImporter, GroupLocalService groupLocalService, JournalArticleLocalService journalArticleLocalService, JSONFactory jsonFactory, KnowledgeBaseArticleResource.Factory knowledgeBaseArticleResourceFactory, KnowledgeBaseFolderResource.Factory knowledgeBaseFolderResourceFactory, LayoutCopyHelper layoutCopyHelper, LayoutLocalService layoutLocalService, LayoutPageTemplateEntryLocalService layoutPageTemplateEntryLocalService, LayoutsImporter layoutsImporter, LayoutPageTemplateStructureLocalService layoutPageTemplateStructureLocalService, LayoutPageTemplateStructureRelLocalService layoutPageTemplateStructureRelLocalService, LayoutSetLocalService layoutSetLocalService, LayoutUtilityPageEntryLocalService layoutUtilityPageEntryLocalService, ListTypeDefinitionLocalService listTypeDefinitionLocalService, ListTypeDefinitionResource listTypeDefinitionResource, ListTypeDefinitionResource.Factory listTypeDefinitionResourceFactory, ListTypeEntryLocalService listTypeEntryLocalService, ListTypeEntryResource listTypeEntryResource, ListTypeEntryResource.Factory listTypeEntryResourceFactory, NotificationTemplateResource.Factory notificationTemplateResourceFactory, ObjectActionLocalService objectActionLocalService, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectDefinitionResource.Factory objectDefinitionResourceFactory, ObjectEntryLocalService objectEntryLocalService, ObjectEntryManager objectEntryManager, ObjectFieldLocalService objectFieldLocalService, ObjectFieldResource.Factory objectFieldResourceFactory, ObjectRelationshipLocalService objectRelationshipLocalService, ObjectRelationshipResource.Factory objectRelationshipResourceFactory, OrganizationLocalService organizationLocalService, OrganizationResource.Factory organizationResourceFactory, PLOEntryLocalService ploEntryLocalService, Portal portal, ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService, SAPEntryLocalService sapEntryLocalService, SegmentsEntryLocalService segmentsEntryLocalService, SegmentsExperienceLocalService segmentsExperienceLocalService, SettingsFactory settingsFactory, SiteNavigationMenuItemLocalService siteNavigationMenuItemLocalService, SiteNavigationMenuItemTypeRegistry siteNavigationMenuItemTypeRegistry, SiteNavigationMenuLocalService siteNavigationMenuLocalService, StructuredContentFolderResource.Factory structuredContentFolderResourceFactory, StyleBookEntryZipProcessor styleBookEntryZipProcessor, TaxonomyCategoryResource.Factory taxonomyCategoryResourceFactory, TaxonomyVocabularyResource.Factory taxonomyVocabularyResourceFactory, TemplateEntryLocalService templateEntryLocalService, ThemeLocalService themeLocalService, UserAccountResource.Factory userAccountResourceFactory, UserGroupLocalService userGroupLocalService, UserLocalService userLocalService, WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService, WorkflowDefinitionResource.Factory workflowDefinitionResourceFactory) {
        this._accountEntryLocalService = accountEntryLocalService;
        this._accountEntryOrganizationRelLocalService = accountEntryOrganizationRelLocalService;
        this._accountGroupLocalService = accountGroupLocalService;
        this._accountGroupRelService = accountGroupRelService;
        this._accountResourceFactory = accountResourceFactory;
        this._accountRoleLocalService = accountRoleLocalService;
        this._accountRoleResourceFactory = accountRoleResourceFactory;
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._assetListEntryLocalService = assetListEntryLocalService;
        this._bundle = bundle;
        this._clientExtensionEntryLocalService = clientExtensionEntryLocalService;
        this._configurationProvider = configurationProvider;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._ddmTemplateLocalService = ddmTemplateLocalService;
        this._defaultDDMStructureHelper = defaultDDMStructureHelper;
        this._dlURLHelper = dlURLHelper;
        this._documentFolderResourceFactory = documentFolderResourceFactory;
        this._documentResourceFactory = documentResourceFactory;
        this._fragmentsImporter = fragmentsImporter;
        this._groupLocalService = groupLocalService;
        this._journalArticleLocalService = journalArticleLocalService;
        this._jsonFactory = jsonFactory;
        this._knowledgeBaseArticleResourceFactory = knowledgeBaseArticleResourceFactory;
        this._knowledgeBaseFolderResourceFactory = knowledgeBaseFolderResourceFactory;
        this._layoutCopyHelper = layoutCopyHelper;
        this._layoutLocalService = layoutLocalService;
        this._layoutPageTemplateEntryLocalService = layoutPageTemplateEntryLocalService;
        this._layoutsImporter = layoutsImporter;
        this._layoutPageTemplateStructureLocalService = layoutPageTemplateStructureLocalService;
        this._layoutPageTemplateStructureRelLocalService = layoutPageTemplateStructureRelLocalService;
        this._layoutSetLocalService = layoutSetLocalService;
        this._layoutUtilityPageEntryLocalService = layoutUtilityPageEntryLocalService;
        this._listTypeDefinitionLocalService = listTypeDefinitionLocalService;
        this._listTypeDefinitionResource = listTypeDefinitionResource;
        this._listTypeDefinitionResourceFactory = listTypeDefinitionResourceFactory;
        this._listTypeEntryLocalService = listTypeEntryLocalService;
        this._listTypeEntryResource = listTypeEntryResource;
        this._listTypeEntryResourceFactory = listTypeEntryResourceFactory;
        this._notificationTemplateResourceFactory = notificationTemplateResourceFactory;
        this._objectActionLocalService = objectActionLocalService;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectDefinitionResourceFactory = objectDefinitionResourceFactory;
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectEntryManager = objectEntryManager;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectFieldResourceFactory = objectFieldResourceFactory;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._objectRelationshipResourceFactory = objectRelationshipResourceFactory;
        this._organizationLocalService = organizationLocalService;
        this._organizationResourceFactory = organizationResourceFactory;
        this._ploEntryLocalService = ploEntryLocalService;
        this._portal = portal;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
        this._sapEntryLocalService = sapEntryLocalService;
        this._segmentsEntryLocalService = segmentsEntryLocalService;
        this._segmentsExperienceLocalService = segmentsExperienceLocalService;
        this._settingsFactory = settingsFactory;
        this._siteNavigationMenuItemLocalService = siteNavigationMenuItemLocalService;
        this._siteNavigationMenuItemTypeRegistry = siteNavigationMenuItemTypeRegistry;
        this._siteNavigationMenuLocalService = siteNavigationMenuLocalService;
        this._structuredContentFolderResourceFactory = structuredContentFolderResourceFactory;
        this._styleBookEntryZipProcessor = styleBookEntryZipProcessor;
        this._taxonomyCategoryResourceFactory = taxonomyCategoryResourceFactory;
        this._taxonomyVocabularyResourceFactory = taxonomyVocabularyResourceFactory;
        this._templateEntryLocalService = templateEntryLocalService;
        this._themeLocalService = themeLocalService;
        this._userAccountResourceFactory = userAccountResourceFactory;
        this._userGroupLocalService = userGroupLocalService;
        this._userLocalService = userLocalService;
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
        this._workflowDefinitionResourceFactory = workflowDefinitionResourceFactory;
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        this._classLoader = bundleWiring.getClassLoader();
        this._classNameIdStringUtilReplaceValues = this._getClassNameIdStringUtilReplaceValues();
        this._releaseInfoStringUtilReplaceValues = this._getReleaseInfoStringUtilReplaceValues();
    }

    public String getDescription(Locale locale) {
        Dictionary headers = this._bundle.getHeaders("");
        return GetterUtil.getString((String)((String)headers.get("Liferay-Site-Initializer-Description")));
    }

    public String getKey() {
        return this._bundle.getSymbolicName();
    }

    public String getName(Locale locale) {
        Dictionary headers = this._bundle.getHeaders("");
        return GetterUtil.getString((String)((String)headers.get("Liferay-Site-Initializer-Name")), (String)((String)headers.get("Bundle-Name")));
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/thumbnail.png";
    }

    public void initialize(long groupId) throws InitializationException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Commerce site initializer " + this._commerceSiteInitializer));
        }
        long startTime = System.currentTimeMillis();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Initializing ", this.getKey(), " for group ", groupId}));
        }
        try {
            User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
            ServiceContext serviceContextThreadLocal = ServiceContextThreadLocal.getServiceContext();
            ServiceContext serviceContext = (ServiceContext)serviceContextThreadLocal.clone();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setCompanyId(user.getCompanyId());
            serviceContext.setScopeGroupId(groupId);
            serviceContext.setTimeZone(user.getTimeZone());
            serviceContext.setUserId(user.getUserId());
            SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder = new SiteNavigationMenuItemSettingsBuilder();
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addAccountGroups(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addAccounts(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addAccountGroupAssignments(serviceContext)));
            Map ddmStructureEntryIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addOrUpdateDDMStructures(serviceContext));
            Map assetListEntryIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addAssetListEntries(this._ddmStructureLocalService, serviceContext));
            Map documentsStringUtilReplaceValues = (Map)this._invoke(() -> this._addOrUpdateDocuments(serviceContext, siteNavigationMenuItemSettingsBuilder));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addFragmentEntries(assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateExpandoColumns(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateKnowledgeBaseArticles(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateOrganizations(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addAccountsOrganizations(serviceContext)));
            Map roleIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addOrUpdateRoles(serviceContext));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateSAPEntries(serviceContext)));
            Map segmentsEntriesIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addOrUpdateSegmentsEntries(serviceContext));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addSiteConfiguration(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addSiteSettings(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addStyleBookEntries(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateUserGroups(serviceContext)));
            Map taxonomyCategoryIdsAndTaxonomyVocabularyIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addOrUpdateTaxonomyVocabularies(serviceContext, siteNavigationMenuItemSettingsBuilder));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addPortletSettings(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._updateLayoutSets(documentsStringUtilReplaceValues, serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateDDMTemplates(this._ddmStructureLocalService, serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateJournalArticles(this._ddmStructureLocalService, this._ddmTemplateLocalService, documentsStringUtilReplaceValues, serviceContext, siteNavigationMenuItemSettingsBuilder)));
            Map listTypeDefinitionIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addOrUpdateListTypeDefinitions(serviceContext));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addUserAccounts(serviceContext)));
            Map objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addObjectDefinitions(documentsStringUtilReplaceValues, listTypeDefinitionIdsStringUtilReplaceValues, serviceContext, siteNavigationMenuItemSettingsBuilder));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateNotificationTemplates(documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, serviceContext)));
            Map layoutsMap = (Map)this._invoke(() -> this._addOrUpdateLayouts(serviceContext));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addCPDefinitions(documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addLayoutPageTemplates(assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, serviceContext, taxonomyCategoryIdsAndTaxonomyVocabularyIdsStringUtilReplaceValues)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addLayoutUtilityPageEntries(assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, serviceContext, taxonomyCategoryIdsAndTaxonomyVocabularyIdsStringUtilReplaceValues)));
            Map clientExtensionEntryIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addOrUpdateClientExtensionEntries(documentsStringUtilReplaceValues, serviceContext));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addLayoutsContent(assetListEntryIdsStringUtilReplaceValues, clientExtensionEntryIdsStringUtilReplaceValues, ddmStructureEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, layoutsMap, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, serviceContext, siteNavigationMenuItemSettingsBuilder.build(), taxonomyCategoryIdsAndTaxonomyVocabularyIdsStringUtilReplaceValues)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addRolesAssignments(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addSegmentsExperiences(assetListEntryIdsStringUtilReplaceValues, clientExtensionEntryIdsStringUtilReplaceValues, ddmStructureEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, segmentsEntriesIdsStringUtilReplaceValues, serviceContext, taxonomyCategoryIdsAndTaxonomyVocabularyIdsStringUtilReplaceValues)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addUserRoles(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addWorkflowDefinitions(roleIdsStringUtilReplaceValues, serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateResourcePermissions(objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._setPLOEntries(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._updateGroupSiteInitializerKey(groupId)));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            throw new InitializationException((Throwable)exception);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Initialized ", this.getKey(), " for group ", groupId, " in ", System.currentTimeMillis() - startTime, " ms"}));
        }
    }

    public boolean isActive(long companyId) {
        Dictionary headers = this._bundle.getHeaders("");
        String featureFlag = (String)headers.get("Liferay-Site-Initializer-Feature-Flag");
        return !Validator.isNotNull((String)featureFlag) || FeatureFlagManagerUtil.isEnabled((String)featureFlag);
    }

    protected void setCommerceSiteInitializer(CommerceSiteInitializer commerceSiteInitializer) {
        this._commerceSiteInitializer = commerceSiteInitializer;
    }

    protected void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    private void _addAccountGroupAssignments(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/account-group-assignments.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            AccountGroup accountGroup;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONArray accountsJSONArray = jsonObject.getJSONArray("accounts");
            if (JSONUtil.isEmpty((JSONArray)accountsJSONArray)) continue;
            ArrayList<AccountEntry> accountEntries = new ArrayList<AccountEntry>();
            for (int j = 0; j < accountsJSONArray.length(); ++j) {
                accountEntries.add(this._accountEntryLocalService.getAccountEntryByExternalReferenceCode(accountsJSONArray.getString(j), serviceContext.getCompanyId()));
            }
            if (ListUtil.isEmpty(accountEntries) || (accountGroup = this._accountGroupLocalService.fetchAccountGroupByExternalReferenceCode(jsonObject.getString("accountGroupExternalReferenceCode"), serviceContext.getCompanyId())) == null) continue;
            this._accountGroupRelService.addAccountGroupRels(accountGroup.getAccountGroupId(), AccountEntry.class.getName(), ListUtil.toLongArray(accountEntries, AccountEntryModel::getAccountEntryId));
        }
    }

    private void _addAccountGroups(ServiceContext serviceContext) throws Exception {
        if (this._commerceSiteInitializer == null) {
            return;
        }
        this._commerceSiteInitializer.addAccountGroups(serviceContext, this._servletContext);
    }

    private void _addAccounts(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/accounts.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        AccountResource.Builder builder = this._accountResourceFactory.create();
        AccountResource accountResource = builder.user(serviceContext.fetchUser()).build();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            Account account = Account.toDTO((String)String.valueOf(jsonArray.getJSONObject(i)));
            if (account == null) {
                _log.error((Object)("Unable to transform account from JSON: " + json));
                continue;
            }
            accountResource.putAccountByExternalReferenceCode(account.getExternalReferenceCode(), account);
        }
    }

    private void _addAccountsOrganizations(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/accounts-organizations.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            AccountEntry accountEntry;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONArray organizationJSONArray = jsonObject.getJSONArray("organizations");
            if (JSONUtil.isEmpty((JSONArray)organizationJSONArray)) continue;
            ArrayList<com.liferay.portal.kernel.model.Organization> organizations = new ArrayList<com.liferay.portal.kernel.model.Organization>();
            for (int j = 0; j < organizationJSONArray.length(); ++j) {
                organizations.add(this._organizationLocalService.getOrganizationByExternalReferenceCode(organizationJSONArray.getString(j), serviceContext.getCompanyId()));
            }
            if (ListUtil.isEmpty(organizations) || (accountEntry = this._accountEntryLocalService.getAccountEntryByExternalReferenceCode(jsonObject.getString("accountExternalReferenceCode"), serviceContext.getCompanyId())) == null) continue;
            this._accountEntryOrganizationRelLocalService.addAccountEntryOrganizationRels(accountEntry.getAccountEntryId(), ListUtil.toLongArray(organizations, OrganizationModel::getOrganizationId));
        }
    }

    private Map<String, String> _addAssetListEntries(DDMStructureLocalService ddmStructureLocalService, ServiceContext serviceContext) throws Exception {
        HashMap<String, String> assetListEntryIdsStringUtilReplaceValues = new HashMap<String, String>();
        String json = SiteInitializerUtil.read((String)"/site-initializer/asset-list-entries.json", (ServletContext)this._servletContext);
        if (json == null) {
            return assetListEntryIdsStringUtilReplaceValues;
        }
        JSONArray assetListJSONArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < assetListJSONArray.length(); ++i) {
            JSONObject assetListJSONObject = assetListJSONArray.getJSONObject(i);
            this._addOrUpdateAssetListEntry(assetListJSONObject, ddmStructureLocalService, serviceContext);
        }
        List assetListEntries = this._assetListEntryLocalService.getAssetListEntries(serviceContext.getScopeGroupId());
        for (AssetListEntry assetListEntry : assetListEntries) {
            String assetListEntryKeyUppercase = StringUtil.toUpperCase((String)assetListEntry.getAssetListEntryKey());
            assetListEntryIdsStringUtilReplaceValues.put("ASSET_LIST_ENTRY_ID:" + assetListEntryKeyUppercase, String.valueOf(assetListEntry.getAssetListEntryId()));
        }
        return assetListEntryIdsStringUtilReplaceValues;
    }

    private void _addCPDefinitions(Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        if (this._commerceSiteInitializer == null) {
            return;
        }
        this._commerceSiteInitializer.addCPDefinitions(this._bundle, documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, serviceContext, this._servletContext);
    }

    private void _addFragmentEntries(Map<String, String> assetListEntryIdsStringUtilReplaceValues, Map<String, String> documentsStringUtilReplaceValues, long groupId, String parentResourcePath, ServiceContext serviceContext) throws Exception {
        Enumeration enumeration = this._bundle.findEntries(parentResourcePath, "*", true);
        if (enumeration == null) {
            return;
        }
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            String fileName = url.getFile();
            if (fileName.endsWith("/")) continue;
            if (StringUtil.endsWith((String)fileName, (String)"fragment-composition-definition.json")) {
                String json = StringUtil.read((InputStream)url.openStream());
                json = this._replace(this._replace(json, serviceContext), assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues);
                zipWriter.addEntry(this._removeFirst(fileName, parentResourcePath), json);
                continue;
            }
            zipWriter.addEntry(this._removeFirst(fileName, parentResourcePath), url.openStream());
        }
        this._fragmentsImporter.importFragmentEntries(serviceContext.getUserId(), groupId, 0L, zipWriter.getFile(), true);
    }

    private void _addFragmentEntries(Map<String, String> assetListEntryIdsStringUtilReplaceValues, Map<String, String> documentsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        Group group = this._groupLocalService.getCompanyGroup(serviceContext.getCompanyId());
        this._addFragmentEntries(assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, group.getGroupId(), "/site-initializer/fragments/company", serviceContext);
        this._addFragmentEntries(assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, serviceContext.getScopeGroupId(), "/site-initializer/fragments/group", serviceContext);
    }

    private void _addLayoutContent(Map<String, String> assetListEntryIdsStringUtilReplaceValues, Map<String, String> clientExtensionEntryIdsStringUtilReplaceValues, Map<String, String> ddmStructureEntryIdsStringUtilReplaceValues, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, Layout layout, String resourcePath, long segmentsExperienceId, ServiceContext serviceContext, Map<String, String> taxonomyCategoryIdsStringUtilReplaceValues) throws Exception {
        JSONArray jsonArray;
        JSONObject pageElementJSONObject;
        String json;
        JSONObject pageJSONObject = this._jsonFactory.createJSONObject(SiteInitializerUtil.read((String)(resourcePath + "page.json"), (ServletContext)this._servletContext));
        String type = StringUtil.toLowerCase((String)pageJSONObject.getString("type"));
        if (Objects.equals(type, "url")) {
            return;
        }
        if (Objects.equals(type, "widget")) {
            type = "portlet";
        }
        if ((json = SiteInitializerUtil.read((String)(resourcePath + "page-definition.json"), (ServletContext)this._servletContext)) == null) {
            return;
        }
        json = this._replace(this._replace(json, serviceContext), assetListEntryIdsStringUtilReplaceValues, clientExtensionEntryIdsStringUtilReplaceValues, ddmStructureEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, taxonomyCategoryIdsStringUtilReplaceValues);
        JSONObject pageDefinitionJSONObject = this._jsonFactory.createJSONObject(json);
        Layout draftLayout = layout.fetchDraftLayout();
        if ((Objects.equals(type, "collection") || Objects.equals(type, "content")) && (pageElementJSONObject = pageDefinitionJSONObject.getJSONObject("pageElement")) != null && Objects.equals(pageElementJSONObject.getString("type"), "Root") && !JSONUtil.isEmpty((JSONArray)(jsonArray = pageElementJSONObject.getJSONArray("pageElements")))) {
            LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(draftLayout.getGroupId(), draftLayout.getPlid(), true);
            LayoutStructure layoutStructure = null;
            if (segmentsExperienceId == 0L) {
                layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getDefaultSegmentsExperienceData());
                segmentsExperienceId = this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(draftLayout.getPlid());
            } else {
                layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(segmentsExperienceId));
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                this._layoutsImporter.importPageElement(draftLayout, layoutStructure, layoutStructure.getMainItemId(), jsonArray.getString(i), i, segmentsExperienceId);
            }
        }
        if (Objects.equals(type, "collection")) {
            Object[] typeSettings;
            UnicodeProperties unicodeProperties = draftLayout.getTypeSettingsProperties();
            for (Object typeSetting : typeSettings = JSONUtil.toObjectArray((JSONArray)pageJSONObject.getJSONArray("typeSettings"))) {
                JSONObject typeSettingJSONObject = (JSONObject)typeSetting;
                String key = typeSettingJSONObject.getString("key");
                String value = typeSettingJSONObject.getString("value");
                unicodeProperties.put(key, this._replace(value, assetListEntryIdsStringUtilReplaceValues));
            }
            draftLayout = this._layoutLocalService.updateLayout(serviceContext.getScopeGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), unicodeProperties.toString());
        }
        if (Objects.equals(type, "collection") || Objects.equals(type, "content")) {
            JSONObject settingsJSONObject = pageDefinitionJSONObject.getJSONObject("settings");
            if (settingsJSONObject != null) {
                draftLayout = this._updateDraftLayout(draftLayout, settingsJSONObject);
            }
            layout = this._layoutCopyHelper.copyLayoutContent(draftLayout, layout);
            this._layoutLocalService.updateStatus(layout.getUserId(), draftLayout.getPlid(), 0, serviceContext);
            this._layoutLocalService.updateStatus(layout.getUserId(), layout.getPlid(), 0, serviceContext);
        }
    }

    private void _addLayoutPageTemplates(Map<String, String> assetListEntryIdsStringUtilReplaceValues, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, ServiceContext serviceContext, Map<String, String> taxonomyCategoryIdsStringUtilReplaceValues) throws Exception {
        Enumeration enumeration = this._bundle.findEntries("/site-initializer/layout-page-templates", "*", true);
        if (enumeration == null) {
            return;
        }
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            String fileName = url.getFile();
            if (fileName.endsWith("/")) continue;
            String urlPath = url.getPath();
            if (StringUtil.endsWith((String)urlPath, (String)"display-page-template.json") || StringUtil.endsWith((String)urlPath, (String)"page-definition.json")) {
                String json = StringUtil.read((InputStream)url.openStream());
                json = this._replace(this._replace(json, serviceContext), assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, taxonomyCategoryIdsStringUtilReplaceValues);
                String css = this._replace(SiteInitializerUtil.read((String)(FileUtil.getPath((String)urlPath) + "/css.css"), (ServletContext)this._servletContext), documentsStringUtilReplaceValues);
                if (Validator.isNotNull((String)css)) {
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
                    JSONObject settingsJSONObject = jsonObject.getJSONObject("settings");
                    settingsJSONObject.put("css", css);
                    jsonObject.put("settings", settingsJSONObject);
                    json = jsonObject.toString();
                }
                zipWriter.addEntry(this._removeFirst(urlPath, "/site-initializer/layout-page-templates"), json);
                continue;
            }
            zipWriter.addEntry(this._removeFirst(urlPath, "/site-initializer/layout-page-templates"), url.openStream());
        }
        this._layoutsImporter.importFile(serviceContext.getUserId(), serviceContext.getScopeGroupId(), zipWriter.getFile(), true);
    }

    private void _addLayoutsContent(Map<String, String> assetListEntryIdsStringUtilReplaceValues, Map<String, String> clientExtensionEntryIdsStringUtilReplaceValues, Map<String, String> ddmStructureEntryIdsStringUtilReplaceValues, Map<String, String> documentsStringUtilReplaceValues, Map<String, Layout> layouts, Map<String, String> objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, ServiceContext serviceContext, Map<String, SiteNavigationMenuItemSetting> siteNavigationMenuItemSettings, Map<String, String> taxonomyCategoryIdsStringUtilReplaceValues) throws Exception {
        for (Map.Entry<String, Layout> entry : layouts.entrySet()) {
            this._addLayoutContent(assetListEntryIdsStringUtilReplaceValues, clientExtensionEntryIdsStringUtilReplaceValues, ddmStructureEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, entry.getValue(), entry.getKey(), 0L, serviceContext, taxonomyCategoryIdsStringUtilReplaceValues);
        }
        this._siteNavigationMenuLocalService.deleteSiteNavigationMenus(serviceContext.getScopeGroupId());
        this._addSiteNavigationMenus(serviceContext, siteNavigationMenuItemSettings);
    }

    private void _addLayoutUtilityPageEntries(Map<String, String> assetListEntryIdsStringUtilReplaceValues, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, ServiceContext serviceContext, Map<String, String> taxonomyCategoryIdsStringUtilReplaceValues) throws Exception {
        Enumeration enumeration = this._bundle.findEntries("/site-initializer/layout-utility-page-entries", "*", true);
        if (enumeration == null) {
            return;
        }
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            String fileName = url.getFile();
            if (fileName.endsWith("/")) continue;
            String urlPath = url.getPath();
            if (StringUtil.endsWith((String)urlPath, (String)"page-definition.json")) {
                String json = StringUtil.read((InputStream)url.openStream());
                json = this._replace(this._replace(json, serviceContext), assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, taxonomyCategoryIdsStringUtilReplaceValues);
                String css = this._replace(SiteInitializerUtil.read((String)(FileUtil.getPath((String)urlPath) + "/css.css"), (ServletContext)this._servletContext), documentsStringUtilReplaceValues);
                if (Validator.isNotNull((String)css)) {
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
                    JSONObject settingsJSONObject = jsonObject.getJSONObject("settings");
                    settingsJSONObject.put("css", css);
                    jsonObject.put("settings", settingsJSONObject);
                    json = jsonObject.toString();
                }
                zipWriter.addEntry(this._removeFirst(urlPath, "/site-initializer/layout-utility-page-entries"), json);
                continue;
            }
            zipWriter.addEntry(this._removeFirst(urlPath, "/site-initializer/layout-utility-page-entries"), url.openStream());
        }
        this._layoutsImporter.importFile(serviceContext.getUserId(), serviceContext.getScopeGroupId(), zipWriter.getFile(), true);
        this._setDefaultLayoutUtilityPageEntries(serviceContext);
    }

    private Map<String, String> _addObjectDefinitions(Map<String, String> documentsStringUtilReplaceValues, Map<String, String> listTypeDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        HashMap<String, String> objectDefinitionIdsStringUtilReplaceValues = new HashMap<String, String>();
        List serviceBuilderObjectDefinitions = this._objectDefinitionLocalService.getObjectDefinitions(serviceContext.getCompanyId(), true, 0);
        for (ObjectDefinition serviceBuilderObjectDefinition : serviceBuilderObjectDefinitions) {
            objectDefinitionIdsStringUtilReplaceValues.put("OBJECT_DEFINITION_ID:" + serviceBuilderObjectDefinition.getShortName(), String.valueOf(serviceBuilderObjectDefinition.getObjectDefinitionId()));
        }
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/object-definitions");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return objectDefinitionIdsStringUtilReplaceValues;
        }
        HashMap<String, com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition> accountEntryRestrictedObjectDefinitions = new HashMap<String, com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition>();
        ObjectDefinitionResource.Builder objectDefinitionResourceBuilder = this._objectDefinitionResourceFactory.create();
        ObjectDefinitionResource objectDefinitionResource = objectDefinitionResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String string : resourcePaths) {
            String objectActionsJSON;
            if (string.endsWith(".object-actions.json")) continue;
            String json = SiteInitializerUtil.read((String)string, (ServletContext)this._servletContext);
            com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition objectDefinition = com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition.toDTO((String)(json = this._replace(json, listTypeDefinitionIdsStringUtilReplaceValues)));
            if (objectDefinition == null) {
                _log.error((Object)("Unable to transform object definition from JSON: " + json));
                continue;
            }
            Page objectDefinitionsPage = objectDefinitionResource.getObjectDefinitionsPage(null, null, objectDefinitionResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", objectDefinition.getName(), "'"})), null, null);
            com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition existingObjectDefinition = (com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition)objectDefinitionsPage.fetchFirstItem();
            if (existingObjectDefinition == null) {
                if (GetterUtil.getBoolean((Object)objectDefinition.getAccountEntryRestricted())) {
                    accountEntryRestrictedObjectDefinitions.put(objectDefinition.getName(), objectDefinition);
                }
                objectDefinition = objectDefinitionResource.postObjectDefinition(objectDefinition);
                objectDefinitionResource.postObjectDefinitionPublish(objectDefinition.getId());
            } else {
                objectDefinition = objectDefinitionResource.patchObjectDefinition(existingObjectDefinition.getId(), objectDefinition);
            }
            objectDefinitionIdsStringUtilReplaceValues.put("OBJECT_DEFINITION_ID:" + objectDefinition.getName(), String.valueOf(objectDefinition.getId()));
            if (Objects.equals(objectDefinition.getScope(), "company") && existingObjectDefinition != null || (objectActionsJSON = SiteInitializerUtil.read((String)StringUtil.replaceLast((String)string, (String)".json", (String)".object-actions.json"), (ServletContext)this._servletContext)) == null) continue;
            JSONArray jsonArray = this._jsonFactory.createJSONArray(objectActionsJSON);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                JSONObject parametersJSONObject = jsonObject.getJSONObject("parameters");
                this._objectActionLocalService.addOrUpdateObjectAction(jsonObject.getString("externalReferenceCode"), 0L, serviceContext.getUserId(), objectDefinition.getId().longValue(), jsonObject.getBoolean("active"), jsonObject.getString("conditionExpression"), jsonObject.getString("description"), SiteInitializerUtil.toMap((String)jsonObject.getString("errorMessage")), SiteInitializerUtil.toMap((String)jsonObject.getString("label")), jsonObject.getString("name"), jsonObject.getString("objectActionExecutorKey"), jsonObject.getString("objectActionTriggerKey"), ObjectActionUtil.toParametersUnicodeProperties((Map)parametersJSONObject.toMap()));
            }
        }
        this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateObjectRelationships(objectDefinitionIdsStringUtilReplaceValues, serviceContext)));
        for (Map.Entry entry : accountEntryRestrictedObjectDefinitions.entrySet()) {
            ObjectDefinition serviceBuilderObjectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(serviceContext.getCompanyId(), "C_" + (String)entry.getKey());
            this._objectDefinitionLocalService.enableAccountEntryRestricted(this._objectRelationshipLocalService.getObjectRelationshipByObjectDefinitionId(serviceBuilderObjectDefinition.getObjectDefinitionId(), "accountEntryTo" + serviceBuilderObjectDefinition.getShortName()));
        }
        this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addOrUpdateObjectFields(listTypeDefinitionIdsStringUtilReplaceValues, objectDefinitionIdsStringUtilReplaceValues, serviceContext)));
        Map objectEntryIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addOrUpdateObjectEntries(documentsStringUtilReplaceValues, serviceContext, siteNavigationMenuItemSettingsBuilder));
        return HashMapBuilder.putAll(objectDefinitionIdsStringUtilReplaceValues).putAll(objectEntryIdsStringUtilReplaceValues).build();
    }

    private void _addOrganizationUser(JSONArray jsonArray, ServiceContext serviceContext, long userId) throws Exception {
        if (JSONUtil.isEmpty((JSONArray)jsonArray)) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            long organizationId = this._organizationLocalService.getOrganizationId(serviceContext.getCompanyId(), jsonObject.getString("name"));
            if (organizationId <= 0L) continue;
            this._userLocalService.addOrganizationUser(organizationId, userId);
        }
    }

    private void _addOrKnowledgeBaseObjects(boolean folder, long parentKnowledgeBaseObjectId, String parentResourcePath, ServiceContext serviceContext) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths(parentResourcePath);
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            String json;
            if (!resourcePath.endsWith(".metadata.json") || (json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)this._servletContext)) == null) continue;
            JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
            if (jsonObject.has("articleBody")) {
                this._addOrUpdateKnowledgeBaseArticle(folder, jsonObject, parentKnowledgeBaseObjectId, resourcePath.substring(0, resourcePath.indexOf(".metadata.json")), serviceContext);
                continue;
            }
            this._addOrUpdateKnowledgeBaseFolder(jsonObject, parentKnowledgeBaseObjectId, resourcePath.substring(0, resourcePath.indexOf(".metadata.json")), serviceContext);
        }
    }

    private void _addOrUpdateAssetListEntry(JSONObject assetListJSONObject, DDMStructureLocalService ddmStructureLocalService, ServiceContext serviceContext) throws Exception {
        Object[] orderByObjects;
        AssetListEntry assetListEntry = null;
        String assetListEntryKey = StringUtil.toLowerCase((String)this._replace(assetListJSONObject.getString("title"), " ", "-"));
        for (AssetListEntry curAssetListEntry : this._assetListEntryLocalService.getAssetListEntries(serviceContext.getScopeGroupId())) {
            if (!Objects.equals(curAssetListEntry.getAssetListEntryKey(), assetListEntryKey)) continue;
            assetListEntry = curAssetListEntry;
            break;
        }
        JSONObject unicodePropertiesJSONObject = assetListJSONObject.getJSONObject("unicodeProperties");
        DDMStructure ddmStructure = ddmStructureLocalService.getStructure(serviceContext.getScopeGroupId(), this._portal.getClassNameId(unicodePropertiesJSONObject.getString("classNameIds")), assetListJSONObject.getString("ddmStructureKey"));
        ArrayList classNameIdStrings = new ArrayList();
        List classNameIds = ListUtil.fromArray((long[])AssetRendererFactoryRegistryUtil.getIndexableClassNameIds((long)serviceContext.getCompanyId(), (boolean)true));
        classNameIds = ListUtil.sort((List)classNameIds, (Comparator)new ClassNameModelResourceComparator(true, serviceContext.getLocale()));
        classNameIds.forEach(classNameId -> classNameIdStrings.add(classNameId.toString()));
        HashMap map = HashMapBuilder.put((Object)"anyAssetType", (Object)String.valueOf(this._portal.getClassNameId(unicodePropertiesJSONObject.getString("classNameIds")))).put((Object)unicodePropertiesJSONObject.getString("anyClassType"), (Object)String.valueOf(ddmStructure.getStructureId())).put((Object)"classNameIds", (Object)StringUtil.merge(classNameIdStrings, (String)",")).put((Object)unicodePropertiesJSONObject.getString("classTypeIds"), (Object)String.valueOf(ddmStructure.getStructureId())).put((Object)"groupIds", (Object)String.valueOf(serviceContext.getScopeGroupId())).build();
        for (Object orderByObject : orderByObjects = JSONUtil.toObjectArray((JSONArray)unicodePropertiesJSONObject.getJSONArray("orderBy"))) {
            JSONObject orderByJSONObject = (JSONObject)orderByObject;
            map.put(orderByJSONObject.getString("key"), orderByJSONObject.getString("value"));
        }
        String[] assetTagNames = JSONUtil.toStringArray((JSONArray)assetListJSONObject.getJSONArray("assetTagNames"));
        for (int i = 0; i < assetTagNames.length; ++i) {
            Object[] queryObjects;
            map.put("queryValues" + i, assetTagNames[i]);
            for (Object queryObject : queryObjects = JSONUtil.toObjectArray((JSONArray)unicodePropertiesJSONObject.getJSONArray("query"))) {
                JSONObject queryJSONObject = (JSONObject)queryObject;
                map.put(queryJSONObject.getString("key"), queryJSONObject.getString("value"));
            }
        }
        if (assetListEntry == null) {
            this._assetListEntryLocalService.addDynamicAssetListEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), assetListJSONObject.getString("title"), UnicodePropertiesBuilder.create((Map)map, (boolean)true).buildString(), serviceContext);
        } else {
            this._assetListEntryLocalService.updateAssetListEntry(assetListEntry.getAssetListEntryId(), assetListJSONObject.getString("title"));
        }
    }

    private Map<String, String> _addOrUpdateClientExtensionEntries(Map<String, String> documentsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        HashMap<String, String> clientExtensionEntryIdsStringUtilReplaceValues = new HashMap<String, String>();
        String json = SiteInitializerUtil.read((String)"/site-initializer/client-extension-entries.json", (ServletContext)this._servletContext);
        if (json == null) {
            return clientExtensionEntryIdsStringUtilReplaceValues;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            StringBundler sb = new StringBundler();
            JSONObject propertiesJSONObject = jsonObject.getJSONObject("properties");
            if (propertiesJSONObject != null) {
                for (String key : propertiesJSONObject.keySet()) {
                    sb.append(key);
                    sb.append("=");
                    sb.append(propertiesJSONObject.getString(key));
                    sb.append("\n");
                }
            }
            this._clientExtensionEntryLocalService.addOrUpdateClientExtensionEntry(jsonObject.getString("externalReferenceCode"), serviceContext.getUserId(), "", SiteInitializerUtil.toMap((String)jsonObject.getString("name_i18n")), sb.toString(), "", "customElement", UnicodePropertiesBuilder.create((boolean)true).put("cssURLs", this._replace(StringUtil.merge((Object[])JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("cssURLs")), (String)"\n"), documentsStringUtilReplaceValues)).put("friendlyURLMapping", "").put("htmlElementName", jsonObject.getString("htmlElementName")).put("instanceable", jsonObject.getBoolean("instanceable")).put("portletCategoryName", jsonObject.getString("portletCategoryName")).put("urls", this._replace(StringUtil.merge((Object[])JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("elementURLs")), (String)"\n"), documentsStringUtilReplaceValues)).put("useESM", jsonObject.getBoolean("useESM", false)).buildString());
            clientExtensionEntryIdsStringUtilReplaceValues.put("CLIENT_EXTENSION_ENTRY_ID:" + jsonObject.getString("clientExtensionEntryKey"), this._replace(jsonObject.getString("widgetName"), StringBundler.concat((String[])new String[]{"[$CLIENT_EXTENSION_ENTRY_ID:", jsonObject.getString("clientExtensionEntryKey"), "$]"}), serviceContext.getCompanyId() + "_" + jsonObject.getString("externalReferenceCode")));
        }
        return clientExtensionEntryIdsStringUtilReplaceValues;
    }

    private Map<String, String> _addOrUpdateDDMStructures(ServiceContext serviceContext) throws Exception {
        HashMap<String, String> ddmStructuresIdsStringUtilReplaceValues = new HashMap<String, String>();
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/ddm-structures");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return ddmStructuresIdsStringUtilReplaceValues;
        }
        for (String resourcePath : resourcePaths) {
            this._defaultDDMStructureHelper.addOrUpdateDDMStructures(serviceContext.getUserId(), serviceContext.getScopeGroupId(), this._portal.getClassNameId(JournalArticle.class), this._classLoader, resourcePath, serviceContext);
        }
        List ddmStructures = this._ddmStructureLocalService.getStructures(serviceContext.getScopeGroupId());
        for (DDMStructure ddmStructure : ddmStructures) {
            ddmStructuresIdsStringUtilReplaceValues.put("DDM_STRUCTURE_ID:" + ddmStructure.getStructureKey(), String.valueOf(ddmStructure.getStructureId()));
        }
        return ddmStructuresIdsStringUtilReplaceValues;
    }

    private void _addOrUpdateDDMTemplates(DDMStructureLocalService ddmStructureLocalService, ServiceContext serviceContext) throws Exception {
        Enumeration enumeration = this._bundle.findEntries("/site-initializer/ddm-templates", "ddm-template.json", true);
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            DDMTemplate ddmTemplate;
            URL url = (URL)enumeration.nextElement();
            JSONObject jsonObject = this._jsonFactory.createJSONObject(StringUtil.read((InputStream)url.openStream()));
            long resourceClassNameId = this._portal.getClassNameId(jsonObject.getString("resourceClassName", JournalArticle.class.getName()));
            long ddmStructureId = 0L;
            String ddmStructureKey = jsonObject.getString("ddmStructureKey");
            if (Validator.isNotNull((String)ddmStructureKey)) {
                DDMStructure ddmStructure = ddmStructureLocalService.fetchStructure(serviceContext.getScopeGroupId(), resourceClassNameId, ddmStructureKey);
                ddmStructureId = ddmStructure.getStructureId();
            }
            if ((ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(serviceContext.getScopeGroupId(), this._portal.getClassNameId(jsonObject.getString("className", DDMStructure.class.getName())), jsonObject.getString("ddmTemplateKey"))) == null) {
                ddmTemplate = this._ddmTemplateLocalService.addTemplate(serviceContext.getUserId(), serviceContext.getScopeGroupId(), this._portal.getClassNameId(jsonObject.getString("className", DDMStructure.class.getName())), ddmStructureId, resourceClassNameId, jsonObject.getString("ddmTemplateKey"), (Map)HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)jsonObject.getString("name")).build(), null, "display", null, "ftl", SiteInitializerUtil.read((Bundle)this._bundle, (String)"ddm-template.ftl", (URL)url), false, false, null, null, serviceContext);
                if (!Objects.equals(jsonObject.getString("className"), TemplateEntry.class.getName())) continue;
                this._templateEntryLocalService.addTemplateEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), ddmTemplate.getTemplateId(), jsonObject.getString("infoItemClassName"), jsonObject.getString("infoItemKey"), serviceContext);
                continue;
            }
            this._ddmTemplateLocalService.updateTemplate(serviceContext.getUserId(), ddmTemplate.getTemplateId(), ddmStructureId, (Map)HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)jsonObject.getString("name")).build(), null, "display", null, "ftl", SiteInitializerUtil.read((Bundle)this._bundle, (String)"ddm-template.ftl", (URL)url), false, false, null, null, serviceContext);
        }
    }

    private Long _addOrUpdateDocumentFolder(Long documentFolderId, long groupId, String resourcePath, ServiceContext serviceContext) throws Exception {
        DocumentFolderResource.Builder documentFolderResourceBuilder = this._documentFolderResourceFactory.create();
        DocumentFolderResource documentFolderResource = documentFolderResourceBuilder.user(serviceContext.fetchUser()).build();
        DocumentFolder documentFolder = null;
        String json = SiteInitializerUtil.read((String)((resourcePath = resourcePath.substring(0, resourcePath.length() - 1)) + ".metadata.json"), (ServletContext)this._servletContext);
        documentFolder = json != null ? DocumentFolder.toDTO((String)json) : DocumentFolder.toDTO((String)JSONUtil.put((String)"name", (Object)FileUtil.getShortFileName((String)resourcePath)).put("viewableBy", "Anyone").toString());
        Page documentFoldersPage = documentFolderResource.getSiteDocumentFoldersPage(Long.valueOf(groupId), Boolean.valueOf(true), null, null, documentFolderResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", documentFolder.getName(), "'"})), null, null);
        DocumentFolder existingDocumentFolder = (DocumentFolder)documentFoldersPage.fetchFirstItem();
        documentFolder = existingDocumentFolder == null ? (documentFolderId != null ? documentFolderResource.postDocumentFolderDocumentFolder(documentFolderId, documentFolder) : documentFolderResource.postSiteDocumentFolder(Long.valueOf(groupId), documentFolder)) : documentFolderResource.putDocumentFolder(existingDocumentFolder.getId(), documentFolder);
        return documentFolder.getId();
    }

    private Map<String, String> _addOrUpdateDocuments(Long documentFolderId, long groupId, String parentResourcePath, final ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        HashMap<String, String> documentsStringUtilReplaceValues = new HashMap<String, String>();
        Set resourcePaths = this._servletContext.getResourcePaths(parentResourcePath);
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return documentsStringUtilReplaceValues;
        }
        DocumentResource.Builder documentResourceBuilder = this._documentResourceFactory.create();
        DocumentResource documentResource = documentResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            Page documentsPage;
            Document existingDocument;
            if (resourcePath.endsWith("/")) {
                documentsStringUtilReplaceValues.putAll(this._addOrUpdateDocuments(this._addOrUpdateDocumentFolder(documentFolderId, groupId, resourcePath, serviceContext), groupId, resourcePath, serviceContext, siteNavigationMenuItemSettingsBuilder));
                continue;
            }
            if (resourcePath.endsWith(".gitkeep") || resourcePath.endsWith(".metadata.json")) continue;
            String fileName = FileUtil.getShortFileName((String)resourcePath);
            URL url = this._servletContext.getResource(resourcePath);
            URLConnection urlConnection = url.openConnection();
            Map<Object, Object> values = new HashMap();
            String json = SiteInitializerUtil.read((String)(resourcePath + ".metadata.json"), (ServletContext)this._servletContext);
            values = json != null ? Collections.singletonMap("document", json) : Collections.singletonMap("document", JSONUtil.put((String)"viewableBy", (Object)"Anyone").toString());
            Document document = null;
            document = documentFolderId != null ? ((existingDocument = (Document)(documentsPage = documentResource.getDocumentFolderDocumentsPage(documentFolderId, Boolean.valueOf(false), null, null, documentResource.toFilter(StringBundler.concat((String[])new String[]{"title eq '", fileName, "'"})), null, null)).fetchFirstItem()) == null ? documentResource.postDocumentFolderDocument(documentFolderId, MultipartBody.of(Collections.singletonMap("file", new BinaryFile(MimeTypesUtil.getContentType((String)fileName), fileName, urlConnection.getInputStream(), (long)urlConnection.getContentLength())), __ -> _objectMapper, values)) : documentResource.putDocument(existingDocument.getId(), MultipartBody.of(Collections.singletonMap("file", new BinaryFile(MimeTypesUtil.getContentType((String)fileName), fileName, urlConnection.getInputStream(), (long)urlConnection.getContentLength())), __ -> _objectMapper, values))) : ((existingDocument = (Document)(documentsPage = documentResource.getSiteDocumentsPage(Long.valueOf(groupId), Boolean.valueOf(false), null, null, documentResource.toFilter(StringBundler.concat((String[])new String[]{"title eq '", fileName, "'"})), null, null)).fetchFirstItem()) == null ? documentResource.postSiteDocument(Long.valueOf(groupId), MultipartBody.of(Collections.singletonMap("file", new BinaryFile(MimeTypesUtil.getContentType((String)fileName), fileName, urlConnection.getInputStream(), (long)urlConnection.getContentLength())), __ -> _objectMapper, values)) : documentResource.putDocument(existingDocument.getId(), MultipartBody.of(Collections.singletonMap("file", new BinaryFile(MimeTypesUtil.getContentType((String)fileName), fileName, urlConnection.getInputStream(), (long)urlConnection.getContentLength())), __ -> _objectMapper, values)));
            String key = resourcePath;
            final FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)document.getId());
            documentsStringUtilReplaceValues.put("DOCUMENT_FILE_ENTRY_ID:" + key, String.valueOf(fileEntry.getFileEntryId()));
            JSONObject jsonObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerialize((Object)fileEntry));
            jsonObject.put("alt", "");
            documentsStringUtilReplaceValues.put("DOCUMENT_JSON:" + key, jsonObject.toString());
            documentsStringUtilReplaceValues.put("DOCUMENT_URL:" + key, this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false));
            long fileEntryTypeId = 0L;
            if (fileEntry.getModel() instanceof DLFileEntry) {
                DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
                DLFileEntryType dlFileEntryType = dlFileEntry.getDLFileEntryType();
                fileEntryTypeId = dlFileEntryType.getFileEntryTypeId();
            }
            final String fileEntryTypeIdString = String.valueOf(fileEntryTypeId);
            siteNavigationMenuItemSettingsBuilder.put(key, new SiteNavigationMenuItemSetting(){
                {
                    this.className = FileEntry.class.getName();
                    this.classPK = String.valueOf(fileEntry.getFileEntryId());
                    this.classTypeId = fileEntryTypeIdString;
                    this.title = fileEntry.getTitle();
                    this.type = ResourceActionsUtil.getModelResource((Locale)serviceContext.getLocale(), (String)FileEntry.class.getName());
                }
            });
        }
        return documentsStringUtilReplaceValues;
    }

    private Map<String, String> _addOrUpdateDocuments(ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        Group group = this._groupLocalService.getCompanyGroup(serviceContext.getCompanyId());
        return HashMapBuilder.putAll(this._addOrUpdateDocuments(null, group.getGroupId(), "/site-initializer/documents/company", serviceContext, siteNavigationMenuItemSettingsBuilder)).putAll(this._addOrUpdateDocuments(null, serviceContext.getScopeGroupId(), "/site-initializer/documents/group", serviceContext, siteNavigationMenuItemSettingsBuilder)).build();
    }

    private void _addOrUpdateExpandoColumns(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/expando-columns.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)serviceContext.getCompanyId(), (String)jsonObject.getString("modelResource"));
            if (expandoBridge == null) continue;
            if (expandoBridge.getAttribute(jsonObject.getString("name")) != null) {
                expandoBridge.setAttributeDefault(jsonObject.getString("name"), this._getExpandoAttributeValue(jsonObject));
            } else {
                expandoBridge.addAttribute(jsonObject.getString("name"), jsonObject.getInt("dataType"), this._getExpandoAttributeValue(jsonObject));
            }
            if (!jsonObject.has("properties")) continue;
            UnicodeProperties unicodeProperties = new UnicodeProperties(true);
            JSONObject propertiesJSONObject = jsonObject.getJSONObject("properties");
            Map map = propertiesJSONObject.toMap();
            for (Map.Entry entry : map.entrySet()) {
                unicodeProperties.setProperty(TextFormatter.format((String)((String)entry.getKey()), (int)10), String.valueOf(entry.getValue()));
            }
            expandoBridge.setAttributeProperties(jsonObject.getString("name"), unicodeProperties);
        }
    }

    private void _addOrUpdateJournalArticles(DDMStructureLocalService ddmStructureLocalService, DDMTemplateLocalService ddmTemplateLocalService, Long documentFolderId, Map<String, String> documentsStringUtilReplaceValues, String parentResourcePath, final ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths(parentResourcePath);
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            parentResourcePath = resourcePath.substring(0, resourcePath.length() - 1);
            if (resourcePath.endsWith("/")) {
                this._addOrUpdateJournalArticles(ddmStructureLocalService, ddmTemplateLocalService, this._addOrUpdateStructuredContentFolders(documentFolderId, parentResourcePath, serviceContext), documentsStringUtilReplaceValues, resourcePath, serviceContext, siteNavigationMenuItemSettingsBuilder);
                continue;
            }
            if (resourcePath.endsWith(".gitkeep") || resourcePath.endsWith(".metadata.json") || resourcePath.endsWith(".xml")) continue;
            long journalFolderId = 0L;
            if (documentFolderId != null) {
                journalFolderId = documentFolderId;
            }
            String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)this._servletContext);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
            Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), jsonObject.getString("name"));
            String ddmStructureKey = jsonObject.getString("ddmStructureKey");
            final DDMStructure ddmStructure = ddmStructureLocalService.getStructure(serviceContext.getScopeGroupId(), this._portal.getClassNameId(JournalArticle.class), ddmStructureKey, true);
            String ddmTemplateKey = jsonObject.getString("ddmTemplateKey");
            ddmTemplateLocalService.getTemplate(serviceContext.getScopeGroupId(), this._portal.getClassNameId(DDMStructure.class), ddmTemplateKey);
            Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
            serviceContext.setAssetCategoryIds(this._getAssetCategoryIds(serviceContext.getScopeGroupId(), JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("assetCategoryERCs"))));
            serviceContext.setAssetTagNames(JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("assetTagNames")));
            JournalArticle journalArticle = this._journalArticleLocalService.fetchArticle(serviceContext.getScopeGroupId(), jsonObject.getString("articleId"));
            journalArticle = journalArticle == null ? this._journalArticleLocalService.addArticle(null, serviceContext.getUserId(), serviceContext.getScopeGroupId(), journalFolderId, 0L, 0L, jsonObject.getString("articleId"), false, 1.0, titleMap, null, titleMap, this._replace(SiteInitializerUtil.read((String)this._replace(resourcePath, ".json", ".xml"), (ServletContext)this._servletContext), documentsStringUtilReplaceValues), ddmStructure.getStructureId(), ddmTemplateKey, null, calendar.get(2), calendar.get(5), calendar.get(1), calendar.get(11), calendar.get(12), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, serviceContext) : this._journalArticleLocalService.updateArticle(serviceContext.getUserId(), serviceContext.getScopeGroupId(), journalFolderId, jsonObject.getString("articleId"), journalArticle.getVersion(), titleMap, null, titleMap, this._replace(SiteInitializerUtil.read((String)this._replace(resourcePath, ".json", ".xml"), (ServletContext)this._servletContext), documentsStringUtilReplaceValues), ddmTemplateKey, null, calendar.get(2), calendar.get(5), calendar.get(1), calendar.get(11), calendar.get(12), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, serviceContext);
            final JournalArticle finalJournalArticle = journalArticle;
            serviceContext.setAssetCategoryIds(null);
            serviceContext.setAssetTagNames(null);
            siteNavigationMenuItemSettingsBuilder.put(resourcePath, new SiteNavigationMenuItemSetting(){
                {
                    this.className = JournalArticle.class.getName();
                    this.classPK = String.valueOf(finalJournalArticle.getResourcePrimKey());
                    this.classTypeId = String.valueOf(ddmStructure.getStructureId());
                    this.title = finalJournalArticle.getTitle(serviceContext.getLocale());
                    this.type = ResourceActionsUtil.getModelResource((Locale)serviceContext.getLocale(), (String)JournalArticle.class.getName());
                }
            });
        }
    }

    private void _addOrUpdateJournalArticles(DDMStructureLocalService ddmStructureLocalService, DDMTemplateLocalService ddmTemplateLocalService, Map<String, String> documentsStringUtilReplaceValues, ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        this._addOrUpdateJournalArticles(ddmStructureLocalService, ddmTemplateLocalService, null, documentsStringUtilReplaceValues, "/site-initializer/journal-articles", serviceContext, siteNavigationMenuItemSettingsBuilder);
    }

    private KnowledgeBaseArticle _addOrUpdateKnowledgeBaseArticle(boolean folder, JSONObject jsonObject, long parentKnowledgeBaseObjectId, ServiceContext serviceContext) throws Exception {
        KnowledgeBaseArticleResource.Builder knowledgeBaseArticleResourceBuilder = this._knowledgeBaseArticleResourceFactory.create();
        KnowledgeBaseArticleResource knowledgeBaseArticleResource = knowledgeBaseArticleResourceBuilder.user(serviceContext.fetchUser()).build();
        KnowledgeBaseArticle knowledgeBaseArticle = KnowledgeBaseArticle.toDTO((String)jsonObject.toString());
        if (!folder) {
            knowledgeBaseArticle.setParentKnowledgeBaseArticleId(Long.valueOf(parentKnowledgeBaseObjectId));
        } else {
            knowledgeBaseArticle.setParentKnowledgeBaseFolderId(Long.valueOf(parentKnowledgeBaseObjectId));
        }
        return knowledgeBaseArticleResource.putSiteKnowledgeBaseArticleByExternalReferenceCode(Long.valueOf(serviceContext.getScopeGroupId()), knowledgeBaseArticle.getExternalReferenceCode(), knowledgeBaseArticle);
    }

    private void _addOrUpdateKnowledgeBaseArticle(boolean folder, JSONObject jsonObject, long parentKnowledgeBaseObjectId, String resourcePath, ServiceContext serviceContext) throws Exception {
        KnowledgeBaseArticle knowledgeBaseArticle = this._addOrUpdateKnowledgeBaseArticle(folder, jsonObject, parentKnowledgeBaseObjectId, serviceContext);
        this._addOrKnowledgeBaseObjects(false, knowledgeBaseArticle.getId(), resourcePath, serviceContext);
    }

    private void _addOrUpdateKnowledgeBaseArticles(ServiceContext serviceContext) throws Exception {
        this._addOrKnowledgeBaseObjects(true, 0L, "/site-initializer/knowledge-base-articles", serviceContext);
    }

    private KnowledgeBaseFolder _addOrUpdateKnowledgeBaseFolder(JSONObject jsonObject, long parentKnowledgeBaseObjectId, ServiceContext serviceContext) throws Exception {
        KnowledgeBaseFolderResource.Builder knowledgeBaseFolderResourceBuilder = this._knowledgeBaseFolderResourceFactory.create();
        KnowledgeBaseFolderResource knowledgeBaseFolderResource = knowledgeBaseFolderResourceBuilder.httpServletRequest(serviceContext.getRequest()).user(serviceContext.fetchUser()).build();
        KnowledgeBaseFolder knowledgeBaseFolder = KnowledgeBaseFolder.toDTO((String)jsonObject.toString());
        knowledgeBaseFolder.setParentKnowledgeBaseFolderId(Long.valueOf(parentKnowledgeBaseObjectId));
        return knowledgeBaseFolderResource.putSiteKnowledgeBaseFolderByExternalReferenceCode(Long.valueOf(serviceContext.getScopeGroupId()), knowledgeBaseFolder.getExternalReferenceCode(), knowledgeBaseFolder);
    }

    private void _addOrUpdateKnowledgeBaseFolder(JSONObject jsonObject, long parentKnowledgeBaseObjectId, String resourcePath, ServiceContext serviceContext) throws Exception {
        KnowledgeBaseFolder knowledgeBaseFolder = this._addOrUpdateKnowledgeBaseFolder(jsonObject, parentKnowledgeBaseObjectId, serviceContext);
        this._addOrKnowledgeBaseObjects(true, knowledgeBaseFolder.getId(), resourcePath, serviceContext);
    }

    private Map<String, Layout> _addOrUpdateLayout(Map<String, String> layoutIdsStringUtilReplaceValues, long parentLayoutId, String parentResourcePath, ServiceContext serviceContext) throws Exception {
        TreeSet resourcePaths;
        Layout layout;
        String type;
        Locale siteDefaultLocale;
        JSONObject pageJSONObject = this._jsonFactory.createJSONObject(this._replace(SiteInitializerUtil.read((String)(parentResourcePath + "page.json"), (ServletContext)this._servletContext), layoutIdsStringUtilReplaceValues));
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>(SiteInitializerUtil.toMap((String)pageJSONObject.getString("name_i18n")));
        if (!nameMap.containsKey(siteDefaultLocale = this._portal.getSiteDefaultLocale(serviceContext.getScopeGroupId()))) {
            nameMap.put(siteDefaultLocale, pageJSONObject.getString("name"));
        }
        if (Objects.equals(type = StringUtil.toLowerCase((String)pageJSONObject.getString("type")), "link_to_layout")) {
            type = "link_to_layout";
        } else if (Objects.equals(type, "url")) {
            type = "url";
        } else if (Objects.equals(type, "widget")) {
            type = "portlet";
        }
        HashMap<Locale, String> friendlyURLMap = new HashMap<Locale, String>(SiteInitializerUtil.toMap((String)pageJSONObject.getString("friendlyURL_i18n")));
        if (!friendlyURLMap.containsKey(siteDefaultLocale)) {
            friendlyURLMap.put(siteDefaultLocale, pageJSONObject.getString("friendlyURL"));
        }
        UnicodeProperties unicodeProperties = new UnicodeProperties(true);
        JSONArray typeSettingsJSONArray = pageJSONObject.getJSONArray("typeSettings");
        if (typeSettingsJSONArray != null) {
            for (int i = 0; i < typeSettingsJSONArray.length(); ++i) {
                JSONObject propertyJSONObject = typeSettingsJSONArray.getJSONObject(i);
                unicodeProperties.put(propertyJSONObject.getString("key"), propertyJSONObject.getString("value"));
            }
        }
        if ((layout = this._layoutLocalService.fetchLayoutByFriendlyURL(serviceContext.getScopeGroupId(), pageJSONObject.getBoolean("private"), pageJSONObject.getString("friendlyURL"))) != null) {
            this._layoutLocalService.deleteLayout(layout);
        }
        layout = this._layoutLocalService.addLayout(serviceContext.getUserId(), serviceContext.getScopeGroupId(), pageJSONObject.getBoolean("private"), parentLayoutId, nameMap, SiteInitializerUtil.toMap((String)pageJSONObject.getString("title_i18n")), SiteInitializerUtil.toMap((String)pageJSONObject.getString("description_i18n")), SiteInitializerUtil.toMap((String)pageJSONObject.getString("keywords_i18n")), SiteInitializerUtil.toMap((String)pageJSONObject.getString("robots_i18n")), type, unicodeProperties.toString(), pageJSONObject.getBoolean("hidden"), pageJSONObject.getBoolean("system"), friendlyURLMap, serviceContext);
        this._setResourcePermissions(layout.getCompanyId(), layout.getModelClassName(), pageJSONObject.getJSONArray("permissions"), String.valueOf(layout.getPlid()));
        if (pageJSONObject.has("priority")) {
            layout = this._layoutLocalService.updatePriority(layout.getPlid(), pageJSONObject.getInt("priority"));
        }
        layoutIdsStringUtilReplaceValues.put("LAYOUT_ID:" + layout.getName(LocaleUtil.getSiteDefault()), String.valueOf(layout.getLayoutId()));
        HashMap layoutsMap = HashMapBuilder.put((Object)parentResourcePath, (Object)layout).build();
        String layoutTemplateId = StringUtil.toLowerCase((String)pageJSONObject.getString("layoutTemplateId"));
        if (Validator.isNotNull((String)layoutTemplateId)) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            layoutTypePortlet.setLayoutTemplateId(0L, layoutTemplateId, false);
        }
        if (SetUtil.isEmpty((Set)(resourcePaths = this._servletContext.getResourcePaths(parentResourcePath)))) {
            return layoutsMap;
        }
        TreeSet sortedResourcePaths = new TreeSet(new NaturalOrderStringComparator());
        sortedResourcePaths.addAll(resourcePaths);
        resourcePaths = sortedResourcePaths;
        for (String resourcePath : resourcePaths) {
            if (!resourcePath.endsWith("/")) continue;
            layoutsMap.putAll(this._addOrUpdateLayout(layoutIdsStringUtilReplaceValues, layout.getLayoutId(), resourcePath, serviceContext));
        }
        return layoutsMap;
    }

    private Map<String, Layout> _addOrUpdateLayouts(ServiceContext serviceContext) throws Exception {
        TreeSet resourcePaths = this._servletContext.getResourcePaths("/site-initializer/layouts");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return new HashMap<String, Layout>();
        }
        HashMap<String, Layout> layoutsMap = new HashMap<String, Layout>();
        HashMap<String, String> layoutIdsStringUtilReplaceValues = new HashMap<String, String>();
        List layouts = this._layoutLocalService.getLayouts(serviceContext.getScopeGroupId(), -1, -1, null);
        for (Layout layout : layouts) {
            layoutIdsStringUtilReplaceValues.put("LAYOUT_ID:" + layout.getName(LocaleUtil.getSiteDefault()), String.valueOf(layout.getLayoutId()));
        }
        TreeSet sortedResourcePaths = new TreeSet(new NaturalOrderStringComparator());
        sortedResourcePaths.addAll(resourcePaths);
        resourcePaths = sortedResourcePaths;
        for (String resourcePath : resourcePaths) {
            if (!resourcePath.endsWith("/")) continue;
            layoutsMap.putAll(this._addOrUpdateLayout(layoutIdsStringUtilReplaceValues, 0L, resourcePath, serviceContext));
        }
        return layoutsMap;
    }

    private Map<String, String> _addOrUpdateListTypeDefinitions(ServiceContext serviceContext) throws Exception {
        HashMap<String, String> listTypeDefinitionIdsStringUtilReplaceValues = new HashMap<String, String>();
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/list-type-definitions");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return listTypeDefinitionIdsStringUtilReplaceValues;
        }
        ListTypeDefinitionResource.Builder listTypeDefinitionResourceBuilder = this._listTypeDefinitionResourceFactory.create();
        ListTypeDefinitionResource listTypeDefinitionResource = listTypeDefinitionResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith(".list-type-entries.json")) continue;
            String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)this._servletContext);
            com.liferay.headless.admin.list.type.dto.v1_0.ListTypeDefinition listTypeDefinition = com.liferay.headless.admin.list.type.dto.v1_0.ListTypeDefinition.toDTO((String)json);
            if (listTypeDefinition == null) {
                _log.error((Object)("Unable to transform list type definition from JSON: " + json));
                continue;
            }
            ListTypeDefinition serviceBuilderListTypeDefinition = this._listTypeDefinitionLocalService.fetchListTypeDefinitionByExternalReferenceCode(listTypeDefinition.getExternalReferenceCode(), serviceContext.getCompanyId());
            listTypeDefinition = serviceBuilderListTypeDefinition == null ? listTypeDefinitionResource.postListTypeDefinition(listTypeDefinition) : listTypeDefinitionResource.patchListTypeDefinition(Long.valueOf(serviceBuilderListTypeDefinition.getListTypeDefinitionId()), listTypeDefinition);
            listTypeDefinitionIdsStringUtilReplaceValues.put("LIST_TYPE_DEFINITION_ID:" + listTypeDefinition.getName(), String.valueOf(listTypeDefinition.getId()));
            String listTypeEntriesJSON = SiteInitializerUtil.read((String)this._replace(resourcePath, ".json", ".list-type-entries.json"), (ServletContext)this._servletContext);
            if (listTypeEntriesJSON == null) continue;
            JSONArray jsonArray = this._jsonFactory.createJSONArray(listTypeEntriesJSON);
            ListTypeEntryResource.Builder listTypeEntryResourceBuilder = this._listTypeEntryResourceFactory.create();
            ListTypeEntryResource listTypeEntryResource = listTypeEntryResourceBuilder.user(serviceContext.fetchUser()).build();
            for (int i = 0; i < jsonArray.length(); ++i) {
                com.liferay.headless.admin.list.type.dto.v1_0.ListTypeEntry listTypeEntry = com.liferay.headless.admin.list.type.dto.v1_0.ListTypeEntry.toDTO((String)String.valueOf(jsonArray.getJSONObject(i)));
                ListTypeEntry serviceBuilderListTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(listTypeDefinition.getId().longValue(), listTypeEntry.getKey());
                if (serviceBuilderListTypeEntry == null) {
                    listTypeEntryResource.postListTypeDefinitionListTypeEntry(listTypeDefinition.getId(), listTypeEntry);
                    continue;
                }
                listTypeEntryResource.putListTypeEntry(Long.valueOf(serviceBuilderListTypeEntry.getListTypeEntryId()), listTypeEntry);
            }
        }
        return listTypeDefinitionIdsStringUtilReplaceValues;
    }

    private void _addOrUpdateNotificationTemplate(Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, String resourcePath, ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)(resourcePath + "notification-template.json"), (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONObject bodyJSONObject = this._jsonFactory.createJSONObject();
        Enumeration enumeration = this._bundle.findEntries(resourcePath, "*.html", false);
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            bodyJSONObject.put(FileUtil.getShortFileName((String)FileUtil.stripExtension((String)url.getPath())), this._replace(this._replace(StringUtil.read((InputStream)url.openStream()), serviceContext), documentsStringUtilReplaceValues));
        }
        JSONObject notificationTemplateJSONObject = this._jsonFactory.createJSONObject(json);
        notificationTemplateJSONObject.put("body", bodyJSONObject);
        NotificationTemplate notificationTemplate = NotificationTemplate.toDTO((String)notificationTemplateJSONObject.toString());
        NotificationTemplateResource.Builder notificationTemplateResourceBuilder = this._notificationTemplateResourceFactory.create();
        NotificationTemplateResource notificationTemplateResource = notificationTemplateResourceBuilder.user(serviceContext.fetchUser()).build();
        Page notificationTemplatesPage = notificationTemplateResource.getNotificationTemplatesPage(null, null, notificationTemplateResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", notificationTemplate.getName(), "'"})), null, null);
        NotificationTemplate existingNotificationTemplate = (NotificationTemplate)notificationTemplatesPage.fetchFirstItem();
        notificationTemplate = existingNotificationTemplate == null ? notificationTemplateResource.postNotificationTemplate(notificationTemplate) : notificationTemplateResource.putNotificationTemplate(existingNotificationTemplate.getId(), notificationTemplate);
        json = SiteInitializerUtil.read((String)(resourcePath + "notification-template.object-actions.json"), (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        json = this._replace(json, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues);
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        HashMap parametersMap = HashMapBuilder.put((Object)"notificationTemplateId", (Object)notificationTemplate.getId()).build();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this._objectActionLocalService.addOrUpdateObjectAction(jsonObject.getString("externalReferenceCode"), 0L, serviceContext.getUserId(), jsonObject.getLong("objectDefinitionId"), jsonObject.getBoolean("active"), jsonObject.getString("conditionExpression"), jsonObject.getString("description"), SiteInitializerUtil.toMap((String)jsonObject.getString("errorMessage")), SiteInitializerUtil.toMap((String)jsonObject.getString("label")), jsonObject.getString("name"), jsonObject.getString("objectActionExecutorKey"), jsonObject.getString("objectActionTriggerKey"), ObjectActionUtil.toParametersUnicodeProperties((Map)parametersMap));
        }
    }

    private void _addOrUpdateNotificationTemplates(Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/notification-templates");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            this._addOrUpdateNotificationTemplate(documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, resourcePath, serviceContext);
        }
    }

    private Map<String, String> _addOrUpdateObjectEntries(Map<String, String> documentsStringUtilReplaceValues, ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        TreeSet resourcePaths = this._servletContext.getResourcePaths("/site-initializer/object-entries");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return null;
        }
        TreeSet sortedResourcePaths = new TreeSet(new NaturalOrderStringComparator());
        sortedResourcePaths.addAll(resourcePaths);
        resourcePaths = sortedResourcePaths;
        HashMap<String, String> objectEntryIdsStringUtilReplaceValues = new HashMap<String, String>();
        for (String resourcePath : resourcePaths) {
            JSONArray jsonArray;
            String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)this._servletContext);
            if (json == null) continue;
            json = this._replace(json, documentsStringUtilReplaceValues, objectEntryIdsStringUtilReplaceValues);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
            final ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(serviceContext.getCompanyId(), "C_" + jsonObject.getString("objectDefinitionName"));
            if (objectDefinition == null || JSONUtil.isEmpty((JSONArray)(jsonArray = jsonObject.getJSONArray("object-entries")))) continue;
            DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, null, null, null, null, LocaleUtil.getSiteDefault(), null, serviceContext.fetchUser());
            for (int i = 0; i < jsonArray.length(); ++i) {
                String objectEntrySiteInitializerKey;
                JSONObject objectEntryJSONObject = jsonArray.getJSONObject(i);
                String externalReferenceCode = objectEntryJSONObject.getString("externalReferenceCode");
                com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry = com.liferay.object.rest.dto.v1_0.ObjectEntry.toDTO((String)JSONUtil.toString((JSONObject)objectEntryJSONObject));
                objectEntry = this._objectEntryManager.updateObjectEntry(serviceContext.getCompanyId(), (DTOConverterContext)defaultDTOConverterContext, externalReferenceCode, objectDefinition, objectEntry, String.valueOf(serviceContext.getScopeGroupId()));
                if (Validator.isNotNull((String)externalReferenceCode)) {
                    objectEntryIdsStringUtilReplaceValues.put(StringBundler.concat((String[])new String[]{objectDefinition.getShortName(), "#", externalReferenceCode}), String.valueOf(objectEntry.getId()));
                }
                if (Validator.isNull((String)(objectEntrySiteInitializerKey = objectEntryJSONObject.getString("objectEntrySiteInitializerKey")))) continue;
                final ObjectEntry serviceBuilderObjectEntry = this._objectEntryLocalService.getObjectEntry(objectEntry.getId().longValue());
                siteNavigationMenuItemSettingsBuilder.put(objectEntrySiteInitializerKey, new SiteNavigationMenuItemSetting(){
                    {
                        this.className = serviceBuilderObjectEntry.getModelClassName();
                        this.classPK = String.valueOf(serviceBuilderObjectEntry.getObjectEntryId());
                        this.title = StringBundler.concat((Object[])new Object[]{objectDefinition.getName(), " ", serviceBuilderObjectEntry.getObjectEntryId()});
                    }
                });
            }
        }
        return objectEntryIdsStringUtilReplaceValues;
    }

    private void _addOrUpdateObjectFields(Map<String, String> listTypeDefinitionIdsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/object-fields");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        ObjectFieldResource.Builder objectFieldResourceBuilder = this._objectFieldResourceFactory.create();
        ObjectFieldResource objectFieldResource = objectFieldResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)this._servletContext);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(json = this._replace(json, listTypeDefinitionIdsStringUtilReplaceValues, objectDefinitionIdsStringUtilReplaceValues));
            JSONArray jsonArray = jsonObject.getJSONArray("object-fields");
            if (JSONUtil.isEmpty((JSONArray)jsonArray)) continue;
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject objectFieldJSONObject = jsonArray.getJSONObject(i);
                ObjectField objectField = ObjectField.toDTO((String)JSONUtil.toString((JSONObject)objectFieldJSONObject));
                if (objectField == null) {
                    _log.error((Object)("Unable to transform object field from JSON: " + json));
                    continue;
                }
                com.liferay.object.model.ObjectField existingObjectField = this._objectFieldLocalService.fetchObjectField(jsonObject.getLong("objectDefinitionId"), objectField.getName());
                if (existingObjectField == null) {
                    objectFieldResource.postObjectDefinitionObjectField(Long.valueOf(jsonObject.getLong("objectDefinitionId")), objectField);
                    continue;
                }
                objectFieldResource.putObjectField(Long.valueOf(existingObjectField.getObjectFieldId()), objectField);
            }
        }
    }

    private void _addOrUpdateObjectRelationships(Map<String, String> objectDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/object-relationships");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        ObjectRelationshipResource.Builder objectRelationshipResourceBuilder = this._objectRelationshipResourceFactory.create();
        ObjectRelationshipResource objectRelationshipResource = objectRelationshipResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)this._servletContext);
            ObjectRelationship objectRelationship = ObjectRelationship.toDTO((String)(json = this._replace(json, objectDefinitionIdsStringUtilReplaceValues)));
            if (objectRelationship == null) {
                _log.error((Object)("Unable to transform object relationship from JSON: " + json));
                continue;
            }
            com.liferay.object.model.ObjectRelationship existingObjectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectDefinitionId1(objectRelationship.getObjectDefinitionId1().longValue(), objectRelationship.getName());
            if (existingObjectRelationship == null) {
                objectRelationshipResource.postObjectDefinitionObjectRelationship(objectRelationship.getObjectDefinitionId1(), objectRelationship);
                continue;
            }
            objectRelationshipResource.putObjectRelationship(Long.valueOf(existingObjectRelationship.getObjectRelationshipId()), objectRelationship);
        }
    }

    private void _addOrUpdateOrganization(JSONObject jsonObject, Organization parentOrganization, ServiceContext serviceContext) throws Exception {
        Organization organization = Organization.toDTO((String)jsonObject.toString());
        if (organization == null) {
            _log.error((Object)("Unable to transform organization from JSON: " + jsonObject));
            return;
        }
        organization.setParentOrganization(parentOrganization);
        OrganizationResource.Builder organizationResourceBuilder = this._organizationResourceFactory.create();
        OrganizationResource organizationResource = organizationResourceBuilder.user(serviceContext.fetchUser()).httpServletRequest(serviceContext.getRequest()).build();
        organization = organizationResource.putOrganizationByExternalReferenceCode(organization.getExternalReferenceCode(), organization);
        JSONArray jsonArray = jsonObject.getJSONArray("childOrganizations");
        if (JSONUtil.isEmpty((JSONArray)jsonArray)) {
            return;
        }
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._addOrUpdateOrganization(jsonArray.getJSONObject(i), organization, serviceContext);
        }
    }

    private void _addOrUpdateOrganizations(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/organizations.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._addOrUpdateOrganization(jsonArray.getJSONObject(i), null, serviceContext);
        }
    }

    private void _addOrUpdateResourcePermissions(Map<String, String> objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/resource-permissions.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        HashMap<String, String> layoutPageTemplateEntryReplaceValues = new HashMap<String, String>();
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryLocalService.getLayoutPageTemplateEntries(serviceContext.getScopeGroupId());
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            layoutPageTemplateEntryReplaceValues.put("LAYOUT_PAGE_TEMPLATE_ENTRY_ID:" + layoutPageTemplateEntry.getName(), String.valueOf(layoutPageTemplateEntry.getLayoutPageTemplateEntryId()));
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(this._replace(json, layoutPageTemplateEntryReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues));
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Object[] actionIds = ArrayUtil.toStringArray((JSONArray)jsonObject.getJSONArray("actionIds"));
            Object[] resourceActionIds = (String[])TransformUtil.transformToArray((Collection)this._resourceActionLocalService.getResourceActions(jsonObject.getString("resourceName")), ResourceAction2 -> ResourceAction2.getActionId(), String.class);
            if (!ArrayUtil.containsAll((Object[])resourceActionIds, (Object[])actionIds)) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"No resource action found with resourceName ", jsonObject.getString("resourceName"), " with the actionIds: ", ArrayUtil.toString((Object[])actionIds, (String)"")}));
                continue;
            }
            Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), jsonObject.getString("roleName"));
            if (role == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No role found with name " + jsonObject.getString("roleName")));
                continue;
            }
            int scope = jsonObject.getInt("scope");
            if (scope == 1) {
                jsonObject.put("primKey", String.valueOf(serviceContext.getCompanyId()));
            } else if (scope == 2) {
                jsonObject.put("primKey", String.valueOf(serviceContext.getScopeGroupId()));
            }
            this._resourcePermissionLocalService.setResourcePermissions(serviceContext.getCompanyId(), jsonObject.getString("resourceName"), scope, jsonObject.getString("primKey"), role.getRoleId(), (String[])actionIds);
        }
    }

    private Map<String, String> _addOrUpdateRoles(ServiceContext serviceContext) throws Exception {
        HashMap<String, String> roleIdsStringUtilReplaceValues = new HashMap<String, String>();
        List roles = this._roleLocalService.getRoles(serviceContext.getCompanyId());
        for (Role role : roles) {
            roleIdsStringUtilReplaceValues.put("ROLE_ID:" + role.getName(), String.valueOf(role.getRoleId()));
        }
        String json = SiteInitializerUtil.read((String)"/site-initializer/roles.json", (ServletContext)this._servletContext);
        if (json == null) {
            return roleIdsStringUtilReplaceValues;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), jsonObject.getString("name"));
            if (role == null) {
                if (jsonObject.getInt("type") == 6) {
                    AccountRole accountRole = this._accountRoleLocalService.addAccountRole(serviceContext.getUserId(), 0L, jsonObject.getString("name"), SiteInitializerUtil.toMap((String)jsonObject.getString("name_i18n")), SiteInitializerUtil.toMap((String)jsonObject.getString("description")));
                    role = accountRole.getRole();
                } else {
                    role = this._roleLocalService.addRole(serviceContext.getUserId(), null, 0L, jsonObject.getString("name"), SiteInitializerUtil.toMap((String)jsonObject.getString("name_i18n")), SiteInitializerUtil.toMap((String)jsonObject.getString("description")), jsonObject.getInt("type"), jsonObject.getString("subtype"), serviceContext);
                }
            } else {
                role = this._roleLocalService.updateRole(role.getRoleId(), jsonObject.getString("name"), SiteInitializerUtil.toMap((String)jsonObject.getString("name_i18n")), SiteInitializerUtil.toMap((String)jsonObject.getString("description")), jsonObject.getString("subtype"), serviceContext);
            }
            roleIdsStringUtilReplaceValues.put("ROLE_ID:" + role.getName(), String.valueOf(role.getRoleId()));
            JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
            if (JSONUtil.isEmpty((JSONArray)actionsJSONArray) || role == null) continue;
            for (int j = 0; j < actionsJSONArray.length(); ++j) {
                JSONObject actionsJSONObject = actionsJSONArray.getJSONObject(j);
                String resource = actionsJSONObject.getString("resource");
                int scope = actionsJSONObject.getInt("scope");
                String actionId = actionsJSONObject.getString("actionId");
                if (scope == 1) {
                    this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), resource, scope, String.valueOf(role.getCompanyId()), role.getRoleId(), actionId);
                    continue;
                }
                if (scope == 2) {
                    this._resourcePermissionLocalService.removeResourcePermissions(serviceContext.getCompanyId(), resource, 2, role.getRoleId(), actionId);
                    this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), resource, 2, String.valueOf(serviceContext.getScopeGroupId()), role.getRoleId(), actionId);
                    continue;
                }
                if (scope != 3) continue;
                this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), resource, 3, String.valueOf(0L), role.getRoleId(), actionId);
            }
        }
        return roleIdsStringUtilReplaceValues;
    }

    private void _addOrUpdateSAPEntries(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/sap-entries.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(serviceContext.getCompanyId(), jsonObject.getString("name"));
            if (sapEntry == null) {
                this._sapEntryLocalService.addSAPEntry(serviceContext.getUserId(), StringUtil.merge((Object[])JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("allowedServiceSignatures")), (String)"\n"), jsonObject.getBoolean("defaultSAPEntry", true), jsonObject.getBoolean("enabled", true), jsonObject.getString("name"), SiteInitializerUtil.toMap((String)jsonObject.getString("title_i18n")), serviceContext);
                continue;
            }
            this._sapEntryLocalService.updateSAPEntry(sapEntry.getSapEntryId(), StringUtil.merge((Object[])JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("allowedServiceSignatures")), (String)"\n"), jsonObject.getBoolean("defaultSAPEntry", true), jsonObject.getBoolean("enabled", true), jsonObject.getString("name"), SiteInitializerUtil.toMap((String)jsonObject.getString("title_i18n")), serviceContext);
        }
    }

    private Map<String, String> _addOrUpdateSegmentsEntries(ServiceContext serviceContext) throws Exception {
        HashMap<String, String> segmentsEntriesIdsStringUtilReplaceValues = new HashMap<String, String>();
        String json = SiteInitializerUtil.read((String)"/site-initializer/segments-entries.json", (ServletContext)this._servletContext);
        if (json == null) {
            return segmentsEntriesIdsStringUtilReplaceValues;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(serviceContext.getScopeGroupId(), jsonObject.getString("segmentsEntryKey"), true);
            segmentsEntry = segmentsEntry == null ? this._segmentsEntryLocalService.addSegmentsEntry(jsonObject.getString("segmentsEntryKey"), SiteInitializerUtil.toMap((String)jsonObject.getString("name_i18n")), null, jsonObject.getBoolean("active", true), jsonObject.getString("criteria"), jsonObject.getString("type"), serviceContext) : this._segmentsEntryLocalService.updateSegmentsEntry(segmentsEntry.getSegmentsEntryId(), jsonObject.getString("segmentsEntryKey"), SiteInitializerUtil.toMap((String)jsonObject.getString("name_i18n")), null, jsonObject.getBoolean("active", true), jsonObject.getString("criteria"), serviceContext);
            segmentsEntriesIdsStringUtilReplaceValues.put("SEGMENTS_ENTRY_ID:" + segmentsEntry.getSegmentsEntryKey(), String.valueOf(segmentsEntry.getSegmentsEntryId()));
        }
        return segmentsEntriesIdsStringUtilReplaceValues;
    }

    private Long _addOrUpdateStructuredContentFolders(Long documentFolderId, String parentResourcePath, ServiceContext serviceContext) throws Exception {
        StructuredContentFolderResource.Builder structuredContentFolderResourceBuilder = this._structuredContentFolderResourceFactory.create();
        StructuredContentFolderResource structuredContentFolderResource = structuredContentFolderResourceBuilder.user(serviceContext.fetchUser()).build();
        String json = SiteInitializerUtil.read((String)(parentResourcePath + ".metadata.json"), (ServletContext)this._servletContext);
        if (json == null) {
            json = JSONUtil.put((String)"name", (Object)FileUtil.getShortFileName((String)parentResourcePath)).toString();
        }
        StructuredContentFolder structuredContentFolder = StructuredContentFolder.toDTO((String)json);
        structuredContentFolder.setParentStructuredContentFolderId(documentFolderId);
        structuredContentFolder = structuredContentFolderResource.putSiteStructuredContentFolderByExternalReferenceCode(Long.valueOf(serviceContext.getScopeGroupId()), structuredContentFolder.getExternalReferenceCode(), structuredContentFolder);
        return structuredContentFolder.getId();
    }

    private TaxonomyCategory _addOrUpdateTaxonomyCategoryTaxonomyCategory(String parentTaxonomyCategoryId, ServiceContext serviceContext, TaxonomyCategory taxonomyCategory) throws Exception {
        TaxonomyCategoryResource.Builder taxonomyCategoryResourceBuilder = this._taxonomyCategoryResourceFactory.create();
        TaxonomyCategoryResource taxonomyCategoryResource = taxonomyCategoryResourceBuilder.user(serviceContext.fetchUser()).build();
        Page taxonomyCategoryPage = taxonomyCategoryResource.getTaxonomyCategoryTaxonomyCategoriesPage(parentTaxonomyCategoryId, "", null, taxonomyCategoryResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", taxonomyCategory.getName(), "'"})), null, null);
        TaxonomyCategory existingTaxonomyCategory = (TaxonomyCategory)taxonomyCategoryPage.fetchFirstItem();
        taxonomyCategory = existingTaxonomyCategory == null ? taxonomyCategoryResource.postTaxonomyCategoryTaxonomyCategory(parentTaxonomyCategoryId, taxonomyCategory) : taxonomyCategoryResource.patchTaxonomyCategory(existingTaxonomyCategory.getId(), taxonomyCategory);
        return taxonomyCategory;
    }

    private Map<String, String> _addOrUpdateTaxonomyVocabularies(long groupId, String parentResourcePath, ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        HashMap<String, String> taxonomyCategoryIdsAndTaxonomyVocabularyIdsStringUtilReplaceValues = new HashMap<String, String>();
        Set resourcePaths = this._servletContext.getResourcePaths(parentResourcePath);
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return taxonomyCategoryIdsAndTaxonomyVocabularyIdsStringUtilReplaceValues;
        }
        TaxonomyVocabularyResource.Builder taxonomyVocabularyResourceBuilder = this._taxonomyVocabularyResourceFactory.create();
        TaxonomyVocabularyResource taxonomyVocabularyResource = taxonomyVocabularyResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith("/")) continue;
            String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)this._servletContext);
            TaxonomyVocabulary taxonomyVocabulary = TaxonomyVocabulary.toDTO((String)json);
            if (taxonomyVocabulary == null) {
                _log.error((Object)("Unable to transform taxonomy vocabulary from JSON: " + json));
                continue;
            }
            Page taxonomyVocabularyPage = taxonomyVocabularyResource.getSiteTaxonomyVocabulariesPage(Long.valueOf(groupId), "", null, taxonomyVocabularyResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", taxonomyVocabulary.getName(), "'"})), null, null);
            TaxonomyVocabulary existingTaxonomyVocabulary = (TaxonomyVocabulary)taxonomyVocabularyPage.fetchFirstItem();
            taxonomyVocabulary = existingTaxonomyVocabulary == null ? taxonomyVocabularyResource.postSiteTaxonomyVocabulary(Long.valueOf(groupId), taxonomyVocabulary) : taxonomyVocabularyResource.patchTaxonomyVocabulary(existingTaxonomyVocabulary.getId(), taxonomyVocabulary);
            taxonomyCategoryIdsAndTaxonomyVocabularyIdsStringUtilReplaceValues.put("TAXONOMY_VOCABULARY_ID:" + taxonomyVocabulary.getName(), String.valueOf(taxonomyVocabulary.getId()));
            taxonomyCategoryIdsAndTaxonomyVocabularyIdsStringUtilReplaceValues.putAll(this._addTaxonomyCategories(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)"/"), null, serviceContext, siteNavigationMenuItemSettingsBuilder, taxonomyVocabulary.getId()));
        }
        return taxonomyCategoryIdsAndTaxonomyVocabularyIdsStringUtilReplaceValues;
    }

    private Map<String, String> _addOrUpdateTaxonomyVocabularies(ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        Group group = this._groupLocalService.getCompanyGroup(serviceContext.getCompanyId());
        return HashMapBuilder.putAll(this._addOrUpdateTaxonomyVocabularies(group.getGroupId(), "/site-initializer/taxonomy-vocabularies/company", serviceContext, siteNavigationMenuItemSettingsBuilder)).putAll(this._addOrUpdateTaxonomyVocabularies(serviceContext.getScopeGroupId(), "/site-initializer/taxonomy-vocabularies/group", serviceContext, siteNavigationMenuItemSettingsBuilder)).build();
    }

    private TaxonomyCategory _addOrUpdateTaxonomyVocabularyTaxonomyCategory(ServiceContext serviceContext, TaxonomyCategory taxonomyCategory, long vocabularyId) throws Exception {
        TaxonomyCategoryResource.Builder taxonomyCategoryResourceBuilder = this._taxonomyCategoryResourceFactory.create();
        TaxonomyCategoryResource taxonomyCategoryResource = taxonomyCategoryResourceBuilder.user(serviceContext.fetchUser()).build();
        Page taxonomyCategoryPage = taxonomyCategoryResource.getTaxonomyVocabularyTaxonomyCategoriesPage(Long.valueOf(vocabularyId), null, "", null, taxonomyCategoryResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", taxonomyCategory.getName(), "'"})), null, null);
        TaxonomyCategory existingTaxonomyCategory = (TaxonomyCategory)taxonomyCategoryPage.fetchFirstItem();
        taxonomyCategory = existingTaxonomyCategory == null ? taxonomyCategoryResource.postTaxonomyVocabularyTaxonomyCategory(Long.valueOf(vocabularyId), taxonomyCategory) : taxonomyCategoryResource.patchTaxonomyCategory(existingTaxonomyCategory.getId(), taxonomyCategory);
        return taxonomyCategory;
    }

    private void _addOrUpdateUserGroups(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/user-groups.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            UserGroup userGroup = this._userGroupLocalService.addOrUpdateUserGroup(jsonObject.getString("externalReferenceCode"), serviceContext.getUserId(), serviceContext.getCompanyId(), jsonObject.getString("name"), jsonObject.getString("description"), serviceContext);
            this._userGroupLocalService.addGroupUserGroup(serviceContext.getScopeGroupId(), userGroup);
        }
    }

    private void _addPortletSettings(ServiceContext serviceContext) throws Exception {
        if (this._commerceSiteInitializer == null) {
            return;
        }
        this._commerceSiteInitializer.addPortletSettings(this._classLoader, serviceContext, this._servletContext);
    }

    private void _addRolesAssignments(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/roles-assignments.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONArray groupsJSONArray = jsonObject.getJSONArray("groups");
            if (JSONUtil.isEmpty((JSONArray)groupsJSONArray)) continue;
            ArrayList<Long> groupIds = new ArrayList<Long>();
            for (int j = 0; j < groupsJSONArray.length(); ++j) {
                Group group;
                JSONObject groupJSONObject = groupsJSONArray.getJSONObject(j);
                String groupType = groupJSONObject.getString("groupType");
                if (StringUtil.equals((String)groupType, (String)"Organization")) {
                    com.liferay.portal.kernel.model.Organization organization = this._organizationLocalService.fetchOrganization(serviceContext.getCompanyId(), groupJSONObject.getString("groupName"));
                    if (organization == null) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("No organization found with name " + groupJSONObject.getString("groupName")));
                        continue;
                    }
                    group = this._groupLocalService.getOrganizationGroup(serviceContext.getCompanyId(), organization.getOrganizationId());
                    groupIds.add(group.getGroupId());
                    continue;
                }
                if (StringUtil.equals((String)groupType, (String)"Site")) {
                    groupIds.add(serviceContext.getScopeGroupId());
                    continue;
                }
                if (StringUtil.equals((String)groupType, (String)"User")) {
                    User user = this._userLocalService.fetchUserByScreenName(serviceContext.getCompanyId(), groupJSONObject.getString("groupName"));
                    if (user == null) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)("No user found with screen name " + groupJSONObject.getString("groupName")));
                        continue;
                    }
                    group = this._groupLocalService.getUserGroup(serviceContext.getCompanyId(), user.getUserId());
                    groupIds.add(group.getGroupId());
                    continue;
                }
                if (!StringUtil.equals((String)groupType, (String)"UserGroups")) continue;
                UserGroup userGroup = this._userGroupLocalService.fetchUserGroup(serviceContext.getCompanyId(), groupJSONObject.getString("groupName"));
                if (userGroup == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("No user group found with name " + groupJSONObject.getString("groupName")));
                    continue;
                }
                group = this._groupLocalService.getUserGroupGroup(serviceContext.getCompanyId(), userGroup.getUserGroupId());
                groupIds.add(group.getGroupId());
            }
            if (ListUtil.isEmpty(groupIds)) continue;
            Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), jsonObject.getString("roleName"));
            if (role == null) {
                if (!_log.isWarnEnabled() || !_log.isWarnEnabled()) continue;
                _log.warn((Object)("No role found with name " + jsonObject.getString("roleName")));
                continue;
            }
            this._groupLocalService.setRoleGroups(role.getRoleId(), ArrayUtil.toLongArray(groupIds));
        }
    }

    private void _addSegmentsExperiences(Map<String, String> assetListEntryIdsStringUtilReplaceValues, Map<String, String> clientExtensionEntryIdsStringUtilReplaceValues, Map<String, String> ddmStructureEntryIdsStringUtilReplaceValues, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, Map<String, String> segmentsEntriesIdsStringUtilReplaceValues, ServiceContext serviceContext, Map<String, String> taxonomyCategoryIdsStringUtilReplaceValues) throws Exception {
        Set parentResourcePaths = this._servletContext.getResourcePaths("/site-initializer/segments-experiences");
        if (SetUtil.isEmpty((Set)parentResourcePaths)) {
            return;
        }
        for (String parentResourcePath : parentResourcePaths) {
            String json = SiteInitializerUtil.read((String)(parentResourcePath + "segments-experiences.json"), (ServletContext)this._servletContext);
            if (json == null) {
                return;
            }
            json = this._replace(json, segmentsEntriesIdsStringUtilReplaceValues);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
            Layout layout = this._layoutLocalService.getLayoutByFriendlyURL(serviceContext.getScopeGroupId(), false, jsonObject.getString("friendlyURL"));
            Layout draftLayout = layout.fetchDraftLayout();
            UnicodeProperties unicodeProperties = new UnicodeProperties(true);
            JSONObject propertiesJSONObject = jsonObject.getJSONObject("typeSettings");
            if (propertiesJSONObject != null) {
                Map map = JSONUtil.toStringMap((JSONObject)propertiesJSONObject);
                unicodeProperties.putAll(map);
            }
            SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.appendSegmentsExperience(serviceContext.getUserId(), serviceContext.getScopeGroupId(), jsonObject.getLong("segmentsEntryId"), draftLayout.getClassPK(), SiteInitializerUtil.toMap((String)jsonObject.getString("name_i18n")), jsonObject.getBoolean("active", true), unicodeProperties, serviceContext);
            LayoutStructure layoutStructure = new LayoutStructure();
            layoutStructure.addRootLayoutStructureItem();
            LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(draftLayout.getGroupId(), draftLayout.getPlid(), true);
            this._layoutPageTemplateStructureRelLocalService.addLayoutPageTemplateStructureRel(serviceContext.getUserId(), serviceContext.getScopeGroupId(), layoutPageTemplateStructure.getLayoutPageTemplateStructureId(), segmentsExperience.getSegmentsExperienceId(), layoutStructure.toString(), serviceContext);
            Set resourcePaths = this._servletContext.getResourcePaths(parentResourcePath);
            for (String resourcePath : resourcePaths) {
                if (!resourcePath.endsWith("/")) continue;
                this._addLayoutContent(assetListEntryIdsStringUtilReplaceValues, clientExtensionEntryIdsStringUtilReplaceValues, ddmStructureEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, objectDefinitionIdsAndObjectEntryIdsStringUtilReplaceValues, layout, resourcePath, segmentsExperience.getSegmentsExperienceId(), serviceContext, taxonomyCategoryIdsStringUtilReplaceValues);
            }
        }
    }

    private void _addSiteConfiguration(ServiceContext serviceContext) throws Exception {
        String resourcePath = "site-initializer/site-configuration.json";
        String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        Group group = this._groupLocalService.getGroup(serviceContext.getScopeGroupId());
        JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
        group.setType(jsonObject.getInt("typeSite"));
        group.setManualMembership(jsonObject.getBoolean("manualMembership"));
        group.setMembershipRestriction(jsonObject.getInt("membershipRestriction"));
        this._groupLocalService.updateGroup(group);
    }

    private void _addSiteNavigationMenu(JSONObject jsonObject, ServiceContext serviceContext, Map<String, SiteNavigationMenuItemSetting> siteNavigationMenuItemSettings) throws Exception {
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuLocalService.addSiteNavigationMenu(serviceContext.getUserId(), serviceContext.getScopeGroupId(), jsonObject.getString("name"), jsonObject.getInt("typeSite"), serviceContext);
        this._addSiteNavigationMenuItems(jsonObject, siteNavigationMenu, 0L, serviceContext, siteNavigationMenuItemSettings);
    }

    private void _addSiteNavigationMenuItems(JSONObject jsonObject, SiteNavigationMenu siteNavigationMenu, long parentSiteNavigationMenuItemId, ServiceContext serviceContext, Map<String, SiteNavigationMenuItemSetting> siteNavigationMenuItemSettings) throws Exception {
        for (Object object : JSONUtil.toObjectArray((JSONArray)jsonObject.getJSONArray("menuItems"))) {
            JSONObject menuItemJSONObject = (JSONObject)object;
            String type = menuItemJSONObject.getString("type");
            String typeSettings = null;
            if (type.equals("layout")) {
                boolean privateLayout = menuItemJSONObject.getBoolean("privateLayout");
                String friendlyURL = menuItemJSONObject.getString("friendlyURL");
                Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(serviceContext.getScopeGroupId(), privateLayout, friendlyURL);
                if (layout == null) {
                    return;
                }
                SiteNavigationMenuItemType siteNavigationMenuItemType = this._siteNavigationMenuItemTypeRegistry.getSiteNavigationMenuItemType("layout");
                typeSettings = siteNavigationMenuItemType.getTypeSettingsFromLayout(layout);
            } else if (type.equals("node")) {
                typeSettings = UnicodePropertiesBuilder.put((String)"name", (String)menuItemJSONObject.getString("name")).buildString();
            } else if (type.equals("url")) {
                typeSettings = UnicodePropertiesBuilder.put((String)"name", (String)menuItemJSONObject.getString("name")).put("url", menuItemJSONObject.getString("url")).put("useNewTab", menuItemJSONObject.getString("useNewTab")).buildString();
            } else if (type.equals("display-page")) {
                SiteNavigationMenuItemSetting siteNavigationMenuItemSetting;
                String key = menuItemJSONObject.getString("key");
                if (Validator.isNull((String)key) || (siteNavigationMenuItemSetting = siteNavigationMenuItemSettings.get(key)) == null) continue;
                type = siteNavigationMenuItemSetting.className;
                typeSettings = UnicodePropertiesBuilder.create((boolean)true).put("className", siteNavigationMenuItemSetting.className).put("classNameId", String.valueOf(this._portal.getClassNameId(siteNavigationMenuItemSetting.className))).put("classPK", String.valueOf(siteNavigationMenuItemSetting.classPK)).put("classTypeId", siteNavigationMenuItemSetting.classTypeId).put("title", siteNavigationMenuItemSetting.title).put("type", siteNavigationMenuItemSetting.type).buildString();
            }
            SiteNavigationMenuItem siteNavigationMenuItem = this._siteNavigationMenuItemLocalService.addSiteNavigationMenuItem(serviceContext.getUserId(), serviceContext.getScopeGroupId(), siteNavigationMenu.getSiteNavigationMenuId(), parentSiteNavigationMenuItemId, type, typeSettings, serviceContext);
            this._addSiteNavigationMenuItems(menuItemJSONObject, siteNavigationMenu, siteNavigationMenuItem.getSiteNavigationMenuItemId(), serviceContext, siteNavigationMenuItemSettings);
        }
    }

    private void _addSiteNavigationMenus(ServiceContext serviceContext, Map<String, SiteNavigationMenuItemSetting> siteNavigationMenuItemSettings) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/site-navigation-menus.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._addSiteNavigationMenu(jsonArray.getJSONObject(i), serviceContext, siteNavigationMenuItemSettings);
        }
    }

    private void _addSiteSettings(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/site-settings.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            HashMapDictionary properties = new HashMapDictionary();
            JSONObject propertiesJSONObject = jsonObject.getJSONObject("properties");
            Iterator iterator = propertiesJSONObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                properties.put(key, propertiesJSONObject.getString(key));
            }
            this._configurationProvider.saveGroupConfiguration(serviceContext.getScopeGroupId(), jsonObject.getString("pid"), (Dictionary)properties);
        }
    }

    private void _addStyleBookEntries(ServiceContext serviceContext) throws Exception {
        Enumeration enumeration = this._bundle.findEntries("/site-initializer/style-books", "*", true);
        if (enumeration == null) {
            return;
        }
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            String fileName = url.getFile();
            if (fileName.endsWith("/")) continue;
            zipWriter.addEntry(this._removeFirst(fileName, "/site-initializer/style-books/"), url.openStream());
        }
        this._styleBookEntryZipProcessor.importStyleBookEntries(serviceContext.getUserId(), serviceContext.getScopeGroupId(), zipWriter.getFile(), true);
    }

    private Map<String, String> _addTaxonomyCategories(String parentResourcePath, String parentTaxonomyCategoryId, ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder, long taxonomyVocabularyId) throws Exception {
        HashMap<String, String> taxonomyCategoryIdsStringUtilReplaceValues = new HashMap<String, String>();
        Set resourcePaths = this._servletContext.getResourcePaths(parentResourcePath);
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return taxonomyCategoryIdsStringUtilReplaceValues;
        }
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith("/")) continue;
            String json = SiteInitializerUtil.read((String)resourcePath, (ServletContext)this._servletContext);
            TaxonomyCategory taxonomyCategory = TaxonomyCategory.toDTO((String)json);
            if (taxonomyCategory == null) {
                _log.error((Object)("Unable to transform taxonomy category from JSON: " + json));
                continue;
            }
            taxonomyCategory = parentTaxonomyCategoryId == null ? this._addOrUpdateTaxonomyVocabularyTaxonomyCategory(serviceContext, taxonomyCategory, taxonomyVocabularyId) : this._addOrUpdateTaxonomyCategoryTaxonomyCategory(parentTaxonomyCategoryId, serviceContext, taxonomyCategory);
            final TaxonomyCategory finalTaxonomyCategory = taxonomyCategory;
            String key = resourcePath;
            taxonomyCategoryIdsStringUtilReplaceValues.put("TAXONOMY_CATEGORY_ID:" + key, String.valueOf(finalTaxonomyCategory.getId()));
            siteNavigationMenuItemSettingsBuilder.put(resourcePath, new SiteNavigationMenuItemSetting(){
                {
                    this.className = AssetCategory.class.getName();
                    this.classPK = finalTaxonomyCategory.getId();
                    this.title = finalTaxonomyCategory.getName();
                }
            });
            taxonomyCategoryIdsStringUtilReplaceValues.putAll(this._addTaxonomyCategories(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)"/"), taxonomyCategory.getId(), serviceContext, siteNavigationMenuItemSettingsBuilder, taxonomyVocabularyId));
        }
        return taxonomyCategoryIdsStringUtilReplaceValues;
    }

    private void _addUserAccounts(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/user-accounts.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        UserAccountResource.Builder userAccountResourceBuilder = this._userAccountResourceFactory.create();
        UserAccountResource userAccountResource = userAccountResourceBuilder.user(serviceContext.fetchUser()).httpServletRequest(serviceContext.getRequest()).build();
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject accountBriefsJSONObject;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONArray accountBriefsJSONArray = jsonObject.getJSONArray("accountBriefs");
            if (JSONUtil.isEmpty((JSONArray)accountBriefsJSONArray)) continue;
            List<Group> oldGroups = new ArrayList();
            int j = 0;
            long userId = 0L;
            UserAccount userAccount = UserAccount.toDTO((String)String.valueOf(jsonObject));
            User user = this._userLocalService.fetchUserByEmailAddress(serviceContext.getCompanyId(), userAccount.getEmailAddress());
            if (user == null) {
                accountBriefsJSONObject = accountBriefsJSONArray.getJSONObject(j);
                userAccount = userAccountResource.putUserAccountByExternalReferenceCode(jsonObject.getString("externalReferenceCode"), userAccount);
                userAccountResource.postAccountByExternalReferenceCodeUserAccountByExternalReferenceCode(accountBriefsJSONObject.getString("externalReferenceCode"), userAccount.getExternalReferenceCode());
                ++j;
                this._associateUserAccounts(accountBriefsJSONObject, jsonObject.getString("emailAddress"), serviceContext);
                userId = userAccount.getId();
            } else {
                userId = user.getUserId();
                oldGroups = user.getSiteGroups();
            }
            oldGroups.add(serviceContext.getScopeGroup());
            this._userLocalService.updateGroups(userId, ListUtil.toLongArray(oldGroups, GroupModel::getGroupId), serviceContext);
            if (jsonObject.has("organizationBriefs")) {
                this._addOrganizationUser(jsonObject.getJSONArray("organizationBriefs"), serviceContext, userId);
            }
            while (j < accountBriefsJSONArray.length()) {
                accountBriefsJSONObject = accountBriefsJSONArray.getJSONObject(j);
                userAccountResource.postAccountUserAccountByExternalReferenceCodeByEmailAddress(accountBriefsJSONObject.getString("externalReferenceCode"), userAccount.getEmailAddress());
                this._associateUserAccounts(accountBriefsJSONObject, jsonObject.getString("emailAddress"), serviceContext);
                ++j;
            }
        }
    }

    private void _addUserRoles(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/user-roles.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            JSONArray rolesJSONArray = jsonObject.getJSONArray("roles");
            if (JSONUtil.isEmpty((JSONArray)rolesJSONArray)) continue;
            ArrayList<Role> roles = new ArrayList<Role>();
            for (int j = 0; j < rolesJSONArray.length(); ++j) {
                roles.add(this._roleLocalService.getRole(serviceContext.getCompanyId(), rolesJSONArray.getString(j)));
            }
            if (!ListUtil.isNotEmpty(roles)) continue;
            User user = this._userLocalService.fetchUserByEmailAddress(serviceContext.getCompanyId(), jsonObject.getString("emailAddress"));
            this._roleLocalService.addUserRoles(user.getUserId(), roles);
        }
    }

    private void _addWorkflowDefinitions(Map<String, String> roleIdsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/workflow-definitions");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        WorkflowDefinitionResource.Builder workflowDefinitionResourceBuilder = this._workflowDefinitionResourceFactory.create();
        WorkflowDefinitionResource workflowDefinitionResource = workflowDefinitionResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            JSONObject workflowDefinitionJSONObject = this._jsonFactory.createJSONObject(SiteInitializerUtil.read((String)(resourcePath + "workflow-definition.json"), (ServletContext)this._servletContext));
            workflowDefinitionJSONObject.put("content", this._replace(SiteInitializerUtil.read((String)(resourcePath + "workflow-definition.xml"), (ServletContext)this._servletContext), roleIdsStringUtilReplaceValues));
            WorkflowDefinition workflowDefinition = workflowDefinitionResource.postWorkflowDefinitionDeploy(WorkflowDefinition.toDTO((String)workflowDefinitionJSONObject.toString()));
            String propertiesJSON = SiteInitializerUtil.read((String)(resourcePath + "workflow-definition.properties.json"), (ServletContext)this._servletContext);
            if (propertiesJSON == null) continue;
            JSONArray propertiesJSONArray = this._jsonFactory.createJSONArray(propertiesJSON);
            for (int i = 0; i < propertiesJSONArray.length(); ++i) {
                String className;
                JSONObject propertiesJSONObject = propertiesJSONArray.getJSONObject(i);
                long groupId = 0L;
                if (StringUtil.equals((String)propertiesJSONObject.getString("scope"), (String)"site")) {
                    groupId = serviceContext.getScopeGroupId();
                }
                if (StringUtil.equals((String)(className = propertiesJSONObject.getString("className")), (String)ObjectDefinition.class.getName())) {
                    ObjectDefinition objectDefinition = this._objectDefinitionLocalService.fetchObjectDefinition(serviceContext.getCompanyId(), propertiesJSONObject.getString("assetName"));
                    if (objectDefinition == null) continue;
                    className = StringBundler.concat((Object[])new Object[]{className, "#", objectDefinition.getObjectDefinitionId()});
                }
                long typePK = 0L;
                if (this._commerceSiteInitializer != null && StringUtil.equals((String)className, (String)this._commerceSiteInitializer.getCommerceOrderClassName())) {
                    groupId = this._commerceSiteInitializer.getCommerceChannelGroupId(groupId);
                    typePK = propertiesJSONObject.getLong("typePK");
                }
                this._workflowDefinitionLinkLocalService.updateWorkflowDefinitionLink(serviceContext.getUserId(), serviceContext.getCompanyId(), groupId, className, 0L, typePK, StringBundler.concat((String[])new String[]{workflowDefinition.getName(), "@", workflowDefinition.getVersion()}));
            }
        }
    }

    private void _associateUserAccounts(JSONObject accountBriefsJSONObject, String emailAddress, ServiceContext serviceContext) throws Exception {
        if (!accountBriefsJSONObject.has("roleBriefs")) {
            return;
        }
        JSONArray jsonArray = accountBriefsJSONObject.getJSONArray("roleBriefs");
        if (JSONUtil.isEmpty((JSONArray)jsonArray)) {
            return;
        }
        AccountRoleResource.Builder builder = this._accountRoleResourceFactory.create();
        AccountRoleResource accountRoleResource = builder.user(serviceContext.fetchUser()).build();
        for (int i = 0; i < jsonArray.length(); ++i) {
            Page accountRolePage = accountRoleResource.getAccountAccountRolesByExternalReferenceCodePage(accountBriefsJSONObject.getString("externalReferenceCode"), null, accountRoleResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", jsonArray.getString(i), "'"})), null, null);
            com.liferay.headless.admin.user.dto.v1_0.AccountRole accountRole = (com.liferay.headless.admin.user.dto.v1_0.AccountRole)accountRolePage.fetchFirstItem();
            if (accountRole == null) continue;
            accountRoleResource.postAccountByExternalReferenceCodeAccountRoleUserAccountByEmailAddress(accountBriefsJSONObject.getString("externalReferenceCode"), accountRole.getId(), emailAddress);
        }
    }

    private long[] _getAssetCategoryIds(long groupId, String[] externalReferenceCodes) {
        ArrayList<Long> assetCategoryIds = new ArrayList<Long>();
        for (String externalReferenceCode : externalReferenceCodes) {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategoryByExternalReferenceCode(externalReferenceCode, groupId);
            if (assetCategory == null) continue;
            assetCategoryIds.add(assetCategory.getCategoryId());
        }
        return ArrayUtil.toLongArray(assetCategoryIds);
    }

    private Map<String, String> _getClassNameIdStringUtilReplaceValues() {
        Class[] classes;
        HashMap<String, String> map = new HashMap<String, String>();
        for (Class clazz : classes = new Class[]{DDMStructure.class, JournalArticle.class}) {
            map.put("CLASS_NAME_ID:" + clazz.getName(), String.valueOf(this._portal.getClassNameId(clazz)));
        }
        return map;
    }

    private Serializable _getExpandoAttributeValue(JSONObject jsonObject) throws Exception {
        if (jsonObject.getInt("dataType") == 1) {
            return Boolean.valueOf(jsonObject.getBoolean("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 3) {
            if (Validator.isNull((String)jsonObject.getString("defaultValue"))) {
                return null;
            }
            DateFormat dateFormat = DateUtil.getISOFormat((String)jsonObject.getString("defaultValue"));
            return dateFormat.parse(jsonObject.getString("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 5) {
            return Double.valueOf(jsonObject.getDouble("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 6) {
            return JSONUtil.toDoubleArray((JSONArray)jsonObject.getJSONArray("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 7) {
            return Double.valueOf(jsonObject.getDouble("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 8) {
            return JSONUtil.toFloatArray((JSONArray)jsonObject.getJSONArray("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 9) {
            return Integer.valueOf(jsonObject.getInt("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 10) {
            return JSONUtil.toIntegerArray((JSONArray)jsonObject.getJSONArray("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 11) {
            return Long.valueOf(jsonObject.getLong("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 12) {
            return JSONUtil.toLongArray((JSONArray)jsonObject.getJSONArray("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 17) {
            return Double.valueOf(jsonObject.getDouble("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 18) {
            return JSONUtil.toIntegerArray((JSONArray)jsonObject.getJSONArray("defaultValue"));
        }
        if (jsonObject.getInt("dataType") == 15) {
            return jsonObject.getString("defaultValue");
        }
        if (jsonObject.getInt("dataType") == 16) {
            return JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("defaultValue"));
        }
        return (Serializable)jsonObject.get("defaultValue");
    }

    private Map<String, String> _getReleaseInfoStringUtilReplaceValues() {
        HashMap<String, String> map = new HashMap<String, String>();
        Object[] entries = new Object[]{"BUILD_DATE", ReleaseInfo.getBuildDate(), "BUILD_NUMBER", ReleaseInfo.getBuildNumber(), "CODE_NAME", ReleaseInfo.getCodeName(), "NAME", ReleaseInfo.getName(), "PARENT_BUILD_NUMBER", ReleaseInfo.getParentBuildNumber(), "RELEASE_INFO", this._replace(ReleaseInfo.getReleaseInfo(), "(", "<br>("), "SERVER_INFO", ReleaseInfo.getServerInfo(), "VENDOR", ReleaseInfo.getVendor(), "VERSION", ReleaseInfo.getVersion(), "VERSION_DISPLAY_NAME", ReleaseInfo.getVersionDisplayName()};
        for (int i = 0; i < entries.length; i += 2) {
            String entryKey = String.valueOf(entries[i]);
            String entryValue = String.valueOf(entries[i + 1]);
            map.put("RELEASE_INFO:" + entryKey, entryValue);
        }
        return map;
    }

    private String _getThemeId(long companyId, String defaultThemeId, String themeName) {
        List themes = ListUtil.filter((List)this._themeLocalService.getThemes(companyId), theme -> Objects.equals(theme.getName(), themeName));
        if (ListUtil.isNotEmpty((List)themes)) {
            Theme theme2 = (Theme)themes.get(0);
            return theme2.getThemeId();
        }
        return defaultThemeId;
    }

    private void _invoke(UnsafeRunnable<Exception> unsafeRunnable) throws Exception {
        long startTime = System.currentTimeMillis();
        unsafeRunnable.run();
        if (_log.isInfoEnabled()) {
            Thread thread = Thread.currentThread();
            StackTraceElement stackTraceElement = thread.getStackTrace()[2];
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Invoking line ", stackTraceElement.getLineNumber(), " took ", System.currentTimeMillis() - startTime, " ms"}));
        }
    }

    private <T> T _invoke(UnsafeSupplier<T, Exception> unsafeSupplier) throws Exception {
        long startTime = System.currentTimeMillis();
        Object t = unsafeSupplier.get();
        if (_log.isInfoEnabled()) {
            Thread thread = Thread.currentThread();
            StackTraceElement stackTraceElement = thread.getStackTrace()[2];
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Invoking line ", stackTraceElement.getLineNumber(), " in ", System.currentTimeMillis() - startTime, " ms"}));
        }
        return (T)t;
    }

    private String _removeFirst(String s, String oldSub) {
        int index = s.indexOf(oldSub);
        return s.substring(index + oldSub.length());
    }

    private String _replace(String s, Map<String, String> ... stringUtilReplaceValuesArray) {
        HashMap<String, String> aggregatedStringUtilReplaceValues = new HashMap<String, String>();
        for (Map<String, String> stringUtilReplaceValues : stringUtilReplaceValuesArray) {
            aggregatedStringUtilReplaceValues.putAll(stringUtilReplaceValues);
        }
        aggregatedStringUtilReplaceValues.putAll(this._classNameIdStringUtilReplaceValues);
        aggregatedStringUtilReplaceValues.putAll(this._releaseInfoStringUtilReplaceValues);
        s = StringUtil.replace((String)s, (String)"\"[#", (String)"#]\"", aggregatedStringUtilReplaceValues);
        return StringUtil.replace((String)s, (String)"[$", (String)"$]", aggregatedStringUtilReplaceValues);
    }

    private String _replace(String s, ServiceContext serviceContext) throws Exception {
        Group group = serviceContext.getScopeGroup();
        return StringUtil.replace((String)s, (String[])new String[]{"[$COMPANY_ID$]", "[$GROUP_FRIENDLY_URL$]", "[$GROUP_ID$]", "[$GROUP_KEY$]", "[$PORTAL_URL$]"}, (String[])new String[]{String.valueOf(group.getCompanyId()), group.getFriendlyURL(), String.valueOf(serviceContext.getScopeGroupId()), group.getGroupKey(), serviceContext.getPortalURL()});
    }

    private String _replace(String s, String oldSub, String newSub) {
        return StringUtil.replace((String)s, (String)oldSub, (String)newSub);
    }

    private void _setDefaultLayoutUtilityPageEntries(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/layout-utility-page-entries/default-utility-page-entries.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String type = (String)iterator.next();
            String name = jsonObject.getString(type);
            LayoutUtilityPageEntry layoutUtilityPageEntry = this._layoutUtilityPageEntryLocalService.fetchLayoutUtilityPageEntry(serviceContext.getScopeGroupId(), name, LayoutUtilityPageEntryTypeConverter.convertToInternalValue((String)type));
            if (layoutUtilityPageEntry == null) continue;
            this._layoutUtilityPageEntryLocalService.setDefaultLayoutUtilityPageEntry(layoutUtilityPageEntry.getLayoutUtilityPageEntryId());
        }
    }

    private void _setPLOEntries(ServiceContext serviceContext) throws Exception {
        String json = SiteInitializerUtil.read((String)"/site-initializer/plo-entries.json", (ServletContext)this._servletContext);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this._ploEntryLocalService.setPLOEntries(serviceContext.getCompanyId(), serviceContext.getUserId(), jsonObject.getString("key"), SiteInitializerUtil.toMap((String)jsonObject.getString("value")));
        }
    }

    private void _setResourcePermissions(long companyId, String name, JSONArray permissionsJSONArray, String primKey) throws Exception {
        if (permissionsJSONArray == null) {
            return;
        }
        for (int i = 0; i < permissionsJSONArray.length(); ++i) {
            JSONObject permissionsJSONObject = permissionsJSONArray.getJSONObject(i);
            int scope = permissionsJSONObject.getInt("scope");
            String roleName = permissionsJSONObject.getString("roleName");
            Role role = this._roleLocalService.getRole(companyId, roleName);
            Object[] actionIds = new String[]{};
            JSONArray actionIdsJSONArray = permissionsJSONObject.getJSONArray("actionIds");
            if (actionIdsJSONArray != null) {
                for (int j = 0; j < actionIdsJSONArray.length(); ++j) {
                    actionIds = (String[])ArrayUtil.append((Object[])actionIds, (Object)actionIdsJSONArray.getString(j));
                }
            }
            this._resourcePermissionLocalService.setResourcePermissions(companyId, name, scope, primKey, role.getRoleId(), (String[])actionIds);
        }
    }

    private Layout _updateDraftLayout(Layout draftLayout, JSONObject settingsJSONObject) throws Exception {
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        UnicodeProperties unicodeProperties = draftLayout.getTypeSettingsProperties();
        Set set = unicodeProperties.entrySet();
        set.removeIf(entry -> StringUtil.startsWith((String)((String)entry.getKey()), (String)"lfr-theme:"));
        JSONObject themeSettingsJSONObject = settingsJSONObject.getJSONObject("themeSettings");
        if (themeSettingsJSONObject != null) {
            for (String key : themeSettingsJSONObject.keySet()) {
                unicodeProperties.put(key, themeSettingsJSONObject.getString(key));
            }
            draftLayout = this._layoutLocalService.updateLayout(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), unicodeProperties.toString());
            draftLayout.setTypeSettingsProperties(unicodeProperties);
        }
        draftLayout = this._layoutLocalService.updateLookAndFeel(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), this._getThemeId(draftLayout.getCompanyId(), draftLayout.getThemeId(), settingsJSONObject.getString("themeName")), settingsJSONObject.getString("colorSchemeName", draftLayout.getColorSchemeId()), settingsJSONObject.getString("css", draftLayout.getCss()));
        JSONObject masterPageJSONObject = settingsJSONObject.getJSONObject("masterPage");
        if (masterPageJSONObject != null && (layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(draftLayout.getGroupId(), masterPageJSONObject.getString("key"))) != null) {
            draftLayout = this._layoutLocalService.updateMasterLayoutPlid(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), layoutPageTemplateEntry.getPlid());
        }
        return draftLayout;
    }

    private void _updateGroupSiteInitializerKey(long groupId) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-165482")) {
            return;
        }
        Group group = this._groupLocalService.getGroup(groupId);
        UnicodeProperties typeSettingsUnicodeProperties = group.getTypeSettingsProperties();
        typeSettingsUnicodeProperties.setProperty("siteInitializerKey", this.getKey());
        this._groupLocalService.updateGroup(group.getGroupId(), typeSettingsUnicodeProperties.toString());
    }

    private void _updateLayoutSet(Map<String, String> documentsStringUtilReplaceValues, boolean privateLayout, ServiceContext serviceContext) throws Exception {
        JSONObject settingsJSONObject;
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(serviceContext.getScopeGroupId(), privateLayout);
        String resourcePath = "/site-initializer/layout-set";
        resourcePath = privateLayout ? resourcePath + "/private" : resourcePath + "/public";
        String metadataJSON = SiteInitializerUtil.read((String)(resourcePath + "/metadata.json"), (ServletContext)this._servletContext);
        JSONObject metadataJSONObject = this._jsonFactory.createJSONObject(metadataJSON == null ? "{}" : metadataJSON);
        String css = this._replace(SiteInitializerUtil.read((String)(resourcePath + "/css.css"), (ServletContext)this._servletContext), documentsStringUtilReplaceValues);
        this._layoutSetLocalService.updateLookAndFeel(serviceContext.getScopeGroupId(), privateLayout, this._getThemeId(serviceContext.getCompanyId(), "", metadataJSONObject.getString("themeName")), layoutSet.getColorSchemeId(), css);
        URL url = this._servletContext.getResource(resourcePath + "/logo.png");
        if (url != null) {
            this._layoutSetLocalService.updateLogo(serviceContext.getScopeGroupId(), privateLayout, true, FileUtil.getBytes((InputStream)url.openStream()));
        }
        if ((settingsJSONObject = metadataJSONObject.getJSONObject("settings")) == null) {
            return;
        }
        String js = SiteInitializerUtil.read((String)(resourcePath + "/js.js"), (ServletContext)this._servletContext);
        if (Validator.isNotNull((String)js)) {
            settingsJSONObject.put("javascript", js);
        }
        UnicodeProperties unicodeProperties = layoutSet.getSettingsProperties();
        for (String key : settingsJSONObject.keySet()) {
            unicodeProperties.put(key, settingsJSONObject.getString(key));
        }
        this._layoutSetLocalService.updateSettings(serviceContext.getScopeGroupId(), privateLayout, unicodeProperties.toString());
    }

    private void _updateLayoutSets(Map<String, String> documentsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        this._updateLayoutSet(documentsStringUtilReplaceValues, false, serviceContext);
        this._updateLayoutSet(documentsStringUtilReplaceValues, true, serviceContext);
    }

    private class SiteNavigationMenuItemSettingsBuilder {
        private Map<String, SiteNavigationMenuItemSetting> _siteNavigationMenuItemSettings = new HashMap<String, SiteNavigationMenuItemSetting>();

        private SiteNavigationMenuItemSettingsBuilder() {
        }

        public Map<String, SiteNavigationMenuItemSetting> build() {
            return this._siteNavigationMenuItemSettings;
        }

        public void put(String key, SiteNavigationMenuItemSetting siteNavigationMenuItemSetting) {
            this._siteNavigationMenuItemSettings.put(key, siteNavigationMenuItemSetting);
        }
    }

    private class SiteNavigationMenuItemSetting {
        public String className;
        public String classPK;
        public String classTypeId = "";
        public String title;
        public String type = "";

        private SiteNavigationMenuItemSetting() {
        }
    }
}

