/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.extender.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.list.model.AssetListEntry;
import com.liferay.asset.list.service.AssetListEntryLocalService;
import com.liferay.commerce.inventory.model.CommerceInventoryWarehouse;
import com.liferay.commerce.product.model.CPDefinition;
import com.liferay.commerce.product.model.CPInstance;
import com.liferay.commerce.product.model.CommerceChannel;
import com.liferay.commerce.product.service.CommerceCatalogLocalServiceUtil;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.fragment.importer.FragmentsImporter;
import com.liferay.headless.admin.list.type.dto.v1_0.ListTypeDefinition;
import com.liferay.headless.admin.list.type.dto.v1_0.ListTypeEntry;
import com.liferay.headless.admin.list.type.resource.v1_0.ListTypeDefinitionResource;
import com.liferay.headless.admin.list.type.resource.v1_0.ListTypeEntryResource;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyCategory;
import com.liferay.headless.admin.taxonomy.dto.v1_0.TaxonomyVocabulary;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyCategoryResource;
import com.liferay.headless.admin.taxonomy.resource.v1_0.TaxonomyVocabularyResource;
import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.headless.admin.user.dto.v1_0.UserAccount;
import com.liferay.headless.admin.user.resource.v1_0.AccountResource;
import com.liferay.headless.admin.user.resource.v1_0.UserAccountResource;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Catalog;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.Option;
import com.liferay.headless.commerce.admin.catalog.dto.v1_0.ProductOption;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.CatalogResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.OptionResource;
import com.liferay.headless.commerce.admin.catalog.resource.v1_0.ProductOptionResource;
import com.liferay.headless.commerce.admin.channel.dto.v1_0.Channel;
import com.liferay.headless.commerce.admin.channel.resource.v1_0.ChannelResource;
import com.liferay.headless.delivery.dto.v1_0.Document;
import com.liferay.headless.delivery.dto.v1_0.DocumentFolder;
import com.liferay.headless.delivery.dto.v1_0.StructuredContentFolder;
import com.liferay.headless.delivery.resource.v1_0.DocumentFolderResource;
import com.liferay.headless.delivery.resource.v1_0.DocumentResource;
import com.liferay.headless.delivery.resource.v1_0.StructuredContentFolderResource;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.layout.page.template.importer.LayoutPageTemplatesImporter;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.object.admin.rest.dto.v1_0.ObjectDefinition;
import com.liferay.object.admin.rest.dto.v1_0.ObjectRelationship;
import com.liferay.object.admin.rest.resource.v1_0.ObjectDefinitionResource;
import com.liferay.object.admin.rest.resource.v1_0.ObjectRelationshipResource;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.LayoutSetLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ThemeLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissionsFactory;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactoryUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import com.liferay.portal.vulcan.multipart.BinaryFile;
import com.liferay.portal.vulcan.multipart.MultipartBody;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.util.ObjectMapperUtil;
import com.liferay.remote.app.model.RemoteAppEntry;
import com.liferay.remote.app.service.RemoteAppEntryLocalService;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import com.liferay.site.initializer.extender.internal.CommerceReferencesHolder;
import com.liferay.site.navigation.model.SiteNavigationMenu;
import com.liferay.site.navigation.model.SiteNavigationMenuItem;
import com.liferay.site.navigation.service.SiteNavigationMenuItemLocalService;
import com.liferay.site.navigation.service.SiteNavigationMenuLocalService;
import com.liferay.site.navigation.type.SiteNavigationMenuItemType;
import com.liferay.site.navigation.type.SiteNavigationMenuItemTypeRegistry;
import com.liferay.style.book.zip.processor.StyleBookEntryZipProcessor;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class BundleSiteInitializer
implements SiteInitializer {
    private static final Log _log = LogFactoryUtil.getLog(BundleSiteInitializer.class);
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private final AccountResource.Factory _accountResourceFactory;
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final AssetListEntryLocalService _assetListEntryLocalService;
    private final Bundle _bundle;
    private final ClassLoader _classLoader;
    private CommerceReferencesHolder _commerceReferencesHolder;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final DDMTemplateLocalService _ddmTemplateLocalService;
    private final DefaultDDMStructureHelper _defaultDDMStructureHelper;
    private final DLURLHelper _dlURLHelper;
    private final DocumentFolderResource.Factory _documentFolderResourceFactory;
    private final DocumentResource.Factory _documentResourceFactory;
    private final FragmentsImporter _fragmentsImporter;
    private final GroupLocalService _groupLocalService;
    private final JournalArticleLocalService _journalArticleLocalService;
    private final JSONFactory _jsonFactory;
    private final LayoutCopyHelper _layoutCopyHelper;
    private final LayoutLocalService _layoutLocalService;
    private final LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    private final LayoutPageTemplatesImporter _layoutPageTemplatesImporter;
    private final LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    private final LayoutSetLocalService _layoutSetLocalService;
    private final ListTypeDefinitionResource _listTypeDefinitionResource;
    private final ListTypeDefinitionResource.Factory _listTypeDefinitionResourceFactory;
    private final ListTypeEntryResource _listTypeEntryResource;
    private final ListTypeEntryResource.Factory _listTypeEntryResourceFactory;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectDefinitionResource.Factory _objectDefinitionResourceFactory;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectRelationshipResource.Factory _objectRelationshipResourceFactory;
    private final Portal _portal;
    private final RemoteAppEntryLocalService _remoteAppEntryLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;
    private final SAPEntryLocalService _sapEntryLocalService;
    private final ServletContext _servletContext;
    private final SettingsFactory _settingsFactory;
    private final SiteNavigationMenuItemLocalService _siteNavigationMenuItemLocalService;
    private final SiteNavigationMenuItemTypeRegistry _siteNavigationMenuItemTypeRegistry;
    private final SiteNavigationMenuLocalService _siteNavigationMenuLocalService;
    private final StructuredContentFolderResource.Factory _structuredContentFolderResourceFactory;
    private final StyleBookEntryZipProcessor _styleBookEntryZipProcessor;
    private final TaxonomyCategoryResource.Factory _taxonomyCategoryResourceFactory;
    private final TaxonomyVocabularyResource.Factory _taxonomyVocabularyResourceFactory;
    private final ThemeLocalService _themeLocalService;
    private final UserAccountResource.Factory _userAccountResourceFactory;
    private final UserLocalService _userLocalService;

    public BundleSiteInitializer(AccountResource.Factory accountResourceFactory, AssetCategoryLocalService assetCategoryLocalService, AssetListEntryLocalService assetListEntryLocalService, Bundle bundle, CommerceReferencesHolder commerceReferencesHolder, DDMStructureLocalService ddmStructureLocalService, DDMTemplateLocalService ddmTemplateLocalService, DefaultDDMStructureHelper defaultDDMStructureHelper, DLURLHelper dlURLHelper, DocumentFolderResource.Factory documentFolderResourceFactory, DocumentResource.Factory documentResourceFactory, FragmentsImporter fragmentsImporter, GroupLocalService groupLocalService, JournalArticleLocalService journalArticleLocalService, JSONFactory jsonFactory, LayoutCopyHelper layoutCopyHelper, LayoutLocalService layoutLocalService, LayoutPageTemplateEntryLocalService layoutPageTemplateEntryLocalService, LayoutPageTemplatesImporter layoutPageTemplatesImporter, LayoutPageTemplateStructureLocalService layoutPageTemplateStructureLocalService, LayoutSetLocalService layoutSetLocalService, ListTypeDefinitionResource listTypeDefinitionResource, ListTypeDefinitionResource.Factory listTypeDefinitionResourceFactory, ListTypeEntryResource listTypeEntryResource, ListTypeEntryResource.Factory listTypeEntryResourceFactory, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectDefinitionResource.Factory objectDefinitionResourceFactory, ObjectRelationshipResource.Factory objectRelationshipResourceFactory, ObjectEntryLocalService objectEntryLocalService, Portal portal, RemoteAppEntryLocalService remoteAppEntryLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService, SAPEntryLocalService sapEntryLocalService, ServletContext servletContext, SettingsFactory settingsFactory, SiteNavigationMenuItemLocalService siteNavigationMenuItemLocalService, SiteNavigationMenuItemTypeRegistry siteNavigationMenuItemTypeRegistry, SiteNavigationMenuLocalService siteNavigationMenuLocalService, StructuredContentFolderResource.Factory structuredContentFolderResourceFactory, StyleBookEntryZipProcessor styleBookEntryZipProcessor, TaxonomyCategoryResource.Factory taxonomyCategoryResourceFactory, TaxonomyVocabularyResource.Factory taxonomyVocabularyResourceFactory, ThemeLocalService themeLocalService, UserAccountResource.Factory userAccountResourceFactory, UserLocalService userLocalService) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Commerce references holder " + commerceReferencesHolder));
        }
        this._accountResourceFactory = accountResourceFactory;
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._assetListEntryLocalService = assetListEntryLocalService;
        this._bundle = bundle;
        this._commerceReferencesHolder = commerceReferencesHolder;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._ddmTemplateLocalService = ddmTemplateLocalService;
        this._defaultDDMStructureHelper = defaultDDMStructureHelper;
        this._dlURLHelper = dlURLHelper;
        this._documentFolderResourceFactory = documentFolderResourceFactory;
        this._documentResourceFactory = documentResourceFactory;
        this._fragmentsImporter = fragmentsImporter;
        this._groupLocalService = groupLocalService;
        this._journalArticleLocalService = journalArticleLocalService;
        this._jsonFactory = jsonFactory;
        this._layoutCopyHelper = layoutCopyHelper;
        this._layoutLocalService = layoutLocalService;
        this._layoutPageTemplateEntryLocalService = layoutPageTemplateEntryLocalService;
        this._layoutPageTemplatesImporter = layoutPageTemplatesImporter;
        this._layoutPageTemplateStructureLocalService = layoutPageTemplateStructureLocalService;
        this._layoutSetLocalService = layoutSetLocalService;
        this._listTypeDefinitionResource = listTypeDefinitionResource;
        this._listTypeDefinitionResourceFactory = listTypeDefinitionResourceFactory;
        this._listTypeEntryResource = listTypeEntryResource;
        this._listTypeEntryResourceFactory = listTypeEntryResourceFactory;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectDefinitionResourceFactory = objectDefinitionResourceFactory;
        this._objectRelationshipResourceFactory = objectRelationshipResourceFactory;
        this._objectEntryLocalService = objectEntryLocalService;
        this._portal = portal;
        this._remoteAppEntryLocalService = remoteAppEntryLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
        this._sapEntryLocalService = sapEntryLocalService;
        this._servletContext = servletContext;
        this._settingsFactory = settingsFactory;
        this._siteNavigationMenuItemLocalService = siteNavigationMenuItemLocalService;
        this._siteNavigationMenuItemTypeRegistry = siteNavigationMenuItemTypeRegistry;
        this._siteNavigationMenuLocalService = siteNavigationMenuLocalService;
        this._structuredContentFolderResourceFactory = structuredContentFolderResourceFactory;
        this._styleBookEntryZipProcessor = styleBookEntryZipProcessor;
        this._taxonomyCategoryResourceFactory = taxonomyCategoryResourceFactory;
        this._taxonomyVocabularyResourceFactory = taxonomyVocabularyResourceFactory;
        this._themeLocalService = themeLocalService;
        this._userAccountResourceFactory = userAccountResourceFactory;
        this._userLocalService = userLocalService;
        BundleWiring bundleWiring = (BundleWiring)this._bundle.adapt(BundleWiring.class);
        this._classLoader = bundleWiring.getClassLoader();
    }

    public String getDescription(Locale locale) {
        Dictionary headers = this._bundle.getHeaders("");
        return GetterUtil.getString((String)((String)headers.get("Liferay-Site-Initializer-Description")));
    }

    public String getKey() {
        return this._bundle.getSymbolicName();
    }

    public String getName(Locale locale) {
        Dictionary headers = this._bundle.getHeaders("");
        return GetterUtil.getString((String)((String)headers.get("Liferay-Site-Initializer-Name")), (String)((String)headers.get("Bundle-Name")));
    }

    public String getThumbnailSrc() {
        return this._servletContext.getContextPath() + "/images/thumbnail.png";
    }

    public void initialize(final long groupId) throws InitializationException {
        long startTime = System.currentTimeMillis();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Initializing ", this.getKey(), " for group ", groupId}));
        }
        try {
            final User user = this._userLocalService.getUser(PrincipalThreadLocal.getUserId());
            ServiceContext serviceContext = new ServiceContext(){
                {
                    this.setAddGroupPermissions(true);
                    this.setAddGuestPermissions(true);
                    this.setCompanyId(user.getCompanyId());
                    this.setScopeGroupId(groupId);
                    this.setTimeZone(user.getTimeZone());
                    this.setUserId(user.getUserId());
                }
            };
            SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder = new SiteNavigationMenuItemSettingsBuilder();
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addPermissions(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addAccounts(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addDDMStructures(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addFragmentEntries(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addSAPEntries(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addStyleBookEntries(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addTaxonomyVocabularies(serviceContext, siteNavigationMenuItemSettingsBuilder)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addUserAccounts(serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._updateLayoutSets(serviceContext)));
            Map assetListEntryIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addAssetListEntries(this._ddmStructureLocalService, serviceContext));
            Map documentsStringUtilReplaceValues = (Map)this._invoke(() -> this._addDocuments(serviceContext, siteNavigationMenuItemSettingsBuilder));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addDDMTemplates(this._ddmStructureLocalService, serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addJournalArticles(this._ddmStructureLocalService, this._ddmTemplateLocalService, documentsStringUtilReplaceValues, serviceContext, siteNavigationMenuItemSettingsBuilder)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addLayoutPageTemplates(assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, serviceContext)));
            Map listTypeDefinitionIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addListTypeDefinitions(serviceContext));
            Map objectDefinitionIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addObjectDefinitions(listTypeDefinitionIdsStringUtilReplaceValues, serviceContext, siteNavigationMenuItemSettingsBuilder));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addCPDefinitions(documentsStringUtilReplaceValues, objectDefinitionIdsStringUtilReplaceValues, serviceContext)));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addObjectRelationships(objectDefinitionIdsStringUtilReplaceValues, serviceContext)));
            Map remoteAppEntryIdsStringUtilReplaceValues = (Map)this._invoke(() -> this._addRemoteAppEntries(documentsStringUtilReplaceValues, serviceContext));
            this._invoke((UnsafeRunnable<Exception>)((UnsafeRunnable)() -> this._addLayouts(assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, remoteAppEntryIdsStringUtilReplaceValues, serviceContext, siteNavigationMenuItemSettingsBuilder.build())));
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
            throw new InitializationException((Throwable)exception);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Initialized ", this.getKey(), " for group ", groupId, " in ", System.currentTimeMillis() - startTime, " ms"}));
        }
    }

    public boolean isActive(long companyId) {
        return true;
    }

    private void _addAccounts(ServiceContext serviceContext) throws Exception {
        String json = this._read("/site-initializer/accounts.json");
        if (json == null) {
            return;
        }
        AccountResource.Builder accountResourceBuilder = this._accountResourceFactory.create();
        AccountResource accountResource = accountResourceBuilder.user(serviceContext.fetchUser()).build();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            Account account = Account.toDTO((String)String.valueOf(jsonArray.getJSONObject(i)));
            accountResource.putAccountByExternalReferenceCode(account.getExternalReferenceCode(), account);
        }
    }

    private Map<String, String> _addAssetListEntries(DDMStructureLocalService ddmStructureLocalService, ServiceContext serviceContext) throws Exception {
        HashMap<String, String> assetListEntryIdsStringUtilReplaceValues = new HashMap<String, String>();
        String json = this._read("/site-initializer/asset-list-entries.json");
        if (json == null) {
            return assetListEntryIdsStringUtilReplaceValues;
        }
        JSONArray assetListJSONArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < assetListJSONArray.length(); ++i) {
            JSONObject assetListJSONObject = assetListJSONArray.getJSONObject(i);
            this._addAssetListEntry(assetListJSONObject, ddmStructureLocalService, serviceContext);
        }
        List assetListEntries = this._assetListEntryLocalService.getAssetListEntries(serviceContext.getScopeGroupId());
        for (AssetListEntry assetListEntry : assetListEntries) {
            String assetListEntryKeyUppercase = StringUtil.toUpperCase((String)assetListEntry.getAssetListEntryKey());
            assetListEntryIdsStringUtilReplaceValues.put("ASSET_LIST_ENTRY_ID:" + assetListEntryKeyUppercase, String.valueOf(assetListEntry.getAssetListEntryId()));
        }
        return assetListEntryIdsStringUtilReplaceValues;
    }

    private void _addAssetListEntry(JSONObject assetListJSONObject, DDMStructureLocalService ddmStructureLocalService, ServiceContext serviceContext) throws Exception {
        Object[] orderByObjects;
        JSONObject unicodePropertiesJSONObject = assetListJSONObject.getJSONObject("unicodeProperties");
        DDMStructure ddmStructure = ddmStructureLocalService.getStructure(serviceContext.getScopeGroupId(), this._portal.getClassNameId(unicodePropertiesJSONObject.getString("classNameIds")), assetListJSONObject.getString("ddmStructureKey"));
        HashMap map = HashMapBuilder.put((Object)"anyAssetType", (Object)String.valueOf(this._portal.getClassNameId(unicodePropertiesJSONObject.getString("classNameIds")))).put((Object)unicodePropertiesJSONObject.getString("anyClassType"), (Object)String.valueOf(ddmStructure.getStructureId())).put((Object)"classNameIds", (Object)unicodePropertiesJSONObject.getString("classNameIds")).put((Object)unicodePropertiesJSONObject.getString("classTypeIds"), (Object)String.valueOf(ddmStructure.getStructureId())).put((Object)"groupIds", (Object)String.valueOf(serviceContext.getScopeGroupId())).build();
        for (Object orderByObject : orderByObjects = JSONUtil.toObjectArray((JSONArray)unicodePropertiesJSONObject.getJSONArray("orderBy"))) {
            JSONObject orderByJSONObject = (JSONObject)orderByObject;
            map.put(orderByJSONObject.getString("key"), orderByJSONObject.getString("value"));
        }
        String[] assetTagNames = JSONUtil.toStringArray((JSONArray)assetListJSONObject.getJSONArray("assetTagNames"));
        for (int i = 0; i < assetTagNames.length; ++i) {
            Object[] queryObjects;
            map.put("queryValues" + i, assetTagNames[i]);
            for (Object queryObject : queryObjects = JSONUtil.toObjectArray((JSONArray)unicodePropertiesJSONObject.getJSONArray("query"))) {
                JSONObject queryJSONObject = (JSONObject)queryObject;
                map.put(queryJSONObject.getString("key"), queryJSONObject.getString("value"));
            }
        }
        this._assetListEntryLocalService.addDynamicAssetListEntry(serviceContext.getUserId(), serviceContext.getScopeGroupId(), assetListJSONObject.getString("title"), String.valueOf(new UnicodeProperties((Map)map, true)), serviceContext);
    }

    private void _addCommerceCatalogs(Channel channel, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, ServiceContext serviceContext) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/commerce-catalogs");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        CatalogResource.Builder catalogResourceBuilder = this._commerceReferencesHolder.catalogResourceFactory.create();
        CatalogResource catalogResource = catalogResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith(".options.json") || resourcePath.endsWith(".products.json") || resourcePath.endsWith(".products.subscriptions.properties.json") || !resourcePath.endsWith(".json")) continue;
            String json = this._read(resourcePath);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
            String assetVocabularyName = jsonObject.getString("assetVocabularyName");
            jsonObject.remove("assetVocabularyName");
            Catalog catalog = Catalog.toDTO((String)String.valueOf(jsonObject));
            if (catalog == null) {
                _log.error((Object)("Unable to transform commerce catalog from JSON: " + json));
                continue;
            }
            catalog = catalogResource.postCatalog(catalog);
            this._addCPOptions(catalog, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".options.json"), serviceContext);
            this._addCPDefinitions(assetVocabularyName, catalog, channel, commerceInventoryWarehouses, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.json"), serviceContext);
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this._addCPInstanceSubscriptions(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".products.subscriptions.properties.json"), serviceContext);
                return null;
            });
        }
    }

    private Channel _addCommerceChannel(ServiceContext serviceContext) throws Exception {
        String resourcePath = "/site-initializer/commerce-channel.json";
        String json = this._read(resourcePath);
        if (json == null) {
            return null;
        }
        ChannelResource.Builder channelResourceBuilder = this._commerceReferencesHolder.channelResourceFactory.create();
        ChannelResource channelResource = channelResourceBuilder.user(serviceContext.fetchUser()).build();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
        jsonObject.put("siteGroupId", serviceContext.getScopeGroupId());
        Channel channel = Channel.toDTO((String)jsonObject.toString());
        if (channel == null) {
            _log.error((Object)("Unable to transform commerce channel from JSON: " + json));
            return null;
        }
        channel = channelResource.postChannel(channel);
        this._addModelResourcePermissions(CommerceChannel.class.getName(), String.valueOf(channel.getId()), StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".model-resource-permissions.json"), serviceContext);
        Group group = this._groupLocalService.getGroup(serviceContext.getScopeGroupId());
        group.setType(3);
        group.setManualMembership(true);
        group.setMembershipRestriction(0);
        this._groupLocalService.updateGroup(group);
        Settings settings = this._settingsFactory.getSettings((SettingsLocator)new GroupServiceSettingsLocator(serviceContext.getScopeGroupId(), "com.liferay.commerce.account"));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        modifiableSettings.setValue("commerceSiteType", String.valueOf(0));
        modifiableSettings.store();
        this._commerceReferencesHolder.commerceAccountRoleHelper.checkCommerceAccountRoles(serviceContext);
        this._commerceReferencesHolder.commerceCurrencyLocalService.importDefaultValues(serviceContext);
        this._commerceReferencesHolder.cpMeasurementUnitLocalService.importDefaultValues(serviceContext);
        return channel;
    }

    private List<CommerceInventoryWarehouse> _addCommerceInventoryWarehouses(ServiceContext serviceContext) throws Exception {
        return this._commerceReferencesHolder.commerceInventoryWarehousesImporter.importCommerceInventoryWarehouses(JSONFactoryUtil.createJSONArray((String)this._read("/site-initializer/commerce-inventory-warehouses.json")), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _addCommerceNotificationTemplate(long commerceChannelId, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsStringUtilReplaceValues, String resourcePath, ServiceContext serviceContext) throws Exception {
        String json = this._read(resourcePath + "commerce-notification-template.json");
        if (Validator.isNull((String)json)) {
            return;
        }
        JSONObject commerceNotificationTemplateJSONObject = JSONFactoryUtil.createJSONObject((String)json);
        CommerceChannel commerceChannel = this._commerceReferencesHolder.commerceChannelLocalService.getCommerceChannel(commerceChannelId);
        JSONObject bodyJSONObject = this._jsonFactory.createJSONObject();
        Enumeration enumeration = this._bundle.findEntries(resourcePath, "*.html", false);
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                bodyJSONObject.put(FileUtil.getShortFileName((String)FileUtil.stripExtension((String)url.getPath())), StringUtil.replace((String)StringUtil.read((InputStream)url.openStream()), (String)"[$", (String)"$]", documentsStringUtilReplaceValues));
            }
        }
        this._commerceReferencesHolder.commerceNotificationTemplateLocalService.addCommerceNotificationTemplate(serviceContext.getUserId(), commerceChannel.getGroupId(), commerceNotificationTemplateJSONObject.getString("name"), commerceNotificationTemplateJSONObject.getString("description"), commerceNotificationTemplateJSONObject.getString("from"), this._toMap(commerceNotificationTemplateJSONObject.getString("fromName")), commerceNotificationTemplateJSONObject.getString("to"), commerceNotificationTemplateJSONObject.getString("cc"), commerceNotificationTemplateJSONObject.getString("bcc"), StringUtil.replace((String)commerceNotificationTemplateJSONObject.getString("type"), (String)"[$", (String)"$]", objectDefinitionIdsStringUtilReplaceValues), commerceNotificationTemplateJSONObject.getBoolean("enabled"), this._toMap(commerceNotificationTemplateJSONObject.getString("subject")), this._toMap(bodyJSONObject.toString()), serviceContext);
    }

    private void _addCommerceNotificationTemplates(long commerceChannelId, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/commerce-notification-templates");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            this._addCommerceNotificationTemplate(commerceChannelId, documentsStringUtilReplaceValues, objectDefinitionIdsStringUtilReplaceValues, resourcePath, serviceContext);
        }
    }

    private void _addCPDefinitions(Map<String, String> documentsStringUtilReplaceValues, Map<String, String> objectDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        if (this._commerceReferencesHolder == null || !GetterUtil.getBoolean((String)PropsUtil.get((String)"enterprise.product.commerce.enabled"))) {
            return;
        }
        Channel channel = this._addCommerceChannel(serviceContext);
        if (channel == null) {
            return;
        }
        this._addCommerceCatalogs(channel, this._addCommerceInventoryWarehouses(serviceContext), serviceContext);
        this._addCommerceNotificationTemplates(channel.getId(), documentsStringUtilReplaceValues, objectDefinitionIdsStringUtilReplaceValues, serviceContext);
    }

    private void _addCPDefinitions(String assetVocabularyName, Catalog catalog, Channel channel, List<CommerceInventoryWarehouse> commerceInventoryWarehouses, String resourcePath, ServiceContext serviceContext) throws Exception {
        String json = this._read(resourcePath);
        if (json == null) {
            return;
        }
        Group commerceCatalogGroup = CommerceCatalogLocalServiceUtil.getCommerceCatalogGroup((long)catalog.getId());
        this._commerceReferencesHolder.cpDefinitionsImporter.importCPDefinitions(JSONFactoryUtil.createJSONArray((String)json), assetVocabularyName, commerceCatalogGroup.getGroupId(), channel.getId().longValue(), ListUtil.toLongArray(commerceInventoryWarehouses, (Accessor)CommerceInventoryWarehouse.COMMERCE_INVENTORY_WAREHOUSE_ID_ACCESSOR), this._classLoader, StringUtil.replace((String)resourcePath, (String)".json", (String)"/"), serviceContext.getScopeGroupId(), serviceContext.getUserId());
    }

    private void _addCPInstanceSubscriptions(String resourcePath, ServiceContext serviceContext) throws Exception {
        String json = this._read(resourcePath);
        if (json == null) {
            return;
        }
        ProductOptionResource.Builder productOptionResourceBuilder = this._commerceReferencesHolder.productOptionResourceFactory.create();
        ProductOptionResource productOptionResource = productOptionResourceBuilder.user(serviceContext.fetchUser()).build();
        OptionResource.Builder optionResourceBuilder = this._commerceReferencesHolder.optionResourceFactory.create();
        OptionResource optionResource = optionResourceBuilder.user(serviceContext.fetchUser()).build();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject subscriptionPropertiesJSONObject = jsonArray.getJSONObject(i);
            Page optionsPage = optionResource.getOptionsPage(null, optionResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", StringUtil.toLowerCase((String)subscriptionPropertiesJSONObject.getString("optionName")), "'"})), null, null);
            final Option option = (Option)optionsPage.fetchFirstItem();
            if (option == null) continue;
            ProductOption[] productOptions = new ProductOption[]{new ProductOption(){
                {
                    this.facetable = option.getFacetable();
                    this.fieldType = option.getFieldType().toString();
                    this.key = option.getKey();
                    this.name = option.getName();
                    this.optionId = option.getId();
                    this.required = option.getRequired();
                    this.skuContributor = option.getSkuContributor();
                }
            }};
            CPDefinition cpDefinition = this._commerceReferencesHolder.cpDefinitionLocalService.fetchCPDefinitionByCProductExternalReferenceCode(subscriptionPropertiesJSONObject.getString("cpDefinitionExternalReferenceCode"), serviceContext.getCompanyId());
            productOptionResource.postProductIdProductOptionsPage(Long.valueOf(cpDefinition.getCProductId()), productOptions);
            this._commerceReferencesHolder.cpInstanceLocalService.buildCPInstances(cpDefinition.getCPDefinitionId(), serviceContext);
            CPInstance cpInstance = this._commerceReferencesHolder.cpInstanceLocalService.getCPInstance(cpDefinition.getCPDefinitionId(), subscriptionPropertiesJSONObject.getString("cpInstanceSku"));
            JSONObject subscriptionTypeSettingsJSONObject = subscriptionPropertiesJSONObject.getJSONObject("subscriptionTypeSettings");
            UnicodeProperties unicodeProperties = new UnicodeProperties(JSONUtil.toStringMap((JSONObject)subscriptionTypeSettingsJSONObject), true);
            this._commerceReferencesHolder.cpInstanceLocalService.updateSubscriptionInfo(cpInstance.getCPInstanceId(), subscriptionPropertiesJSONObject.getBoolean("overrideSubscriptionInfo"), subscriptionPropertiesJSONObject.getBoolean("subscriptionEnabled"), subscriptionPropertiesJSONObject.getInt("subscriptionLength"), subscriptionPropertiesJSONObject.getString("subscriptionType"), unicodeProperties, subscriptionPropertiesJSONObject.getLong("maxSubscriptionCycles"), subscriptionPropertiesJSONObject.getBoolean("deliverySubscriptionEnabled"), subscriptionPropertiesJSONObject.getInt("deliverySubscriptionLength"), subscriptionPropertiesJSONObject.getString("deliverySubscriptionType"), new UnicodeProperties(), subscriptionPropertiesJSONObject.getLong("deliveryMaxSubscriptionCycles"));
        }
    }

    private void _addCPOptions(Catalog catalog, String resourcePath, ServiceContext serviceContext) throws Exception {
        String json = this._read(resourcePath);
        if (json == null) {
            return;
        }
        Group commerceCatalogGroup = CommerceCatalogLocalServiceUtil.getCommerceCatalogGroup((long)catalog.getId());
        this._commerceReferencesHolder.cpOptionsImporter.importCPOptions(JSONFactoryUtil.createJSONArray((String)json), commerceCatalogGroup.getGroupId(), serviceContext.getUserId());
    }

    private void _addDDMStructures(ServiceContext serviceContext) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/ddm-structures");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            this._defaultDDMStructureHelper.addDDMStructures(serviceContext.getUserId(), serviceContext.getScopeGroupId(), this._portal.getClassNameId(JournalArticle.class), this._classLoader, resourcePath, serviceContext);
        }
    }

    private void _addDDMTemplates(DDMStructureLocalService ddmStructureLocalService, ServiceContext serviceContext) throws Exception {
        Enumeration enumeration = this._bundle.findEntries("/site-initializer/ddm-templates", "ddm-template.json", true);
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read((InputStream)url.openStream()));
            long resourceClassNameId = this._portal.getClassNameId(jsonObject.getString("resourceClassName", JournalArticle.class.getName()));
            long ddmStructureId = 0L;
            String ddmStructureKey = jsonObject.getString("ddmStructureKey");
            if (Validator.isNotNull((String)ddmStructureKey)) {
                DDMStructure ddmStructure = ddmStructureLocalService.fetchStructure(serviceContext.getScopeGroupId(), resourceClassNameId, ddmStructureKey);
                ddmStructureId = ddmStructure.getStructureId();
            }
            this._ddmTemplateLocalService.addTemplate(serviceContext.getUserId(), serviceContext.getScopeGroupId(), this._portal.getClassNameId(jsonObject.getString("className", DDMStructure.class.getName())), ddmStructureId, resourceClassNameId, jsonObject.getString("ddmTemplateKey"), (Map)HashMapBuilder.put((Object)LocaleUtil.getSiteDefault(), (Object)jsonObject.getString("name")).build(), null, "display", null, "ftl", this._read("ddm-template.ftl", url), false, false, null, null, serviceContext);
        }
    }

    private Long _addDocumentFolder(Long documentFolderId, long groupId, String resourcePath, ServiceContext serviceContext) throws Exception {
        DocumentFolderResource.Builder documentFolderResourceBuilder = this._documentFolderResourceFactory.create();
        DocumentFolderResource documentFolderResource = documentFolderResourceBuilder.user(serviceContext.fetchUser()).build();
        DocumentFolder documentFolder = null;
        String json = this._read((resourcePath = resourcePath.substring(0, resourcePath.length() - 1)) + ".metadata.json");
        documentFolder = json != null ? DocumentFolder.toDTO((String)json) : DocumentFolder.toDTO((String)JSONUtil.put((String)"name", (Object)FileUtil.getShortFileName((String)resourcePath)).put("viewableBy", "Anyone").toString());
        Page documentFoldersPage = documentFolderResource.getSiteDocumentFoldersPage(Long.valueOf(groupId), Boolean.valueOf(true), null, null, documentFolderResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", documentFolder.getName(), "'"})), null, null);
        DocumentFolder existingDocumentFolder = (DocumentFolder)documentFoldersPage.fetchFirstItem();
        documentFolder = existingDocumentFolder == null ? (documentFolderId != null ? documentFolderResource.postDocumentFolderDocumentFolder(documentFolderId, documentFolder) : documentFolderResource.postSiteDocumentFolder(Long.valueOf(groupId), documentFolder)) : documentFolderResource.putDocumentFolder(existingDocumentFolder.getId(), documentFolder);
        return documentFolder.getId();
    }

    private Map<String, String> _addDocuments(Long documentFolderId, long groupId, String parentResourcePath, final ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        HashMap<String, String> documentsStringUtilReplaceValues = new HashMap<String, String>();
        Set resourcePaths = this._servletContext.getResourcePaths(parentResourcePath);
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return documentsStringUtilReplaceValues;
        }
        DocumentResource.Builder documentResourceBuilder = this._documentResourceFactory.create();
        DocumentResource documentResource = documentResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            Page documentsPage;
            Document existingDocument;
            if (resourcePath.endsWith("/")) {
                documentsStringUtilReplaceValues.putAll(this._addDocuments(this._addDocumentFolder(documentFolderId, groupId, resourcePath, serviceContext), groupId, resourcePath, serviceContext, siteNavigationMenuItemSettingsBuilder));
                continue;
            }
            if (resourcePath.endsWith(".gitkeep") || resourcePath.endsWith(".metadata.json")) continue;
            String fileName = FileUtil.getShortFileName((String)resourcePath);
            URL url = this._servletContext.getResource(resourcePath);
            URLConnection urlConnection = url.openConnection();
            Map<Object, Object> values = new HashMap();
            String json = this._read(resourcePath + ".metadata.json");
            values = json != null ? Collections.singletonMap("document", json) : Collections.singletonMap("document", JSONUtil.put((String)"viewableBy", (Object)"Anyone").toString());
            Document document = null;
            document = documentFolderId != null ? ((existingDocument = (Document)(documentsPage = documentResource.getDocumentFolderDocumentsPage(documentFolderId, Boolean.valueOf(false), null, null, documentResource.toFilter(StringBundler.concat((String[])new String[]{"title eq '", fileName, "'"})), null, null)).fetchFirstItem()) == null ? documentResource.postDocumentFolderDocument(documentFolderId, MultipartBody.of(Collections.singletonMap("file", new BinaryFile(MimeTypesUtil.getContentType((String)fileName), fileName, urlConnection.getInputStream(), (long)urlConnection.getContentLength())), __ -> _objectMapper, values)) : documentResource.putDocument(existingDocument.getId(), MultipartBody.of(Collections.singletonMap("file", new BinaryFile(MimeTypesUtil.getContentType((String)fileName), fileName, urlConnection.getInputStream(), (long)urlConnection.getContentLength())), __ -> _objectMapper, values))) : ((existingDocument = (Document)(documentsPage = documentResource.getSiteDocumentsPage(Long.valueOf(groupId), Boolean.valueOf(false), null, null, documentResource.toFilter(StringBundler.concat((String[])new String[]{"title eq '", fileName, "'"})), null, null)).fetchFirstItem()) == null ? documentResource.postSiteDocument(Long.valueOf(groupId), MultipartBody.of(Collections.singletonMap("file", new BinaryFile(MimeTypesUtil.getContentType((String)fileName), fileName, urlConnection.getInputStream(), (long)urlConnection.getContentLength())), __ -> _objectMapper, values)) : documentResource.putDocument(existingDocument.getId(), MultipartBody.of(Collections.singletonMap("file", new BinaryFile(MimeTypesUtil.getContentType((String)fileName), fileName, urlConnection.getInputStream(), (long)urlConnection.getContentLength())), __ -> _objectMapper, values)));
            String key = resourcePath;
            final FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)document.getId());
            documentsStringUtilReplaceValues.put("DOCUMENT_FILE_ENTRY_ID:" + key, String.valueOf(fileEntry.getFileEntryId()));
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)fileEntry));
            jsonObject.put("alt", "");
            documentsStringUtilReplaceValues.put("DOCUMENT_JSON:" + key, jsonObject.toString());
            documentsStringUtilReplaceValues.put("DOCUMENT_URL:" + key, this._dlURLHelper.getPreviewURL(fileEntry, fileEntry.getFileVersion(), null, "", false, false));
            long fileEntryTypeId = 0L;
            if (fileEntry.getModel() instanceof DLFileEntry) {
                DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
                DLFileEntryType dlFileEntryType = dlFileEntry.getDLFileEntryType();
                fileEntryTypeId = dlFileEntryType.getFileEntryTypeId();
            }
            final String fileEntryTypeIdString = String.valueOf(fileEntryTypeId);
            siteNavigationMenuItemSettingsBuilder.put(key, new SiteNavigationMenuItemSetting(){
                {
                    this.className = FileEntry.class.getName();
                    this.classPK = String.valueOf(fileEntry.getFileEntryId());
                    this.classTypeId = fileEntryTypeIdString;
                    this.title = fileEntry.getTitle();
                    this.type = ResourceActionsUtil.getModelResource((Locale)serviceContext.getLocale(), (String)FileEntry.class.getName());
                }
            });
        }
        return documentsStringUtilReplaceValues;
    }

    private Map<String, String> _addDocuments(ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        Group group = this._groupLocalService.getCompanyGroup(serviceContext.getCompanyId());
        return HashMapBuilder.putAll(this._addDocuments(null, group.getGroupId(), "/site-initializer/documents/company", serviceContext, siteNavigationMenuItemSettingsBuilder)).putAll(this._addDocuments(null, serviceContext.getScopeGroupId(), "/site-initializer/documents/group", serviceContext, siteNavigationMenuItemSettingsBuilder)).build();
    }

    private void _addFragmentEntries(ServiceContext serviceContext) throws Exception {
        URL url = this._bundle.getEntry("/fragments.zip");
        if (url == null) {
            return;
        }
        this._fragmentsImporter.importFragmentEntries(serviceContext.getUserId(), serviceContext.getScopeGroupId(), 0L, FileUtil.createTempFile((InputStream)url.openStream()), false);
    }

    private void _addJournalArticles(DDMStructureLocalService ddmStructureLocalService, DDMTemplateLocalService ddmTemplateLocalService, Long documentFolderId, Map<String, String> documentsStringUtilReplaceValues, String parentResourcePath, final ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths(parentResourcePath);
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            parentResourcePath = resourcePath.substring(0, resourcePath.length() - 1);
            if (resourcePath.endsWith("/")) {
                this._addJournalArticles(ddmStructureLocalService, ddmTemplateLocalService, this._addStructuredContentFolders(documentFolderId, parentResourcePath, serviceContext), documentsStringUtilReplaceValues, resourcePath, serviceContext, siteNavigationMenuItemSettingsBuilder);
                continue;
            }
            if (resourcePath.endsWith(".gitkeep") || resourcePath.endsWith(".metadata.json") || resourcePath.endsWith(".xml")) continue;
            long journalFolderId = 0L;
            if (documentFolderId != null) {
                journalFolderId = documentFolderId;
            }
            String json = this._read(resourcePath);
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)json);
            Map<Locale, String> titleMap = Collections.singletonMap(LocaleUtil.getSiteDefault(), jsonObject.getString("name"));
            String ddmStructureKey = jsonObject.getString("ddmStructureKey");
            ddmStructureLocalService.getStructure(serviceContext.getScopeGroupId(), this._portal.getClassNameId(JournalArticle.class), ddmStructureKey);
            String ddmTemplateKey = jsonObject.getString("ddmTemplateKey");
            ddmTemplateLocalService.getTemplate(serviceContext.getScopeGroupId(), this._portal.getClassNameId(DDMStructure.class), ddmTemplateKey);
            Calendar calendar = CalendarFactoryUtil.getCalendar((TimeZone)serviceContext.getTimeZone());
            serviceContext.setAssetCategoryIds(this._getAssetCategoryIds(serviceContext.getScopeGroupId(), JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("assetCategoryERCs"))));
            serviceContext.setAssetTagNames(JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("assetTagNames")));
            final JournalArticle journalArticle = this._journalArticleLocalService.addArticle(null, serviceContext.getUserId(), serviceContext.getScopeGroupId(), journalFolderId, 0L, 0L, jsonObject.getString("articleId"), false, 1.0, titleMap, null, titleMap, StringUtil.replace((String)this._read(StringUtil.replace((String)resourcePath, (String)".json", (String)".xml")), (String)"[$", (String)"$]", documentsStringUtilReplaceValues), ddmStructureKey, ddmTemplateKey, null, calendar.get(2), calendar.get(5), calendar.get(1), calendar.get(11), calendar.get(12), 0, 0, 0, 0, 0, true, 0, 0, 0, 0, 0, true, true, false, null, null, null, null, serviceContext);
            serviceContext.setAssetCategoryIds(null);
            serviceContext.setAssetTagNames(null);
            final DDMStructure ddmStructure = journalArticle.getDDMStructure();
            siteNavigationMenuItemSettingsBuilder.put(resourcePath, new SiteNavigationMenuItemSetting(){
                {
                    this.className = JournalArticle.class.getName();
                    this.classPK = String.valueOf(journalArticle.getResourcePrimKey());
                    this.classTypeId = String.valueOf(ddmStructure.getStructureId());
                    this.title = journalArticle.getTitle(serviceContext.getLocale());
                    this.type = ResourceActionsUtil.getModelResource((Locale)serviceContext.getLocale(), (String)JournalArticle.class.getName());
                }
            });
        }
    }

    private void _addJournalArticles(DDMStructureLocalService ddmStructureLocalService, DDMTemplateLocalService ddmTemplateLocalService, Map<String, String> documentsStringUtilReplaceValues, ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        this._addJournalArticles(ddmStructureLocalService, ddmTemplateLocalService, null, documentsStringUtilReplaceValues, "/site-initializer/journal-articles", serviceContext, siteNavigationMenuItemSettingsBuilder);
    }

    private void _addLayout(Map<String, String> assetListEntryIdsStringUtilReplaceValues, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> remoteAppEntryIdsStringUtilReplaceValues, String resourcePath, ServiceContext serviceContext) throws Exception {
        JSONObject pageElementJSONObject;
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)this._read(resourcePath + "page.json"));
        String type = StringUtil.toLowerCase((String)jsonObject.getString("type"));
        if (Objects.equals(type, "widget")) {
            type = "portlet";
        }
        Layout layout = this._layoutLocalService.addLayout(serviceContext.getUserId(), serviceContext.getScopeGroupId(), jsonObject.getBoolean("private"), 0L, this._toMap(jsonObject.getString("name_i18n")), this._toMap(jsonObject.getString("title_i18n")), this._toMap(jsonObject.getString("description_i18n")), this._toMap(jsonObject.getString("keywords_i18n")), this._toMap(jsonObject.getString("robots_i18n")), type, null, jsonObject.getBoolean("hidden"), jsonObject.getBoolean("system"), this._toMap(jsonObject.getString("friendlyURL_i18n")), serviceContext);
        String json = this._read(resourcePath + "page-definition.json");
        if (json == null) {
            return;
        }
        json = StringUtil.replace((String)json, (String)"[$", (String)"$]", (Map)HashMapBuilder.putAll(assetListEntryIdsStringUtilReplaceValues).putAll(documentsStringUtilReplaceValues).putAll(remoteAppEntryIdsStringUtilReplaceValues).build());
        JSONObject pageDefinitionJSONObject = JSONFactoryUtil.createJSONObject((String)json);
        Layout draftLayout = layout.fetchDraftLayout();
        if ((Objects.equals(type, "collection") || Objects.equals(type, "content")) && (pageElementJSONObject = pageDefinitionJSONObject.getJSONObject("pageElement")) != null && Objects.equals(pageElementJSONObject.getString("type"), "Root")) {
            LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(draftLayout.getGroupId(), draftLayout.getPlid(), true);
            LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(0L));
            JSONArray jsonArray = pageElementJSONObject.getJSONArray("pageElements");
            for (int i = 0; i < jsonArray.length(); ++i) {
                this._layoutPageTemplatesImporter.importPageElement(draftLayout, layoutStructure, layoutStructure.getMainItemId(), jsonArray.getString(i), i);
            }
        }
        if (Objects.equals(type, "collection")) {
            Object[] typeSettings;
            UnicodeProperties unicodeProperties = draftLayout.getTypeSettingsProperties();
            for (Object typeSetting : typeSettings = JSONUtil.toObjectArray((JSONArray)jsonObject.getJSONArray("typeSettings"))) {
                JSONObject typeSettingJSONObject = (JSONObject)typeSetting;
                String key = typeSettingJSONObject.getString("key");
                String value = typeSettingJSONObject.getString("value");
                unicodeProperties.put(key, StringUtil.replace((String)value, (String)"[$", (String)"$]", assetListEntryIdsStringUtilReplaceValues));
            }
            draftLayout = this._layoutLocalService.updateLayout(serviceContext.getScopeGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), unicodeProperties.toString());
        }
        if (Objects.equals(type, "collection") || Objects.equals(type, "content")) {
            JSONObject settingsJSONObject = pageDefinitionJSONObject.getJSONObject("settings");
            if (settingsJSONObject != null) {
                draftLayout = this._updateDraftLayout(draftLayout, settingsJSONObject);
            }
            layout = this._layoutCopyHelper.copyLayout(draftLayout, layout);
            this._layoutLocalService.updateStatus(layout.getUserId(), draftLayout.getPlid(), 0, serviceContext);
            this._layoutLocalService.updateStatus(layout.getUserId(), layout.getPlid(), 0, serviceContext);
        }
    }

    private void _addLayoutPageTemplates(Map<String, String> assetListEntryIdsStringUtilReplaceValues, Map<String, String> documentsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        Enumeration enumeration = this._bundle.findEntries("/site-initializer/layout-page-templates", "*", true);
        if (enumeration == null) {
            return;
        }
        ZipWriter zipWriter = ZipWriterFactoryUtil.getZipWriter();
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            String urlPath = url.getPath();
            if (StringUtil.endsWith((String)urlPath, (String)"page-definition.json")) {
                String json = StringUtil.read((InputStream)url.openStream());
                json = StringUtil.replace((String)json, (String)"\"[$", (String)"$]\"", (Map)HashMapBuilder.putAll(assetListEntryIdsStringUtilReplaceValues).putAll(documentsStringUtilReplaceValues).build());
                Group scopeGroup = serviceContext.getScopeGroup();
                json = StringUtil.replace((String)json, (String[])new String[]{"[$GROUP_FRIENDLY_URL$]", "[$GROUP_ID$]"}, (String[])new String[]{scopeGroup.getFriendlyURL(), String.valueOf(serviceContext.getScopeGroupId())});
                String css = this._read(FileUtil.getPath((String)urlPath) + "/css.css");
                if (Validator.isNotNull((String)css)) {
                    JSONObject jsonObject = this._jsonFactory.createJSONObject(json);
                    JSONObject settingsJSONObject = jsonObject.getJSONObject("settings");
                    settingsJSONObject.put("css", css);
                    jsonObject.put("settings", settingsJSONObject);
                    json = jsonObject.toString();
                }
                zipWriter.addEntry(StringUtil.removeFirst((String)urlPath, (String)"/site-initializer/layout-page-templates/"), json);
                continue;
            }
            zipWriter.addEntry(StringUtil.removeFirst((String)urlPath, (String)"/site-initializer/layout-page-templates/"), url.openStream());
        }
        this._layoutPageTemplatesImporter.importFile(serviceContext.getUserId(), serviceContext.getScopeGroupId(), zipWriter.getFile(), false);
    }

    private void _addLayouts(Map<String, String> assetListEntryIdsStringUtilReplaceValues, Map<String, String> documentsStringUtilReplaceValues, Map<String, String> remoteAppEntryIdsStringUtilReplaceValues, ServiceContext serviceContext, Map<String, SiteNavigationMenuItemSetting> siteNavigationMenuItemSettings) throws Exception {
        TreeSet resourcePaths = this._servletContext.getResourcePaths("/site-initializer/layouts");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        TreeSet sortedResourcePaths = new TreeSet(new NaturalOrderStringComparator());
        sortedResourcePaths.addAll(resourcePaths);
        resourcePaths = sortedResourcePaths;
        for (String resourcePath : resourcePaths) {
            if (!resourcePath.endsWith("/")) continue;
            this._addLayout(assetListEntryIdsStringUtilReplaceValues, documentsStringUtilReplaceValues, remoteAppEntryIdsStringUtilReplaceValues, resourcePath, serviceContext);
        }
        this._addSiteNavigationMenus(serviceContext, siteNavigationMenuItemSettings);
    }

    private Map<String, String> _addListTypeDefinitions(ServiceContext serviceContext) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/list-type-definitions");
        HashMap<String, String> listTypeDefinitionIdsStringUtilReplaceValues = new HashMap<String, String>();
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return listTypeDefinitionIdsStringUtilReplaceValues;
        }
        ListTypeDefinitionResource.Builder listTypeDefinitionResourceBuilder = this._listTypeDefinitionResourceFactory.create();
        ListTypeDefinitionResource listTypeDefinitionResource = listTypeDefinitionResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith(".list-type-entries.json")) continue;
            String json = this._read(resourcePath);
            ListTypeDefinition listTypeDefinition = ListTypeDefinition.toDTO((String)json);
            if (listTypeDefinition == null) {
                _log.error((Object)("Unable to transform list type definition from JSON: " + json));
                continue;
            }
            Page listTypeDefinitionsPage = listTypeDefinitionResource.getListTypeDefinitionsPage(null, null, listTypeDefinitionResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", listTypeDefinition.getName(), "'"})), null, null);
            ListTypeDefinition existingListTypeDefinition = (ListTypeDefinition)listTypeDefinitionsPage.fetchFirstItem();
            listTypeDefinition = existingListTypeDefinition == null ? listTypeDefinitionResource.postListTypeDefinition(listTypeDefinition) : listTypeDefinitionResource.putListTypeDefinition(existingListTypeDefinition.getId(), listTypeDefinition);
            listTypeDefinitionIdsStringUtilReplaceValues.put("LIST_TYPE_DEFINITION_ID:" + listTypeDefinition.getName(), String.valueOf(listTypeDefinition.getId()));
            String listTypeEntriesJSON = this._read(StringUtil.replace((String)resourcePath, (String)".json", (String)".list-type-entries.json"));
            if (listTypeEntriesJSON == null) continue;
            JSONArray jsonArray = this._jsonFactory.createJSONArray(listTypeEntriesJSON);
            ListTypeEntryResource.Builder listTypeEntryResourceBuilder = this._listTypeEntryResourceFactory.create();
            ListTypeEntryResource listTypeEntryResource = listTypeEntryResourceBuilder.user(serviceContext.fetchUser()).build();
            for (int i = 0; i < jsonArray.length(); ++i) {
                ListTypeEntry listTypeEntry = ListTypeEntry.toDTO((String)String.valueOf(jsonArray.getJSONObject(i)));
                Page listTypeEntriesPage = listTypeEntryResource.getListTypeDefinitionListTypeEntriesPage(listTypeDefinition.getId(), null, null, listTypeEntryResource.toFilter(StringBundler.concat((String[])new String[]{"key eq '", listTypeEntry.getKey(), "'"})), null, null);
                ListTypeEntry existingListTypeEntry = (ListTypeEntry)listTypeEntriesPage.fetchFirstItem();
                if (existingListTypeEntry == null) {
                    listTypeEntryResource.postListTypeDefinitionListTypeEntry(listTypeDefinition.getId(), listTypeEntry);
                    continue;
                }
                listTypeEntryResource.putListTypeEntry(existingListTypeEntry.getId(), listTypeEntry);
            }
        }
        return listTypeDefinitionIdsStringUtilReplaceValues;
    }

    private void _addModelResourcePermissions(String className, String primKey, String resourcePath, ServiceContext serviceContext) throws Exception {
        String json = this._read(resourcePath);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this._resourcePermissionLocalService.addModelResourcePermissions(serviceContext.getCompanyId(), serviceContext.getScopeGroupId(), serviceContext.getUserId(), className, primKey, ModelPermissionsFactory.create((Map)HashMapBuilder.put((Object)jsonObject.getString("roleName"), (Object)ArrayUtil.toStringArray((JSONArray)jsonObject.getJSONArray("actionIds"))).build(), null));
        }
    }

    private Map<String, String> _addObjectDefinitions(Map<String, String> listTypeDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        HashMap<String, String> objectDefinitionIdsStringUtilReplaceValues = new HashMap<String, String>();
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/object-definitions");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return objectDefinitionIdsStringUtilReplaceValues;
        }
        ObjectDefinitionResource.Builder objectDefinitionResourceBuilder = this._objectDefinitionResourceFactory.create();
        ObjectDefinitionResource objectDefinitionResource = objectDefinitionResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            String objectEntriesJSON;
            if (resourcePath.endsWith(".object-entries.json")) continue;
            String json = this._read(resourcePath);
            ObjectDefinition objectDefinition = ObjectDefinition.toDTO((String)(json = StringUtil.replace((String)json, (String)"[$", (String)"$]", listTypeDefinitionIdsStringUtilReplaceValues)));
            if (objectDefinition == null) {
                _log.error((Object)("Unable to transform object definition from JSON: " + json));
                continue;
            }
            Page objectDefinitionsPage = objectDefinitionResource.getObjectDefinitionsPage(null, null, objectDefinitionResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", objectDefinition.getName(), "'"})), null, null);
            ObjectDefinition existingObjectDefinition = (ObjectDefinition)objectDefinitionsPage.fetchFirstItem();
            if (existingObjectDefinition == null) {
                objectDefinition = objectDefinitionResource.postObjectDefinition(objectDefinition);
                objectDefinitionResource.postObjectDefinitionPublish(objectDefinition.getId());
            } else {
                objectDefinition = objectDefinitionResource.patchObjectDefinition(existingObjectDefinition.getId(), objectDefinition);
            }
            objectDefinitionIdsStringUtilReplaceValues.put("OBJECT_DEFINITION_ID:" + objectDefinition.getName(), String.valueOf(objectDefinition.getId()));
            long groupId = serviceContext.getScopeGroupId();
            if (Objects.equals(objectDefinition.getScope(), "company")) {
                groupId = 0L;
                if (existingObjectDefinition != null) continue;
            }
            if ((objectEntriesJSON = this._read(StringUtil.replaceLast((String)resourcePath, (String)".json", (String)".object-entries.json"))) == null) continue;
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)objectEntriesJSON);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                final ObjectEntry objectEntry = this._objectEntryLocalService.addObjectEntry(serviceContext.getUserId(), groupId, objectDefinition.getId().longValue(), (Map)ObjectMapperUtil.readValue(Serializable.class, (String)String.valueOf(jsonObject)), serviceContext);
                String objectEntrySiteInitializerKey = jsonObject.getString("objectEntrySiteInitializerKey");
                if (objectEntrySiteInitializerKey == null) continue;
                final String objectDefinitionName = objectDefinition.getName();
                siteNavigationMenuItemSettingsBuilder.put(objectEntrySiteInitializerKey, new SiteNavigationMenuItemSetting(){
                    {
                        this.className = objectEntry.getModelClassName();
                        this.classPK = String.valueOf(objectEntry.getObjectEntryId());
                        this.title = objectDefinitionName + " " + objectEntry.getObjectEntryId();
                    }
                });
            }
        }
        return objectDefinitionIdsStringUtilReplaceValues;
    }

    private void _addObjectRelationships(Map<String, String> objectDefinitionIdsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths("/site-initializer/object-relationships");
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        ObjectRelationshipResource.Builder objectRelationshipResourceBuilder = this._objectRelationshipResourceFactory.create();
        ObjectRelationshipResource objectRelationshipResource = objectRelationshipResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            String json = this._read(resourcePath);
            ObjectRelationship objectRelationship = ObjectRelationship.toDTO((String)(json = StringUtil.replace((String)json, (String)"[$", (String)"$]", objectDefinitionIdsStringUtilReplaceValues)));
            if (objectRelationship == null) {
                _log.error((Object)("Unable to transform object relationship from JSON: " + json));
                continue;
            }
            Page objectRelationshipsPage = objectRelationshipResource.getObjectDefinitionObjectRelationshipsPage(objectRelationship.getObjectDefinitionId1(), null, objectRelationshipResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", objectRelationship.getName(), "'"})), null);
            ObjectRelationship existingObjectRelationship = (ObjectRelationship)objectRelationshipsPage.fetchFirstItem();
            if (existingObjectRelationship == null) {
                objectRelationshipResource.postObjectDefinitionObjectRelationship(objectRelationship.getObjectDefinitionId1(), objectRelationship);
                continue;
            }
            objectRelationshipResource.putObjectRelationship(existingObjectRelationship.getId(), objectRelationship);
        }
    }

    private void _addPermissions(ServiceContext serviceContext) throws Exception {
        this._addRoles(serviceContext);
        this._addResourcePermissions("/site-initializer/resource-permissions.json", serviceContext);
    }

    private Map<String, String> _addRemoteAppEntries(Map<String, String> documentsStringUtilReplaceValues, ServiceContext serviceContext) throws Exception {
        String json = this._read("/site-initializer/remote-app-entries.json");
        if (json == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> remoteAppEntryIdsStringUtilReplaceValues = new HashMap<String, String>();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            StringBundler sb = new StringBundler();
            JSONObject propertiesJSONObject = jsonObject.getJSONObject("properties");
            if (propertiesJSONObject != null) {
                for (String key : propertiesJSONObject.keySet()) {
                    sb.append(key);
                    sb.append("=");
                    sb.append(propertiesJSONObject.getString(key));
                    sb.append("\n");
                }
            }
            RemoteAppEntry remoteAppEntry = this._remoteAppEntryLocalService.addOrUpdateCustomElementRemoteAppEntry(jsonObject.getString("externalReferenceCode"), serviceContext.getUserId(), StringUtil.replace((String)StringUtil.merge((Object[])JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("cssURLs")), (String)"\n"), (String)"[$", (String)"$]", documentsStringUtilReplaceValues), jsonObject.getString("htmlElementName"), StringUtil.replace((String)StringUtil.merge((Object[])JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("elementURLs")), (String)"\n"), (String)"[$", (String)"$]", documentsStringUtilReplaceValues), "", "", jsonObject.getBoolean("instanceable"), this._toMap(jsonObject.getString("name_i18n")), jsonObject.getString("portletCategoryName"), sb.toString(), "");
            remoteAppEntryIdsStringUtilReplaceValues.put("REMOTE_APP_ENTRY_ID:" + jsonObject.getString("remoteAppEntryKey"), StringUtil.replace((String)jsonObject.getString("widgetName"), (String)StringBundler.concat((String[])new String[]{"[$REMOTE_APP_ENTRY_ID:", jsonObject.getString("remoteAppEntryKey"), "$]"}), (String)String.valueOf(remoteAppEntry.getRemoteAppEntryId())));
        }
        return remoteAppEntryIdsStringUtilReplaceValues;
    }

    private void _addResourcePermissions(String resourcePath, ServiceContext serviceContext) throws Exception {
        String json = this._read(resourcePath);
        if (json == null) {
            return;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), jsonObject.getString("roleName"));
            if (role == null && _log.isWarnEnabled()) {
                _log.warn((Object)("No role found with name " + jsonObject.getString("roleName")));
            }
            this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), jsonObject.getString("resourceName"), jsonObject.getInt("scope"), jsonObject.getString("primKey"), role.getRoleId(), jsonObject.getString("actionId"));
        }
    }

    private void _addRole(JSONObject jsonObject, ServiceContext serviceContext) throws Exception {
        String name = jsonObject.getString("name");
        Role role = this._roleLocalService.fetchRole(serviceContext.getCompanyId(), name);
        if (role == null) {
            role = this._roleLocalService.addRole(serviceContext.getUserId(), null, 0L, name, Collections.singletonMap(serviceContext.getLocale(), name), null, jsonObject.getInt("type"), null, serviceContext);
        }
        JSONArray jsonArray = jsonObject.getJSONArray("actions");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject actionsJSONObject = jsonArray.getJSONObject(i);
            String resource = actionsJSONObject.getString("resource");
            int scope = actionsJSONObject.getInt("scope");
            String actionId = actionsJSONObject.getString("actionId");
            if (scope == 1) {
                this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), resource, scope, String.valueOf(role.getCompanyId()), role.getRoleId(), actionId);
                continue;
            }
            if (scope == 2) {
                this._resourcePermissionLocalService.removeResourcePermissions(serviceContext.getCompanyId(), resource, 2, role.getRoleId(), actionId);
                this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), resource, 2, String.valueOf(serviceContext.getScopeGroupId()), role.getRoleId(), actionId);
                continue;
            }
            if (scope != 3) continue;
            this._resourcePermissionLocalService.addResourcePermission(serviceContext.getCompanyId(), resource, 3, String.valueOf(0L), role.getRoleId(), actionId);
        }
    }

    private void _addRoles(ServiceContext serviceContext) throws Exception {
        if (this._commerceReferencesHolder == null) {
            return;
        }
        String json = this._read("/site-initializer/roles.json");
        if (json == null) {
            return;
        }
        JSONArray jsonArray = this._jsonFactory.createJSONArray(json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._addRole(jsonArray.getJSONObject(i), serviceContext);
        }
    }

    private void _addSAPEntries(ServiceContext serviceContext) throws Exception {
        String json = this._read("/site-initializer/sap-entries.json");
        if (json == null) {
            return;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(serviceContext.getCompanyId(), jsonObject.getString("name"));
            if (sapEntry == null) {
                this._sapEntryLocalService.addSAPEntry(serviceContext.getUserId(), StringUtil.merge((Object[])JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("allowedServiceSignatures")), (String)"\n"), jsonObject.getBoolean("defaultSAPEntry", true), jsonObject.getBoolean("enabled", true), jsonObject.getString("name"), this._toMap(jsonObject.getString("title_i18n")), serviceContext);
                continue;
            }
            this._sapEntryLocalService.updateSAPEntry(sapEntry.getSapEntryId(), StringUtil.merge((Object[])JSONUtil.toStringArray((JSONArray)jsonObject.getJSONArray("allowedServiceSignatures")), (String)"\n"), jsonObject.getBoolean("defaultSAPEntry", true), jsonObject.getBoolean("enabled", true), jsonObject.getString("name"), this._toMap(jsonObject.getString("title_i18n")), serviceContext);
        }
    }

    private void _addSiteNavigationMenu(JSONObject jsonObject, ServiceContext serviceContext, Map<String, SiteNavigationMenuItemSetting> siteNavigationMenuItemSettings) throws Exception {
        SiteNavigationMenu siteNavigationMenu = this._siteNavigationMenuLocalService.addSiteNavigationMenu(serviceContext.getUserId(), serviceContext.getScopeGroupId(), jsonObject.getString("name"), serviceContext);
        this._addSiteNavigationMenuItems(jsonObject, siteNavigationMenu, 0L, serviceContext, siteNavigationMenuItemSettings);
    }

    private void _addSiteNavigationMenuItems(JSONObject jsonObject, SiteNavigationMenu siteNavigationMenu, long parentSiteNavigationMenuItemId, ServiceContext serviceContext, Map<String, SiteNavigationMenuItemSetting> siteNavigationMenuItemSettings) throws Exception {
        for (Object object : JSONUtil.toObjectArray((JSONArray)jsonObject.getJSONArray("menuItems"))) {
            UnicodeProperties typeSettingsUnicodeProperties;
            JSONObject menuItemJSONObject = (JSONObject)object;
            String type = menuItemJSONObject.getString("type");
            String typeSettings = null;
            if (type.equals("layout")) {
                boolean privateLayout = menuItemJSONObject.getBoolean("privateLayout");
                String friendlyURL = menuItemJSONObject.getString("friendlyURL");
                Layout layout = this._layoutLocalService.fetchLayoutByFriendlyURL(serviceContext.getScopeGroupId(), privateLayout, friendlyURL);
                if (layout == null) {
                    return;
                }
                SiteNavigationMenuItemType siteNavigationMenuItemType = this._siteNavigationMenuItemTypeRegistry.getSiteNavigationMenuItemType("layout");
                typeSettings = siteNavigationMenuItemType.getTypeSettingsFromLayout(layout);
            } else if (type.equals("node")) {
                typeSettingsUnicodeProperties = new UnicodeProperties();
                typeSettingsUnicodeProperties.setProperty("name", menuItemJSONObject.getString("name"));
            } else if (type.equals("url")) {
                typeSettingsUnicodeProperties = new UnicodeProperties();
                typeSettingsUnicodeProperties.setProperty("name", menuItemJSONObject.getString("name"));
                typeSettingsUnicodeProperties.setProperty("url", menuItemJSONObject.getString("url"));
                typeSettingsUnicodeProperties.setProperty("useNewTab", menuItemJSONObject.getString("useNewTab"));
                typeSettings = typeSettingsUnicodeProperties.toString();
            } else if (type.equals("display-page")) {
                SiteNavigationMenuItemSetting siteNavigationMenuItemSetting;
                String key = menuItemJSONObject.getString("key");
                if (Validator.isNull((String)key) || (siteNavigationMenuItemSetting = siteNavigationMenuItemSettings.get(key)) == null) continue;
                type = siteNavigationMenuItemSetting.className;
                typeSettings = UnicodePropertiesBuilder.create((boolean)true).put("className", siteNavigationMenuItemSetting.className).put("classNameId", String.valueOf(this._portal.getClassNameId(siteNavigationMenuItemSetting.className))).put("classPK", String.valueOf(siteNavigationMenuItemSetting.classPK)).put("classTypeId", siteNavigationMenuItemSetting.classTypeId).put("title", siteNavigationMenuItemSetting.title).put("type", siteNavigationMenuItemSetting.type).buildString();
            }
            SiteNavigationMenuItem siteNavigationMenuItem = this._siteNavigationMenuItemLocalService.addSiteNavigationMenuItem(serviceContext.getUserId(), serviceContext.getScopeGroupId(), siteNavigationMenu.getSiteNavigationMenuId(), parentSiteNavigationMenuItemId, type, typeSettings, serviceContext);
            this._addSiteNavigationMenuItems(menuItemJSONObject, siteNavigationMenu, siteNavigationMenuItem.getSiteNavigationMenuItemId(), serviceContext, siteNavigationMenuItemSettings);
        }
    }

    private void _addSiteNavigationMenus(ServiceContext serviceContext, Map<String, SiteNavigationMenuItemSetting> siteNavigationMenuItemSettings) throws Exception {
        String json = this._read("/site-initializer/site-navigation-menus.json");
        if (json == null) {
            return;
        }
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this._addSiteNavigationMenu(jsonArray.getJSONObject(i), serviceContext, siteNavigationMenuItemSettings);
        }
    }

    private Long _addStructuredContentFolders(Long documentFolderId, String parentResourcePath, ServiceContext serviceContext) throws Exception {
        StructuredContentFolderResource.Builder structuredContentFolderResourceBuilder = this._structuredContentFolderResourceFactory.create();
        StructuredContentFolderResource structuredContentFolderResource = structuredContentFolderResourceBuilder.user(serviceContext.fetchUser()).build();
        String json = this._read(parentResourcePath + ".metadata.json");
        if (json == null) {
            json = JSONUtil.put((String)"name", (Object)FileUtil.getShortFileName((String)parentResourcePath)).toString();
        }
        StructuredContentFolder structuredContentFolder = StructuredContentFolder.toDTO((String)json);
        structuredContentFolder = documentFolderId != null ? structuredContentFolderResource.postStructuredContentFolderStructuredContentFolder(documentFolderId, structuredContentFolder) : structuredContentFolderResource.postSiteStructuredContentFolder(Long.valueOf(serviceContext.getScopeGroupId()), structuredContentFolder);
        return structuredContentFolder.getId();
    }

    private void _addStyleBookEntries(ServiceContext serviceContext) throws Exception {
        URL url = this._bundle.getEntry("/style-books.zip");
        if (url == null) {
            return;
        }
        this._styleBookEntryZipProcessor.importStyleBookEntries(serviceContext.getUserId(), serviceContext.getScopeGroupId(), FileUtil.createTempFile((InputStream)url.openStream()), false);
    }

    private void _addTaxonomyCategories(long groupId, String parentResourcePath, String parentTaxonomyCategoryId, ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder, long taxonomyVocabularyId) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths(parentResourcePath);
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith("/")) continue;
            String json = this._read(resourcePath);
            TaxonomyCategory taxonomyCategory = TaxonomyCategory.toDTO((String)json);
            if (taxonomyCategory == null) {
                _log.error((Object)("Unable to transform taxonomy category from JSON: " + json));
                continue;
            }
            taxonomyCategory = parentTaxonomyCategoryId == null ? this._addTaxonomyVocabularyTaxonomyCategory(serviceContext, taxonomyCategory, taxonomyVocabularyId) : this._addTaxonomyCategoryTaxonomyCategory(parentTaxonomyCategoryId, serviceContext, taxonomyCategory);
            final TaxonomyCategory finalTaxonomyCategory = taxonomyCategory;
            siteNavigationMenuItemSettingsBuilder.put(resourcePath, new SiteNavigationMenuItemSetting(){
                {
                    this.className = AssetCategory.class.getName();
                    this.classPK = finalTaxonomyCategory.getId();
                    this.title = finalTaxonomyCategory.getName();
                }
            });
            this._addTaxonomyCategories(groupId, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)"/"), taxonomyCategory.getId(), serviceContext, siteNavigationMenuItemSettingsBuilder, taxonomyVocabularyId);
        }
    }

    private TaxonomyCategory _addTaxonomyCategoryTaxonomyCategory(String parentTaxonomyCategoryId, ServiceContext serviceContext, TaxonomyCategory taxonomyCategory) throws Exception {
        TaxonomyCategoryResource.Builder taxonomyCategoryResourceBuilder = this._taxonomyCategoryResourceFactory.create();
        TaxonomyCategoryResource taxonomyCategoryResource = taxonomyCategoryResourceBuilder.user(serviceContext.fetchUser()).build();
        Page taxonomyCategoryPage = taxonomyCategoryResource.getTaxonomyCategoryTaxonomyCategoriesPage(parentTaxonomyCategoryId, "", taxonomyCategoryResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", taxonomyCategory.getName(), "'"})), null, null);
        TaxonomyCategory existingTaxonomyCategory = (TaxonomyCategory)taxonomyCategoryPage.fetchFirstItem();
        taxonomyCategory = existingTaxonomyCategory == null ? taxonomyCategoryResource.postTaxonomyCategoryTaxonomyCategory(parentTaxonomyCategoryId, taxonomyCategory) : taxonomyCategoryResource.patchTaxonomyCategory(existingTaxonomyCategory.getId(), taxonomyCategory);
        return taxonomyCategory;
    }

    private void _addTaxonomyVocabularies(long groupId, String parentResourcePath, ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        Set resourcePaths = this._servletContext.getResourcePaths(parentResourcePath);
        if (SetUtil.isEmpty((Set)resourcePaths)) {
            return;
        }
        TaxonomyVocabularyResource.Builder taxonomyVocabularyResourceBuilder = this._taxonomyVocabularyResourceFactory.create();
        TaxonomyVocabularyResource taxonomyVocabularyResource = taxonomyVocabularyResourceBuilder.user(serviceContext.fetchUser()).build();
        for (String resourcePath : resourcePaths) {
            if (resourcePath.endsWith("/")) continue;
            String json = this._read(resourcePath);
            TaxonomyVocabulary taxonomyVocabulary = TaxonomyVocabulary.toDTO((String)json);
            if (taxonomyVocabulary == null) {
                _log.error((Object)("Unable to transform taxonomy vocabulary from JSON: " + json));
                continue;
            }
            Page taxonomyVocabularyPage = taxonomyVocabularyResource.getSiteTaxonomyVocabulariesPage(Long.valueOf(groupId), "", taxonomyVocabularyResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", taxonomyVocabulary.getName(), "'"})), null, null);
            TaxonomyVocabulary existingTaxonomyVocabulary = (TaxonomyVocabulary)taxonomyVocabularyPage.fetchFirstItem();
            taxonomyVocabulary = existingTaxonomyVocabulary == null ? taxonomyVocabularyResource.postSiteTaxonomyVocabulary(Long.valueOf(groupId), taxonomyVocabulary) : taxonomyVocabularyResource.patchTaxonomyVocabulary(existingTaxonomyVocabulary.getId(), taxonomyVocabulary);
            this._addTaxonomyCategories(groupId, StringUtil.replaceLast((String)resourcePath, (String)".json", (String)"/"), null, serviceContext, siteNavigationMenuItemSettingsBuilder, taxonomyVocabulary.getId());
        }
    }

    private void _addTaxonomyVocabularies(ServiceContext serviceContext, SiteNavigationMenuItemSettingsBuilder siteNavigationMenuItemSettingsBuilder) throws Exception {
        Group group = this._groupLocalService.getCompanyGroup(serviceContext.getCompanyId());
        this._addTaxonomyVocabularies(group.getGroupId(), "/site-initializer/taxonomy-vocabularies/company", serviceContext, siteNavigationMenuItemSettingsBuilder);
        this._addTaxonomyVocabularies(serviceContext.getScopeGroupId(), "/site-initializer/taxonomy-vocabularies/group", serviceContext, siteNavigationMenuItemSettingsBuilder);
    }

    private TaxonomyCategory _addTaxonomyVocabularyTaxonomyCategory(ServiceContext serviceContext, TaxonomyCategory taxonomyCategory, long vocabularyId) throws Exception {
        TaxonomyCategoryResource.Builder taxonomyCategoryResourceBuilder = this._taxonomyCategoryResourceFactory.create();
        TaxonomyCategoryResource taxonomyCategoryResource = taxonomyCategoryResourceBuilder.user(serviceContext.fetchUser()).build();
        Page taxonomyCategoryPage = taxonomyCategoryResource.getTaxonomyVocabularyTaxonomyCategoriesPage(Long.valueOf(vocabularyId), "", taxonomyCategoryResource.toFilter(StringBundler.concat((String[])new String[]{"name eq '", taxonomyCategory.getName(), "'"})), null, null);
        TaxonomyCategory existingTaxonomyCategory = (TaxonomyCategory)taxonomyCategoryPage.fetchFirstItem();
        taxonomyCategory = existingTaxonomyCategory == null ? taxonomyCategoryResource.postTaxonomyVocabularyTaxonomyCategory(Long.valueOf(vocabularyId), taxonomyCategory) : taxonomyCategoryResource.patchTaxonomyCategory(existingTaxonomyCategory.getId(), taxonomyCategory);
        return taxonomyCategory;
    }

    private void _addUserAccounts(ServiceContext serviceContext) throws Exception {
        String json = this._read("/site-initializer/user-accounts.json");
        if (json == null) {
            return;
        }
        UserAccountResource.Builder userAccountResourceBuilder = this._userAccountResourceFactory.create();
        UserAccountResource userAccountResource = userAccountResourceBuilder.user(serviceContext.fetchUser()).build();
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            UserAccount userAccount = UserAccount.toDTO((String)String.valueOf(jsonObject));
            String externalReferenceCode = jsonObject.getString("externalReferenceCode");
            User existingUserAccount = this._userLocalService.fetchUserByEmailAddress(serviceContext.getCompanyId(), userAccount.getEmailAddress());
            if (existingUserAccount == null) {
                userAccountResource.postAccountUserAccountByExternalReferenceCode(externalReferenceCode, userAccount);
                continue;
            }
            userAccountResource.postAccountUserAccountByExternalReferenceCodeByEmailAddress(externalReferenceCode, existingUserAccount.getEmailAddress());
        }
    }

    private long[] _getAssetCategoryIds(long groupId, String[] externalReferenceCodes) {
        ArrayList<Long> assetCategoryIds = new ArrayList<Long>();
        for (String externalReferenceCode : externalReferenceCodes) {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategoryByExternalReferenceCode(groupId, externalReferenceCode);
            if (assetCategory == null) continue;
            assetCategoryIds.add(assetCategory.getCategoryId());
        }
        return ArrayUtil.toLongArray(assetCategoryIds);
    }

    private String _getThemeId(long companyId, String defaultThemeId, String themeName) {
        List themes = ListUtil.filter((List)this._themeLocalService.getThemes(companyId), theme -> Objects.equals(theme.getName(), themeName));
        if (ListUtil.isNotEmpty((List)themes)) {
            Theme theme2 = (Theme)themes.get(0);
            return theme2.getThemeId();
        }
        return defaultThemeId;
    }

    private void _invoke(UnsafeRunnable<Exception> unsafeRunnable) throws Exception {
        long startTime = System.currentTimeMillis();
        unsafeRunnable.run();
        if (_log.isInfoEnabled()) {
            Thread thread = Thread.currentThread();
            StackTraceElement stackTraceElement = thread.getStackTrace()[2];
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Invoking line ", stackTraceElement.getLineNumber(), " took ", System.currentTimeMillis() - startTime, " ms"}));
        }
    }

    private <T> T _invoke(UnsafeSupplier<T, Exception> unsafeSupplier) throws Exception {
        long startTime = System.currentTimeMillis();
        Object t = unsafeSupplier.get();
        if (_log.isInfoEnabled()) {
            Thread thread = Thread.currentThread();
            StackTraceElement stackTraceElement = thread.getStackTrace()[2];
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Invoking line ", stackTraceElement.getLineNumber(), " in ", System.currentTimeMillis() - startTime, " ms"}));
        }
        return (T)t;
    }

    private String _read(String resourcePath) throws Exception {
        InputStream inputStream = this._servletContext.getResourceAsStream(resourcePath);
        if (inputStream == null) {
            return null;
        }
        return StringUtil.read((InputStream)inputStream);
    }

    private String _read(String fileName, URL url) throws Exception {
        String urlPath = url.getPath();
        URL entryURL = this._bundle.getEntry(urlPath.substring(0, urlPath.lastIndexOf("/") + 1) + fileName);
        return StringUtil.read((InputStream)entryURL.openStream());
    }

    private Map<Locale, String> _toMap(String values) {
        return this._toMap("", values);
    }

    private Map<Locale, String> _toMap(String prefix, String values) {
        if (Validator.isBlank((String)values)) {
            return Collections.emptyMap();
        }
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        Map valuesMap = (Map)ObjectMapperUtil.readValue(HashMap.class, (String)values);
        for (Map.Entry entry : valuesMap.entrySet()) {
            map.put(LocaleUtil.fromLanguageId((String)((String)entry.getKey())), prefix + (String)entry.getValue());
        }
        return map;
    }

    private Layout _updateDraftLayout(Layout draftLayout, JSONObject settingsJSONObject) throws Exception {
        LayoutPageTemplateEntry layoutPageTemplateEntry;
        UnicodeProperties unicodeProperties = draftLayout.getTypeSettingsProperties();
        Set set = unicodeProperties.entrySet();
        set.removeIf(entry -> StringUtil.startsWith((String)((String)entry.getKey()), (String)"lfr-theme:"));
        JSONObject themeSettingsJSONObject = settingsJSONObject.getJSONObject("themeSettings");
        if (themeSettingsJSONObject != null) {
            for (String key : themeSettingsJSONObject.keySet()) {
                unicodeProperties.put(key, themeSettingsJSONObject.getString(key));
            }
            draftLayout = this._layoutLocalService.updateLayout(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), unicodeProperties.toString());
            draftLayout.setTypeSettingsProperties(unicodeProperties);
        }
        draftLayout = this._layoutLocalService.updateLookAndFeel(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), this._getThemeId(draftLayout.getCompanyId(), draftLayout.getThemeId(), settingsJSONObject.getString("themeName")), settingsJSONObject.getString("colorSchemeName", draftLayout.getColorSchemeId()), settingsJSONObject.getString("css", draftLayout.getCss()));
        JSONObject masterPageJSONObject = settingsJSONObject.getJSONObject("masterPage");
        if (masterPageJSONObject != null && (layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(draftLayout.getGroupId(), masterPageJSONObject.getString("key"))) != null) {
            draftLayout = this._layoutLocalService.updateMasterLayoutPlid(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), layoutPageTemplateEntry.getPlid());
        }
        return draftLayout;
    }

    private void _updateLayoutSet(boolean privateLayout, ServiceContext serviceContext) throws Exception {
        JSONObject settingsJSONObject;
        LayoutSet layoutSet = this._layoutSetLocalService.getLayoutSet(serviceContext.getScopeGroupId(), privateLayout);
        String resourcePath = "/site-initializer/layout-set";
        resourcePath = privateLayout ? resourcePath + "/private" : resourcePath + "/public";
        String metadataJSON = this._read(resourcePath + "/metadata.json");
        JSONObject metadataJSONObject = JSONFactoryUtil.createJSONObject((String)(metadataJSON == null ? "{}" : metadataJSON));
        String css = GetterUtil.getString((String)this._read(resourcePath + "/css.css"));
        this._layoutSetLocalService.updateLookAndFeel(serviceContext.getScopeGroupId(), privateLayout, this._getThemeId(serviceContext.getCompanyId(), "", metadataJSONObject.getString("themeName")), layoutSet.getColorSchemeId(), css);
        URL url = this._servletContext.getResource(resourcePath + "/logo.png");
        if (url != null) {
            this._layoutSetLocalService.updateLogo(serviceContext.getScopeGroupId(), privateLayout, true, FileUtil.getBytes((InputStream)url.openStream()));
        }
        if ((settingsJSONObject = metadataJSONObject.getJSONObject("settings")) == null) {
            return;
        }
        String js = this._read(resourcePath + "/js.js");
        if (Validator.isNotNull((String)js)) {
            settingsJSONObject.put("javascript", js);
        }
        UnicodeProperties unicodeProperties = layoutSet.getSettingsProperties();
        for (String key : settingsJSONObject.keySet()) {
            unicodeProperties.put(key, settingsJSONObject.getString(key));
        }
        this._layoutSetLocalService.updateSettings(serviceContext.getScopeGroupId(), privateLayout, unicodeProperties.toString());
    }

    private void _updateLayoutSets(ServiceContext serviceContext) throws Exception {
        this._updateLayoutSet(false, serviceContext);
        this._updateLayoutSet(true, serviceContext);
    }

    private class SiteNavigationMenuItemSettingsBuilder {
        private Map<String, SiteNavigationMenuItemSetting> _siteNavigationMenuItemSettings = new HashMap<String, SiteNavigationMenuItemSetting>();

        private SiteNavigationMenuItemSettingsBuilder() {
        }

        public Map<String, SiteNavigationMenuItemSetting> build() {
            return this._siteNavigationMenuItemSettings;
        }

        public void put(String key, SiteNavigationMenuItemSetting siteNavigationMenuItemSetting) {
            this._siteNavigationMenuItemSettings.put(key, siteNavigationMenuItemSetting);
        }
    }

    private class SiteNavigationMenuItemSetting {
        public String className;
        public String classPK;
        public String classTypeId = "";
        public String title;
        public String type = "";

        private SiteNavigationMenuItemSetting() {
        }
    }
}

