/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.initializer.extender.internal;

import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFolderService;
import com.liferay.layout.exporter.LayoutsExporter;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.utility.page.model.LayoutUtilityPageEntry;
import com.liferay.layout.utility.page.service.LayoutUtilityPageEntryLocalService;
import com.liferay.list.type.model.ListTypeDefinition;
import com.liferay.list.type.service.ListTypeDefinitionLocalService;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReader;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactory;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.kernel.zip.ZipWriterFactory;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.site.exception.SerializationException;
import com.liferay.site.initializer.SiteInitializerSerializer;
import com.liferay.style.book.model.StyleBookEntry;
import com.liferay.style.book.service.StyleBookEntryLocalService;
import com.liferay.style.book.util.comparator.StyleBookEntryNameComparator;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SiteInitializerSerializer.class})
public class SiteInitializerSerializerImpl
implements SiteInitializerSerializer {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JournalFolderService _journalFolderService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutsExporter _layoutsExporter;
    @Reference
    private LayoutUtilityPageEntryLocalService _layoutUtilityPageEntryLocalService;
    @Reference
    private ListTypeDefinitionLocalService _listTypeDefinitionLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference(target="(component.name=com.liferay.headless.delivery.internal.dto.v1_0.converter.PageDefinitionDTOConverter)")
    private DTOConverter<LayoutStructure, PageDefinition> _pageDefinitionDTOConverter;
    @Reference
    private SAXReader _saxReader;
    @Reference
    private StyleBookEntryLocalService _styleBookEntryLocalService;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private ZipReaderFactory _zipReaderFactory;
    @Reference
    private ZipWriterFactory _zipWriterFactory;

    public File serialize(long groupId) throws SerializationException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-19870")) {
            throw new UnsupportedOperationException();
        }
        try {
            ZipWriter zipWriter = this._zipWriterFactory.getZipWriter();
            this._serializeDDMStructures(groupId, zipWriter);
            this._serializeDDMTemplates(groupId, zipWriter);
            this._serializeDocuments(groupId, 0L, "documents/group", zipWriter);
            this._serializeJournalArticles(groupId, 0L, "journal-articles", zipWriter);
            this._serializeLayoutPageTemplates(groupId, zipWriter);
            this._serializeLayoutUtilityPageEntries(groupId, zipWriter);
            this._serializeLayouts(groupId, "layouts", zipWriter);
            Group group = this._groupLocalService.getGroup(groupId);
            this._serializeObjectDefinitions(group.getCompanyId(), zipWriter);
            this._serializeStyleBookEntries(groupId, zipWriter);
            this._serializeUserAccounts(groupId, zipWriter);
            return zipWriter.getFile();
        }
        catch (Exception exception) {
            throw new SerializationException((Throwable)exception);
        }
    }

    private void _addZipEntry(String fileName, InputStream inputStream, ZipWriter zipWriter) throws Exception {
        zipWriter.addEntry("site-initializer/" + fileName, inputStream);
    }

    private void _addZipEntry(String fileName, JSONArray jsonArray, ZipWriter zipWriter) throws Exception {
        this._addZipEntry(fileName, JSONUtil.toString((JSONArray)jsonArray), zipWriter);
    }

    private void _addZipEntry(String fileName, JSONObject jsonObject, ZipWriter zipWriter) throws Exception {
        this._addZipEntry(fileName, JSONUtil.toString((JSONObject)jsonObject), zipWriter);
    }

    private void _addZipEntry(String fileName, String string, ZipWriter zipWriter) throws Exception {
        zipWriter.addEntry("site-initializer/" + fileName, string);
    }

    private void _addZipEntry(String fileName, UnsafeSupplier<String, Exception> unsafeSupplier, ZipWriter zipWriter) throws Exception {
        zipWriter.addEntry("site-initializer/" + fileName, (String)unsafeSupplier.get());
    }

    private String _normalize(String string) {
        string = StringUtil.toLowerCase((String)string);
        return StringUtil.replace((String)string, (char)' ', (char)'-');
    }

    private void _serializeDDMStructure(DDMStructure ddmStructure, ZipWriter zipWriter) throws Exception {
        Document document = this._saxReader.createDocument();
        Element rootElement = document.addElement("root");
        Element structureElement = rootElement.addElement("structure");
        Element definitionElement = structureElement.addElement("definition");
        String definition = ddmStructure.getDefinition();
        if (JSONUtil.isJSONObject((String)definition)) {
            definition = JSONUtil.toString((JSONObject)this._jsonFactory.createJSONObject(definition));
        }
        definitionElement.addCDATA(definition);
        Element descriptionElement = structureElement.addElement("description");
        descriptionElement.addText(ddmStructure.getDescription(LocaleUtil.getDefault()));
        Element nameElement = structureElement.addElement("name");
        nameElement.addText(ddmStructure.getName(LocaleUtil.getDefault()));
        this._addZipEntry("ddm-structures/" + this._normalize(ddmStructure.getStructureKey()) + ".xml", document.formattedString(), zipWriter);
    }

    private void _serializeDDMStructures(long groupId, ZipWriter zipWriter) throws Exception {
        List ddmStructures = this._ddmStructureLocalService.getStructures(groupId);
        for (DDMStructure ddmStructure : ddmStructures) {
            this._serializeDDMStructure(ddmStructure, zipWriter);
        }
    }

    private void _serializeDDMTemplate(DDMTemplate ddmTemplate, ZipWriter zipWriter) throws Exception {
        this._addZipEntry("ddm-templates/" + this._normalize(ddmTemplate.getTemplateKey()) + "/ddm-template.ftl", ddmTemplate.getScript(), zipWriter);
        this._addZipEntry("ddm-templates/" + this._normalize(ddmTemplate.getTemplateKey()) + "/ddm-template.json", JSONUtil.put((String)"className", (Object)ddmTemplate.getClassName()).put("ddmTemplateKey", ddmTemplate.getTemplateKey()).put("name", ddmTemplate.getName(LocaleUtil.getDefault())).put("resourceClassName", ddmTemplate.getResourceClassName()), zipWriter);
    }

    private void _serializeDDMTemplates(long groupId, ZipWriter zipWriter) throws Exception {
        List ddmTemplates = this._ddmTemplateLocalService.getTemplatesByGroupId(groupId);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            this._serializeDDMTemplate(ddmTemplate, zipWriter);
        }
    }

    private void _serializeDocuments(long groupId, Long parentFolderId, String zipDirName, ZipWriter zipWriter) throws Exception {
        List fileEntries = this._dlAppService.getFileEntries(groupId, parentFolderId.longValue());
        for (FileEntry fileEntry : fileEntries) {
            this._addZipEntry(this._normalize(zipDirName + "/" + fileEntry.getFileName()), fileEntry.getContentStream(), zipWriter);
        }
        List folders = this._dlAppService.getFolders(groupId, parentFolderId.longValue());
        for (Folder folder : folders) {
            this._serializeDocuments(groupId, folder.getFolderId(), zipDirName + "/" + folder.getName(), zipWriter);
        }
    }

    private void _serializeJournalArticles(long groupId, long parentFolderId, String zipDirName, ZipWriter zipWriter) throws Exception {
        List journalArticles = this._journalArticleLocalService.getArticles(groupId, parentFolderId);
        for (JournalArticle journalArticle : journalArticles) {
            this._addZipEntry(this._normalize(StringBundler.concat((String[])new String[]{zipDirName, "/", journalArticle.getArticleId(), ".json"})), JSONUtil.put((String)"ddmStructureKey", (Object)journalArticle.getDDMStructureKey()).put("name", journalArticle.getArticleId()), zipWriter);
            this._addZipEntry(this._normalize(StringBundler.concat((String[])new String[]{zipDirName, "/", journalArticle.getArticleId(), ".xml"})), journalArticle.getContent(), zipWriter);
        }
        List journalFolders = this._journalFolderService.getFolders(groupId, parentFolderId);
        for (JournalFolder journalFolder : journalFolders) {
            this._addZipEntry(this._normalize(StringBundler.concat((String[])new String[]{zipDirName, "/", journalFolder.getName(), "metadata.json"})), JSONUtil.put((String)"description", (Object)journalFolder.getDescription()).put("externalReferenceCode", journalFolder.getExternalReferenceCode()).put("name", journalFolder.getName()).put("viewableBy", "Anyone"), zipWriter);
            this._serializeJournalArticles(groupId, journalFolder.getFolderId(), StringBundler.concat((String[])new String[]{zipDirName, "/", journalFolder.getName()}), zipWriter);
        }
    }

    private void _serializeLayout(final Layout layout, String zipDirName, ZipWriter zipWriter) throws Exception {
        this._addZipEntry(zipDirName + "/page.json", JSONUtil.put((String)"friendlyURL", (Object)layout.getFriendlyURL()).put("hidden", layout.isHidden()).put("name_i18n", JSONUtil.put((String)"en_US", (Object)layout.getName(LocaleUtil.US))).put("priority", layout.getPriority()).put("private", layout.isPrivateLayout()).put("system", layout.isSystem()).put("type", layout.getType()).put("typeSettings", () -> {
            if (Validator.isNull((String)layout.getTypeSettings())) {
                return null;
            }
            String[] parts = StringUtil.split((String)layout.getTypeSettings(), (char)'=');
            JSONObject jsonObject = JSONUtil.put((String)"key", (Object)parts[0]);
            if (Objects.equals(layout.getType(), "link_to_layout")) {
                Layout linkToLayout = this._layoutLocalService.getLayout(layout.getGroupId(), layout.isPrivateLayout(), GetterUtil.getLong((String)parts[1].replace("\n", "")));
                jsonObject.put("value", "[$LAYOUT_ID:" + linkToLayout.getName(LocaleUtil.US) + "$]");
            } else if (Objects.equals(layout.getType(), "url")) {
                jsonObject.put("value", parts[1].replace("\n", ""));
            }
            return JSONUtil.put((Object)jsonObject);
        }), zipWriter);
        if (!Objects.equals(layout.getType(), "content")) {
            return;
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        PageDefinition pageDefinition = (PageDefinition)this._pageDefinitionDTOConverter.toDTO((DTOConverterContext)new DefaultDTOConverterContext(true, null, this._dtoConverterRegistry, null, layout.getPlid(), null, null, null){
            {
                super(x0, x1, x2, x3, x4, x5, x6, x7);
                this.setAttribute("embeddedPageDefinition", Boolean.TRUE);
                this.setAttribute("groupId", layout.getGroupId());
                this.setAttribute("layout", layout);
            }
        }, (Object)LayoutStructure.of((String)layoutPageTemplateStructure.getDefaultSegmentsExperienceData()));
        this._addZipEntry(zipDirName + "/page-definition.json", JSONUtil.put((String)"pageElement", (Object)pageDefinition.getPageElement()).put("settings", (Object)pageDefinition.getSettings()), zipWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _serializeLayoutPageTemplates(long groupId, ZipWriter zipWriter) throws Exception {
        File file = this._layoutsExporter.exportLayoutPageTemplateEntries(groupId);
        ZipReader zipReader = null;
        try {
            zipReader = this._zipReaderFactory.getZipReader(file);
            for (String name : zipReader.getEntries()) {
                InputStream inputStream = zipReader.getEntryAsInputStream(name);
                this._addZipEntry("layout-page-templates/" + name, inputStream, zipWriter);
            }
        }
        finally {
            if (zipReader != null) {
                zipReader.close();
            }
            file.delete();
        }
    }

    private void _serializeLayouts(long groupId, boolean privateLayout, long layoutId, String zipDirName, ZipWriter zipWriter) throws Exception {
        List layouts = this._layoutLocalService.getLayouts(groupId, privateLayout, layoutId);
        for (Layout layout : layouts) {
            zipDirName = zipDirName + '/' + this._normalize(layout.getName(LocaleUtil.US));
            this._serializeLayout(layout, zipDirName, zipWriter);
            this._serializeLayouts(groupId, layout.isPrivateLayout(), layout.getLayoutId(), zipDirName, zipWriter);
        }
    }

    private void _serializeLayouts(long groupId, String zipDirName, ZipWriter zipWriter) throws Exception {
        this._serializeLayouts(groupId, false, 0L, zipDirName, zipWriter);
        this._serializeLayouts(groupId, true, 0L, zipDirName, zipWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _serializeLayoutUtilityPageEntries(long groupId, ZipWriter zipWriter) throws Exception {
        File file = this._layoutsExporter.exportLayoutUtilityPageEntries(ListUtil.toLongArray((List)this._layoutUtilityPageEntryLocalService.getLayoutUtilityPageEntries(groupId), (Accessor)LayoutUtilityPageEntry.LAYOUT_UTILITY_PAGE_ENTRY_ID_ACCESSOR));
        ZipReader zipReader = null;
        try {
            zipReader = this._zipReaderFactory.getZipReader(file);
            for (String name : zipReader.getEntries()) {
                String fileName = "layout-utility-page-entries/";
                fileName = fileName + StringUtil.removeSubstring((String)name, (String)"layout-utility-page-template/");
                this._addZipEntry(fileName, zipReader.getEntryAsInputStream(name), zipWriter);
            }
        }
        finally {
            if (zipReader != null) {
                zipReader.close();
            }
            file.delete();
        }
    }

    private void _serializeObjectDefinition(ObjectDefinition objectDefinition, ZipWriter zipWriter) throws Exception {
        JSONArray objectFieldsJSONArray = JSONUtil.toJSONArray((Collection)this._objectFieldLocalService.getCustomObjectFields(objectDefinition.getObjectDefinitionId()), objectField -> {
            if (StringUtil.equals((String)objectField.getBusinessType(), (String)"Relationship")) {
                return null;
            }
            return JSONUtil.put((String)"businessType", (Object)objectField.getBusinessType()).put("DBType", objectField.getDBType()).put("indexedAsKeyword", objectField.isIndexedAsKeyword()).put("label", JSONUtil.put((String)"en_US", (Object)objectField.getLabel(LocaleUtil.US))).put("listTypeDefinitionId", () -> {
                ListTypeDefinition listTypeDefinition = this._listTypeDefinitionLocalService.fetchListTypeDefinition(objectField.getListTypeDefinitionId());
                if (listTypeDefinition == null) {
                    return "0";
                }
                String name = this._normalize(listTypeDefinition.getName(LocaleUtil.US));
                return "[$LIST_TYPE_DEFINITION_ID:" + name + "$]";
            }).put("name", objectField.getName()).put("objectFieldSettings", JSONUtil.toJSONArray((Collection)objectField.getObjectFieldSettings(), objectFieldSetting -> JSONUtil.put((String)"name", (Object)objectFieldSetting.getName()).put("value", objectFieldSetting.getValue()))).put("required", objectField.isRequired()).put("state", objectField.isState());
        });
        String name = StringUtil.removeSubstring((String)objectDefinition.getName(), (String)"C_");
        JSONArray objectRelationshipsJSONArray = JSONUtil.toJSONArray((Collection)this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId()), objectRelationship -> {
            String objectDefinition2Name = StringUtil.removeSubstring((String)this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2()).getName(), (String)"C_");
            return JSONUtil.put((String)"deletionType", (Object)objectRelationship.getDeletionType()).put("label", JSONUtil.put((String)"en_US", (Object)objectRelationship.getLabel(LocaleUtil.US))).put("name", objectRelationship.getName()).put("objectDefinitionId1", "[$OBJECT_DEFINITION_ID:" + name + "$]").put("objectDefinitionId2", "[$OBJECT_DEFINITION_ID:" + objectDefinition2Name + "$]").put("objectDefinitionName2", objectDefinition2Name).put("type", objectRelationship.getType());
        });
        this._addZipEntry("object-definitions/" + this._normalize(objectDefinition.getLabel(LocaleUtil.US)), JSONUtil.put((String)"label", (Object)JSONUtil.put((String)"en_US", (Object)objectDefinition.getLabel(LocaleUtil.US))).put("name", name).put("objectFields", objectFieldsJSONArray).put("objectRelationships", objectRelationshipsJSONArray).put("pluralLabel", objectDefinition.getPluralLabel(LocaleUtil.US)).put("scope", objectDefinition.getScope()), zipWriter);
    }

    private void _serializeObjectDefinitions(long companyId, ZipWriter zipWriter) throws Exception {
        for (ObjectDefinition objectDefinition : this._objectDefinitionLocalService.getObjectDefinitions(companyId, true, false, 0)) {
            this._serializeObjectDefinition(objectDefinition, zipWriter);
        }
    }

    private void _serializeOrganization(JSONArray jsonArray, Organization organization) {
        JSONObject jsonObject = JSONUtil.put((String)"childOrganizations", (Object)this._jsonFactory.createJSONArray()).put("externalReferenceCode", organization.getExternalReferenceCode()).put("name", organization.getName());
        for (Organization childOrganization : this._organizationLocalService.getOrganizations(organization.getCompanyId(), organization.getOrganizationId())) {
            this._serializeOrganization(jsonObject.getJSONArray("childOrganizations"), childOrganization);
        }
        jsonArray.put(jsonObject);
    }

    private void _serializeStyleBookEntries(long groupId, ZipWriter zipWriter) throws Exception {
        List styleBookEntries = this._styleBookEntryLocalService.getStyleBookEntries(groupId, -1, -1, (OrderByComparator)StyleBookEntryNameComparator.getInstance((boolean)true));
        for (StyleBookEntry styleBookEntry : styleBookEntries) {
            styleBookEntry.populateZipWriter(zipWriter, "site-initializer/style-books");
        }
    }

    private void _serializeUserAccounts(long groupId, ZipWriter zipWriter) throws Exception {
        TreeSet accountEntries = new TreeSet();
        HashMap roleNamesMap = new HashMap();
        TreeSet organizations = new TreeSet();
        TreeSet roles = new TreeSet();
        this._addZipEntry("user-accounts.json", JSONUtil.toJSONArray((Collection)this._userLocalService.getGroupUsers(groupId), user -> {
            List userRoles = user.getRoles();
            for (Role role : userRoles) {
                if (!StringUtil.equals((String)role.getName(), (String)"Administrator") && !StringUtil.equals((String)role.getName(), (String)"Power User")) continue;
                return null;
            }
            roleNamesMap.put(user.getEmailAddress(), ListUtil.toArray((List)userRoles, (Accessor)Role.NAME_ACCESSOR));
            roles.addAll(userRoles);
            List userAccountEntries = this._accountEntryLocalService.getUserAccountEntries(user.getUserId(), null, null, null, -1, -1);
            accountEntries.addAll(userAccountEntries);
            List userOrganizations = user.getOrganizations();
            organizations.addAll(userOrganizations);
            return JSONUtil.put((String)"accountBriefs", (Object)JSONUtil.toJSONArray((Collection)userAccountEntries, accountEntry -> JSONUtil.put((String)"externalReferenceCode", (Object)accountEntry.getExternalReferenceCode()))).put("alternateName", user.getScreenName()).put("emailAddress", (Object)user.getEmailAddresses()).put("externalReferenceCode", user.getExternalReferenceCode()).put("familyName", user.getLastName()).put("givenName", user.getFirstName()).put("name", user.getFullName()).put("organizationBriefs", JSONUtil.toJSONArray((Collection)userOrganizations, organization -> JSONUtil.put((String)"name", (Object)organization.getName())));
        }), zipWriter);
        this._addZipEntry("accounts.json", JSONUtil.toJSONArray(accountEntries, accountEntry -> JSONUtil.put((String)"externalReferenceCode", (Object)accountEntry.getExternalReferenceCode()).put("name", accountEntry.getName()).put("type", accountEntry.getType())), zipWriter);
        this._addZipEntry("organizations.json", (UnsafeSupplier<String, Exception>)((UnsafeSupplier)() -> {
            JSONArray jsonArray = this._jsonFactory.createJSONArray();
            for (Organization organization : organizations) {
                this._serializeOrganization(jsonArray, organization);
            }
            return JSONUtil.toString((JSONArray)jsonArray);
        }), zipWriter);
        this._addZipEntry("roles.json", JSONUtil.toJSONArray(roles, role -> {
            if (StringUtil.equals((String)role.getName(), (String)"User")) {
                return null;
            }
            return JSONUtil.put((String)"name", (Object)role.getName()).put("name_i18n", JSONUtil.put((String)"en-US", (Object)role.getName())).put("type", role.getType());
        }), zipWriter);
        this._addZipEntry("user-groups.json", JSONUtil.toJSONArray((Collection)this._userGroupLocalService.getGroupUserGroups(groupId), userGroup -> JSONUtil.put((String)"description", (Object)userGroup.getDescription()).put("externalReferenceCode", userGroup.getExternalReferenceCode()).put("name", userGroup.getName())), zipWriter);
        this._addZipEntry("user-roles.json", JSONUtil.toJSONArray(roleNamesMap.keySet(), emailAddress -> JSONUtil.put((String)"emailAddress", (Object)emailAddress).put("roles", JSONUtil.toJSONArray((Object[])((Object[])roleNamesMap.get(emailAddress)), roleName -> {
            if (StringUtil.equals((String)roleName, (String)"User")) {
                return null;
            }
            return roleName;
        }))), zipWriter);
    }
}

