/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

import {State} from '../contexts/StateContext';
import {ObjectDefinition, ObjectField} from '../types/ObjectDefinition';
import {FIELD_TYPE_BUSINESS_TYPE, Field} from './field';

export default function buildObjectDefinition({
	fields = [],
	id,
	label,
	name,
}: {
	fields?: Field[];
	id?: State['id'];
	label: State['label'];
	name?: State['name'];
}): ObjectDefinition {
	const objectDefinition: ObjectDefinition = {
		label: {
			en_US: label,
		},
		objectFields: buildFields(fields),
		pluralLabel: {
			en_US: label,
		},
		scope: 'company',
	};

	if (id) {
		objectDefinition.id = id;
	}

	if (name) {
		objectDefinition.name = name;
	}

	return objectDefinition;
}

function buildFields(fields: Field[]) {
	return fields.map((field) => {
		const objectField: ObjectField = {
			businessType: FIELD_TYPE_BUSINESS_TYPE[field.type],
			externalReferenceCode: field.erc,
			label: {
				en_US: field.label,
			},
			localized: false,
			name: field.name,
			required: false,
		};

		if ('settings' in field) {
			objectField.objectFieldSettings = Object.entries(
				field.settings
			).map(([name, value]) => ({name, value}));
		}

		return objectField;
	});
}
