/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.cms.site.initializer.util;

import com.liferay.depot.model.DepotEntry;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryFolder;
import com.liferay.object.rest.filter.factory.FilterFactory;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryFolderLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.site.cms.site.initializer.util.CMSDefaultPermissionUtil;
import java.util.List;
import java.util.Objects;

public class ResetAssetPermissionUtil {
    public static void executeResetAssetPermission(String className, long classPK, FilterFactory<Predicate> filterFactory, GroupLocalService groupLocalService, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryFolderLocalService objectEntryFolderLocalService, ModelResourcePermission<ObjectEntryFolder> objectEntryFolderModelResourcePermission, ObjectEntryLocalService objectEntryLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) throws Exception {
        if (className.startsWith(ObjectDefinition.class.getName())) {
            ObjectEntry objectEntry = objectEntryLocalService.getObjectEntry(classPK);
            ObjectDefinition objectDefinition = objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
            ModelResourcePermission modelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission((String)objectDefinition.getClassName());
            modelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), objectEntry.getObjectEntryId(), "PERMISSIONS");
            ObjectEntryFolder rootObjectEntryFolder = ResetAssetPermissionUtil._getRootObjectEntryFolder(objectEntry, objectEntryFolderLocalService);
            if (rootObjectEntryFolder == null) {
                return;
            }
            JSONObject jsonObject = ResetAssetPermissionUtil._getCMSDefaultPermissionJSONObject(objectEntry.getGroupId(), groupLocalService, objectEntry.getObjectEntryFolderId(), filterFactory, objectEntryFolderLocalService);
            JSONObject objectEntryJSONObject = jsonObject.getJSONObject(rootObjectEntryFolder.getExternalReferenceCode());
            if (objectEntryJSONObject == null) {
                return;
            }
            ResetAssetPermissionUtil._setResourcePermissions(objectEntry.getModelClassName(), objectEntry.getCompanyId(), objectEntryJSONObject, objectEntry.getObjectEntryId(), resourcePermissionLocalService, roleLocalService);
        } else if (className.equals(ObjectEntryFolder.class.getName())) {
            ObjectEntryFolder objectEntryFolder = objectEntryFolderLocalService.getObjectEntryFolder(classPK);
            objectEntryFolderModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), objectEntryFolder.getObjectEntryFolderId(), "PERMISSIONS");
            JSONObject jsonObject = ResetAssetPermissionUtil._getCMSDefaultPermissionJSONObject(objectEntryFolder.getGroupId(), groupLocalService, objectEntryFolder.getParentObjectEntryFolderId(), filterFactory, objectEntryFolderLocalService);
            ResetAssetPermissionUtil._setResourcePermissions(objectEntryFolder.getModelClassName(), objectEntryFolder.getCompanyId(), jsonObject.getJSONObject("OBJECT_ENTRY_FOLDERS"), objectEntryFolder.getObjectEntryFolderId(), resourcePermissionLocalService, roleLocalService);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static JSONObject _getCMSDefaultPermissionJSONObject(long groupId, GroupLocalService groupLocalService, long objectEntryFolderId, FilterFactory<Predicate> filterFactory, ObjectEntryFolderLocalService objectEntryFolderLocalService) throws Exception {
        ObjectEntryFolder objectEntryFolder;
        JSONObject jsonObject;
        if (objectEntryFolderId != 0L && (jsonObject = CMSDefaultPermissionUtil.getJSONObject((objectEntryFolder = objectEntryFolderLocalService.getObjectEntryFolder(objectEntryFolderId)).getCompanyId(), objectEntryFolder.getUserId(), objectEntryFolder.getExternalReferenceCode(), objectEntryFolder.getModelClassName(), filterFactory)) != null && !JSONUtil.isEmpty((JSONObject)jsonObject)) {
            return jsonObject;
        }
        Group group = groupLocalService.getGroup(groupId);
        return CMSDefaultPermissionUtil.getJSONObject(group.getCompanyId(), group.getCreatorUserId(), group.getExternalReferenceCode(), DepotEntry.class.getName(), filterFactory);
    }

    private static ObjectEntryFolder _getRootObjectEntryFolder(ObjectEntry objectEntry, ObjectEntryFolderLocalService objectEntryFolderLocalService) {
        ObjectEntryFolder objectEntryFolder = objectEntryFolderLocalService.fetchObjectEntryFolder(objectEntry.getObjectEntryFolderId());
        if (objectEntryFolder == null) {
            return null;
        }
        if (Objects.equals(objectEntryFolder.getExternalReferenceCode(), "L_CONTENTS") || Objects.equals(objectEntryFolder.getExternalReferenceCode(), "L_FILES")) {
            return objectEntryFolder;
        }
        String[] parts = StringUtil.split((String)objectEntryFolder.getTreePath(), (char)'/');
        if (parts.length <= 2) {
            return null;
        }
        return objectEntryFolderLocalService.fetchObjectEntryFolder(GetterUtil.getLong((String)parts[1]));
    }

    private static void _setResourcePermissions(String className, long companyId, JSONObject jsonObject, long primKey, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService) throws Exception {
        resourcePermissionLocalService.deleteResourcePermissions(companyId, className, 4, String.valueOf(primKey));
        List resourceActions = ResourceActionsUtil.getResourceActions((String)className);
        for (String key : jsonObject.keySet()) {
            Role role;
            JSONArray jsonArray = jsonObject.getJSONArray(key);
            if (jsonArray == null || JSONUtil.isEmpty((JSONArray)jsonArray) || (role = roleLocalService.fetchRole(companyId, key)) == null) continue;
            resourcePermissionLocalService.setResourcePermissions(companyId, className, 4, String.valueOf(primKey), role.getRoleId(), (String[])ArrayUtil.filter((Object[])JSONUtil.toStringArray((JSONArray)jsonArray), action -> resourceActions.contains(action)));
        }
    }
}

