/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.util;

import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.PanelCategoryRegistry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GroupURLProvider.class})
public class GroupURLProvider {
    private static final Log _log = LogFactoryUtil.getLog(GroupURLProvider.class);
    @Reference
    private Http _http;
    private PanelAppRegistry _panelAppRegistry;
    private PanelCategoryRegistry _panelCategoryRegistry;
    @Reference
    private Portal _portal;

    public String getGroupAdministrationURL(Group group, PortletRequest portletRequest) {
        PortletURL groupAdministrationURL;
        PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry, this._panelCategoryRegistry);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletId = panelCategoryHelper.getFirstPortletId("site_administration", themeDisplay.getPermissionChecker(), group);
        if (Validator.isNotNull((String)portletId) && (groupAdministrationURL = this._portal.getControlPanelPortletURL(portletRequest, group, portletId, 0L, 0L, "RENDER_PHASE")) != null) {
            return groupAdministrationURL.toString();
        }
        return null;
    }

    public String getGroupLayoutsURL(Group group, boolean privateLayout, PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String groupDisplayURL = group.getDisplayURL(themeDisplay, privateLayout);
        if (Validator.isNotNull((String)groupDisplayURL)) {
            return groupDisplayURL;
        }
        return null;
    }

    public String getGroupURL(Group group, PortletRequest portletRequest) {
        return this.getGroupURL(group, portletRequest, true);
    }

    public String getLiveGroupURL(Group group, PortletRequest portletRequest) {
        return this.getGroupURL(group, portletRequest, false);
    }

    protected String getGroupURL(Group group, PortletRequest portletRequest, boolean includeStagingGroup) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String groupDisplayURL = group.getDisplayURL(themeDisplay, false);
        if (Validator.isNotNull((String)groupDisplayURL)) {
            return this._http.removeParameter(groupDisplayURL, "p_p_id");
        }
        groupDisplayURL = group.getDisplayURL(themeDisplay, true);
        if (Validator.isNotNull((String)groupDisplayURL)) {
            return this._http.removeParameter(groupDisplayURL, "p_p_id");
        }
        if (includeStagingGroup && group.hasStagingGroup()) {
            try {
                if (GroupPermissionUtil.contains((PermissionChecker)themeDisplay.getPermissionChecker(), (Group)group, (String)"VIEW_STAGING")) {
                    return this.getGroupURL(group.getStagingGroup(), portletRequest);
                }
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to check permission on group " + group.getGroupId()), (Throwable)portalException);
            }
        }
        return this.getGroupAdministrationURL(group, portletRequest);
    }

    @Reference(unbind="-")
    protected void setPanelAppRegistry(PanelAppRegistry panelAppRegistry) {
        this._panelAppRegistry = panelAppRegistry;
    }

    @Reference(unbind="-")
    protected void setPanelCategoryRegistry(PanelCategoryRegistry panelCategoryRegistry) {
        this._panelCategoryRegistry = panelCategoryRegistry;
    }
}

