/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.site.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedGroupedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the SiteFriendlyURL service. Represents a row in the &quot;SiteFriendlyURL&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.site.model.impl.SiteFriendlyURLModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.site.model.impl.SiteFriendlyURLImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SiteFriendlyURL
 * @generated
 */
@ProviderType
public interface SiteFriendlyURLModel
	extends BaseModel<SiteFriendlyURL>, MVCCModel, ShardedModel,
			StagedGroupedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a site friendly url model instance should use the {@link SiteFriendlyURL} interface instead.
	 */

	/**
	 * Returns the primary key of this site friendly url.
	 *
	 * @return the primary key of this site friendly url
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this site friendly url.
	 *
	 * @param primaryKey the primary key of this site friendly url
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this site friendly url.
	 *
	 * @return the mvcc version of this site friendly url
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this site friendly url.
	 *
	 * @param mvccVersion the mvcc version of this site friendly url
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the uuid of this site friendly url.
	 *
	 * @return the uuid of this site friendly url
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this site friendly url.
	 *
	 * @param uuid the uuid of this site friendly url
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the site friendly url ID of this site friendly url.
	 *
	 * @return the site friendly url ID of this site friendly url
	 */
	public long getSiteFriendlyURLId();

	/**
	 * Sets the site friendly url ID of this site friendly url.
	 *
	 * @param siteFriendlyURLId the site friendly url ID of this site friendly url
	 */
	public void setSiteFriendlyURLId(long siteFriendlyURLId);

	/**
	 * Returns the group ID of this site friendly url.
	 *
	 * @return the group ID of this site friendly url
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this site friendly url.
	 *
	 * @param groupId the group ID of this site friendly url
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this site friendly url.
	 *
	 * @return the company ID of this site friendly url
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this site friendly url.
	 *
	 * @param companyId the company ID of this site friendly url
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this site friendly url.
	 *
	 * @return the user ID of this site friendly url
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this site friendly url.
	 *
	 * @param userId the user ID of this site friendly url
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this site friendly url.
	 *
	 * @return the user uuid of this site friendly url
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this site friendly url.
	 *
	 * @param userUuid the user uuid of this site friendly url
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this site friendly url.
	 *
	 * @return the user name of this site friendly url
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this site friendly url.
	 *
	 * @param userName the user name of this site friendly url
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this site friendly url.
	 *
	 * @return the create date of this site friendly url
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this site friendly url.
	 *
	 * @param createDate the create date of this site friendly url
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this site friendly url.
	 *
	 * @return the modified date of this site friendly url
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this site friendly url.
	 *
	 * @param modifiedDate the modified date of this site friendly url
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the friendly url of this site friendly url.
	 *
	 * @return the friendly url of this site friendly url
	 */
	@AutoEscape
	public String getFriendlyURL();

	/**
	 * Sets the friendly url of this site friendly url.
	 *
	 * @param friendlyURL the friendly url of this site friendly url
	 */
	public void setFriendlyURL(String friendlyURL);

	/**
	 * Returns the language ID of this site friendly url.
	 *
	 * @return the language ID of this site friendly url
	 */
	@AutoEscape
	public String getLanguageId();

	/**
	 * Sets the language ID of this site friendly url.
	 *
	 * @param languageId the language ID of this site friendly url
	 */
	public void setLanguageId(String languageId);

	/**
	 * Returns the last publish date of this site friendly url.
	 *
	 * @return the last publish date of this site friendly url
	 */
	@Override
	public Date getLastPublishDate();

	/**
	 * Sets the last publish date of this site friendly url.
	 *
	 * @param lastPublishDate the last publish date of this site friendly url
	 */
	@Override
	public void setLastPublishDate(Date lastPublishDate);

}