/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.site.util.GroupURLProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={RecentGroupManager.class})
public class RecentGroupManager {
    private static final String _KEY_RECENT_GROUPS = "com.liferay.site.util_recentGroups";
    private static final Log _log = LogFactoryUtil.getLog(RecentGroupManager.class);
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupURLProvider _groupURLProvider;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public void addRecentGroup(HttpServletRequest request, Group group) {
        this.addRecentGroup(request, group.getGroupId());
    }

    public void addRecentGroup(HttpServletRequest request, long groupId) {
        long liveGroupId = this._getLiveGroupId(groupId);
        if (liveGroupId <= 0L) {
            return;
        }
        Group liveGroup = this._groupLocalService.fetchGroup(liveGroupId);
        if (liveGroup.isLayoutPrototype() || liveGroup.isLayoutSetPrototype()) {
            return;
        }
        String value = this._getRecentGroupsValue(request);
        List groupIds = ListUtil.fromArray((Object[])ArrayUtil.toLongArray((long[])StringUtil.split((String)value, (long)0L)));
        groupIds.remove(liveGroupId);
        groupIds.add(0, liveGroupId);
        this._setRecentGroupsValue(request, StringUtil.merge((Collection)groupIds));
    }

    public List<Group> getRecentGroups(HttpServletRequest request) {
        String value = this._getRecentGroupsValue(request);
        try {
            PortletRequest portletRequest = (PortletRequest)request.getAttribute("javax.portlet.request");
            return this.getRecentGroups(value, portletRequest);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to get recent groups", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Deprecated
    protected List<Group> getRecentGroups(String value) {
        long[] groupIds = StringUtil.split((String)value, (long)0L);
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            return Collections.emptyList();
        }
        ArrayList<Group> groups = new ArrayList<Group>(groupIds.length);
        for (long groupId : groupIds) {
            Group group = this._groupLocalService.fetchGroup(groupId);
            if (!this._groupLocalService.isLiveGroupActive(group)) continue;
            groups.add(group);
        }
        return groups;
    }

    protected List<Group> getRecentGroups(String value, PortletRequest portletRequest) throws Exception {
        long[] groupIds = StringUtil.split((String)value, (long)0L);
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            return Collections.emptyList();
        }
        ArrayList<Group> groups = new ArrayList<Group>(groupIds.length);
        User user = this._portal.getUser(portletRequest);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        for (long groupId : groupIds) {
            String groupURL;
            Layout layout;
            Group group = this._groupLocalService.fetchGroup(groupId);
            if (!this._groupLocalService.isLiveGroupActive(group) || (layout = this._layoutLocalService.fetchFirstLayout(group.getGroupId(), false, 0L)) == null && ((layout = this._layoutLocalService.fetchFirstLayout(group.getGroupId(), true, 0L)) == null || !LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (boolean)true, (String)"VIEW")) || Validator.isNull((String)(groupURL = this._groupURLProvider.getGroupURL(group, portletRequest)))) continue;
            groups.add(group);
        }
        return groups;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    private long _getLiveGroupId(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return 0L;
        }
        if (!group.isStagedRemotely() && group.isStagingGroup()) {
            return group.getLiveGroupId();
        }
        return groupId;
    }

    private String _getRecentGroupsValue(HttpServletRequest request) {
        return SessionClicks.get((HttpServletRequest)request, (String)_KEY_RECENT_GROUPS, null);
    }

    private void _setRecentGroupsValue(HttpServletRequest request, String value) {
        SessionClicks.put((HttpServletRequest)request, (String)_KEY_RECENT_GROUPS, (String)value);
    }
}

