/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.util;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={RecentGroupManager.class})
public class RecentGroupManager {
    private static final String _KEY_RECENT_GROUPS = "com.liferay.site.util_recentGroups";
    private GroupLocalService _groupLocalService;

    public void addRecentGroup(HttpServletRequest request, Group group) {
        this.addRecentGroup(request, group.getGroupId());
    }

    public void addRecentGroup(HttpServletRequest request, long groupId) {
        long liveGroupId = this._getLiveGroupId(groupId);
        if (liveGroupId <= 0L) {
            return;
        }
        String value = this._getRecentGroupsValue(request);
        List groupIds = ListUtil.fromArray((Object[])ArrayUtil.toLongArray((long[])StringUtil.split((String)value, (long)0L)));
        groupIds.remove(liveGroupId);
        groupIds.add(0, liveGroupId);
        this._setRecentGroupsValue(request, StringUtil.merge((Collection)groupIds));
    }

    public List<Group> getRecentGroups(HttpServletRequest request) {
        String value = this._getRecentGroupsValue(request);
        return this.getRecentGroups(value);
    }

    protected List<Group> getRecentGroups(String value) {
        long[] groupIds = StringUtil.split((String)value, (long)0L);
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            return Collections.emptyList();
        }
        ArrayList<Group> groups = new ArrayList<Group>(groupIds.length);
        for (long groupId : groupIds) {
            Group group = this._groupLocalService.fetchGroup(groupId);
            if (group == null || !group.isActive()) continue;
            groups.add(group);
        }
        return groups;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    private long _getLiveGroupId(long groupId) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return 0L;
        }
        if (!group.isStagedRemotely() && group.isStagingGroup()) {
            return group.getLiveGroupId();
        }
        return groupId;
    }

    private String _getRecentGroupsValue(HttpServletRequest request) {
        return SessionClicks.get((HttpServletRequest)request, (String)_KEY_RECENT_GROUPS, null);
    }

    private void _setRecentGroupsValue(HttpServletRequest request, String value) {
        SessionClicks.put((HttpServletRequest)request, (String)_KEY_RECENT_GROUPS, (String)value);
    }
}

