/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.util;

import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.PanelCategoryRegistry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GroupURLProvider.class})
public class GroupURLProvider {
    private PanelAppRegistry _panelAppRegistry;
    private PanelCategoryRegistry _panelCategoryRegistry;

    public String getGroupAdministrationURL(Group group, PortletRequest portletRequest) {
        PortletURL groupAdministrationURL;
        PanelCategoryHelper panelCategoryHelper = new PanelCategoryHelper(this._panelAppRegistry, this._panelCategoryRegistry);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String portletId = panelCategoryHelper.getFirstPortletId("site_administration", themeDisplay.getPermissionChecker(), group);
        if (Validator.isNotNull((String)portletId) && (groupAdministrationURL = PortalUtil.getControlPanelPortletURL((PortletRequest)portletRequest, (Group)group, (String)portletId, (long)0L, (long)0L, (String)"RENDER_PHASE")) != null) {
            return groupAdministrationURL.toString();
        }
        return null;
    }

    public String getGroupLayoutsURL(Group group, boolean privateLayout, PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String groupDisplayURL = group.getDisplayURL(themeDisplay, privateLayout);
        if (Validator.isNotNull((String)groupDisplayURL)) {
            return groupDisplayURL;
        }
        return null;
    }

    public String getGroupURL(Group group, PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String groupDisplayURL = group.getDisplayURL(themeDisplay, false);
        if (Validator.isNotNull((String)groupDisplayURL)) {
            return groupDisplayURL;
        }
        groupDisplayURL = group.getDisplayURL(themeDisplay, true);
        if (Validator.isNotNull((String)groupDisplayURL)) {
            return groupDisplayURL;
        }
        return this.getGroupAdministrationURL(group, portletRequest);
    }

    @Reference(unbind="-")
    protected void setPanelAppRegistry(PanelAppRegistry panelAppRegistry) {
        this._panelAppRegistry = panelAppRegistry;
    }

    @Reference(unbind="-")
    protected void setPanelCategoryRegistry(PanelCategoryRegistry panelCategoryRegistry) {
        this._panelCategoryRegistry = panelCategoryRegistry;
    }
}

