/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.display.context;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.util.PropsValues;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class GroupDisplayContextHelper {
    private Group _group;
    private Long _groupId;
    private UnicodeProperties _groupTypeSettingsUnicodeProperties;
    private final HttpServletRequest _httpServletRequest;
    private Group _liveGroup;
    private Long _liveGroupId;
    private Group _selGroup;
    private Group _stagingGroup;
    private Long _stagingGroupId;

    public GroupDisplayContextHelper(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
    }

    public List<BreadcrumbEntry> getBreadcrumbEntries() {
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        breadcrumbEntry.setTitle(LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"staging"));
        return Collections.singletonList(breadcrumbEntry);
    }

    public Group getGroup() {
        if (this._group != null) {
            return this._group;
        }
        if (!PropsValues.STAGING_LIVE_GROUP_LOCKING_ENABLED && this.getSelGroup() != null) {
            this._group = this.getSelGroup();
            return this._group;
        }
        this._group = this.getStagingGroup() != null ? this.getStagingGroup() : this.getLiveGroup();
        if (this._group == null) {
            this._group = this.getSelGroup();
        }
        return this._group;
    }

    public Long getGroupId() {
        if (this._groupId != null) {
            return this._groupId;
        }
        Group group = this.getGroup();
        if (group != null) {
            this._groupId = group.getGroupId();
        }
        return this._groupId;
    }

    public UnicodeProperties getGroupTypeSettings() {
        if (this._groupTypeSettingsUnicodeProperties != null) {
            return this._groupTypeSettingsUnicodeProperties;
        }
        Group group = this.getGroup();
        this._groupTypeSettingsUnicodeProperties = group != null ? group.getTypeSettingsProperties() : new UnicodeProperties();
        return this._groupTypeSettingsUnicodeProperties;
    }

    public Group getLiveGroup() {
        if (this._liveGroup != null) {
            return this._liveGroup;
        }
        Group group = this.getSelGroup();
        if (group == null) {
            return null;
        }
        this._liveGroup = StagingUtil.getLiveGroup((long)group.getGroupId());
        if (this._liveGroup == null) {
            this._liveGroup = group;
        }
        return this._liveGroup;
    }

    public Long getLiveGroupId() {
        if (this._liveGroupId != null) {
            return this._liveGroupId;
        }
        Group liveGroup = this.getLiveGroup();
        if (liveGroup != null) {
            this._liveGroupId = liveGroup.getGroupId();
        }
        return this._liveGroupId;
    }

    public Group getSelGroup() {
        if (this._selGroup != null) {
            return this._selGroup;
        }
        long groupId = ParamUtil.getLong((HttpServletRequest)this._httpServletRequest, (String)"groupId");
        this._selGroup = GroupLocalServiceUtil.fetchGroup((long)groupId);
        if (this._selGroup == null) {
            this._selGroup = (Group)this._httpServletRequest.getAttribute("GROUP");
        }
        if (this._selGroup == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._selGroup = themeDisplay.getScopeGroup();
        }
        return this._selGroup;
    }

    public Group getStagingGroup() {
        if (this._stagingGroup != null) {
            return this._stagingGroup;
        }
        Group group = this.getSelGroup();
        if (group == null) {
            return null;
        }
        this._stagingGroup = StagingUtil.getStagingGroup((long)group.getGroupId());
        return this._stagingGroup;
    }

    public Long getStagingGroupId() {
        if (this._stagingGroupId != null) {
            return this._stagingGroupId;
        }
        Group stagingGroup = this.getStagingGroup();
        if (stagingGroup != null) {
            this._stagingGroupId = stagingGroup.getGroupId();
        }
        return this._stagingGroupId;
    }
}

