/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.site.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.GroupService;
import com.liferay.portal.kernel.service.permission.GroupPermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.usersadmin.search.GroupSearch;
import com.liferay.portlet.usersadmin.search.GroupSearchTerms;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={GroupSearchProvider.class})
public class GroupSearchProvider {
    private long[] _classNameIds;
    private GroupLocalService _groupLocalService;
    @Reference
    private GroupPermission _groupPermission;
    private GroupService _groupService;

    public GroupSearch getGroupSearch(PortletRequest portletRequest, PortletURL portletURL) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        GroupSearch groupSearch = new GroupSearch(portletRequest, portletURL);
        GroupSearchTerms searchTerms = (GroupSearchTerms)groupSearch.getSearchTerms();
        long parentGroupId = this.getParentGroupId(portletRequest);
        Company company = themeDisplay.getCompany();
        if (!searchTerms.hasSearchTerms() && this.isFilterManageableGroups(portletRequest) && parentGroupId <= 0L) {
            List groups = ListUtil.sort(this.getAllGroups(portletRequest), (Comparator)groupSearch.getOrderByComparator());
            groupSearch.setResultsAndTotal(() -> ListUtil.subList((List)groups, (int)groupSearch.getStart(), (int)groupSearch.getEnd()), groups.size());
        } else if (searchTerms.hasSearchTerms()) {
            groupSearch.setResultsAndTotal(() -> this._groupLocalService.search(company.getCompanyId(), this._classNameIds, searchTerms.getKeywords(), this.getGroupParams(portletRequest, searchTerms, parentGroupId), groupSearch.getStart(), groupSearch.getEnd(), groupSearch.getOrderByComparator()), this._groupLocalService.searchCount(company.getCompanyId(), this._classNameIds, searchTerms.getKeywords(), this.getGroupParams(portletRequest, searchTerms, parentGroupId)));
        } else {
            long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId", (long)0L);
            groupSearch.setResultsAndTotal(() -> this._groupLocalService.search(company.getCompanyId(), this._classNameIds, groupId, searchTerms.getKeywords(), this.getGroupParams(portletRequest, searchTerms, parentGroupId), groupSearch.getStart(), groupSearch.getEnd(), groupSearch.getOrderByComparator()), this._groupLocalService.searchCount(company.getCompanyId(), this._classNameIds, groupId, searchTerms.getKeywords(), this.getGroupParams(portletRequest, searchTerms, parentGroupId)));
        }
        return groupSearch;
    }

    protected List<Group> getAllGroups(PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        User user = themeDisplay.getUser();
        List groups = user.getMySiteGroups(new String[]{Company.class.getName(), Group.class.getName(), Organization.class.getName()}, -1);
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId", (long)0L);
        if (groupId != 0L) {
            groups.clear();
            groups.add(this._groupLocalService.getGroup(groupId));
        }
        return groups;
    }

    protected LinkedHashMap<String, Object> getGroupParams(PortletRequest portletRequest, GroupSearchTerms searchTerms, long parentGroupId) throws PortalException {
        LinkedHashMap groupParams = LinkedHashMapBuilder.put((Object)"actionId", (Object)"VIEW").put((Object)"site", (Object)Boolean.TRUE).build();
        if (searchTerms.hasSearchTerms()) {
            if (this.isFilterManageableGroups(portletRequest)) {
                groupParams.put("groupsTree", this.getAllGroups(portletRequest));
            } else if (parentGroupId > 0L) {
                List groupsTree = ListUtil.fromArray((Object[])new Group[]{this._groupLocalService.getGroup(parentGroupId)});
                groupParams.put("groupsTree", groupsTree);
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            if (!permissionChecker.isCompanyAdmin() && !this._groupPermission.contains(permissionChecker, "VIEW")) {
                User user = themeDisplay.getUser();
                groupParams.put("usersGroups", user.getUserId());
            }
        }
        return groupParams;
    }

    protected long getParentGroupId(PortletRequest portletRequest) {
        Group group = null;
        long groupId = ParamUtil.getLong((PortletRequest)portletRequest, (String)"groupId", (long)0L);
        if (groupId > 0L) {
            group = this._groupLocalService.fetchGroup(groupId);
        }
        if (group != null) {
            return group.getGroupId();
        }
        if (this.isFilterManageableGroups(portletRequest)) {
            return -1L;
        }
        return 0L;
    }

    protected boolean isFilterManageableGroups(PortletRequest portletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        return !permissionChecker.isCompanyAdmin() && !this._groupPermission.contains(permissionChecker, "VIEW");
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Deprecated
    @Reference(unbind="-")
    protected void setGroupService(GroupService groupService) {
        this._groupService = groupService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
        this._classNameIds = new long[]{PortalUtil.getClassNameId(Company.class), PortalUtil.getClassNameId(Group.class), PortalUtil.getClassNameId(Organization.class)};
    }
}

