/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.document.library.internal.frontend.taglib.dynamic.section;

import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.frontend.taglib.dynamic.section.DynamicSection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.sharing.configuration.SharingConfiguration;
import com.liferay.sharing.configuration.SharingConfigurationFactory;
import com.liferay.sharing.model.SharingEntryModel;
import com.liferay.sharing.security.permission.SharingPermission;
import com.liferay.sharing.service.SharingEntryLocalService;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"name=com.liferay.document.library.web#/document_library/info_panel_file_entry.jsp#fileEntryOwner"}, service={DynamicSection.class})
public class DLInfoPanelFileEntryOwnerDynamicSection
implements DynamicSection {
    private static final Log _log = LogFactoryUtil.getLog(DLInfoPanelFileEntryOwnerDynamicSection.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference(target="(osgi.web.symbolicname=com.liferay.sharing.document.library)")
    private ServletContext _servletContext;
    @Reference
    private SharingConfigurationFactory _sharingConfigurationFactory;
    @Reference
    private SharingEntryLocalService _sharingEntryLocalService;
    @Reference
    private SharingPermission _sharingPermission;
    @Reference
    private UserLocalService _userLocalService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StringBundler modify(StringBundler sb, PageContext pageContext) {
        FileEntry fileEntry;
        HttpServletRequest httpServletRequest = (HttpServletRequest)pageContext.getRequest();
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        SharingConfiguration sharingConfiguration = this._sharingConfigurationFactory.getGroupSharingConfiguration(themeDisplay.getSiteGroup());
        if (!sharingConfiguration.isEnabled()) {
            return sb;
        }
        long classNameId = this._classNameLocalService.getClassNameId(DLFileEntryConstants.getClassName());
        int sharingEntriesCount = this._sharingEntryLocalService.getSharingEntriesCount(classNameId, (fileEntry = (FileEntry)httpServletRequest.getAttribute("info_panel.jsp-fileEntry")).getFileEntryId());
        if (sharingEntriesCount == 0) {
            return sb;
        }
        httpServletRequest.setAttribute("info_panel_file_entry.jsp-sharingEntriesCount", (Object)sharingEntriesCount);
        List sharingEntries = this._sharingEntryLocalService.getSharingEntries(classNameId, fileEntry.getFileEntryId(), 0, 4);
        Stream stream = sharingEntries.stream();
        List sharingEntryToUsers = stream.map(SharingEntryModel::getToUserId).map(arg_0 -> ((UserLocalService)this._userLocalService).fetchUserById(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        httpServletRequest.setAttribute("info_panel_file_entry.jsp-sharingEntryToUsers", sharingEntryToUsers);
        boolean showManageCollaborators = false;
        try {
            showManageCollaborators = this._sharingPermission.containsManageCollaboratorsPermission(themeDisplay.getPermissionChecker(), classNameId, fileEntry.getFileEntryId(), themeDisplay.getScopeGroupId());
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        httpServletRequest.setAttribute("info_panel_file_entry.jsp-showManageCollaborators", (Object)showManageCollaborators);
        RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher("/META-INF/resources/dynamic_section/info_panel_file_entry.jsp");
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            PipingServletResponse httpServletResponse = new PipingServletResponse((HttpServletResponse)pageContext.getResponse(), (OutputStream)outputStream);
            requestDispatcher.include(pageContext.getRequest(), (ServletResponse)httpServletResponse);
            StringBundler stringBundler = new StringBundler(new String(outputStream.toByteArray()));
            return stringBundler;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

