/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.document.library.internal.display.context;

import com.liferay.document.library.display.context.BaseDLViewFileVersionDisplayContext;
import com.liferay.document.library.display.context.DLUIItemKeys;
import com.liferay.document.library.display.context.DLViewFileVersionDisplayContext;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.taglib.ui.BaseUIItem;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.servlet.taglib.ui.ToolbarItem;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.SettingsLocator;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.sharing.configuration.SharingConfiguration;
import com.liferay.sharing.display.context.util.SharingMenuItemFactory;
import com.liferay.sharing.display.context.util.SharingToolbarItemFactory;
import com.liferay.sharing.document.library.internal.security.permission.SharingPermissionHelper;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SharingDLViewFileVersionDisplayContext
extends BaseDLViewFileVersionDisplayContext {
    private static final UUID _UUID = UUID.fromString("6d7d30de-01fa-49db-a422-d78748aa03a7");
    private final FileEntry _fileEntry;
    private final HttpServletRequest _httpServletRequest;
    private final SharingConfiguration _sharingConfiguration;
    private final SharingMenuItemFactory _sharingMenuItemFactory;
    private final SharingPermissionHelper _sharingPermissionHelper;
    private final SharingToolbarItemFactory _sharingToolbarItemFactory;
    private Boolean _showImageEditorAction;
    private final ThemeDisplay _themeDisplay;

    public SharingDLViewFileVersionDisplayContext(DLViewFileVersionDisplayContext parentDLDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileEntry fileEntry, FileVersion fileVersion, ResourceBundle resourceBundle, SharingMenuItemFactory sharingMenuItemFactory, SharingToolbarItemFactory sharingToolbarItemFactory, SharingPermissionHelper sharingPermissionHelper, SharingConfiguration sharingConfiguration) {
        super(_UUID, parentDLDisplayContext, httpServletRequest, httpServletResponse, fileVersion);
        this._httpServletRequest = httpServletRequest;
        this._fileEntry = fileEntry;
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._sharingMenuItemFactory = sharingMenuItemFactory;
        this._sharingToolbarItemFactory = sharingToolbarItemFactory;
        this._sharingPermissionHelper = sharingPermissionHelper;
        this._sharingConfiguration = sharingConfiguration;
    }

    public Menu getMenu() throws PortalException {
        Menu menu = super.getMenu();
        if (!this._isShowShareAction() || !this._sharingConfiguration.isEnabled()) {
            return menu;
        }
        this._addSharingUIItem(menu.getMenuItems(), this._sharingMenuItemFactory.createShareMenuItem(DLFileEntryConstants.getClassName(), this._fileEntry.getFileEntryId(), this._httpServletRequest));
        return menu;
    }

    public List<ToolbarItem> getToolbarItems() throws PortalException {
        List toolbarItems = super.getToolbarItems();
        if (!this._isShowShareAction() || !this._sharingConfiguration.isEnabled()) {
            return toolbarItems;
        }
        this._addSharingUIItem(toolbarItems, this._sharingToolbarItemFactory.createShareToolbarItem(DLFileEntryConstants.getClassName(), this._fileEntry.getFileEntryId(), this._httpServletRequest));
        return toolbarItems;
    }

    public boolean isSharingLinkVisible() {
        return this._sharingConfiguration.isEnabled() && this._sharingPermissionHelper.isShareable(this._themeDisplay.getPermissionChecker(), this._fileEntry.getFileEntryId());
    }

    private <T extends BaseUIItem> List<T> _addSharingUIItem(List<T> uiItems, T sharingUIItem) {
        BaseUIItem uiItem;
        int i = 1;
        Iterator<T> iterator = uiItems.iterator();
        while (iterator.hasNext() && !DLUIItemKeys.DOWNLOAD.equals((uiItem = (BaseUIItem)iterator.next()).getKey())) {
            ++i;
        }
        if (i >= uiItems.size()) {
            uiItems.add(sharingUIItem);
        } else {
            uiItems.add(i, sharingUIItem);
        }
        return uiItems;
    }

    private boolean _isShowActions() throws PortalException {
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        String portletName = portletDisplay.getPortletName();
        if (portletName.equals("com_liferay_document_library_web_portlet_DLAdminPortlet")) {
            return true;
        }
        Settings settings = SettingsFactoryUtil.getSettings((SettingsLocator)new PortletInstanceSettingsLocator(this._themeDisplay.getLayout(), portletDisplay.getId()));
        TypedSettings typedSettings = new TypedSettings(settings);
        return typedSettings.getBooleanValue("showActions");
    }

    private boolean _isShowShareAction() throws PortalException {
        if (this._showImageEditorAction != null) {
            return this._showImageEditorAction;
        }
        this._showImageEditorAction = false;
        if (this._themeDisplay.isSignedIn() && this._isShowActions() && this._sharingPermissionHelper.isShareable(this._themeDisplay.getPermissionChecker(), this._fileEntry.getFileEntryId())) {
            this._showImageEditorAction = true;
        }
        return this._showImageEditorAction;
    }
}

