/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.segments.util;

import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.segments.constants.SegmentsExperienceConstants;

/**
 * @author     Pavel Savinov
 * @deprecated As of Athanasius (7.3.x), with no direct replacement
 */
@Deprecated
public class SegmentsExperiencePortletUtil {

	public static String decodePortletName(String portletId) {
		int index = portletId.indexOf(_SEGMENTS_EXPERIENCE_SEPARATOR);

		if (index == -1) {
			return PortletIdCodec.decodePortletName(portletId);
		}

		return PortletIdCodec.decodePortletName(portletId.substring(0, index));
	}

	public static long getSegmentsExperienceId(String portletId) {
		int index = portletId.indexOf(_SEGMENTS_EXPERIENCE_SEPARATOR);

		if (index == -1) {
			return 0L;
		}

		return GetterUtil.getLong(
			portletId.substring(
				index + _SEGMENTS_EXPERIENCE_SEPARATOR.length()),
			SegmentsExperienceConstants.ID_DEFAULT);
	}

	public static String setSegmentsExperienceId(
		String instanceId, long segmentsExperienceId) {

		if (segmentsExperienceId == SegmentsExperienceConstants.ID_DEFAULT) {
			return instanceId;
		}

		int index = instanceId.indexOf(_SEGMENTS_EXPERIENCE_SEPARATOR);

		if (index == -1) {
			return instanceId + _SEGMENTS_EXPERIENCE_SEPARATOR +
				segmentsExperienceId;
		}

		return instanceId.substring(0, index) + _SEGMENTS_EXPERIENCE_SEPARATOR +
			segmentsExperienceId;
	}

	private static final String _SEGMENTS_EXPERIENCE_SEPARATOR =
		"_SEGMENTS_EXPERIENCE_";

}