/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.segments.context.contributor;

import com.liferay.segments.context.Context;

import javax.servlet.http.HttpServletRequest;

/**
 * Provides an interface for extending the {@link Context} with information from
 * the request.
 *
 * @author Eduardo García
 */
public interface RequestContextContributor {

	/**
	 * Contributes additional information to the context.
	 *
	 * @param context the context that segments users
	 * @param httpServletRequest the current request
	 */
	public void contribute(
		Context context, HttpServletRequest httpServletRequest);

}