/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.segments.processor;

import com.liferay.portal.kernel.exception.PortalException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Provides methods for processing {@link
 * com.liferay.segments.model.SegmentsExperiment SegmentsExperiment}s.
 *
 * @author Eduardo García
 * @review
 */
@ProviderType
public interface SegmentsExperienceRequestProcessor {

	/**
	 * Returns the processed IDs of segments experiences that will be actually
	 * applied in the current request.
	 *
	 * @param  httpServletRequest the servlet request
	 * @param  httpServletResponse the servlet response
	 * @param  groupId the primary key of the group
	 * @param  classNameId the entity's class name ID
	 * @param  classPK the primary key of the entity
	 * @param  segmentsExperienceIds the primary keys of the user's active
	 *         segment experiences
	 * @return the processed IDs of segments experiences that will be actually
	 *         applied in the current request
	 * @throws PortalException if a portal exception occurred
	 */
	public long[] getSegmentsExperienceIds(
			HttpServletRequest httpServletRequest,
			HttpServletResponse httpServletResponse, long groupId,
			long classNameId, long classPK, long[] segmentsExperienceIds)
		throws PortalException;

	/**
	 * Returns the processed IDs of segments experiences that will be actually
	 * applied in the current request.
	 *
	 * @param  httpServletRequest the servlet request
	 * @param  httpServletResponse the servlet response
	 * @param  groupId the primary key of the group
	 * @param  classNameId the entity's class name ID
	 * @param  classPK the primary key of the entity
	 * @param  segmentsEntryIds the primary keys of the user's active segment
	 *         entries
	 * @param  segmentsExperienceIds the primary keys of the user's active
	 *         segment experiences
	 * @return the processed IDs of segments experiences that will be actually
	 *         applied in the current request
	 * @throws PortalException if a portal exception occurred
	 */
	public long[] getSegmentsExperienceIds(
			HttpServletRequest httpServletRequest,
			HttpServletResponse httpServletResponse, long groupId,
			long classNameId, long classPK, long[] segmentsEntryIds,
			long[] segmentsExperienceIds)
		throws PortalException;

}