/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.segments.field.customizer;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.util.CamelCaseUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.segments.field.Field;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.portlet.PortletRequest;

/**
 * Provides an interface for customizing a {@link Field}.
 *
 * @author Eduardo García
 */
public interface SegmentsFieldCustomizer {

	public default ClassedModel getClassedModel(String fieldValue) {
		return null;
	}

	public default String getClassName() {
		return null;
	}

	public List<String> getFieldNames();

	public default String getFieldValueName(String fieldValue, Locale locale) {
		return fieldValue;
	}

	public String getKey();

	public default String getLabel(String fieldName, Locale locale) {
		ResourceBundle resourceBundle = ResourceBundleUtil.getBundle(
			"content.Language", locale, getClass());

		return LanguageUtil.get(
			resourceBundle, "field." + CamelCaseUtil.fromCamelCase(fieldName));
	}

	public default List<Field.Option> getOptions(Locale locale) {
		return Collections.emptyList();
	}

	public default Field.SelectEntity getSelectEntity(
		PortletRequest portletRequest) {

		return null;
	}

}