/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.segments.exception;

import com.liferay.portal.kernel.exception.PortalException;

/**
 * @author Eduardo García
 */
public class RequiredSegmentsEntryException extends PortalException {

	public RequiredSegmentsEntryException() {
	}

	public RequiredSegmentsEntryException(String msg) {
		super(msg);
	}

	public RequiredSegmentsEntryException(String msg, Throwable throwable) {
		super(msg, throwable);
	}

	public RequiredSegmentsEntryException(Throwable throwable) {
		super(throwable);
	}

	public static class
		MustNotDeleteSegmentsEntryReferencedBySegmentsExperiences
			extends RequiredSegmentsEntryException {

		public MustNotDeleteSegmentsEntryReferencedBySegmentsExperiences(
			long segmentsEntryId) {

			super(
				String.format(
					"Segments entry %s cannot be deleted because it is " +
						"referenced by one or more segments experiences",
					segmentsEntryId));
		}

	}

}