/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.segments.criteria.contributor;

import com.liferay.segments.criteria.Criteria;

import java.util.List;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Provides methods for retrieving segment criteria contributors defined by
 * {@link SegmentsCriteriaContributor} implementations.
 *
 * @author Eduardo García
 */
@ProviderType
public interface SegmentsCriteriaContributorRegistry {

	public List<SegmentsCriteriaContributor> getSegmentsCriteriaContributors(
		String className);

	public List<SegmentsCriteriaContributor> getSegmentsCriteriaContributors(
		String className, Criteria.Type type);

}