/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.segments.model;

import com.liferay.portal.kernel.annotation.ImplementationClassName;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.util.Accessor;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The extended model interface for the SegmentsEntryRole service. Represents a row in the &quot;SegmentsEntryRole&quot; database table, with each column mapped to a property of this class.
 *
 * @author Eduardo Garcia
 * @see SegmentsEntryRoleModel
 * @generated
 */
@ImplementationClassName(
	"com.liferay.segments.model.impl.SegmentsEntryRoleImpl"
)
@ProviderType
public interface SegmentsEntryRole
	extends PersistedModel, SegmentsEntryRoleModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this interface directly. Add methods to <code>com.liferay.segments.model.impl.SegmentsEntryRoleImpl</code> and rerun ServiceBuilder to automatically copy the method declarations to this interface.
	 */
	public static final Accessor<SegmentsEntryRole, Long>
		SEGMENTS_ENTRY_ROLE_ID_ACCESSOR =
			new Accessor<SegmentsEntryRole, Long>() {

				@Override
				public Long get(SegmentsEntryRole segmentsEntryRole) {
					return segmentsEntryRole.getSegmentsEntryRoleId();
				}

				@Override
				public Class<Long> getAttributeClass() {
					return Long.class;
				}

				@Override
				public Class<SegmentsEntryRole> getTypeClass() {
					return SegmentsEntryRole.class;
				}

			};

}