/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.manager;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.LayoutPermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import jakarta.servlet.http.HttpServletRequest;

public class SegmentsExperienceManager {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsExperienceManager.class);
    private final LayoutPermission _layoutPermission;
    private final SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public SegmentsExperienceManager(LayoutPermission layoutPermission, SegmentsExperienceLocalService segmentsExperienceLocalService) {
        this._layoutPermission = layoutPermission;
        this._segmentsExperienceLocalService = segmentsExperienceLocalService;
    }

    public SegmentsExperienceManager(SegmentsExperienceLocalService segmentsExperienceLocalService) {
        this._segmentsExperienceLocalService = segmentsExperienceLocalService;
        this._layoutPermission = null;
    }

    public long getSegmentsExperienceId(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid"));
        }
        long segmentsExperienceId = ParamUtil.getLong((HttpServletRequest)PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest), (String)"segmentsExperienceId", (long)-1L);
        try {
            PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
            if (segmentsExperienceId != -1L && (permissionChecker.isGroupAdmin(themeDisplay.getScopeGroupId()) || this._layoutPermission != null && this._layoutPermission.containsLayoutUpdatePermission(permissionChecker, themeDisplay.getLayout()))) {
                return segmentsExperienceId;
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        long[] segmentsExperienceIds = GetterUtil.getLongValues((Object)httpServletRequest.getAttribute("SEGMENTS_EXPERIENCE_IDS"));
        if (ArrayUtil.isNotEmpty((long[])segmentsExperienceIds)) {
            return segmentsExperienceIds[0];
        }
        return this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(themeDisplay.getPlid());
    }
}

