/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.manager;

import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import javax.servlet.http.HttpServletRequest;

public class SegmentsExperienceManager {
    private final SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public SegmentsExperienceManager(SegmentsExperienceLocalService segmentsExperienceLocalService) {
        this._segmentsExperienceLocalService = segmentsExperienceLocalService;
    }

    public long getSegmentsExperienceId(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"plid"));
        }
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        long segmentsExperienceId = ParamUtil.getLong((HttpServletRequest)PortalUtil.getOriginalServletRequest((HttpServletRequest)httpServletRequest), (String)"segmentsExperienceId", (long)-1L);
        if (segmentsExperienceId != -1L && permissionChecker.isGroupAdmin(themeDisplay.getScopeGroupId())) {
            return segmentsExperienceId;
        }
        long[] segmentsExperienceIds = GetterUtil.getLongValues((Object)httpServletRequest.getAttribute("SEGMENTS_EXPERIENCE_IDS"));
        if (ArrayUtil.isNotEmpty((long[])segmentsExperienceIds)) {
            return segmentsExperienceIds[0];
        }
        return this._segmentsExperienceLocalService.fetchDefaultSegmentsExperienceId(themeDisplay.getPlid());
    }
}

