/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.segments.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the SegmentsExperimentRel service. Represents a row in the &quot;SegmentsExperimentRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.segments.model.impl.SegmentsExperimentRelModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.segments.model.impl.SegmentsExperimentRelImpl</code>.
 * </p>
 *
 * @author Eduardo Garcia
 * @see SegmentsExperimentRel
 * @generated
 */
@ProviderType
public interface SegmentsExperimentRelModel
	extends BaseModel<SegmentsExperimentRel>, CTModel<SegmentsExperimentRel>,
			GroupedModel, MVCCModel, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a segments experiment rel model instance should use the {@link SegmentsExperimentRel} interface instead.
	 */

	/**
	 * Returns the primary key of this segments experiment rel.
	 *
	 * @return the primary key of this segments experiment rel
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this segments experiment rel.
	 *
	 * @param primaryKey the primary key of this segments experiment rel
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this segments experiment rel.
	 *
	 * @return the mvcc version of this segments experiment rel
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this segments experiment rel.
	 *
	 * @param mvccVersion the mvcc version of this segments experiment rel
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this segments experiment rel.
	 *
	 * @return the ct collection ID of this segments experiment rel
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this segments experiment rel.
	 *
	 * @param ctCollectionId the ct collection ID of this segments experiment rel
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the segments experiment rel ID of this segments experiment rel.
	 *
	 * @return the segments experiment rel ID of this segments experiment rel
	 */
	public long getSegmentsExperimentRelId();

	/**
	 * Sets the segments experiment rel ID of this segments experiment rel.
	 *
	 * @param segmentsExperimentRelId the segments experiment rel ID of this segments experiment rel
	 */
	public void setSegmentsExperimentRelId(long segmentsExperimentRelId);

	/**
	 * Returns the group ID of this segments experiment rel.
	 *
	 * @return the group ID of this segments experiment rel
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this segments experiment rel.
	 *
	 * @param groupId the group ID of this segments experiment rel
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this segments experiment rel.
	 *
	 * @return the company ID of this segments experiment rel
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this segments experiment rel.
	 *
	 * @param companyId the company ID of this segments experiment rel
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this segments experiment rel.
	 *
	 * @return the user ID of this segments experiment rel
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this segments experiment rel.
	 *
	 * @param userId the user ID of this segments experiment rel
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this segments experiment rel.
	 *
	 * @return the user uuid of this segments experiment rel
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this segments experiment rel.
	 *
	 * @param userUuid the user uuid of this segments experiment rel
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this segments experiment rel.
	 *
	 * @return the user name of this segments experiment rel
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this segments experiment rel.
	 *
	 * @param userName the user name of this segments experiment rel
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this segments experiment rel.
	 *
	 * @return the create date of this segments experiment rel
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this segments experiment rel.
	 *
	 * @param createDate the create date of this segments experiment rel
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this segments experiment rel.
	 *
	 * @return the modified date of this segments experiment rel
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this segments experiment rel.
	 *
	 * @param modifiedDate the modified date of this segments experiment rel
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the segments experiment ID of this segments experiment rel.
	 *
	 * @return the segments experiment ID of this segments experiment rel
	 */
	public long getSegmentsExperimentId();

	/**
	 * Sets the segments experiment ID of this segments experiment rel.
	 *
	 * @param segmentsExperimentId the segments experiment ID of this segments experiment rel
	 */
	public void setSegmentsExperimentId(long segmentsExperimentId);

	/**
	 * Returns the segments experience ID of this segments experiment rel.
	 *
	 * @return the segments experience ID of this segments experiment rel
	 */
	public long getSegmentsExperienceId();

	/**
	 * Sets the segments experience ID of this segments experiment rel.
	 *
	 * @param segmentsExperienceId the segments experience ID of this segments experiment rel
	 */
	public void setSegmentsExperienceId(long segmentsExperienceId);

	/**
	 * Returns the split of this segments experiment rel.
	 *
	 * @return the split of this segments experiment rel
	 */
	public double getSplit();

	/**
	 * Sets the split of this segments experiment rel.
	 *
	 * @param split the split of this segments experiment rel
	 */
	public void setSplit(double split);

}