/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.field;

import com.liferay.portal.kernel.util.CollatorUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import java.io.Serializable;
import java.text.Collator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class Field
implements Comparable<Field>,
Serializable {
    private Collator _collator;
    private String _icon;
    private String _label;
    private String _name;
    private List<Option> _options;
    private SelectEntity _selectEntity;
    private String _type;

    public Field() {
    }

    public Field(String name, String label, String type) {
        this(name, label, type, Collections.emptyList(), null);
    }

    public Field(String name, String label, String type, List<Option> options, SelectEntity selectEntity) {
        this(null, name, label, type, options, selectEntity);
    }

    public Field(String icon, String name, String label, String type, List<Option> options, SelectEntity selectEntity) {
        this._icon = icon;
        this._name = name;
        this._label = label;
        this._type = type;
        this._options = options;
        this._selectEntity = selectEntity;
        this._collator = CollatorUtil.getInstance((Locale)LocaleThreadLocal.getThemeDisplayLocale());
    }

    @Override
    public int compareTo(Field field) {
        return this._collator.compare(this._label, field._label);
    }

    public String getIcon() {
        return this._icon;
    }

    public String getLabel() {
        return this._label;
    }

    public String getName() {
        return this._name;
    }

    public List<Option> getOptions() {
        return this._options;
    }

    public SelectEntity getSelectEntity() {
        return this._selectEntity;
    }

    public String getType() {
        return this._type;
    }

    public static final class SelectEntity
    implements Serializable {
        private String _id;
        private boolean _multiple;
        private String _title;
        private String _uri;

        public SelectEntity() {
        }

        public SelectEntity(String id, String title, String uri, boolean multiple) {
            this._id = id;
            this._title = title;
            this._uri = uri;
            this._multiple = multiple;
        }

        public String getId() {
            return this._id;
        }

        public String getTitle() {
            return this._title;
        }

        public String getUri() {
            return this._uri;
        }

        public boolean isMultiple() {
            return this._multiple;
        }
    }

    public static final class Option
    implements Serializable {
        private String _label;
        private String _value;

        public Option() {
        }

        public Option(String label, String value) {
            this._label = label;
            this._value = value;
        }

        public String getLabel() {
            return this._label;
        }

        public String getValue() {
            return this._value;
        }
    }
}

