/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.constants;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.exception.SegmentsExperimentStatusException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class SegmentsExperimentConstants {
    public static final int NOTIFICATION_TYPE_UPDATE_STATUS = 0;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_DRAFT = 0;
    public static final int STATUS_FINISHED_NO_WINNER = 4;
    public static final int STATUS_FINISHED_WINNER = 3;
    public static final int STATUS_PAUSED = 5;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_SCHEDULED = 7;
    public static final int STATUS_TERMINATED = 6;

    public static enum Status {
        COMPLETED(2, "COMPLETED", "completed", true, false, true, false),
        DRAFT(0, "DRAFT", "draft", true){

            @Override
            public Set<Status> validTransitions() {
                return SetUtil.fromCollection(Arrays.asList(RUNNING, SCHEDULED));
            }
        }
        ,
        FINISHED_NO_WINNER(4, "FINISHED_NO_WINNER", "no-winner", false, true, false, true){

            @Override
            public Set<Status> validTransitions() {
                return Collections.singleton(COMPLETED);
            }
        }
        ,
        FINISHED_WINNER_DECLARED(3, "FINISHED_WINNER", "winner", false, true, true, true){

            @Override
            public Set<Status> validTransitions() {
                return Collections.singleton(COMPLETED);
            }
        }
        ,
        PAUSED(5, "PAUSED", "paused", false){

            @Override
            public Set<Status> validTransitions() {
                return Collections.singleton(RUNNING);
            }
        }
        ,
        RUNNING(1, "RUNNING", "running", false, true, false, true){

            @Override
            public Set<Status> validTransitions() {
                return SetUtil.fromCollection(Arrays.asList(FINISHED_NO_WINNER, FINISHED_WINNER_DECLARED, PAUSED, TERMINATED));
            }
        }
        ,
        SCHEDULED(7, "SCHEDULED", "scheduled", false){

            @Override
            public Set<Status> validTransitions() {
                return Collections.singleton(RUNNING);
            }
        }
        ,
        TERMINATED(6, "TERMINATED", "terminated", true, false, false, false);

        private final boolean _editable;
        private final boolean _exclusive;
        private final String _label;
        private final boolean _requiresWinnerExperience;
        private final boolean _split;
        private final String _stringValue;
        private final int _value;

        public static int[] getExclusiveStatusValues() {
            return ArrayUtil.toIntArray((Collection)TransformUtil.transformToList((Object[])Status.values(), status -> {
                if (status.isExclusive()) {
                    return status.getValue();
                }
                return null;
            }));
        }

        public static int[] getLockedStatusValues() {
            return ArrayUtil.toIntArray((Collection)TransformUtil.transformToList((Object[])Status.values(), status -> {
                if (!status.isEditable()) {
                    return status.getValue();
                }
                return null;
            }));
        }

        public static int[] getNonexclusiveStatusValues() {
            return ArrayUtil.toIntArray((Collection)TransformUtil.transformToList((Object[])Status.values(), status -> {
                if (!status.isExclusive()) {
                    return status.getValue();
                }
                return null;
            }));
        }

        public static int[] getSplitStatusValues() {
            return ArrayUtil.toIntArray((Collection)TransformUtil.transformToList((Object[])Status.values(), status -> {
                if (status.isSplit()) {
                    return status.getValue();
                }
                return null;
            }));
        }

        public static Status parse(int value) {
            for (Status status : Status.values()) {
                if (status.getValue() != value) continue;
                return status;
            }
            return null;
        }

        public static Status parse(String stringValue) {
            if (Validator.isNull((String)stringValue)) {
                return null;
            }
            for (Status status : Status.values()) {
                if (!stringValue.equals(status.toString())) continue;
                return status;
            }
            return null;
        }

        public static void validateTransition(int fromStatusValue, int toStatusValue) throws SegmentsExperimentStatusException {
            Status fromStatus = Status.parse(fromStatusValue);
            if (fromStatus == null) {
                throw new SegmentsExperimentStatusException("Invalid initial status value " + fromStatusValue);
            }
            Status toStatus = Status.parse(toStatusValue);
            if (toStatus == null) {
                throw new SegmentsExperimentStatusException("Invalid final status value " + toStatusValue);
            }
            if (Objects.equals((Object)fromStatus, (Object)toStatus)) {
                return;
            }
            Set<Status> validTransitions = fromStatus.validTransitions();
            if (!validTransitions.contains((Object)toStatus)) {
                throw new SegmentsExperimentStatusException(String.format("Invalid status transition: from %s to %s", fromStatus.name(), toStatus.name()));
            }
        }

        public static Status valueOf(int value) {
            for (Status status : Status.values()) {
                if (status.getValue() != value) continue;
                return status;
            }
            throw new IllegalArgumentException("Invalid status value " + value);
        }

        public String getLabel() {
            return this._label;
        }

        public int getValue() {
            return this._value;
        }

        public boolean isEditable() {
            return this._editable;
        }

        public boolean isExclusive() {
            return this._exclusive;
        }

        public boolean isSplit() {
            return this._split;
        }

        public boolean requiresWinnerExperience() {
            return this._requiresWinnerExperience;
        }

        public String toString() {
            return this._stringValue;
        }

        public Set<Status> validTransitions() {
            return Collections.emptySet();
        }

        private Status(int value, String stringValue, String label, boolean editable) {
            this._value = value;
            this._stringValue = stringValue;
            this._label = label;
            this._editable = editable;
            this._exclusive = true;
            this._requiresWinnerExperience = false;
            this._split = false;
        }

        private Status(int value, String stringValue, String label, boolean editable, boolean exclusive, boolean requiresWinnerExperience, boolean split) {
            this._value = value;
            this._stringValue = stringValue;
            this._label = label;
            this._editable = editable;
            this._exclusive = exclusive;
            this._requiresWinnerExperience = requiresWinnerExperience;
            this._split = split;
        }
    }

    public static enum Goal {
        BOUNCE_RATE("bounce-rate"),
        CLICK_RATE("click"),
        MAX_SCROLL_DEPTH("max-scroll-depth"),
        TIME_ON_PAGE("time-on-page");

        private final String _label;

        public static Goal parse(String label) {
            if (Validator.isNull((String)label)) {
                return null;
            }
            for (Goal goal : Goal.values()) {
                if (!label.equals(goal.getLabel())) continue;
                return goal;
            }
            return null;
        }

        public String getLabel() {
            return this._label;
        }

        private Goal(String label) {
            this._label = label;
        }
    }
}

