/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.segments.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AttachedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.MVCCModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.model.StagedAuditedModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the SegmentsExperiment service. Represents a row in the &quot;SegmentsExperiment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.segments.model.impl.SegmentsExperimentModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.segments.model.impl.SegmentsExperimentImpl</code>.
 * </p>
 *
 * @author Eduardo Garcia
 * @see SegmentsExperiment
 * @generated
 */
@ProviderType
public interface SegmentsExperimentModel
	extends AttachedModel, BaseModel<SegmentsExperiment>,
			CTModel<SegmentsExperiment>, GroupedModel, MVCCModel, ShardedModel,
			StagedAuditedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a segments experiment model instance should use the {@link SegmentsExperiment} interface instead.
	 */

	/**
	 * Returns the primary key of this segments experiment.
	 *
	 * @return the primary key of this segments experiment
	 */
	@Override
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this segments experiment.
	 *
	 * @param primaryKey the primary key of this segments experiment
	 */
	@Override
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the mvcc version of this segments experiment.
	 *
	 * @return the mvcc version of this segments experiment
	 */
	@Override
	public long getMvccVersion();

	/**
	 * Sets the mvcc version of this segments experiment.
	 *
	 * @param mvccVersion the mvcc version of this segments experiment
	 */
	@Override
	public void setMvccVersion(long mvccVersion);

	/**
	 * Returns the ct collection ID of this segments experiment.
	 *
	 * @return the ct collection ID of this segments experiment
	 */
	@Override
	public long getCtCollectionId();

	/**
	 * Sets the ct collection ID of this segments experiment.
	 *
	 * @param ctCollectionId the ct collection ID of this segments experiment
	 */
	@Override
	public void setCtCollectionId(long ctCollectionId);

	/**
	 * Returns the uuid of this segments experiment.
	 *
	 * @return the uuid of this segments experiment
	 */
	@AutoEscape
	@Override
	public String getUuid();

	/**
	 * Sets the uuid of this segments experiment.
	 *
	 * @param uuid the uuid of this segments experiment
	 */
	@Override
	public void setUuid(String uuid);

	/**
	 * Returns the segments experiment ID of this segments experiment.
	 *
	 * @return the segments experiment ID of this segments experiment
	 */
	public long getSegmentsExperimentId();

	/**
	 * Sets the segments experiment ID of this segments experiment.
	 *
	 * @param segmentsExperimentId the segments experiment ID of this segments experiment
	 */
	public void setSegmentsExperimentId(long segmentsExperimentId);

	/**
	 * Returns the group ID of this segments experiment.
	 *
	 * @return the group ID of this segments experiment
	 */
	@Override
	public long getGroupId();

	/**
	 * Sets the group ID of this segments experiment.
	 *
	 * @param groupId the group ID of this segments experiment
	 */
	@Override
	public void setGroupId(long groupId);

	/**
	 * Returns the company ID of this segments experiment.
	 *
	 * @return the company ID of this segments experiment
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this segments experiment.
	 *
	 * @param companyId the company ID of this segments experiment
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this segments experiment.
	 *
	 * @return the user ID of this segments experiment
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this segments experiment.
	 *
	 * @param userId the user ID of this segments experiment
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this segments experiment.
	 *
	 * @return the user uuid of this segments experiment
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this segments experiment.
	 *
	 * @param userUuid the user uuid of this segments experiment
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this segments experiment.
	 *
	 * @return the user name of this segments experiment
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this segments experiment.
	 *
	 * @param userName the user name of this segments experiment
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this segments experiment.
	 *
	 * @return the create date of this segments experiment
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this segments experiment.
	 *
	 * @param createDate the create date of this segments experiment
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this segments experiment.
	 *
	 * @return the modified date of this segments experiment
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this segments experiment.
	 *
	 * @param modifiedDate the modified date of this segments experiment
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the segments entry ID of this segments experiment.
	 *
	 * @return the segments entry ID of this segments experiment
	 */
	public long getSegmentsEntryId();

	/**
	 * Sets the segments entry ID of this segments experiment.
	 *
	 * @param segmentsEntryId the segments entry ID of this segments experiment
	 */
	public void setSegmentsEntryId(long segmentsEntryId);

	/**
	 * Returns the segments experience ID of this segments experiment.
	 *
	 * @return the segments experience ID of this segments experiment
	 */
	public long getSegmentsExperienceId();

	/**
	 * Sets the segments experience ID of this segments experiment.
	 *
	 * @param segmentsExperienceId the segments experience ID of this segments experiment
	 */
	public void setSegmentsExperienceId(long segmentsExperienceId);

	/**
	 * Returns the segments experiment key of this segments experiment.
	 *
	 * @return the segments experiment key of this segments experiment
	 */
	@AutoEscape
	public String getSegmentsExperimentKey();

	/**
	 * Sets the segments experiment key of this segments experiment.
	 *
	 * @param segmentsExperimentKey the segments experiment key of this segments experiment
	 */
	public void setSegmentsExperimentKey(String segmentsExperimentKey);

	/**
	 * Returns the fully qualified class name of this segments experiment.
	 *
	 * @return the fully qualified class name of this segments experiment
	 */
	@Override
	public String getClassName();

	public void setClassName(String className);

	/**
	 * Returns the class name ID of this segments experiment.
	 *
	 * @return the class name ID of this segments experiment
	 */
	@Override
	public long getClassNameId();

	/**
	 * Sets the class name ID of this segments experiment.
	 *
	 * @param classNameId the class name ID of this segments experiment
	 */
	@Override
	public void setClassNameId(long classNameId);

	/**
	 * Returns the class pk of this segments experiment.
	 *
	 * @return the class pk of this segments experiment
	 */
	@Override
	public long getClassPK();

	/**
	 * Sets the class pk of this segments experiment.
	 *
	 * @param classPK the class pk of this segments experiment
	 */
	@Override
	public void setClassPK(long classPK);

	/**
	 * Returns the name of this segments experiment.
	 *
	 * @return the name of this segments experiment
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this segments experiment.
	 *
	 * @param name the name of this segments experiment
	 */
	public void setName(String name);

	/**
	 * Returns the description of this segments experiment.
	 *
	 * @return the description of this segments experiment
	 */
	@AutoEscape
	public String getDescription();

	/**
	 * Sets the description of this segments experiment.
	 *
	 * @param description the description of this segments experiment
	 */
	public void setDescription(String description);

	/**
	 * Returns the type settings of this segments experiment.
	 *
	 * @return the type settings of this segments experiment
	 */
	@AutoEscape
	public String getTypeSettings();

	/**
	 * Sets the type settings of this segments experiment.
	 *
	 * @param typeSettings the type settings of this segments experiment
	 */
	public void setTypeSettings(String typeSettings);

	/**
	 * Returns the status of this segments experiment.
	 *
	 * @return the status of this segments experiment
	 */
	public int getStatus();

	/**
	 * Sets the status of this segments experiment.
	 *
	 * @param status the status of this segments experiment
	 */
	public void setStatus(int status);

	@Override
	public SegmentsExperiment cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}