/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.manager;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoColumnLocalServiceUtil;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalServiceUtil;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.WebsiteURLException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Country;
import com.liferay.portal.kernel.model.Region;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ContactLocalService;
import com.liferay.portal.kernel.service.CountryLocalService;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.ListTypeLocalService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.RegionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserGroupService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.service.WebsiteLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.scim.rest.internal.configuration.ScimClientOAuth2ApplicationConfiguration;
import com.liferay.scim.rest.internal.model.ScimUser;
import com.liferay.scim.rest.internal.util.ScimUtil;
import com.liferay.scim.rest.util.ScimClientUtil;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.cm.ConfigurationAdmin;
import org.wso2.charon3.core.exceptions.AbstractCharonException;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.ConflictException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.Group;
import org.wso2.charon3.core.objects.plainobjects.GroupsGetResponse;
import org.wso2.charon3.core.objects.plainobjects.MultiValuedComplexType;
import org.wso2.charon3.core.objects.plainobjects.ScimAddress;
import org.wso2.charon3.core.objects.plainobjects.UsersGetResponse;
import org.wso2.charon3.core.utils.codeutils.ExpressionNode;
import org.wso2.charon3.core.utils.codeutils.Node;

public class UserManagerImpl
implements UserManager {
    private static final Log _log = LogFactoryUtil.getLog(UserManagerImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRED, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private final AddressLocalService _addressLocalService;
    private final ClassNameLocalService _classNameLocalService;
    private final CompanyLocalService _companyLocalService;
    private final ConfigurationAdmin _configurationAdmin;
    private final ContactLocalService _contactLocalService;
    private final CounterLocalService _counterLocalService;
    private final CountryLocalService _countryLocalService;
    private final EmailAddressLocalService _emailAddressLocalService;
    private final ExpandoColumnLocalService _expandoColumnLocalService;
    private final ExpandoTableLocalService _expandoTableLocalService;
    private final ExpandoValueLocalService _expandoValueLocalService;
    private final ListTypeLocalService _listTypeLocalService;
    private final PhoneLocalService _phoneLocalService;
    private final RegionLocalService _regionLocalService;
    private final Searcher _searcher;
    private final SearchRequestBuilderFactory _searchRequestBuilderFactory;
    private final UserGroupLocalService _userGroupLocalService;
    private final UserGroupService _userGroupService;
    private final UserLocalService _userLocalService;
    private final UserService _userService;
    private final WebsiteLocalService _websiteLocalService;

    public UserManagerImpl(AddressLocalService addressLocalService, ClassNameLocalService classNameLocalService, CompanyLocalService companyLocalService, ConfigurationAdmin configurationAdmin, ContactLocalService contactLocalService, CounterLocalService counterLocalService, CountryLocalService countryLocalService, EmailAddressLocalService emailAddressLocalService, ExpandoColumnLocalService expandoColumnLocalService, ExpandoTableLocalService expandoTableLocalService, ExpandoValueLocalService expandoValueLocalService, ListTypeLocalService listTypeLocalService, PhoneLocalService phoneLocalService, RegionLocalService regionLocalService, Searcher searcher, SearchRequestBuilderFactory searchRequestBuilderFactory, UserGroupLocalService userGroupLocalService, UserGroupService userGroupService, UserLocalService userLocalService, UserService userService, WebsiteLocalService websiteLocalService) {
        this._addressLocalService = addressLocalService;
        this._classNameLocalService = classNameLocalService;
        this._companyLocalService = companyLocalService;
        this._configurationAdmin = configurationAdmin;
        this._contactLocalService = contactLocalService;
        this._counterLocalService = counterLocalService;
        this._countryLocalService = countryLocalService;
        this._emailAddressLocalService = emailAddressLocalService;
        this._expandoColumnLocalService = expandoColumnLocalService;
        this._expandoTableLocalService = expandoTableLocalService;
        this._expandoValueLocalService = expandoValueLocalService;
        this._listTypeLocalService = listTypeLocalService;
        this._phoneLocalService = phoneLocalService;
        this._regionLocalService = regionLocalService;
        this._searcher = searcher;
        this._searchRequestBuilderFactory = searchRequestBuilderFactory;
        this._userGroupLocalService = userGroupLocalService;
        this._userGroupService = userGroupService;
        this._userLocalService = userLocalService;
        this._userService = userService;
        this._websiteLocalService = websiteLocalService;
    }

    public Group createGroup(Group group, Map<String, Boolean> requiredAttributes) throws CharonException {
        return this._addOrUpdateGroup(group);
    }

    public org.wso2.charon3.core.objects.User createMe(org.wso2.charon3.core.objects.User user, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public org.wso2.charon3.core.objects.User createUser(org.wso2.charon3.core.objects.User user, Map<String, Boolean> requiredAttributes) throws CharonException {
        return this._addOrUpdateUser(user);
    }

    public void deleteGroup(String groupId) throws CharonException, NotFoundException {
        try {
            this.getGroup(groupId, Collections.emptyMap());
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                this._userService.setUserGroupUsers(GetterUtil.getLong((String)groupId), new long[0]);
                this._userGroupService.deleteUserGroup(GetterUtil.getLong((String)groupId));
                return null;
            });
        }
        catch (AbstractCharonException abstractCharonException) {
            ReflectionUtil.throwException((Throwable)abstractCharonException);
        }
        catch (PrincipalException principalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)principalException);
            }
            throw new NotFoundException();
        }
        catch (Throwable throwable) {
            throw new CharonException("Unable to delete group with group ID " + groupId, throwable);
        }
    }

    public void deleteMe(String userName) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public void deleteUser(String userId) throws CharonException {
        try {
            this._getScimUser(CompanyThreadLocal.getCompanyId(), GetterUtil.getLong((String)userId));
            this._userService.updateStatus(GetterUtil.getLong((String)userId), 5, new ServiceContext());
        }
        catch (AbstractCharonException abstractCharonException) {
            ReflectionUtil.throwException((Throwable)abstractCharonException);
        }
        catch (Exception exception) {
            throw new CharonException("Unable to delete user with user ID " + userId, (Throwable)exception);
        }
    }

    public Group getGroup(String groupId, Map<String, Boolean> requiredAttributes) {
        try {
            UserGroup userGroup = this._getUserGroup(CompanyThreadLocal.getCompanyId(), GetterUtil.getLong((String)groupId));
            return ScimUtil.toGroup(this._getScimUsers(CompanyThreadLocal.getCompanyId(), userGroup.getUserGroupId()), userGroup);
        }
        catch (Exception exception) {
            return (Group)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public org.wso2.charon3.core.objects.User getMe(String userName, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public org.wso2.charon3.core.objects.User getUser(String userId, Map<String, Boolean> requiredAttributes) {
        try {
            ScimUser scimUser = this._getScimUser(CompanyThreadLocal.getCompanyId(), GetterUtil.getLong((String)userId));
            if (!scimUser.isActive()) {
                throw new NotFoundException("No user found with user ID " + userId);
            }
            return ScimUtil.toUser(this._getGroups(CompanyThreadLocal.getCompanyId(), GetterUtil.getLong((String)scimUser.getId())), scimUser);
        }
        catch (Exception exception) {
            return (org.wso2.charon3.core.objects.User)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public GroupsGetResponse listGroupsWithGET(Node node, Integer startIndex, Integer count, String sortBy, String sortOrder, String domainName, Map<String, Boolean> requiredAttributes) throws BadRequestException {
        this._validate(node, "displayName");
        if (startIndex != null) {
            Integer n = startIndex;
            startIndex = startIndex - 1;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration = ScimUtil.getScimClientOAuth2ApplicationConfiguration(serviceContext.getCompanyId(), this._configurationAdmin);
        String scimClientId = ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName());
        SearchRequest searchRequest = this._searchRequestBuilderFactory.builder().modelIndexerClasses(new Class[]{UserGroup.class}).companyId(Long.valueOf(serviceContext.getCompanyId())).fetchSource(false).fields(new String[0]).from(startIndex).emptySearchEnabled(true).size(count).withSearchContext(searchContext -> {
            searchContext.setAndSearch(true);
            searchContext.setAttribute("groupId", (Serializable)Long.valueOf(0L));
            searchContext.setAttribute("expando__keyword__custom_fields__scimClientId", (Serializable)((Object)scimClientId));
            ExpressionNode expressionNode = (ExpressionNode)node;
            if (expressionNode != null && StringUtil.contains((String)expressionNode.getAttributeValue(), (String)"displayName", (String)":")) {
                searchContext.setAttribute("name", (Serializable)((Object)expressionNode.getValue()));
            }
            searchContext.setUserId(serviceContext.getUserId());
        }).build();
        SearchResponse searchResponse = this._searcher.search(searchRequest);
        SearchHits searchHits = searchResponse.getSearchHits();
        return new GroupsGetResponse((int)searchHits.getTotalHits(), TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            UserGroup userGroup = this._userGroupService.getUserGroup(document.getLong("entryClassPK").longValue());
            return ScimUtil.toGroup(this._getScimUsers(userGroup.getCompanyId(), userGroup.getUserGroupId()), userGroup);
        }));
    }

    public GroupsGetResponse listGroupsWithPost(org.wso2.charon3.core.utils.codeutils.SearchRequest searchRequest, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public UsersGetResponse listUsersWithGET(Node node, Integer startIndex, Integer count, String sortBy, String sortOrder, String domainName, Map<String, Boolean> requiredAttributes) throws BadRequestException {
        this._validate(node, "externalId", "userName");
        if (startIndex != null) {
            Integer n = startIndex;
            startIndex = startIndex - 1;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration = ScimUtil.getScimClientOAuth2ApplicationConfiguration(serviceContext.getCompanyId(), this._configurationAdmin);
        String scimClientId = ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName());
        SearchRequest searchRequest = this._searchRequestBuilderFactory.builder().modelIndexerClasses(new Class[]{User.class}).companyId(Long.valueOf(serviceContext.getCompanyId())).fetchSource(false).fields(new String[0]).from(startIndex).emptySearchEnabled(true).size(count).withSearchContext(searchContext -> {
            searchContext.setAndSearch(true);
            searchContext.setAttribute("groupId", (Serializable)Long.valueOf(0L));
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(0));
            searchContext.setAttribute("expando__keyword__custom_fields__scimClientId", (Serializable)((Object)scimClientId));
            ExpressionNode expressionNode = (ExpressionNode)node;
            if (expressionNode != null) {
                if (StringUtil.contains((String)expressionNode.getAttributeValue(), (String)"externalId", (String)":")) {
                    searchContext.setAttribute("externalReferenceCode", (Serializable)((Object)expressionNode.getValue()));
                } else if (StringUtil.contains((String)expressionNode.getAttributeValue(), (String)"userName", (String)":")) {
                    searchContext.setAttribute("screenName", (Serializable)((Object)expressionNode.getValue()));
                }
            }
            searchContext.setUserId(serviceContext.getUserId());
        }).build();
        SearchResponse searchResponse = this._searcher.search(searchRequest);
        SearchHits searchHits = searchResponse.getSearchHits();
        return new UsersGetResponse((int)searchHits.getTotalHits(), TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long userId = document.getLong("entryClassPK");
            return ScimUtil.toUser(this._getGroups(serviceContext.getCompanyId(), userId), ScimUtil.toScimUser(this._userService.getUserById(userId)));
        }));
    }

    public UsersGetResponse listUsersWithPost(org.wso2.charon3.core.utils.codeutils.SearchRequest searchRequest, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public void updateGroup(Group oldGroup, Group newGroup) throws CharonException {
        this._addOrUpdateGroup(newGroup);
    }

    public Group updateGroup(Group oldGroup, Group newGroup, Map<String, Boolean> requiredAttributes) throws CharonException {
        return this._addOrUpdateGroup(newGroup);
    }

    public org.wso2.charon3.core.objects.User updateMe(org.wso2.charon3.core.objects.User updatedUser, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public org.wso2.charon3.core.objects.User updateUser(org.wso2.charon3.core.objects.User user, Map<String, Boolean> requiredAttributes) throws CharonException {
        return this._addOrUpdateUser(user);
    }

    private void _addOrUpdateExpandoValue(String name, User portalUser, boolean textBox, String value) throws Exception {
        long classNameId = ClassNameLocalServiceUtil.getClassNameId((String)User.class.getName());
        ExpandoColumn expandoColumn = this._getOrAddExpandoColumn(classNameId, portalUser.getCompanyId(), name, textBox);
        this._expandoValueLocalService.addValue(classNameId, expandoColumn.getTableId(), expandoColumn.getColumnId(), portalUser.getUserId(), value);
    }

    private Group _addOrUpdateGroup(Group group) throws CharonException {
        try {
            Company company = this._companyLocalService.fetchCompany(CompanyThreadLocal.getCompanyId().longValue());
            return (Group)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                UserGroup userGroup = this._addOrUpdateUserGroup(company, group);
                return ScimUtil.toGroup(this._getScimUsers(userGroup.getCompanyId(), userGroup.getUserGroupId()), userGroup);
            });
        }
        catch (AbstractCharonException abstractCharonException) {
            return (Group)ReflectionUtil.throwException((Throwable)abstractCharonException);
        }
        catch (Throwable throwable) {
            throw new CharonException("Unable to provision a portal group for " + group.getDisplayName(), throwable);
        }
    }

    private ScimUser _addOrUpdateScimUser(ScimUser scimUser) throws Exception {
        User portalUser;
        block13: {
            String skypeSn;
            Company company = this._companyLocalService.getCompany(scimUser.getCompanyId());
            ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration = ScimUtil.getScimClientOAuth2ApplicationConfiguration(company.getCompanyId(), this._configurationAdmin);
            portalUser = this._fetchPortalUser(scimClientOAuth2ApplicationConfiguration, scimUser);
            Calendar birthdayCalendar = CalendarFactoryUtil.getCalendar();
            birthdayCalendar.setTime(scimUser.getBirthday());
            int birthdayMonth = birthdayCalendar.get(2);
            int birthdayDay = birthdayCalendar.get(5);
            int birthdayYear = birthdayCalendar.get(1);
            portalUser = portalUser == null ? this._addPortalUser(birthdayMonth, birthdayDay, birthdayYear, scimClientOAuth2ApplicationConfiguration, scimUser) : this._updatePortalUser(birthdayMonth, birthdayDay, birthdayYear, portalUser, scimUser, scimClientOAuth2ApplicationConfiguration);
            if (!FeatureFlagManagerUtil.isEnabled((String)"LPD-56434")) {
                return ScimUtil.toScimUser(portalUser);
            }
            this._addOrUpdateExpandoValue("scimDisplayName", portalUser, false, scimUser.getDisplayName());
            this._addOrUpdateExpandoValue("scimEntitlements", portalUser, true, ArrayUtil.toString((Object[])scimUser.getEntitlements(), (String)"", (String)"\n"));
            this._addOrUpdateExpandoValue("scimNickName", portalUser, false, scimUser.getNickName());
            this._addOrUpdateExpandoValue("scimPhotos", portalUser, true, ArrayUtil.toString((Object[])scimUser.getPhotos(), (String)"", (String)"\n"));
            this._addOrUpdateExpandoValue("scimPreferredLanguage", portalUser, false, scimUser.getPreferredLanguage());
            this._addOrUpdateExpandoValue("scimUserType", portalUser, false, scimUser.getUserType());
            this._addOrUpdateExpandoValue("scimX509Certificates", portalUser, true, ArrayUtil.toString((Object[])scimUser.getX509Certificates(), (String)"", (String)"\n"));
            this._addressLocalService.deleteAddresses(portalUser.getCompanyId(), Contact.class.getName(), portalUser.getContactId());
            for (ScimAddress scimAddress : scimUser.getAddresses()) {
                Address address = this._addressLocalService.createAddress(this._counterLocalService.increment());
                address.setUserId(portalUser.getUserId());
                address.setUserName(portalUser.getFullName());
                address.setClassName(Contact.class.getName());
                address.setClassPK(portalUser.getContactId());
                Country country = this._countryLocalService.getCountryByA2(portalUser.getCompanyId(), scimAddress.getCountry());
                address.setCountryId(country.getCountryId());
                if (Validator.isNull((String)scimAddress.getType())) {
                    scimAddress.setType("other");
                }
                address.setListTypeId(this._listTypeLocalService.getListTypeId(portalUser.getCompanyId(), scimAddress.getType(), Contact.class.getName() + ".address"));
                for (Region region : this._regionLocalService.getRegions(country.getCountryId(), true)) {
                    if (!Objects.equals(region.getName(), scimAddress.getRegion())) continue;
                    address.setRegionId(region.getRegionId());
                    break;
                }
                address.setCity(scimAddress.getLocality());
                address.setPrimary(scimAddress.isPrimary());
                String[] streetAddressParts = StringUtil.split((String)scimAddress.getStreetAddress(), (String)"\n");
                address.setStreet1(streetAddressParts[0]);
                if (streetAddressParts.length > 1) {
                    address.setStreet2(streetAddressParts[1]);
                }
                if (streetAddressParts.length > 2) {
                    address.setStreet3(streetAddressParts[2]);
                }
                address.setZip(scimAddress.getPostalCode());
                this._addressLocalService.addAddress(address);
            }
            Contact contact = portalUser.getContact();
            Map<String, String> ims = scimUser.getIMs();
            String jabberSn = ims.get("Jabber");
            if (Validator.isNotNull((String)jabberSn)) {
                contact.setJabberSn(jabberSn);
            }
            if (Validator.isNotNull((String)(skypeSn = ims.get("Skype")))) {
                contact.setSkypeSn(skypeSn);
            }
            contact = this._contactLocalService.updateContact(contact);
            portalUser.setContact(contact);
            this._emailAddressLocalService.deleteEmailAddresses(portalUser.getCompanyId(), Contact.class.getName(), portalUser.getContactId());
            long listTypeId = this._listTypeLocalService.getListTypeId(portalUser.getCompanyId(), "email-address", Contact.class.getName() + ".emailAddress");
            boolean primary = true;
            for (String emailAddress : scimUser.getEmailAddresses()) {
                ServiceContext serviceContext = new ServiceContext();
                this._emailAddressLocalService.addEmailAddress(serviceContext.getUuidWithoutReset(), portalUser.getUserId(), Contact.class.getName(), portalUser.getContactId(), emailAddress, listTypeId, primary, serviceContext);
                primary = false;
            }
            this._phoneLocalService.deletePhones(portalUser.getCompanyId(), Contact.class.getName(), portalUser.getContactId());
            for (MultiValuedComplexType multiValuedComplexType : scimUser.getPhoneNumberMultiValuedComplexTypes()) {
                listTypeId = this._listTypeLocalService.getListTypeId(portalUser.getCompanyId(), StringUtil.toLowerCase((String)multiValuedComplexType.getType()), Contact.class.getName() + ".phone");
                this._phoneLocalService.addPhone(null, portalUser.getUserId(), Contact.class.getName(), portalUser.getContactId(), multiValuedComplexType.getValue(), null, listTypeId, multiValuedComplexType.isPrimary(), new ServiceContext());
            }
            this._websiteLocalService.deleteWebsites(portalUser.getCompanyId(), Contact.class.getName(), portalUser.getContactId());
            if (Validator.isNotNull((String)scimUser.getProfileUrl())) {
                listTypeId = this._listTypeLocalService.getListTypeId(portalUser.getCompanyId(), "personal", Contact.class.getName() + ".website");
                try {
                    this._websiteLocalService.addWebsite(null, portalUser.getUserId(), Contact.class.getName(), portalUser.getContactId(), scimUser.getProfileUrl(), listTypeId, true, new ServiceContext());
                }
                catch (WebsiteURLException websiteURLException) {
                    if (!_log.isDebugEnabled()) break block13;
                    _log.debug((Object)"Unable to create website URL", (Throwable)websiteURLException);
                }
            }
        }
        return ScimUtil.toScimUser(portalUser);
    }

    private org.wso2.charon3.core.objects.User _addOrUpdateUser(org.wso2.charon3.core.objects.User user) throws CharonException {
        try {
            Company company = this._companyLocalService.fetchCompany(CompanyThreadLocal.getCompanyId().longValue());
            return (org.wso2.charon3.core.objects.User)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                ScimUser scimUser = this._addOrUpdateScimUser(ScimUtil.toScimUser(company.getCompanyId(), company.getLocale(), user));
                return ScimUtil.toUser(this._getGroups(company.getCompanyId(), GetterUtil.getLong((String)scimUser.getId())), scimUser);
            });
        }
        catch (AbstractCharonException abstractCharonException) {
            return (org.wso2.charon3.core.objects.User)ReflectionUtil.throwException((Throwable)abstractCharonException);
        }
        catch (Throwable throwable) {
            throw new CharonException("Unable to provision a portal user for " + user.getDisplayName(), throwable);
        }
    }

    private UserGroup _addOrUpdateUserGroup(Company company, Group group) throws Exception {
        ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration = ScimUtil.getScimClientOAuth2ApplicationConfiguration(company.getCompanyId(), this._configurationAdmin);
        UserGroup userGroup = this._fetchUserGroup(company.getCompanyId(), group.getExternalId(), GetterUtil.getLong((String)group.getId()));
        if (userGroup == null) {
            userGroup = this._userGroupService.addUserGroup(group.getExternalId(), group.getDisplayName(), null, new ServiceContext());
            this._saveScimClientId(UserGroup.class.getName(), userGroup.getPrimaryKey(), userGroup.getCompanyId(), ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName()));
        } else {
            String scimClientId = ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName());
            String userGroupScimClientId = this._getScimClientId(UserGroup.class.getName(), userGroup.getPrimaryKey(), userGroup.getCompanyId());
            if (Validator.isNotNull((String)userGroupScimClientId) && !Objects.equals(scimClientId, userGroupScimClientId)) {
                throw new ConflictException("Group was provisioned by another SCIM client");
            }
            userGroup = this._userGroupService.updateUserGroup(group.getExternalId(), userGroup.getPrimaryKey(), group.getDisplayName(), userGroup.getDescription(), new ServiceContext());
            if (Validator.isNull((String)userGroupScimClientId)) {
                this._saveScimClientId(UserGroup.class.getName(), userGroup.getPrimaryKey(), userGroup.getCompanyId(), scimClientId);
            }
        }
        this._updateUserGroupUsers(userGroup.getCompanyId(), group, userGroup.getUserGroupId());
        return userGroup;
    }

    private User _addPortalUser(int birthdayMonth, int birthdayDay, int birthdayYear, ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration, ScimUser scimUser) throws Exception {
        User portalUser = this._userService.addUser(scimUser.getCompanyId(), scimUser.isAutoPassword(), scimUser.getPassword(), scimUser.getPassword(), scimUser.isAutoScreenName(), scimUser.getScreenName(), scimUser.getEmailAddresses()[0], scimUser.getLocale(), scimUser.getFirstName(), scimUser.getMiddleName(), scimUser.getLastName(), scimUser.getPrefix(), scimUser.getSuffix(), scimUser.isMale(), birthdayMonth, birthdayDay, birthdayYear, scimUser.getJobTitle(), scimUser.getGroupIds(), scimUser.getOrganizationIds(), scimUser.getRoleIds(), scimUser.getUserGroupIds(), scimUser.isSendEmail(), new ServiceContext());
        portalUser.setExternalReferenceCode(scimUser.getExternalReferenceCode());
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-56434") && Validator.isNotNull((String)scimUser.getTimeZoneId())) {
            portalUser.setTimeZoneId(scimUser.getTimeZoneId());
        }
        portalUser = this._userLocalService.updateUser(portalUser);
        portalUser = this._userLocalService.updateEmailAddressVerified(portalUser.getUserId(), true);
        this._saveScimClientId(User.class.getName(), portalUser.getUserId(), portalUser.getCompanyId(), ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName()));
        return portalUser;
    }

    private User _fetchPortalUser(ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration, ScimUser scimUser) {
        User portalUser = this._userLocalService.fetchUserByExternalReferenceCode(scimUser.getExternalReferenceCode(), scimUser.getCompanyId());
        if (portalUser != null) {
            return portalUser;
        }
        if (Objects.equals(scimClientOAuth2ApplicationConfiguration.matcherField(), "email")) {
            return this._userLocalService.fetchUserByEmailAddress(scimUser.getCompanyId(), scimUser.getEmailAddresses()[0]);
        }
        if (Objects.equals(scimClientOAuth2ApplicationConfiguration.matcherField(), "userName")) {
            return this._userLocalService.fetchUserByScreenName(scimUser.getCompanyId(), scimUser.getScreenName());
        }
        return null;
    }

    private UserGroup _fetchUserGroup(long companyId, String externalReferenceCode, long userGroupId) {
        UserGroup userGroup = this._userGroupLocalService.fetchUserGroupByExternalReferenceCode(externalReferenceCode, companyId);
        if (userGroup != null) {
            return userGroup;
        }
        return this._userGroupLocalService.fetchUserGroup(userGroupId);
    }

    private List<Group> _getGroups(long companyId, long userId) {
        String userScimClientId = this._getScimClientId(User.class.getName(), userId, companyId);
        return TransformUtil.transform((Collection)this._userGroupLocalService.getUserUserGroups(userId), userGroup -> {
            String userGroupScimClientId = this._getScimClientId(UserGroup.class.getName(), userGroup.getUserGroupId(), userGroup.getCompanyId());
            if (!Objects.equals(userGroupScimClientId, userScimClientId)) {
                return null;
            }
            return ScimUtil.toGroup(Collections.emptyList(), userGroup);
        });
    }

    private ExpandoColumn _getOrAddExpandoColumn(long classNameId, long companyId, String name, boolean textBox) throws Exception {
        ExpandoColumn expandoColumn;
        ExpandoTable expandoTable = ExpandoTableLocalServiceUtil.fetchTable((long)companyId, (long)classNameId, (String)"CUSTOM_FIELDS");
        if (expandoTable == null) {
            expandoTable = ExpandoTableLocalServiceUtil.addTable((long)companyId, (long)classNameId, (String)"CUSTOM_FIELDS");
        }
        if ((expandoColumn = ExpandoColumnLocalServiceUtil.fetchColumn((long)expandoTable.getTableId(), (String)name)) != null) {
            return expandoColumn;
        }
        expandoColumn = ExpandoColumnLocalServiceUtil.addColumn((long)expandoTable.getTableId(), (String)name, (int)15);
        UnicodeProperties unicodeProperties = expandoColumn.getTypeSettingsProperties();
        unicodeProperties.setProperty("index-type", String.valueOf(2));
        if (textBox) {
            unicodeProperties.setProperty("display-type", "text-box");
            unicodeProperties.setProperty("height", "150");
        } else {
            unicodeProperties.setProperty("display-type", "input-field");
        }
        unicodeProperties.setProperty("width", "400");
        expandoColumn.setTypeSettingsProperties(unicodeProperties);
        return ExpandoColumnLocalServiceUtil.updateExpandoColumn((ExpandoColumn)expandoColumn);
    }

    private String _getScimClientId(String className, long classPK, long companyId) {
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchTable(companyId, this._classNameLocalService.getClassNameId(className), "CUSTOM_FIELDS");
        if (expandoTable == null) {
            return "";
        }
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.fetchColumn(expandoTable.getTableId(), "scimClientId");
        if (expandoColumn == null) {
            return "";
        }
        ExpandoValue expandoValue = this._expandoValueLocalService.getValue(expandoTable.getTableId(), expandoColumn.getColumnId(), classPK);
        if (expandoValue == null) {
            return "";
        }
        return expandoValue.getData();
    }

    private ScimUser _getScimUser(long companyId, long userId) throws Exception {
        User portalUser = null;
        try {
            portalUser = this._userService.getUserById(userId);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            throw new NotFoundException();
        }
        String userScimClientId = this._getScimClientId(User.class.getName(), portalUser.getUserId(), portalUser.getCompanyId());
        if (Validator.isNull((String)userScimClientId)) {
            throw new NotFoundException("User " + userId + " is not a SCIM user");
        }
        ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration = ScimUtil.getScimClientOAuth2ApplicationConfiguration(companyId, this._configurationAdmin);
        String scimClientId = ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName());
        if (!Objects.equals(userScimClientId, scimClientId)) {
            throw new ConflictException("User was provisioned by another SCIM client");
        }
        return ScimUtil.toScimUser(portalUser);
    }

    private List<ScimUser> _getScimUsers(long companyId, long userGroupId) {
        String userGroupScimClientId = this._getScimClientId(UserGroup.class.getName(), userGroupId, companyId);
        return TransformUtil.transform((Collection)this._userLocalService.getUserGroupUsers(userGroupId), user -> {
            String userScimClientId = this._getScimClientId(User.class.getName(), user.getUserId(), user.getCompanyId());
            if (!Objects.equals(userGroupScimClientId, userScimClientId)) {
                return null;
            }
            return ScimUtil.toScimUser(user);
        });
    }

    private UserGroup _getUserGroup(long companyId, long userGroupId) throws AbstractCharonException {
        UserGroup userGroup = null;
        try {
            userGroup = this._userGroupService.fetchUserGroup(userGroupId);
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            throw new NotFoundException();
        }
        if (userGroup == null) {
            throw new NotFoundException("No group found with group ID " + userGroupId);
        }
        String groupScimClientId = this._getScimClientId(UserGroup.class.getName(), userGroup.getPrimaryKey(), userGroup.getCompanyId());
        if (Validator.isNull((String)groupScimClientId)) {
            throw new NotFoundException("No group found with group ID " + userGroupId);
        }
        ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration = ScimUtil.getScimClientOAuth2ApplicationConfiguration(companyId, this._configurationAdmin);
        String scimClientId = ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName());
        if (!Objects.equals(groupScimClientId, scimClientId)) {
            throw new ConflictException("Group was provisioned by another SCIM client");
        }
        return userGroup;
    }

    private void _saveScimClientId(String className, long classPK, long companyId, String scimClientId) throws Exception {
        ExpandoColumn expandoColumn;
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchTable(companyId, this._classNameLocalService.getClassNameId(className), "CUSTOM_FIELDS");
        if (expandoTable == null) {
            expandoTable = this._expandoTableLocalService.addTable(companyId, className, "CUSTOM_FIELDS");
        }
        if ((expandoColumn = this._expandoColumnLocalService.fetchColumn(expandoTable.getTableId(), "scimClientId")) == null) {
            expandoColumn = this._expandoColumnLocalService.addColumn(expandoTable.getTableId(), "scimClientId", 15);
            UnicodeProperties unicodeProperties = expandoColumn.getTypeSettingsProperties();
            unicodeProperties.setProperty("index-type", String.valueOf(2));
            unicodeProperties.setProperty("hidden", Boolean.TRUE.toString());
            expandoColumn.setTypeSettingsProperties(unicodeProperties);
            expandoColumn = this._expandoColumnLocalService.updateExpandoColumn(expandoColumn);
        }
        this._expandoValueLocalService.addValue(companyId, className, "CUSTOM_FIELDS", expandoColumn.getName(), classPK, scimClientId);
    }

    private User _updatePortalUser(int birthdayMonth, int birthdayDay, int birthdayYear, User portalUser, ScimUser scimUser, ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration) throws Exception {
        String scimClientId = ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName());
        String portalUserScimClientId = this._getScimClientId(User.class.getName(), portalUser.getUserId(), portalUser.getCompanyId());
        if (Validator.isNotNull((String)portalUserScimClientId) && !Objects.equals(scimClientId, portalUserScimClientId)) {
            throw new ConflictException("User was provisioned by another SCIM client");
        }
        Contact contact = portalUser.getContact();
        if (!Objects.equals((portalUser = this._userService.updateUser(portalUser.getUserId(), scimUser.getPassword(), "", "", false, portalUser.getReminderQueryQuestion(), portalUser.getReminderQueryAnswer(), portalUser.getScreenName(), scimUser.getEmailAddresses()[0], false, null, portalUser.getLanguageId(), scimUser.getTimeZoneId(), portalUser.getGreeting(), portalUser.getComments(), scimUser.getFirstName(), scimUser.getMiddleName(), scimUser.getLastName(), scimUser.getPrefix(), scimUser.getSuffix(), scimUser.isMale(), birthdayMonth, birthdayDay, birthdayYear, contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), scimUser.getJobTitle(), portalUser.getGroupIds(), portalUser.getOrganizationIds(), scimUser.getRoleIds(), null, portalUser.getUserGroupIds(), portalUser.getAddresses(), portalUser.getEmailAddresses(), portalUser.getPhones(), portalUser.getWebsites(), null, new ServiceContext())).getExternalReferenceCode(), scimUser.getExternalReferenceCode())) {
            portalUser.setExternalReferenceCode(scimUser.getExternalReferenceCode());
            portalUser = this._userLocalService.updateUser(portalUser);
        }
        if (portalUser.isActive() != scimUser.isActive()) {
            portalUser = this._userLocalService.updateStatus(portalUser.getUserId(), scimUser.isActive() ? 0 : 5, new ServiceContext());
        }
        if (Validator.isNull((String)portalUserScimClientId)) {
            this._saveScimClientId(User.class.getName(), portalUser.getUserId(), portalUser.getCompanyId(), scimClientId);
        }
        return portalUser;
    }

    private void _updateUserGroupUsers(long companyId, Group group, long userGroupId) throws Exception {
        String userGroupScimClientId = this._getScimClientId(UserGroup.class.getName(), userGroupId, companyId);
        this._userLocalService.setUserGroupUsers(userGroupId, TransformUtil.transformToLongArray((Collection)group.getMembers(), userId -> {
            String userScimClientId = this._getScimClientId(User.class.getName(), GetterUtil.getLong((Object)userId), companyId);
            if (!Objects.equals(userGroupScimClientId, userScimClientId)) {
                return null;
            }
            return GetterUtil.getLong((Object)userId);
        }));
    }

    private void _validate(Node node, String ... fieldNames) throws BadRequestException {
        if (node == null) {
            return;
        }
        ExpressionNode expressionNode = (ExpressionNode)node;
        for (String fieldName : fieldNames) {
            if (!StringUtil.contains((String)expressionNode.getAttributeValue(), (String)fieldName, (String)":")) continue;
            return;
        }
        throw new BadRequestException();
    }
}

