/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.resource.v1_0;

import com.liferay.portal.vulcan.resource.OpenAPIResource;
import com.liferay.scim.rest.internal.resource.v1_0.GroupResourceImpl;
import com.liferay.scim.rest.internal.resource.v1_0.ResourceTypesResourceImpl;
import com.liferay.scim.rest.internal.resource.v1_0.SchemaResourceImpl;
import com.liferay.scim.rest.internal.resource.v1_0.ServiceProviderConfigResourceImpl;
import com.liferay.scim.rest.internal.resource.v1_0.UserResourceImpl;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@OpenAPIDefinition(info=@Info(description="Liferay SCIM endpoints. A Java client JAR is available for use with the group ID 'com.liferay', artifact ID 'com.liferay.scim.rest.client', and version '1.0.15'.", license=@License(name="Apache 2.0", url="http://www.apache.org/licenses/LICENSE-2.0.html"), title="System for Cross-domain Identity Management", version="v1.0"))
@Path(value="/v1.0")
@Component(properties={"OSGI-INF/liferay/rest/v1_0/openapi.properties"}, service={OpenAPIResourceImpl.class})
public class OpenAPIResourceImpl {
    @Reference
    private OpenAPIResource _openAPIResource;
    private final Set<Class<?>> _resourceClasses = new HashSet<Class<?>>(){
        {
            this.add(GroupResourceImpl.class);
            this.add(ResourceTypesResourceImpl.class);
            this.add(SchemaResourceImpl.class);
            this.add(ServiceProviderConfigResourceImpl.class);
            this.add(UserResourceImpl.class);
            this.add(OpenAPIResourceImpl.class);
        }
    };

    @GET
    @Path(value="/openapi.{type:json|yaml}")
    @Produces(value={"application/json", "application/yaml"})
    public Response getOpenAPI(@Context HttpServletRequest httpServletRequest, @PathParam(value="type") String type, @Context UriInfo uriInfo) throws Exception {
        Class clazz = this._openAPIResource.getClass();
        try {
            Method method = clazz.getMethod("getOpenAPI", HttpServletRequest.class, Set.class, String.class, UriInfo.class);
            return (Response)method.invoke((Object)this._openAPIResource, httpServletRequest, this._resourceClasses, type, uriInfo);
        }
        catch (NoSuchMethodException noSuchMethodException1) {
            try {
                Method method = clazz.getMethod("getOpenAPI", Set.class, String.class, UriInfo.class);
                return (Response)method.invoke((Object)this._openAPIResource, this._resourceClasses, type, uriInfo);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return this._openAPIResource.getOpenAPI(this._resourceClasses, type);
            }
        }
    }
}

