/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.resource.v1_0;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.URLUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.scim.rest.internal.resource.v1_0.BaseResourceTypesResourceImpl;
import com.liferay.scim.rest.internal.util.ScimUtil;
import com.liferay.scim.rest.resource.v1_0.ResourceTypesResource;
import java.net.URL;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.wso2.charon3.core.exceptions.AbstractCharonException;
import org.wso2.charon3.core.exceptions.ConflictException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/resource-types.properties"}, scope=ServiceScope.PROTOTYPE, service={ResourceTypesResource.class})
public class ResourceTypesResourceImpl
extends BaseResourceTypesResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(ResourceTypesResourceImpl.class);
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private JSONFactory _jsonFactory;
    private final Map<String, String> _resourceTypeFileNames = Map.of("Group", "group.json", "User", "user.json");

    @Override
    public Object getV2ResourceTypeById(String id) throws Exception {
        return ScimUtil.buildResponse(this._getSCIMResponse(id));
    }

    @Override
    public Object getV2ResourceTypes() throws Exception {
        return this.getV2ResourceTypeById(null);
    }

    private String _getResourceTypeJSON(String id) throws AbstractCharonException {
        if (this._resourceTypeFileNames.containsKey(id)) {
            JSONObject resourceTypeJSONObject = this._read(this._resourceTypeFileNames.get(id));
            return resourceTypeJSONObject.toString();
        }
        throw new NotFoundException("No resource type found with resource type ID " + id);
    }

    private String _getResourceTypesJSON() throws AbstractCharonException {
        return JSONUtil.put((String)"itemsPerPage", (Object)2).put("Resources", () -> {
            JSONArray jsonArray = this._jsonFactory.createJSONArray();
            for (Map.Entry<String, String> entry : this._resourceTypeFileNames.entrySet()) {
                jsonArray.put(this._read(entry.getValue()));
            }
            return jsonArray;
        }).put("schemas", JSONUtil.put((Object)"urn:ietf:params:scim:api:messages:2.0:ListResponse")).put("startIndex", 1).put("totalResults", this._resourceTypeFileNames.size()).toString();
    }

    private SCIMResponse _getSCIMResponse(String id) {
        try {
            ScimUtil.getScimClientOAuth2ApplicationConfiguration(this.contextCompany.getCompanyId(), this._configurationAdmin);
            if (Validator.isNull((String)id)) {
                return new SCIMResponse(200, this._getResourceTypesJSON(), ScimUtil.getHeaders("/ResourceTypes"));
            }
            String resourceTypeJSON = this._getResourceTypeJSON(id);
            if (Validator.isNull((String)resourceTypeJSON)) {
                throw new NotFoundException("No resource type found with resourceType ID " + id);
            }
            return new SCIMResponse(200, resourceTypeJSON, ScimUtil.getHeaders("/ResourceTypes"));
        }
        catch (AbstractCharonException abstractCharonException) {
            return AbstractResourceManager.encodeSCIMException((AbstractCharonException)abstractCharonException);
        }
        catch (Exception exception) {
            if (exception instanceof ConflictException) {
                return AbstractResourceManager.encodeSCIMException((AbstractCharonException)((ConflictException)exception));
            }
            throw exception;
        }
    }

    private JSONObject _read(String fileName) throws InternalErrorException {
        try {
            Bundle bundle = FrameworkUtil.getBundle(ResourceTypesResourceImpl.class);
            JSONObject resourceTypeJSONObject = this._jsonFactory.createJSONObject(URLUtil.toString((URL)bundle.getResource("META-INF/resource-types/" + fileName)));
            JSONObject metaJSONObject = resourceTypeJSONObject.getJSONObject("meta");
            String resourceEndpointURL = AbstractResourceManager.getResourceEndpointURL((String)"/ResourceTypes");
            metaJSONObject.put("location", resourceEndpointURL + metaJSONObject.getString("location"));
            resourceTypeJSONObject.put("schemas", JSONUtil.put((Object)"urn:ietf:params:scim:schemas:core:2.0:ResourceType"));
            return resourceTypeJSONObject;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new InternalErrorException("Unable to read " + fileName);
        }
    }
}

