/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.configuration;

import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.rest.spi.bearer.token.provider.BearerTokenProvider;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.oauth2.provider.util.OAuth2SecureRandomGenerator;
import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.scim.rest.internal.configuration.ScimClientOAuth2ApplicationConfiguration;
import com.liferay.scim.rest.internal.provider.ScimClientBearerTokenProvider;
import com.liferay.scim.rest.util.ScimClientUtil;
import jakarta.ws.rs.core.Application;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(configurationPid={"com.liferay.scim.rest.internal.configuration.ScimClientOAuth2ApplicationConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class ScimClientOAuth2ApplicationConfigurationFactory {
    private static final Log _log = LogFactoryUtil.getLog(ScimClientOAuth2ApplicationConfigurationFactory.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private Collection<Application> _applications;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference(target="(module.service.lifecycle=portal.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    private volatile OAuth2Application _oAuth2Application;
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    private volatile ServiceRegistration<BearerTokenProvider> _serviceRegistration;
    @Reference
    private UserLocalService _userLocalService;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        ConfigurationFactoryUtil.executeAsCompany((CompanyLocalService)this._companyLocalService, properties, companyId -> {
            ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration = (ScimClientOAuth2ApplicationConfiguration)ConfigurableUtil.createConfigurable(ScimClientOAuth2ApplicationConfiguration.class, (Map)properties);
            this._oAuth2Application = this._getOrAddOAuth2Application((long)companyId, scimClientOAuth2ApplicationConfiguration, GetterUtil.getLong(properties.get("userId")));
            this._serviceRegistration = bundleContext.registerService(BearerTokenProvider.class, (Object)new ScimClientBearerTokenProvider(), (Dictionary)HashMapDictionaryBuilder.put((Object)"clientId", (Object)this._oAuth2Application.getClientId()).put((Object)"companyId", (Object)companyId.toString()).build());
        });
    }

    @Deactivate
    protected void deactivate(Integer reason) throws PortalException {
        if (reason != 4) {
            return;
        }
        this._oAuth2ApplicationLocalService.deleteOAuth2Application(this._oAuth2Application);
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
            this._serviceRegistration = null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Removed OAuth2 application: " + this._oAuth2Application.getName()));
        }
    }

    private OAuth2Application _getOrAddOAuth2Application(long companyId, ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration, long userId) throws Exception {
        String clientId = ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName());
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.fetchOAuth2Application(companyId, clientId);
        if (oAuth2Application == null) {
            User user = this._userLocalService.getUser(userId);
            oAuth2Application = this._oAuth2ApplicationLocalService.addOAuth2Application(companyId, user.getUserId(), user.getScreenName(), ListUtil.fromArray((Object[])new GrantType[]{GrantType.CLIENT_CREDENTIALS}), "client_secret_post", user.getUserId(), clientId, ClientProfile.HEADLESS_SERVER.id(), OAuth2SecureRandomGenerator.generateClientSecret(), null, Collections.emptyList(), null, 0L, null, scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName(), null, Collections.emptyList(), false, false, null, new ServiceContext());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Created OAuth2 application: " + oAuth2Application.getName()));
            }
        }
        return this._oAuth2ApplicationLocalService.updateScopeAliases(oAuth2Application.getUserId(), oAuth2Application.getUserName(), oAuth2Application.getOAuth2ApplicationId(), ListUtil.fromArray((Object[])new String[]{"Liferay.Scim.REST.everything"}));
    }
}

