/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.util;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ContactConstants;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.scim.rest.dto.v1_0.Operation;
import com.liferay.scim.rest.dto.v1_0.PatchOp;
import com.liferay.scim.rest.internal.configuration.ScimClientOAuth2ApplicationConfiguration;
import com.liferay.scim.rest.internal.model.ScimUser;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.service.cm.ConfigurationAdmin;
import org.wso2.charon3.core.attributes.AbstractAttribute;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.config.SCIMUserSchemaExtensionBuilder;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.objects.Group;
import org.wso2.charon3.core.objects.plainobjects.MultiValuedComplexType;
import org.wso2.charon3.core.objects.plainobjects.ScimName;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.ResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.utils.AttributeUtil;

public class ScimUtil {
    public static final String LIFERAY_USER_SCHEMA_EXTENSION_URI = "urn:ietf:params:scim:schemas:extension:liferay:2.0:User";
    private static final String _PATTERN = "yyyy-MM-dd'T'HH:mm:ssXX";
    private static final Log _log = LogFactoryUtil.getLog(ScimUtil.class);
    private static final DCLSingleton<AttributeSchema> _attributeSchemaDCLSingleton = new DCLSingleton();

    public static Response buildResponse(SCIMResponse scimResponse) {
        Map map;
        Response.ResponseBuilder responseBuilder = Response.status((int)scimResponse.getResponseStatus());
        if (scimResponse.getResponseMessage() != null) {
            responseBuilder.entity((Object)scimResponse.getResponseMessage());
        }
        if (MapUtil.isNotEmpty((Map)(map = scimResponse.getHeaderParamMap()))) {
            for (Map.Entry entry : map.entrySet()) {
                responseBuilder.header((String)entry.getKey(), entry.getValue());
            }
        }
        return responseBuilder.build();
    }

    public static Map<String, String> getHeaders(String resourceName) throws NotFoundException {
        return HashMapBuilder.put((Object)"Content-Type", (Object)"application/scim+json").put((Object)"Location", (Object)AbstractResourceManager.getResourceEndpointURL((String)resourceName)).build();
    }

    public static ScimClientOAuth2ApplicationConfiguration getScimClientOAuth2ApplicationConfiguration(long companyId, ConfigurationAdmin configurationAdmin) {
        try {
            Object[] configurations = configurationAdmin.listConfigurations(StringBundler.concat((Object[])new Object[]{"(&(", "service.factoryPid", "=com.liferay.scim.rest.internal.configuration.", "ScimClientOAuth2ApplicationConfiguration)(companyId=", companyId, "))"}));
            if (ArrayUtil.isEmpty((Object[])configurations)) {
                throw new NotFoundException("SCIM is not configured for company " + companyId);
            }
            Object configuration = configurations[0];
            return (ScimClientOAuth2ApplicationConfiguration)ConfigurableUtil.createConfigurable(ScimClientOAuth2ApplicationConfiguration.class, (Dictionary)configuration.getProperties());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to get the SCIM client OAuth 2 application ", "configuration for company ", companyId}), (Throwable)exception);
            }
            return (ScimClientOAuth2ApplicationConfiguration)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public static Group toGroup(List<ScimUser> scimUsers, UserGroup userGroup) throws Exception {
        Group group = new Group();
        group.replaceDisplayName(userGroup.getName());
        Date createDate = ScimUtil._truncateDate(userGroup.getCreateDate());
        group.setCreatedInstant(createDate.toInstant());
        group.setExternalId(userGroup.getExternalReferenceCode());
        group.setId(String.valueOf(userGroup.getPrimaryKey()));
        Date modifiedDate = ScimUtil._truncateDate(userGroup.getModifiedDate());
        group.setLastModifiedInstant(modifiedDate.toInstant());
        group.setLocation(StringBundler.concat((Object[])new Object[]{AbstractResourceManager.getResourceEndpointURL((String)"/Groups"), Character.valueOf('/'), userGroup.getPrimaryKey()}));
        for (ScimUser scimUser : scimUsers) {
            group.setMember(ScimUtil.toUser(Collections.emptyList(), scimUser));
        }
        group.setResourceType("Group");
        group.setSchemas();
        return group;
    }

    public static ScimUser toScimUser(long companyId, Locale locale, org.wso2.charon3.core.objects.User user) throws Exception {
        ScimUser scimUser = new ScimUser();
        scimUser.setActive(ScimUtil._isActive(user));
        scimUser.setAutoScreenName(PrefsPropsUtil.getBoolean((long)companyId, (String)"users.screen.name.always.autogenerate"));
        scimUser.setAutoPassword(user.getPassword() == null);
        scimUser.setBirthday(ScimUtil._getBirthday(user));
        scimUser.setCompanyId(companyId);
        scimUser.setEmailAddress(ScimUtil._getEmailAddress(user));
        scimUser.setExternalReferenceCode(user.getExternalId());
        ScimName scimName = user.getName();
        scimUser.setFirstName(scimName.getGivenName());
        scimUser.setId(user.getId());
        scimUser.setJobTitle(user.getTitle());
        scimUser.setLastName(scimName.getFamilyName());
        scimUser.setLocale(locale);
        scimUser.setMale(ScimUtil._isMale(user));
        scimUser.setMiddleName(scimName.getMiddleName());
        scimUser.setPassword(user.getPassword());
        scimUser.setScreenName(user.getUserName());
        ScimUtil._validate(scimUser);
        return scimUser;
    }

    public static ScimUser toScimUser(User portalUser) {
        try {
            ScimUser scimUser = new ScimUser();
            scimUser.setActive(portalUser.isActive());
            scimUser.setBirthday(portalUser.getBirthday());
            scimUser.setCompanyId(portalUser.getCompanyId());
            scimUser.setCreateDate(ScimUtil._truncateDate(portalUser.getCreateDate()));
            scimUser.setFirstName(portalUser.getFirstName());
            scimUser.setEmailAddress(portalUser.getEmailAddress());
            scimUser.setExternalReferenceCode(portalUser.getExternalReferenceCode());
            scimUser.setId(String.valueOf(portalUser.getUserId()));
            scimUser.setJobTitle(portalUser.getJobTitle());
            scimUser.setLastName(portalUser.getLastName());
            scimUser.setLocale(portalUser.getLocale());
            scimUser.setMale(portalUser.isMale());
            scimUser.setMiddleName(portalUser.getMiddleName());
            scimUser.setModifiedDate(ScimUtil._truncateDate(portalUser.getModifiedDate()));
            scimUser.setScreenName(portalUser.getScreenName());
            return scimUser;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to convert portal user to a SCIM user", (Throwable)portalException);
            }
            return (ScimUser)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    public static org.wso2.charon3.core.objects.User toUser(List<Group> groups, ScimUser scimUser) throws Exception {
        org.wso2.charon3.core.objects.User user = new org.wso2.charon3.core.objects.User();
        user.replaceActive(scimUser.isActive());
        user.replaceEmails(Collections.singletonList(new MultiValuedComplexType("work", true, null, scimUser.getEmailAddress(), null)));
        ScimName scimName = new ScimName();
        scimName.setFamilyName(scimUser.getLastName());
        scimName.setGivenName(scimUser.getFirstName());
        scimName.setMiddleName(scimUser.getMiddleName());
        user.replaceName(scimName);
        user.replaceTitle(scimUser.getJobTitle());
        SCIMResourceSchemaManager scimResourceSchemaManager = SCIMResourceSchemaManager.getInstance();
        user.setAttribute((Attribute)ScimUtil._createLiferayUserExtensionComplexAttribute(scimUser), (ResourceTypeSchema)scimResourceSchemaManager.getUserResourceSchema());
        Date createDate = scimUser.getCreateDate();
        user.setCreatedInstant(createDate.toInstant());
        user.setExternalId(scimUser.getExternalReferenceCode());
        for (Group group : groups) {
            user.setGroup("direct", group);
        }
        user.setId(scimUser.getId());
        Date modifiedDate = scimUser.getModifiedDate();
        user.setLastModifiedInstant(modifiedDate.toInstant());
        user.setLocation(StringBundler.concat((Object[])new Object[]{AbstractResourceManager.getResourceEndpointURL((String)"/Users"), Character.valueOf('/'), scimUser.getId()}));
        user.setResourceType("User");
        user.setSchemas();
        user.setUserName(scimUser.getScreenName());
        return user;
    }

    public static String transformGroupPatchOp(PatchOp patchOp) {
        JSONArray operationsJSONArray = JSONFactoryUtil.createJSONArray();
        for (Operation operation : patchOp.getOperations()) {
            JSONObject valueJSONObject;
            JSONArray valueJSONArray;
            Object value;
            JSONObject operationJSONObject = JSONUtil.put((String)"op", (Object)operation.getOp());
            operationsJSONArray.put(operationJSONObject);
            if ("add".equalsIgnoreCase(operation.getOp())) {
                if (!"members".equalsIgnoreCase(operation.getPath())) continue;
                value = operation.getValue();
                if (!(value instanceof ArrayList)) {
                    operationJSONObject.put("value", JSONUtil.put((String)"members", (Object)value));
                    continue;
                }
                valueJSONArray = JSONFactoryUtil.createJSONArray((Collection)((ArrayList)value));
                valueJSONObject = valueJSONArray.getJSONObject(0);
                if (!valueJSONObject.has("display")) {
                    valueJSONObject.put("display", "");
                }
                operationJSONObject.put("value", JSONUtil.put((String)"members", (Object)valueJSONArray));
                continue;
            }
            if ("remove".equalsIgnoreCase(operation.getOp())) {
                value = operation.getValue();
                if (value == null) {
                    operationJSONObject.put("path", operation.getPath());
                    continue;
                }
                if (value instanceof ArrayList) {
                    valueJSONArray = JSONFactoryUtil.createJSONArray((Collection)((ArrayList)value));
                    valueJSONObject = valueJSONArray.getJSONObject(0);
                    value = valueJSONObject.get("value");
                } else if (value instanceof Map) {
                    value = MapUtil.getString((Map)((Map)value), (Object)"value");
                }
                operationJSONObject.put("path", StringBundler.concat((Object[])new Object[]{operation.getPath(), "[", "value", " eq \"", value, "\"", "]"}));
                continue;
            }
            operationJSONObject.put("path", operation.getPath());
            value = operation.getValue();
            if (value instanceof ArrayList) {
                operationJSONObject.put("value", JSONFactoryUtil.createJSONArray((Collection)((ArrayList)value)));
                continue;
            }
            operationJSONObject.put("value", value);
        }
        return JSONUtil.put((String)"schemas", (Object)patchOp.getSchemas()).put("Operations", operationsJSONArray).toString();
    }

    private static AttributeSchema _createAttributeSchema() {
        SCIMUserSchemaExtensionBuilder scimUserSchemaExtensionBuilder = SCIMUserSchemaExtensionBuilder.getInstance();
        String json = JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"attributeName", (Object)"birthday").put("attributeURI", "urn:ietf:params:scim:schemas:extension:liferay:2.0:User:birthday").put("canonicalValues", JSONFactoryUtil.createJSONArray()).put("caseExact", "false").put("dataType", "string").put("description", "User's birthday").put("multiValued", "false").put("mutability", "readWrite").put("referenceTypes", JSONFactoryUtil.createJSONArray()).put("required", "false").put("returned", "default").put("subAttributes", "null").put("uniqueness", "none"), JSONUtil.put((String)"attributeName", (Object)"male").put("attributeURI", "urn:ietf:params:scim:schemas:extension:liferay:2.0:User:male").put("canonicalValues", JSONFactoryUtil.createJSONArray()).put("caseExact", "false").put("dataType", "boolean").put("description", "User's gender").put("multiValued", "false").put("mutability", "readWrite").put("referenceTypes", JSONFactoryUtil.createJSONArray()).put("required", "false").put("returned", "default").put("subAttributes", "null").put("uniqueness", "none"), JSONUtil.put((String)"attributeName", (Object)LIFERAY_USER_SCHEMA_EXTENSION_URI).put("attributeURI", LIFERAY_USER_SCHEMA_EXTENSION_URI).put("canonicalValues", JSONFactoryUtil.createJSONArray()).put("caseExact", "false").put("dataType", "complex").put("description", "Liferay's User Schema Extension").put("multiValued", "false").put("mutability", "readWrite").put("referenceTypes", JSONUtil.put((Object)"external")).put("required", "false").put("returned", "default").put("subAttributes", "birthday male").put("uniqueness", "none")}).toString();
        try {
            File file = FileUtil.createTempFile((byte[])json.getBytes());
            scimUserSchemaExtensionBuilder.buildUserSchemaExtension(file.getPath());
        }
        catch (Exception exception) {
            ReflectionUtil.throwException((Throwable)exception);
        }
        return scimUserSchemaExtensionBuilder.getExtensionSchema();
    }

    private static ComplexAttribute _createLiferayUserExtensionComplexAttribute(ScimUser scimUser) throws Exception {
        AttributeSchema attributeSchema = (AttributeSchema)_attributeSchemaDCLSingleton.getSingleton(ScimUtil::_createAttributeSchema);
        ComplexAttribute complexAttribute = new ComplexAttribute(attributeSchema.getName());
        DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_PATTERN);
        complexAttribute.setSubAttributesList((Map)HashMapBuilder.put((Object)"birthday", (Object)ScimUtil._createSimpleAttribute(attributeSchema.getSubAttributeSchema("birthday"), dateFormat.format(scimUser.getBirthday()))).put((Object)"male", (Object)ScimUtil._createSimpleAttribute(attributeSchema.getSubAttributeSchema("male"), scimUser.isMale())).build());
        return (ComplexAttribute)DefaultAttributeFactory.createAttribute((AttributeSchema)attributeSchema, (AbstractAttribute)complexAttribute);
    }

    private static SimpleAttribute _createSimpleAttribute(AttributeSchema attributeSchema, Object attributeValue) throws Exception {
        return (SimpleAttribute)DefaultAttributeFactory.createAttribute((AttributeSchema)attributeSchema, (AbstractAttribute)new SimpleAttribute(attributeSchema.getName(), AttributeUtil.getAttributeValueFromString((Object)attributeValue, (SCIMDefinitions.DataType)attributeSchema.getType())));
    }

    private static Date _getBirthday() {
        Calendar birthdayCalendar = CalendarFactoryUtil.getCalendar((int)1970, (int)0, (int)1);
        return birthdayCalendar.getTime();
    }

    private static Date _getBirthday(org.wso2.charon3.core.objects.User user) {
        try {
            ComplexAttribute complexAttribute = (ComplexAttribute)user.getAttribute(LIFERAY_USER_SCHEMA_EXTENSION_URI);
            if (complexAttribute == null) {
                return ScimUtil._getBirthday();
            }
            SimpleAttribute simpleAttribute = (SimpleAttribute)complexAttribute.getSubAttribute("birthday");
            if (simpleAttribute == null) {
                return ScimUtil._getBirthday();
            }
            DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_PATTERN);
            return dateFormat.parse(simpleAttribute.getStringValue());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return ScimUtil._getBirthday();
        }
    }

    private static String _getEmailAddress(org.wso2.charon3.core.objects.User user) {
        List multiValuedComplexTypes = user.getEmails();
        if (ListUtil.isEmpty((List)multiValuedComplexTypes)) {
            return null;
        }
        for (MultiValuedComplexType multiValuedComplexType : multiValuedComplexTypes) {
            if (!multiValuedComplexType.isPrimary()) continue;
            return multiValuedComplexType.getValue();
        }
        MultiValuedComplexType multiValuedComplexType = (MultiValuedComplexType)multiValuedComplexTypes.get(0);
        return multiValuedComplexType.getValue();
    }

    private static boolean _isActive(org.wso2.charon3.core.objects.User user) {
        SimpleAttribute simpleAttribute = (SimpleAttribute)user.getAttribute("active");
        if (simpleAttribute != null) {
            return GetterUtil.getBoolean((Object)simpleAttribute.getValue());
        }
        return user.getActive();
    }

    private static boolean _isMale(org.wso2.charon3.core.objects.User user) {
        try {
            ComplexAttribute complexAttribute = (ComplexAttribute)user.getAttribute(LIFERAY_USER_SCHEMA_EXTENSION_URI);
            if (complexAttribute == null) {
                return true;
            }
            SimpleAttribute simpleAttribute = (SimpleAttribute)complexAttribute.getSubAttribute("male");
            if (simpleAttribute == null) {
                return true;
            }
            return simpleAttribute.getBooleanValue();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return true;
        }
    }

    private static Date _truncateDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static void _validate(ScimUser scimUser) throws Exception {
        if (!scimUser.isAutoScreenName() && Validator.isNull((String)scimUser.getScreenName())) {
            throw new UserScreenNameException.MustNotBeNull(ContactConstants.getFullName((String)scimUser.getFirstName(), (String)scimUser.getMiddleName(), (String)scimUser.getLastName()));
        }
        if (Validator.isNull((String)scimUser.getEmailAddress()) && PrefsPropsUtil.getBoolean((long)scimUser.getCompanyId(), (String)"users.email.address.required")) {
            throw new UserEmailAddressException.MustNotBeNull(ContactConstants.getFullName((String)scimUser.getFirstName(), (String)scimUser.getMiddleName(), (String)scimUser.getLastName()));
        }
    }
}

