/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.resource.v1_0;

import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserGroupService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.scim.rest.dto.v1_0.PatchOp;
import com.liferay.scim.rest.dto.v1_0.User;
import com.liferay.scim.rest.internal.manager.UserManagerImpl;
import com.liferay.scim.rest.internal.manager.UserResourceManagerImpl;
import com.liferay.scim.rest.internal.resource.v1_0.BaseUserResourceImpl;
import com.liferay.scim.rest.resource.v1_0.UserResource;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.UserResourceManager;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user.properties"}, scope=ServiceScope.PROTOTYPE, service={UserResource.class})
public class UserResourceImpl
extends BaseUserResourceImpl {
    private static final UserResourceManager _userResourceManager = new UserResourceManagerImpl();
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private ExpandoValueLocalService _expandoValueLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private UserGroupLocalService _userGroupLocalService;
    @Reference
    private UserGroupService _userGroupService;
    @Reference
    private UserLocalService _userLocalService;
    private UserManager _userManager;
    @Reference
    private UserService _userService;

    @Override
    public Response deleteV2User(String id) throws Exception {
        return this._buildResponse(_userResourceManager.delete(id, this._userManager));
    }

    @Override
    public Object getV2UserById(String id) throws Exception {
        return this._buildResponse(_userResourceManager.get(id, this._userManager, null, null));
    }

    @Override
    public Object getV2Users(Integer count, Integer startIndex, Filter filter) throws Exception {
        return this._buildResponse(_userResourceManager.listWithGET(this._userManager, ParamUtil.getString((HttpServletRequest)this.contextHttpServletRequest, (String)"filter", null), startIndex, count, null, null, null, null, null));
    }

    @Override
    public Response patchV2User(String id, PatchOp patchOp) throws Exception {
        return this._buildResponse(_userResourceManager.updateWithPATCH(id, patchOp.toString(), this._userManager, null, null));
    }

    @Override
    public Response postV2User(User user) throws Exception {
        return this._buildResponse(_userResourceManager.create(user.toString(), this._userManager, null, null));
    }

    @Override
    public Response putV2User(String id, User user) throws Exception {
        return this._buildResponse(_userResourceManager.updateWithPUT(id, user.toString(), this._userManager, null, null));
    }

    @Activate
    protected void activate() {
        this._userManager = new UserManagerImpl(this._classNameLocalService, this._companyLocalService, this._configurationAdmin, this._expandoColumnLocalService, this._expandoTableLocalService, this._expandoValueLocalService, this._searcher, this._searchRequestBuilderFactory, this._userGroupLocalService, this._userGroupService, this._userLocalService, this._userService);
    }

    private Response _buildResponse(SCIMResponse scimResponse) {
        Map map;
        Response.ResponseBuilder responseBuilder = Response.status((int)scimResponse.getResponseStatus());
        if (scimResponse.getResponseMessage() != null) {
            responseBuilder.entity((Object)scimResponse.getResponseMessage());
        }
        if (MapUtil.isNotEmpty((Map)(map = scimResponse.getHeaderParamMap()))) {
            for (Map.Entry entry : map.entrySet()) {
                responseBuilder.header((String)entry.getKey(), entry.getValue());
            }
        }
        return responseBuilder.build();
    }
}

