/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.manager;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.scim.rest.internal.configuration.ScimClientOAuth2ApplicationConfiguration;
import com.liferay.scim.rest.internal.model.ScimUser;
import com.liferay.scim.rest.internal.util.ScimUserUtil;
import com.liferay.scim.rest.util.ScimClientUtil;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.cm.ConfigurationAdmin;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.Group;
import org.wso2.charon3.core.objects.plainobjects.GroupsGetResponse;
import org.wso2.charon3.core.objects.plainobjects.UsersGetResponse;
import org.wso2.charon3.core.utils.codeutils.SearchRequest;

public class UserManagerImpl
implements UserManager {
    private static final Log _log = LogFactoryUtil.getLog(UserManagerImpl.class);
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.SUPPORTS, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);
    private final ClassNameLocalService _classNameLocalService;
    private final CompanyLocalService _companyLocalService;
    private final ConfigurationAdmin _configurationAdmin;
    private final ExpandoColumnLocalService _expandoColumnLocalService;
    private final ExpandoTableLocalService _expandoTableLocalService;
    private final ExpandoValueLocalService _expandoValueLocalService;
    private final UserLocalService _userLocalService;

    public UserManagerImpl(ClassNameLocalService classNameLocalService, CompanyLocalService companyLocalService, ConfigurationAdmin configurationAdmin, ExpandoColumnLocalService expandoColumnLocalService, ExpandoTableLocalService expandoTableLocalService, ExpandoValueLocalService expandoValueLocalService, UserLocalService userLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._companyLocalService = companyLocalService;
        this._configurationAdmin = configurationAdmin;
        this._expandoColumnLocalService = expandoColumnLocalService;
        this._expandoTableLocalService = expandoTableLocalService;
        this._expandoValueLocalService = expandoValueLocalService;
        this._userLocalService = userLocalService;
    }

    public Group createGroup(Group group, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public org.wso2.charon3.core.objects.User createMe(org.wso2.charon3.core.objects.User user, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public org.wso2.charon3.core.objects.User createUser(org.wso2.charon3.core.objects.User user, Map<String, Boolean> requiredAttributes) throws CharonException {
        return this._addOrUpdateUser(user);
    }

    public void deleteGroup(String groupId) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public void deleteMe(String userName) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public void deleteUser(String userId) throws CharonException {
        ScimUser scimUser = this._fetchScimUser(CompanyThreadLocal.getCompanyId(), GetterUtil.getLong((String)userId));
        if (scimUser == null) {
            return;
        }
        try {
            this._userLocalService.updateStatus(GetterUtil.getLong((String)userId), 5, new ServiceContext());
        }
        catch (PortalException portalException) {
            throw new CharonException("Unable to delete user with user ID " + userId, (Throwable)portalException);
        }
    }

    public Group getGroup(String groupId, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public org.wso2.charon3.core.objects.User getMe(String userName, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public org.wso2.charon3.core.objects.User getUser(String userId, Map<String, Boolean> requiredAttributes) throws BadRequestException, CharonException, NotFoundException {
        ScimUser scimUser = this._fetchScimUser(CompanyThreadLocal.getCompanyId(), GetterUtil.getLong((String)userId));
        if (scimUser == null || !scimUser.isActive()) {
            throw new NotFoundException("No user found with user ID " + userId);
        }
        try {
            return ScimUserUtil.toUser(scimUser);
        }
        catch (Exception exception) {
            throw new CharonException(exception.getMessage(), (Throwable)exception);
        }
    }

    public GroupsGetResponse listGroupsWithPost(SearchRequest searchRequest, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public UsersGetResponse listUsersWithPost(SearchRequest searchRequest, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public Group updateGroup(Group oldGroup, Group newGroup, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public org.wso2.charon3.core.objects.User updateMe(org.wso2.charon3.core.objects.User updatedUser, Map<String, Boolean> requiredAttributes) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public org.wso2.charon3.core.objects.User updateUser(org.wso2.charon3.core.objects.User user, Map<String, Boolean> requiredAttributes) throws CharonException {
        return this._addOrUpdateUser(user);
    }

    private ScimUser _addOrUpdateScimUser(ScimUser scimUser) throws PortalException {
        Company company = this._companyLocalService.getCompany(scimUser.getCompanyId());
        ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration = this._getScimClientOAuth2ApplicationConfiguration(company.getCompanyId());
        User portalUser = this._fetchPortalUser(scimClientOAuth2ApplicationConfiguration, scimUser);
        Calendar birthdayCalendar = CalendarFactoryUtil.getCalendar();
        birthdayCalendar.setTime(scimUser.getBirthday());
        int birthdayMonth = birthdayCalendar.get(2);
        int birthdayDay = birthdayCalendar.get(5);
        int birthdayYear = birthdayCalendar.get(1);
        portalUser = portalUser == null ? this._addPortalUser(birthdayMonth, birthdayDay, birthdayYear, scimClientOAuth2ApplicationConfiguration, scimUser) : this._updatePortalUser(birthdayMonth, birthdayDay, birthdayYear, portalUser, scimUser, scimClientOAuth2ApplicationConfiguration);
        return this._toScimUser(portalUser);
    }

    private org.wso2.charon3.core.objects.User _addOrUpdateUser(org.wso2.charon3.core.objects.User user) throws CharonException {
        try {
            Company company = this._companyLocalService.fetchCompany(CompanyThreadLocal.getCompanyId().longValue());
            ScimUser scimUser = (ScimUser)TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> this._addOrUpdateScimUser(ScimUserUtil.toScimUser(company.getCompanyId(), company.getLocale(), user)));
            return ScimUserUtil.toUser(scimUser);
        }
        catch (Throwable throwable) {
            throw new CharonException("Unable to provision a portal user for " + user.getDisplayName(), throwable);
        }
    }

    private User _addPortalUser(int birthdayMonth, int birthdayDay, int birthdayYear, ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration, ScimUser scimUser) throws PortalException {
        User portalUser = this._userLocalService.addUser(0L, scimUser.getCompanyId(), scimUser.isAutoPassword(), scimUser.getPassword(), scimUser.getPassword(), scimUser.isAutoScreenName(), scimUser.getScreenName(), scimUser.getEmailAddress(), scimUser.getLocale(), scimUser.getFirstName(), scimUser.getMiddleName(), scimUser.getLastName(), 0L, 0L, scimUser.isMale(), birthdayMonth, birthdayDay, birthdayYear, "", 1, scimUser.getGroupIds(), scimUser.getOrganizationIds(), scimUser.getRoleIds(), scimUser.getUserGroupIds(), scimUser.isSendEmail(), new ServiceContext());
        portalUser.setExternalReferenceCode(scimUser.getExternalReferenceCode());
        portalUser = this._userLocalService.updateUser(portalUser);
        portalUser = this._userLocalService.updateEmailAddressVerified(portalUser.getUserId(), true);
        this._saveScimClientId(ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName()), portalUser);
        return portalUser;
    }

    private User _fetchPortalUser(ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration, ScimUser scimUser) {
        User portalUser = this._userLocalService.fetchUserByExternalReferenceCode(scimUser.getExternalReferenceCode(), scimUser.getCompanyId());
        if (portalUser != null) {
            return portalUser;
        }
        if (Objects.equals(scimClientOAuth2ApplicationConfiguration.matcherField(), "emailAddress")) {
            return this._userLocalService.fetchUserByEmailAddress(scimUser.getCompanyId(), scimUser.getEmailAddress());
        }
        if (Objects.equals(scimClientOAuth2ApplicationConfiguration.matcherField(), "userName")) {
            return this._userLocalService.fetchUserByScreenName(scimUser.getCompanyId(), scimUser.getScreenName());
        }
        return null;
    }

    private ScimUser _fetchScimUser(long companyId, long userId) {
        User portalUser = this._userLocalService.fetchUserById(userId);
        if (portalUser == null) {
            return null;
        }
        ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration = this._getScimClientOAuth2ApplicationConfiguration(companyId);
        String scimClientId = ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName());
        if (!Objects.equals(this._getScimClientId(portalUser), scimClientId)) {
            return null;
        }
        return this._toScimUser(portalUser);
    }

    private String _getScimClientId(User portalUser) {
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchTable(portalUser.getCompanyId(), this._classNameLocalService.getClassNameId(org.wso2.charon3.core.objects.User.class.getName()), "CUSTOM_FIELDS");
        if (expandoTable == null) {
            return "";
        }
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.fetchColumn(expandoTable.getTableId(), "scimClientId");
        if (expandoColumn == null) {
            return "";
        }
        ExpandoValue expandoValue = this._expandoValueLocalService.getValue(expandoTable.getTableId(), expandoColumn.getColumnId(), portalUser.getUserId());
        if (expandoValue == null) {
            return "";
        }
        return expandoValue.getData();
    }

    private ScimClientOAuth2ApplicationConfiguration _getScimClientOAuth2ApplicationConfiguration(long companyId) {
        try {
            Object[] configurations = this._configurationAdmin.listConfigurations(String.format("(%s=%s*)", "service.factoryPid", ScimClientOAuth2ApplicationConfiguration.class.getName()));
            if (ArrayUtil.isEmpty((Object[])configurations)) {
                return null;
            }
            for (Object configuration : configurations) {
                HashMap properties = HashMapBuilder.putAll((Dictionary)configuration.getProperties()).build();
                long configurationCompanyId = ConfigurationFactoryUtil.getCompanyId((CompanyLocalService)this._companyLocalService, (Map)properties);
                if (companyId != configurationCompanyId) continue;
                return (ScimClientOAuth2ApplicationConfiguration)ConfigurableUtil.createConfigurable(ScimClientOAuth2ApplicationConfiguration.class, (Map)properties);
            }
            return null;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Unable to get the SCIM client OAuth 2 application ", "configuration for company ", companyId}), (Throwable)exception);
            }
            return (ScimClientOAuth2ApplicationConfiguration)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    private void _saveScimClientId(String scimClientId, User portalUser) throws PortalException {
        ExpandoColumn expandoColumn;
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchTable(portalUser.getCompanyId(), this._classNameLocalService.getClassNameId(org.wso2.charon3.core.objects.User.class.getName()), "CUSTOM_FIELDS");
        if (expandoTable == null) {
            expandoTable = this._expandoTableLocalService.addTable(portalUser.getCompanyId(), org.wso2.charon3.core.objects.User.class.getName(), "CUSTOM_FIELDS");
        }
        if ((expandoColumn = this._expandoColumnLocalService.fetchColumn(expandoTable.getTableId(), "scimClientId")) == null) {
            expandoColumn = this._expandoColumnLocalService.addColumn(expandoTable.getTableId(), "scimClientId", 15);
        }
        this._expandoValueLocalService.addValue(portalUser.getCompanyId(), org.wso2.charon3.core.objects.User.class.getName(), "CUSTOM_FIELDS", expandoColumn.getName(), portalUser.getUserId(), scimClientId);
    }

    private ScimUser _toScimUser(User portalUser) {
        try {
            ScimUser scimUser = new ScimUser();
            scimUser.setActive(portalUser.isActive());
            scimUser.setBirthday(portalUser.getBirthday());
            scimUser.setCompanyId(portalUser.getCompanyId());
            scimUser.setCreateDate(portalUser.getCreateDate());
            scimUser.setFirstName(portalUser.getFirstName());
            scimUser.setEmailAddress(portalUser.getEmailAddress());
            scimUser.setExternalReferenceCode(portalUser.getExternalReferenceCode());
            scimUser.setId(String.valueOf(portalUser.getUserId()));
            scimUser.setJobTitle(portalUser.getJobTitle());
            scimUser.setLastName(portalUser.getLastName());
            scimUser.setLocale(portalUser.getLocale());
            scimUser.setMale(portalUser.isMale());
            scimUser.setMiddleName(portalUser.getMiddleName());
            scimUser.setModifiedDate(portalUser.getModifiedDate());
            scimUser.setScreenName(portalUser.getScreenName());
            return scimUser;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to convert portal user to a SCIM user", (Throwable)portalException);
            }
            return (ScimUser)ReflectionUtil.throwException((Throwable)portalException);
        }
    }

    private User _updatePortalUser(int birthdayMonth, int birthdayDay, int birthdayYear, User portalUser, ScimUser scimUser, ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration) throws PortalException {
        String scimClientId = ScimClientUtil.generateScimClientId((String)scimClientOAuth2ApplicationConfiguration.oAuth2ApplicationName());
        String portalUserScimClientId = this._getScimClientId(portalUser);
        if (Validator.isNotNull((String)portalUserScimClientId) && !Objects.equals(scimClientId, portalUserScimClientId)) {
            throw new PortalException("User was provisioned by another SCIM client");
        }
        Contact contact = portalUser.getContact();
        if (!Objects.equals((portalUser = this._userLocalService.updateUser(portalUser.getUserId(), scimUser.getPassword(), "", "", false, portalUser.getReminderQueryQuestion(), portalUser.getReminderQueryAnswer(), portalUser.getScreenName(), scimUser.getEmailAddress(), false, null, portalUser.getLanguageId(), portalUser.getTimeZoneId(), portalUser.getGreeting(), portalUser.getComments(), scimUser.getFirstName(), scimUser.getMiddleName(), scimUser.getLastName(), 0L, 0L, scimUser.isMale(), birthdayMonth, birthdayDay, birthdayYear, contact.getSmsSn(), contact.getFacebookSn(), contact.getJabberSn(), contact.getSkypeSn(), contact.getTwitterSn(), scimUser.getJobTitle(), portalUser.getGroupIds(), portalUser.getOrganizationIds(), portalUser.getRoleIds(), null, portalUser.getUserGroupIds(), new ServiceContext())).getExternalReferenceCode(), scimUser.getExternalReferenceCode())) {
            portalUser.setExternalReferenceCode(scimUser.getExternalReferenceCode());
            portalUser = this._userLocalService.updateUser(portalUser);
        }
        if (!portalUser.isActive()) {
            portalUser = this._userLocalService.updateStatus(portalUser.getUserId(), 0, new ServiceContext());
        }
        if (Validator.isNull((String)portalUserScimClientId)) {
            this._saveScimClientId(scimClientId, portalUser);
        }
        return portalUser;
    }
}

