/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.upgrade.v0_0_1;

import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.UnicodeProperties;

public class ExpandoColumnUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final CompanyLocalService _companyLocalService;
    private final ExpandoColumnLocalService _expandoColumnLocalService;
    private final ExpandoTableLocalService _expandoTableLocalService;

    public ExpandoColumnUpgradeProcess(ClassNameLocalService classNameLocalService, CompanyLocalService companyLocalService, ExpandoColumnLocalService expandoColumnLocalService, ExpandoTableLocalService expandoTableLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._companyLocalService = companyLocalService;
        this._expandoColumnLocalService = expandoColumnLocalService;
        this._expandoTableLocalService = expandoTableLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._companyLocalService.forEachCompanyId(companyId -> {
            try (LoggingTimer loggingTimer = new LoggingTimer(String.valueOf(companyId));){
                this._updateExpandoColumn((long)companyId, User.class.getName());
                this._updateExpandoColumn((long)companyId, UserGroup.class.getName());
            }
        });
    }

    private void _updateExpandoColumn(long companyId, String className) {
        ExpandoTable expandoTable = this._expandoTableLocalService.fetchTable(companyId, this._classNameLocalService.getClassNameId(className), "CUSTOM_FIELDS");
        if (expandoTable == null) {
            return;
        }
        ExpandoColumn expandoColumn = this._expandoColumnLocalService.fetchColumn(expandoTable.getTableId(), "scimClientId");
        if (expandoColumn == null) {
            return;
        }
        UnicodeProperties unicodeProperties = expandoColumn.getTypeSettingsProperties();
        unicodeProperties.setProperty("hidden", Boolean.TRUE.toString());
        expandoColumn.setTypeSettingsProperties(unicodeProperties);
        this._expandoColumnLocalService.updateExpandoColumn(expandoColumn);
    }
}

