/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.provider;

import com.liferay.oauth2.provider.rest.spi.bearer.token.provider.BearerTokenProvider;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.BigEndianCodec;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import java.util.concurrent.TimeUnit;

public class ScimClientBearerTokenProvider
implements BearerTokenProvider {
    public boolean isValid(BearerTokenProvider.AccessToken accessToken) {
        return this.isValid(accessToken.getExpiresIn(), accessToken.getIssuedAt());
    }

    public void onBeforeCreate(BearerTokenProvider.AccessToken accessToken) {
        accessToken.setExpiresIn(TimeUnit.DAYS.toSeconds(365L));
        accessToken.setTokenKey(this.generateTokenKey(32));
    }

    protected String generateTokenKey(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size is less than 0");
        }
        int count = (int)Math.ceil((double)size / 8.0);
        byte[] bytes = new byte[count * 8];
        for (int i = 0; i < count; ++i) {
            BigEndianCodec.putLong((byte[])bytes, (int)(i * 8), (long)SecureRandomUtil.nextLong());
        }
        StringBundler sb = new StringBundler(size);
        for (int i = 0; i < size; ++i) {
            sb.append(Integer.toHexString(0xFF & bytes[i]));
        }
        return sb.toString();
    }

    protected boolean isValid(long expiresIn, long issuedAt) {
        long expiresInMillis = expiresIn * 1000L;
        if (expiresInMillis < 0L) {
            return false;
        }
        long issuedAtMillis = issuedAt * 1000L;
        return issuedAtMillis <= System.currentTimeMillis() && issuedAtMillis + expiresInMillis >= System.currentTimeMillis();
    }
}

