/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.configuration;

import com.liferay.oauth.client.LocalOAuthClient;
import com.liferay.oauth2.provider.constants.ClientProfile;
import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.rest.spi.bearer.token.provider.BearerTokenProvider;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.oauth2.provider.util.OAuth2SecureRandomGenerator;
import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.scim.rest.internal.configuration.ScimClientOAuth2ApplicationConfiguration;
import com.liferay.scim.rest.internal.provider.ScimClientBearerTokenProvider;
import com.liferay.scim.rest.internal.util.ScimClientUtil;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.scim.rest.internal.configuration.ScimClientOAuth2ApplicationConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class ScimClientOAuth2ApplicationConfigurationFactory {
    @Reference
    protected UserLocalService userLocalService;
    private static final Log _log = LogFactoryUtil.getLog(ScimClientOAuth2ApplicationConfigurationFactory.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private LocalOAuthClient _localOAuthClient;
    private volatile OAuth2Application _oAuth2Application;
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    private volatile ServiceRegistration<BearerTokenProvider> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-96845")) {
            return;
        }
        ConfigurationFactoryUtil.executeAsCompany((CompanyLocalService)this._companyLocalService, properties, companyId -> {
            ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration = (ScimClientOAuth2ApplicationConfiguration)ConfigurableUtil.createConfigurable(ScimClientOAuth2ApplicationConfiguration.class, (Map)properties);
            this._oAuth2Application = this._getOrAddOAuth2Application((long)companyId, scimClientOAuth2ApplicationConfiguration);
            this._serviceRegistration = bundleContext.registerService(BearerTokenProvider.class, (Object)new ScimClientBearerTokenProvider(), (Dictionary)HashMapDictionaryBuilder.put((Object)"clientId", (Object)this._oAuth2Application.getClientId()).put((Object)"companyId", (Object)companyId.toString()).build());
            JSONObject jsonObject = this._jsonFactory.createJSONObject(this._localOAuthClient.requestTokens(this._oAuth2Application, this.userLocalService.getGuestUser(companyId.longValue()).getUserId()));
            if (_log.isInfoEnabled()) {
                _log.info((Object)StringBundler.concat((String[])new String[]{"New access token for SCIM OAuth 2 application ", this._oAuth2Application.getName(), " generated: ", jsonObject.getString("access_token")}));
            }
        });
    }

    @Deactivate
    protected void deactivate(Integer reason) throws PortalException {
        if (!FeatureFlagManagerUtil.isEnabled((String)"LPS-96845") || reason != 4) {
            return;
        }
        this._oAuth2ApplicationLocalService.deleteOAuth2Application(this._oAuth2Application);
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
            this._serviceRegistration = null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Removed OAuth2 application: " + this._oAuth2Application.getName()));
        }
    }

    private OAuth2Application _getOrAddOAuth2Application(long companyId, ScimClientOAuth2ApplicationConfiguration scimClientOAuth2ApplicationConfiguration) throws Exception {
        User user = this.userLocalService.getGuestUser(companyId);
        User clientCredentialUser = this.userLocalService.getUserByScreenName(companyId, PropsValues.DEFAULT_ADMIN_SCREEN_NAME);
        String clientId = ScimClientUtil.generateScimClientId(scimClientOAuth2ApplicationConfiguration.applicationName());
        OAuth2Application oAuth2Application = this._oAuth2ApplicationLocalService.fetchOAuth2Application(companyId, clientId);
        if (oAuth2Application == null) {
            oAuth2Application = this._oAuth2ApplicationLocalService.addOAuth2Application(companyId, user.getUserId(), user.getScreenName(), ListUtil.fromArray((Object[])new GrantType[]{GrantType.JWT_BEARER}), "client_secret_post", clientCredentialUser.getUserId(), clientId, ClientProfile.HEADLESS_SERVER.id(), OAuth2SecureRandomGenerator.generateClientSecret(), null, Collections.emptyList(), null, 0L, null, scimClientOAuth2ApplicationConfiguration.applicationName(), null, Collections.emptyList(), false, true, null, new ServiceContext());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Created OAuth2 application: " + oAuth2Application.getName()));
            }
        }
        return this._oAuth2ApplicationLocalService.updateScopeAliases(oAuth2Application.getUserId(), oAuth2Application.getUserName(), oAuth2Application.getOAuth2ApplicationId(), ListUtil.fromArray((Object[])new String[]{"Liferay.Scim.REST.everything"}));
    }
}

