/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.scim.rest.internal.resource.v1_0;

import com.liferay.expando.kernel.service.ExpandoColumnLocalService;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.expando.kernel.service.ExpandoValueLocalService;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.scim.rest.dto.v1_0.User;
import com.liferay.scim.rest.internal.manager.UserManagerImpl;
import com.liferay.scim.rest.internal.resource.v1_0.BaseUserResourceImpl;
import com.liferay.scim.rest.resource.v1_0.UserResource;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.wso2.charon3.core.config.SCIMUserSchemaExtensionBuilder;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.protocol.endpoints.UserResourceManager;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/user.properties"}, scope=ServiceScope.PROTOTYPE, service={UserResource.class})
public class UserResourceImpl
extends BaseUserResourceImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ExpandoColumnLocalService _expandoColumnLocalService;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private ExpandoValueLocalService _expandoValueLocalService;
    @Reference
    private com.liferay.portal.kernel.util.File _file;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private UserLocalService _userLocalService;
    private UserManager _userManager;
    private final UserResourceManager _userResourceManager = new UserResourceManager();

    @Override
    public Object getV2User(Integer count, Integer startIndex) throws Exception {
        return this._buildResponse(this._userResourceManager.listWithGET(this._userManager, null, startIndex, count, null, null, null, null, null));
    }

    @Override
    public Object getV2UserById(String id) throws Exception {
        return this._buildResponse(this._userResourceManager.get(id, this._userManager, null, null));
    }

    @Override
    public Response postV2User(User user) throws Exception {
        return this._buildResponse(this._userResourceManager.create(user.toString(), this._userManager, null, null));
    }

    @Override
    public Response putV2User(String id, User user) throws Exception {
        return this._buildResponse(this._userResourceManager.updateWithPUT(id, user.toString(), this._userManager, null, null));
    }

    @Activate
    protected void activate() throws Exception {
        AbstractResourceManager.setEndpointURLMap(Collections.singletonMap("/Users", "/o/scim/Users"));
        this._registerLiferayUserSchemaExtension();
        this._userManager = new UserManagerImpl(this._classNameLocalService, this._companyLocalService, this._configurationAdmin, this._expandoColumnLocalService, this._expandoTableLocalService, this._expandoValueLocalService, this._userLocalService);
    }

    private Response _buildResponse(SCIMResponse scimResponse) {
        Response.ResponseBuilder responseBuilder = Response.status((int)scimResponse.getResponseStatus());
        Map map = scimResponse.getHeaderParamMap();
        if (MapUtil.isNotEmpty((Map)map)) {
            for (Map.Entry entry : map.entrySet()) {
                responseBuilder.header((String)entry.getKey(), entry.getValue());
            }
        }
        if (scimResponse.getResponseMessage() != null) {
            responseBuilder.entity((Object)scimResponse.getResponseMessage());
        }
        return responseBuilder.build();
    }

    private void _registerLiferayUserSchemaExtension() throws Exception {
        SCIMUserSchemaExtensionBuilder scimUserSchemaExtensionBuilder = SCIMUserSchemaExtensionBuilder.getInstance();
        String json = JSONUtil.putAll((Object[])new Object[]{JSONUtil.put((String)"attributeName", (Object)"birthday").put("attributeURI", "urn:ietf:params:scim:schemas:extension:liferay:2.0:User:birthday").put("canonicalValues", this._jsonFactory.createJSONArray()).put("caseExact", "false").put("dataType", "string").put("description", "User's birthday").put("multiValued", "false").put("mutability", "readWrite").put("referenceTypes", this._jsonFactory.createJSONArray()).put("required", "false").put("returned", "default").put("subAttributes", "null").put("uniqueness", "none"), JSONUtil.put((String)"attributeName", (Object)"male").put("attributeURI", "urn:ietf:params:scim:schemas:extension:liferay:2.0:User:male").put("canonicalValues", this._jsonFactory.createJSONArray()).put("caseExact", "false").put("dataType", "boolean").put("description", "User's gender").put("multiValued", "false").put("mutability", "readWrite").put("referenceTypes", this._jsonFactory.createJSONArray()).put("required", "false").put("returned", "default").put("subAttributes", "null").put("uniqueness", "none"), JSONUtil.put((String)"attributeName", (Object)"urn:ietf:params:scim:schemas:extension:liferay:2.0:User").put("attributeURI", "urn:ietf:params:scim:schemas:extension:liferay:2.0:User").put("canonicalValues", this._jsonFactory.createJSONArray()).put("caseExact", "false").put("dataType", "complex").put("description", "Liferay's User Schema Extension").put("multiValued", "false").put("mutability", "readWrite").put("referenceTypes", JSONUtil.put((Object)"external")).put("required", "false").put("returned", "default").put("subAttributes", "birthday male").put("uniqueness", "none")}).toString();
        File file = this._file.createTempFile(json.getBytes());
        scimUserSchemaExtensionBuilder.buildUserSchemaExtension(file.getPath());
    }
}

