/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.saml.persistence.model;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ShardedModel;
import com.liferay.portal.kernel.service.ServiceContext;

import java.io.Serializable;

import java.util.Date;

/**
 * The base model interface for the SamlIdpSpSession service. Represents a row in the &quot;SamlIdpSpSession&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.saml.persistence.model.impl.SamlIdpSpSessionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.saml.persistence.model.impl.SamlIdpSpSessionImpl</code>.
 * </p>
 *
 * @author Mika Koivisto
 * @see SamlIdpSpSession
 * @generated
 */
@ProviderType
public interface SamlIdpSpSessionModel extends AuditedModel,
	BaseModel<SamlIdpSpSession>, ShardedModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a saml idp sp session model instance should use the {@link SamlIdpSpSession} interface instead.
	 */

	/**
	 * Returns the primary key of this saml idp sp session.
	 *
	 * @return the primary key of this saml idp sp session
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this saml idp sp session.
	 *
	 * @param primaryKey the primary key of this saml idp sp session
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the saml idp sp session ID of this saml idp sp session.
	 *
	 * @return the saml idp sp session ID of this saml idp sp session
	 */
	public long getSamlIdpSpSessionId();

	/**
	 * Sets the saml idp sp session ID of this saml idp sp session.
	 *
	 * @param samlIdpSpSessionId the saml idp sp session ID of this saml idp sp session
	 */
	public void setSamlIdpSpSessionId(long samlIdpSpSessionId);

	/**
	 * Returns the company ID of this saml idp sp session.
	 *
	 * @return the company ID of this saml idp sp session
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this saml idp sp session.
	 *
	 * @param companyId the company ID of this saml idp sp session
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this saml idp sp session.
	 *
	 * @return the user ID of this saml idp sp session
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this saml idp sp session.
	 *
	 * @param userId the user ID of this saml idp sp session
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this saml idp sp session.
	 *
	 * @return the user uuid of this saml idp sp session
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this saml idp sp session.
	 *
	 * @param userUuid the user uuid of this saml idp sp session
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this saml idp sp session.
	 *
	 * @return the user name of this saml idp sp session
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this saml idp sp session.
	 *
	 * @param userName the user name of this saml idp sp session
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this saml idp sp session.
	 *
	 * @return the create date of this saml idp sp session
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this saml idp sp session.
	 *
	 * @param createDate the create date of this saml idp sp session
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this saml idp sp session.
	 *
	 * @return the modified date of this saml idp sp session
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this saml idp sp session.
	 *
	 * @param modifiedDate the modified date of this saml idp sp session
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the saml idp sso session ID of this saml idp sp session.
	 *
	 * @return the saml idp sso session ID of this saml idp sp session
	 */
	public long getSamlIdpSsoSessionId();

	/**
	 * Sets the saml idp sso session ID of this saml idp sp session.
	 *
	 * @param samlIdpSsoSessionId the saml idp sso session ID of this saml idp sp session
	 */
	public void setSamlIdpSsoSessionId(long samlIdpSsoSessionId);

	/**
	 * Returns the saml sp entity ID of this saml idp sp session.
	 *
	 * @return the saml sp entity ID of this saml idp sp session
	 */
	@AutoEscape
	public String getSamlSpEntityId();

	/**
	 * Sets the saml sp entity ID of this saml idp sp session.
	 *
	 * @param samlSpEntityId the saml sp entity ID of this saml idp sp session
	 */
	public void setSamlSpEntityId(String samlSpEntityId);

	/**
	 * Returns the name ID format of this saml idp sp session.
	 *
	 * @return the name ID format of this saml idp sp session
	 */
	@AutoEscape
	public String getNameIdFormat();

	/**
	 * Sets the name ID format of this saml idp sp session.
	 *
	 * @param nameIdFormat the name ID format of this saml idp sp session
	 */
	public void setNameIdFormat(String nameIdFormat);

	/**
	 * Returns the name ID value of this saml idp sp session.
	 *
	 * @return the name ID value of this saml idp sp session
	 */
	@AutoEscape
	public String getNameIdValue();

	/**
	 * Sets the name ID value of this saml idp sp session.
	 *
	 * @param nameIdValue the name ID value of this saml idp sp session
	 */
	public void setNameIdValue(String nameIdValue);

	@Override
	public boolean isNew();

	@Override
	public void setNew(boolean n);

	@Override
	public boolean isCachedModel();

	@Override
	public void setCachedModel(boolean cachedModel);

	@Override
	public boolean isEscapedModel();

	@Override
	public Serializable getPrimaryKeyObj();

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj);

	@Override
	public ExpandoBridge getExpandoBridge();

	@Override
	public void setExpandoBridgeAttributes(BaseModel<?> baseModel);

	@Override
	public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge);

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext);

	@Override
	public Object clone();

	@Override
	public int compareTo(SamlIdpSpSession samlIdpSpSession);

	@Override
	public int hashCode();

	@Override
	public CacheModel<SamlIdpSpSession> toCacheModel();

	@Override
	public SamlIdpSpSession toEscapedModel();

	@Override
	public SamlIdpSpSession toUnescapedModel();

	@Override
	public String toString();

	@Override
	public String toXmlString();
}