/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.saml.persistence.service.persistence;

import aQute.bnd.annotation.ProviderType;

import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;

import com.liferay.saml.persistence.model.SamlIdpSpSession;

import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import org.osgi.util.tracker.ServiceTracker;

import java.util.Date;
import java.util.List;

/**
 * The persistence utility for the saml idp sp session service. This utility wraps {@link com.liferay.saml.persistence.service.persistence.impl.SamlIdpSpSessionPersistenceImpl} and provides direct access to the database for CRUD operations. This utility should only be used by the service layer, as it must operate within a transaction. Never access this utility in a JSP, controller, model, or other front-end class.
 *
 * <p>
 * Caching information and settings can be found in <code>portal.properties</code>
 * </p>
 *
 * @author Mika Koivisto
 * @see SamlIdpSpSessionPersistence
 * @see com.liferay.saml.persistence.service.persistence.impl.SamlIdpSpSessionPersistenceImpl
 * @generated
 */
@ProviderType
public class SamlIdpSpSessionUtil {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify this class directly. Modify <code>service.xml</code> and rerun ServiceBuilder to regenerate this class.
	 */

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#clearCache()
	 */
	public static void clearCache() {
		getPersistence().clearCache();
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#clearCache(com.liferay.portal.kernel.model.BaseModel)
	 */
	public static void clearCache(SamlIdpSpSession samlIdpSpSession) {
		getPersistence().clearCache(samlIdpSpSession);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#countWithDynamicQuery(DynamicQuery)
	 */
	public static long countWithDynamicQuery(DynamicQuery dynamicQuery) {
		return getPersistence().countWithDynamicQuery(dynamicQuery);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery)
	 */
	public static List<SamlIdpSpSession> findWithDynamicQuery(
		DynamicQuery dynamicQuery) {
		return getPersistence().findWithDynamicQuery(dynamicQuery);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int)
	 */
	public static List<SamlIdpSpSession> findWithDynamicQuery(
		DynamicQuery dynamicQuery, int start, int end) {
		return getPersistence().findWithDynamicQuery(dynamicQuery, start, end);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#findWithDynamicQuery(DynamicQuery, int, int, OrderByComparator)
	 */
	public static List<SamlIdpSpSession> findWithDynamicQuery(
		DynamicQuery dynamicQuery, int start, int end,
		OrderByComparator<SamlIdpSpSession> orderByComparator) {
		return getPersistence()
				   .findWithDynamicQuery(dynamicQuery, start, end,
			orderByComparator);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#update(com.liferay.portal.kernel.model.BaseModel)
	 */
	public static SamlIdpSpSession update(SamlIdpSpSession samlIdpSpSession) {
		return getPersistence().update(samlIdpSpSession);
	}

	/**
	 * @see com.liferay.portal.kernel.service.persistence.BasePersistence#update(com.liferay.portal.kernel.model.BaseModel, ServiceContext)
	 */
	public static SamlIdpSpSession update(SamlIdpSpSession samlIdpSpSession,
		ServiceContext serviceContext) {
		return getPersistence().update(samlIdpSpSession, serviceContext);
	}

	/**
	* Returns all the saml idp sp sessions where createDate &lt; &#63;.
	*
	* @param createDate the create date
	* @return the matching saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findByCreateDate(Date createDate) {
		return getPersistence().findByCreateDate(createDate);
	}

	/**
	* Returns a range of all the saml idp sp sessions where createDate &lt; &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link SamlIdpSpSessionModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param createDate the create date
	* @param start the lower bound of the range of saml idp sp sessions
	* @param end the upper bound of the range of saml idp sp sessions (not inclusive)
	* @return the range of matching saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findByCreateDate(Date createDate,
		int start, int end) {
		return getPersistence().findByCreateDate(createDate, start, end);
	}

	/**
	* Returns an ordered range of all the saml idp sp sessions where createDate &lt; &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link SamlIdpSpSessionModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param createDate the create date
	* @param start the lower bound of the range of saml idp sp sessions
	* @param end the upper bound of the range of saml idp sp sessions (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findByCreateDate(Date createDate,
		int start, int end,
		OrderByComparator<SamlIdpSpSession> orderByComparator) {
		return getPersistence()
				   .findByCreateDate(createDate, start, end, orderByComparator);
	}

	/**
	* Returns an ordered range of all the saml idp sp sessions where createDate &lt; &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link SamlIdpSpSessionModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param createDate the create date
	* @param start the lower bound of the range of saml idp sp sessions
	* @param end the upper bound of the range of saml idp sp sessions (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @param retrieveFromCache whether to retrieve from the finder cache
	* @return the ordered range of matching saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findByCreateDate(Date createDate,
		int start, int end,
		OrderByComparator<SamlIdpSpSession> orderByComparator,
		boolean retrieveFromCache) {
		return getPersistence()
				   .findByCreateDate(createDate, start, end, orderByComparator,
			retrieveFromCache);
	}

	/**
	* Returns the first saml idp sp session in the ordered set where createDate &lt; &#63;.
	*
	* @param createDate the create date
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching saml idp sp session
	* @throws NoSuchIdpSpSessionException if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession findByCreateDate_First(Date createDate,
		OrderByComparator<SamlIdpSpSession> orderByComparator)
		throws com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException {
		return getPersistence()
				   .findByCreateDate_First(createDate, orderByComparator);
	}

	/**
	* Returns the first saml idp sp session in the ordered set where createDate &lt; &#63;.
	*
	* @param createDate the create date
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching saml idp sp session, or <code>null</code> if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession fetchByCreateDate_First(Date createDate,
		OrderByComparator<SamlIdpSpSession> orderByComparator) {
		return getPersistence()
				   .fetchByCreateDate_First(createDate, orderByComparator);
	}

	/**
	* Returns the last saml idp sp session in the ordered set where createDate &lt; &#63;.
	*
	* @param createDate the create date
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching saml idp sp session
	* @throws NoSuchIdpSpSessionException if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession findByCreateDate_Last(Date createDate,
		OrderByComparator<SamlIdpSpSession> orderByComparator)
		throws com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException {
		return getPersistence()
				   .findByCreateDate_Last(createDate, orderByComparator);
	}

	/**
	* Returns the last saml idp sp session in the ordered set where createDate &lt; &#63;.
	*
	* @param createDate the create date
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching saml idp sp session, or <code>null</code> if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession fetchByCreateDate_Last(Date createDate,
		OrderByComparator<SamlIdpSpSession> orderByComparator) {
		return getPersistence()
				   .fetchByCreateDate_Last(createDate, orderByComparator);
	}

	/**
	* Returns the saml idp sp sessions before and after the current saml idp sp session in the ordered set where createDate &lt; &#63;.
	*
	* @param samlIdpSpSessionId the primary key of the current saml idp sp session
	* @param createDate the create date
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next saml idp sp session
	* @throws NoSuchIdpSpSessionException if a saml idp sp session with the primary key could not be found
	*/
	public static SamlIdpSpSession[] findByCreateDate_PrevAndNext(
		long samlIdpSpSessionId, Date createDate,
		OrderByComparator<SamlIdpSpSession> orderByComparator)
		throws com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException {
		return getPersistence()
				   .findByCreateDate_PrevAndNext(samlIdpSpSessionId,
			createDate, orderByComparator);
	}

	/**
	* Removes all the saml idp sp sessions where createDate &lt; &#63; from the database.
	*
	* @param createDate the create date
	*/
	public static void removeByCreateDate(Date createDate) {
		getPersistence().removeByCreateDate(createDate);
	}

	/**
	* Returns the number of saml idp sp sessions where createDate &lt; &#63;.
	*
	* @param createDate the create date
	* @return the number of matching saml idp sp sessions
	*/
	public static int countByCreateDate(Date createDate) {
		return getPersistence().countByCreateDate(createDate);
	}

	/**
	* Returns all the saml idp sp sessions where samlIdpSsoSessionId = &#63;.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @return the matching saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findBySamlIdpSsoSessionId(
		long samlIdpSsoSessionId) {
		return getPersistence().findBySamlIdpSsoSessionId(samlIdpSsoSessionId);
	}

	/**
	* Returns a range of all the saml idp sp sessions where samlIdpSsoSessionId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link SamlIdpSpSessionModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param start the lower bound of the range of saml idp sp sessions
	* @param end the upper bound of the range of saml idp sp sessions (not inclusive)
	* @return the range of matching saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findBySamlIdpSsoSessionId(
		long samlIdpSsoSessionId, int start, int end) {
		return getPersistence()
				   .findBySamlIdpSsoSessionId(samlIdpSsoSessionId, start, end);
	}

	/**
	* Returns an ordered range of all the saml idp sp sessions where samlIdpSsoSessionId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link SamlIdpSpSessionModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param start the lower bound of the range of saml idp sp sessions
	* @param end the upper bound of the range of saml idp sp sessions (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of matching saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findBySamlIdpSsoSessionId(
		long samlIdpSsoSessionId, int start, int end,
		OrderByComparator<SamlIdpSpSession> orderByComparator) {
		return getPersistence()
				   .findBySamlIdpSsoSessionId(samlIdpSsoSessionId, start, end,
			orderByComparator);
	}

	/**
	* Returns an ordered range of all the saml idp sp sessions where samlIdpSsoSessionId = &#63;.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link SamlIdpSpSessionModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param start the lower bound of the range of saml idp sp sessions
	* @param end the upper bound of the range of saml idp sp sessions (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @param retrieveFromCache whether to retrieve from the finder cache
	* @return the ordered range of matching saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findBySamlIdpSsoSessionId(
		long samlIdpSsoSessionId, int start, int end,
		OrderByComparator<SamlIdpSpSession> orderByComparator,
		boolean retrieveFromCache) {
		return getPersistence()
				   .findBySamlIdpSsoSessionId(samlIdpSsoSessionId, start, end,
			orderByComparator, retrieveFromCache);
	}

	/**
	* Returns the first saml idp sp session in the ordered set where samlIdpSsoSessionId = &#63;.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching saml idp sp session
	* @throws NoSuchIdpSpSessionException if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession findBySamlIdpSsoSessionId_First(
		long samlIdpSsoSessionId,
		OrderByComparator<SamlIdpSpSession> orderByComparator)
		throws com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException {
		return getPersistence()
				   .findBySamlIdpSsoSessionId_First(samlIdpSsoSessionId,
			orderByComparator);
	}

	/**
	* Returns the first saml idp sp session in the ordered set where samlIdpSsoSessionId = &#63;.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the first matching saml idp sp session, or <code>null</code> if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession fetchBySamlIdpSsoSessionId_First(
		long samlIdpSsoSessionId,
		OrderByComparator<SamlIdpSpSession> orderByComparator) {
		return getPersistence()
				   .fetchBySamlIdpSsoSessionId_First(samlIdpSsoSessionId,
			orderByComparator);
	}

	/**
	* Returns the last saml idp sp session in the ordered set where samlIdpSsoSessionId = &#63;.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching saml idp sp session
	* @throws NoSuchIdpSpSessionException if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession findBySamlIdpSsoSessionId_Last(
		long samlIdpSsoSessionId,
		OrderByComparator<SamlIdpSpSession> orderByComparator)
		throws com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException {
		return getPersistence()
				   .findBySamlIdpSsoSessionId_Last(samlIdpSsoSessionId,
			orderByComparator);
	}

	/**
	* Returns the last saml idp sp session in the ordered set where samlIdpSsoSessionId = &#63;.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the last matching saml idp sp session, or <code>null</code> if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession fetchBySamlIdpSsoSessionId_Last(
		long samlIdpSsoSessionId,
		OrderByComparator<SamlIdpSpSession> orderByComparator) {
		return getPersistence()
				   .fetchBySamlIdpSsoSessionId_Last(samlIdpSsoSessionId,
			orderByComparator);
	}

	/**
	* Returns the saml idp sp sessions before and after the current saml idp sp session in the ordered set where samlIdpSsoSessionId = &#63;.
	*
	* @param samlIdpSpSessionId the primary key of the current saml idp sp session
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param orderByComparator the comparator to order the set by (optionally <code>null</code>)
	* @return the previous, current, and next saml idp sp session
	* @throws NoSuchIdpSpSessionException if a saml idp sp session with the primary key could not be found
	*/
	public static SamlIdpSpSession[] findBySamlIdpSsoSessionId_PrevAndNext(
		long samlIdpSpSessionId, long samlIdpSsoSessionId,
		OrderByComparator<SamlIdpSpSession> orderByComparator)
		throws com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException {
		return getPersistence()
				   .findBySamlIdpSsoSessionId_PrevAndNext(samlIdpSpSessionId,
			samlIdpSsoSessionId, orderByComparator);
	}

	/**
	* Removes all the saml idp sp sessions where samlIdpSsoSessionId = &#63; from the database.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	*/
	public static void removeBySamlIdpSsoSessionId(long samlIdpSsoSessionId) {
		getPersistence().removeBySamlIdpSsoSessionId(samlIdpSsoSessionId);
	}

	/**
	* Returns the number of saml idp sp sessions where samlIdpSsoSessionId = &#63;.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @return the number of matching saml idp sp sessions
	*/
	public static int countBySamlIdpSsoSessionId(long samlIdpSsoSessionId) {
		return getPersistence().countBySamlIdpSsoSessionId(samlIdpSsoSessionId);
	}

	/**
	* Returns the saml idp sp session where samlIdpSsoSessionId = &#63; and samlSpEntityId = &#63; or throws a {@link NoSuchIdpSpSessionException} if it could not be found.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param samlSpEntityId the saml sp entity ID
	* @return the matching saml idp sp session
	* @throws NoSuchIdpSpSessionException if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession findBySISSI_SSEI(long samlIdpSsoSessionId,
		String samlSpEntityId)
		throws com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException {
		return getPersistence()
				   .findBySISSI_SSEI(samlIdpSsoSessionId, samlSpEntityId);
	}

	/**
	* Returns the saml idp sp session where samlIdpSsoSessionId = &#63; and samlSpEntityId = &#63; or returns <code>null</code> if it could not be found. Uses the finder cache.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param samlSpEntityId the saml sp entity ID
	* @return the matching saml idp sp session, or <code>null</code> if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession fetchBySISSI_SSEI(long samlIdpSsoSessionId,
		String samlSpEntityId) {
		return getPersistence()
				   .fetchBySISSI_SSEI(samlIdpSsoSessionId, samlSpEntityId);
	}

	/**
	* Returns the saml idp sp session where samlIdpSsoSessionId = &#63; and samlSpEntityId = &#63; or returns <code>null</code> if it could not be found, optionally using the finder cache.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param samlSpEntityId the saml sp entity ID
	* @param retrieveFromCache whether to retrieve from the finder cache
	* @return the matching saml idp sp session, or <code>null</code> if a matching saml idp sp session could not be found
	*/
	public static SamlIdpSpSession fetchBySISSI_SSEI(long samlIdpSsoSessionId,
		String samlSpEntityId, boolean retrieveFromCache) {
		return getPersistence()
				   .fetchBySISSI_SSEI(samlIdpSsoSessionId, samlSpEntityId,
			retrieveFromCache);
	}

	/**
	* Removes the saml idp sp session where samlIdpSsoSessionId = &#63; and samlSpEntityId = &#63; from the database.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param samlSpEntityId the saml sp entity ID
	* @return the saml idp sp session that was removed
	*/
	public static SamlIdpSpSession removeBySISSI_SSEI(
		long samlIdpSsoSessionId, String samlSpEntityId)
		throws com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException {
		return getPersistence()
				   .removeBySISSI_SSEI(samlIdpSsoSessionId, samlSpEntityId);
	}

	/**
	* Returns the number of saml idp sp sessions where samlIdpSsoSessionId = &#63; and samlSpEntityId = &#63;.
	*
	* @param samlIdpSsoSessionId the saml idp sso session ID
	* @param samlSpEntityId the saml sp entity ID
	* @return the number of matching saml idp sp sessions
	*/
	public static int countBySISSI_SSEI(long samlIdpSsoSessionId,
		String samlSpEntityId) {
		return getPersistence()
				   .countBySISSI_SSEI(samlIdpSsoSessionId, samlSpEntityId);
	}

	/**
	* Caches the saml idp sp session in the entity cache if it is enabled.
	*
	* @param samlIdpSpSession the saml idp sp session
	*/
	public static void cacheResult(SamlIdpSpSession samlIdpSpSession) {
		getPersistence().cacheResult(samlIdpSpSession);
	}

	/**
	* Caches the saml idp sp sessions in the entity cache if it is enabled.
	*
	* @param samlIdpSpSessions the saml idp sp sessions
	*/
	public static void cacheResult(List<SamlIdpSpSession> samlIdpSpSessions) {
		getPersistence().cacheResult(samlIdpSpSessions);
	}

	/**
	* Creates a new saml idp sp session with the primary key. Does not add the saml idp sp session to the database.
	*
	* @param samlIdpSpSessionId the primary key for the new saml idp sp session
	* @return the new saml idp sp session
	*/
	public static SamlIdpSpSession create(long samlIdpSpSessionId) {
		return getPersistence().create(samlIdpSpSessionId);
	}

	/**
	* Removes the saml idp sp session with the primary key from the database. Also notifies the appropriate model listeners.
	*
	* @param samlIdpSpSessionId the primary key of the saml idp sp session
	* @return the saml idp sp session that was removed
	* @throws NoSuchIdpSpSessionException if a saml idp sp session with the primary key could not be found
	*/
	public static SamlIdpSpSession remove(long samlIdpSpSessionId)
		throws com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException {
		return getPersistence().remove(samlIdpSpSessionId);
	}

	public static SamlIdpSpSession updateImpl(SamlIdpSpSession samlIdpSpSession) {
		return getPersistence().updateImpl(samlIdpSpSession);
	}

	/**
	* Returns the saml idp sp session with the primary key or throws a {@link NoSuchIdpSpSessionException} if it could not be found.
	*
	* @param samlIdpSpSessionId the primary key of the saml idp sp session
	* @return the saml idp sp session
	* @throws NoSuchIdpSpSessionException if a saml idp sp session with the primary key could not be found
	*/
	public static SamlIdpSpSession findByPrimaryKey(long samlIdpSpSessionId)
		throws com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException {
		return getPersistence().findByPrimaryKey(samlIdpSpSessionId);
	}

	/**
	* Returns the saml idp sp session with the primary key or returns <code>null</code> if it could not be found.
	*
	* @param samlIdpSpSessionId the primary key of the saml idp sp session
	* @return the saml idp sp session, or <code>null</code> if a saml idp sp session with the primary key could not be found
	*/
	public static SamlIdpSpSession fetchByPrimaryKey(long samlIdpSpSessionId) {
		return getPersistence().fetchByPrimaryKey(samlIdpSpSessionId);
	}

	public static java.util.Map<java.io.Serializable, SamlIdpSpSession> fetchByPrimaryKeys(
		java.util.Set<java.io.Serializable> primaryKeys) {
		return getPersistence().fetchByPrimaryKeys(primaryKeys);
	}

	/**
	* Returns all the saml idp sp sessions.
	*
	* @return the saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findAll() {
		return getPersistence().findAll();
	}

	/**
	* Returns a range of all the saml idp sp sessions.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link SamlIdpSpSessionModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of saml idp sp sessions
	* @param end the upper bound of the range of saml idp sp sessions (not inclusive)
	* @return the range of saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findAll(int start, int end) {
		return getPersistence().findAll(start, end);
	}

	/**
	* Returns an ordered range of all the saml idp sp sessions.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link SamlIdpSpSessionModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of saml idp sp sessions
	* @param end the upper bound of the range of saml idp sp sessions (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @return the ordered range of saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findAll(int start, int end,
		OrderByComparator<SamlIdpSpSession> orderByComparator) {
		return getPersistence().findAll(start, end, orderByComparator);
	}

	/**
	* Returns an ordered range of all the saml idp sp sessions.
	*
	* <p>
	* Useful when paginating results. Returns a maximum of <code>end - start</code> instances. <code>start</code> and <code>end</code> are not primary keys, they are indexes in the result set. Thus, <code>0</code> refers to the first result in the set. Setting both <code>start</code> and <code>end</code> to {@link QueryUtil#ALL_POS} will return the full result set. If <code>orderByComparator</code> is specified, then the query will include the given ORDER BY logic. If <code>orderByComparator</code> is absent and pagination is required (<code>start</code> and <code>end</code> are not {@link QueryUtil#ALL_POS}), then the query will include the default ORDER BY logic from {@link SamlIdpSpSessionModelImpl}. If both <code>orderByComparator</code> and pagination are absent, for performance reasons, the query will not have an ORDER BY clause and the returned result set will be sorted on by the primary key in an ascending order.
	* </p>
	*
	* @param start the lower bound of the range of saml idp sp sessions
	* @param end the upper bound of the range of saml idp sp sessions (not inclusive)
	* @param orderByComparator the comparator to order the results by (optionally <code>null</code>)
	* @param retrieveFromCache whether to retrieve from the finder cache
	* @return the ordered range of saml idp sp sessions
	*/
	public static List<SamlIdpSpSession> findAll(int start, int end,
		OrderByComparator<SamlIdpSpSession> orderByComparator,
		boolean retrieveFromCache) {
		return getPersistence()
				   .findAll(start, end, orderByComparator, retrieveFromCache);
	}

	/**
	* Removes all the saml idp sp sessions from the database.
	*/
	public static void removeAll() {
		getPersistence().removeAll();
	}

	/**
	* Returns the number of saml idp sp sessions.
	*
	* @return the number of saml idp sp sessions
	*/
	public static int countAll() {
		return getPersistence().countAll();
	}

	public static SamlIdpSpSessionPersistence getPersistence() {
		return _serviceTracker.getService();
	}

	private static ServiceTracker<SamlIdpSpSessionPersistence, SamlIdpSpSessionPersistence> _serviceTracker;

	static {
		Bundle bundle = FrameworkUtil.getBundle(SamlIdpSpSessionPersistence.class);

		ServiceTracker<SamlIdpSpSessionPersistence, SamlIdpSpSessionPersistence> serviceTracker =
			new ServiceTracker<SamlIdpSpSessionPersistence, SamlIdpSpSessionPersistence>(bundle.getBundleContext(),
				SamlIdpSpSessionPersistence.class, null);

		serviceTracker.open();

		_serviceTracker = serviceTracker;
	}
}