/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.saml.persistence.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the SamlSpIdpConnection service. Represents a row in the &quot;SamlSpIdpConnection&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.saml.persistence.model.impl.SamlSpIdpConnectionModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.saml.persistence.model.impl.SamlSpIdpConnectionImpl</code>.
 * </p>
 *
 * @author Mika Koivisto
 * @see SamlSpIdpConnection
 * @generated
 */
@ProviderType
public interface SamlSpIdpConnectionModel
	extends AuditedModel, BaseModel<SamlSpIdpConnection>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a saml sp idp connection model instance should use the {@link SamlSpIdpConnection} interface instead.
	 */

	/**
	 * Returns the primary key of this saml sp idp connection.
	 *
	 * @return the primary key of this saml sp idp connection
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this saml sp idp connection.
	 *
	 * @param primaryKey the primary key of this saml sp idp connection
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the saml sp idp connection ID of this saml sp idp connection.
	 *
	 * @return the saml sp idp connection ID of this saml sp idp connection
	 */
	public long getSamlSpIdpConnectionId();

	/**
	 * Sets the saml sp idp connection ID of this saml sp idp connection.
	 *
	 * @param samlSpIdpConnectionId the saml sp idp connection ID of this saml sp idp connection
	 */
	public void setSamlSpIdpConnectionId(long samlSpIdpConnectionId);

	/**
	 * Returns the company ID of this saml sp idp connection.
	 *
	 * @return the company ID of this saml sp idp connection
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this saml sp idp connection.
	 *
	 * @param companyId the company ID of this saml sp idp connection
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the user ID of this saml sp idp connection.
	 *
	 * @return the user ID of this saml sp idp connection
	 */
	@Override
	public long getUserId();

	/**
	 * Sets the user ID of this saml sp idp connection.
	 *
	 * @param userId the user ID of this saml sp idp connection
	 */
	@Override
	public void setUserId(long userId);

	/**
	 * Returns the user uuid of this saml sp idp connection.
	 *
	 * @return the user uuid of this saml sp idp connection
	 */
	@Override
	public String getUserUuid();

	/**
	 * Sets the user uuid of this saml sp idp connection.
	 *
	 * @param userUuid the user uuid of this saml sp idp connection
	 */
	@Override
	public void setUserUuid(String userUuid);

	/**
	 * Returns the user name of this saml sp idp connection.
	 *
	 * @return the user name of this saml sp idp connection
	 */
	@AutoEscape
	@Override
	public String getUserName();

	/**
	 * Sets the user name of this saml sp idp connection.
	 *
	 * @param userName the user name of this saml sp idp connection
	 */
	@Override
	public void setUserName(String userName);

	/**
	 * Returns the create date of this saml sp idp connection.
	 *
	 * @return the create date of this saml sp idp connection
	 */
	@Override
	public Date getCreateDate();

	/**
	 * Sets the create date of this saml sp idp connection.
	 *
	 * @param createDate the create date of this saml sp idp connection
	 */
	@Override
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this saml sp idp connection.
	 *
	 * @return the modified date of this saml sp idp connection
	 */
	@Override
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this saml sp idp connection.
	 *
	 * @param modifiedDate the modified date of this saml sp idp connection
	 */
	@Override
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the saml idp entity ID of this saml sp idp connection.
	 *
	 * @return the saml idp entity ID of this saml sp idp connection
	 */
	@AutoEscape
	public String getSamlIdpEntityId();

	/**
	 * Sets the saml idp entity ID of this saml sp idp connection.
	 *
	 * @param samlIdpEntityId the saml idp entity ID of this saml sp idp connection
	 */
	public void setSamlIdpEntityId(String samlIdpEntityId);

	/**
	 * Returns the assertion signature required of this saml sp idp connection.
	 *
	 * @return the assertion signature required of this saml sp idp connection
	 */
	public boolean getAssertionSignatureRequired();

	/**
	 * Returns <code>true</code> if this saml sp idp connection is assertion signature required.
	 *
	 * @return <code>true</code> if this saml sp idp connection is assertion signature required; <code>false</code> otherwise
	 */
	public boolean isAssertionSignatureRequired();

	/**
	 * Sets whether this saml sp idp connection is assertion signature required.
	 *
	 * @param assertionSignatureRequired the assertion signature required of this saml sp idp connection
	 */
	public void setAssertionSignatureRequired(
		boolean assertionSignatureRequired);

	/**
	 * Returns the clock skew of this saml sp idp connection.
	 *
	 * @return the clock skew of this saml sp idp connection
	 */
	public long getClockSkew();

	/**
	 * Sets the clock skew of this saml sp idp connection.
	 *
	 * @param clockSkew the clock skew of this saml sp idp connection
	 */
	public void setClockSkew(long clockSkew);

	/**
	 * Returns the enabled of this saml sp idp connection.
	 *
	 * @return the enabled of this saml sp idp connection
	 */
	public boolean getEnabled();

	/**
	 * Returns <code>true</code> if this saml sp idp connection is enabled.
	 *
	 * @return <code>true</code> if this saml sp idp connection is enabled; <code>false</code> otherwise
	 */
	public boolean isEnabled();

	/**
	 * Sets whether this saml sp idp connection is enabled.
	 *
	 * @param enabled the enabled of this saml sp idp connection
	 */
	public void setEnabled(boolean enabled);

	/**
	 * Returns the force authn of this saml sp idp connection.
	 *
	 * @return the force authn of this saml sp idp connection
	 */
	public boolean getForceAuthn();

	/**
	 * Returns <code>true</code> if this saml sp idp connection is force authn.
	 *
	 * @return <code>true</code> if this saml sp idp connection is force authn; <code>false</code> otherwise
	 */
	public boolean isForceAuthn();

	/**
	 * Sets whether this saml sp idp connection is force authn.
	 *
	 * @param forceAuthn the force authn of this saml sp idp connection
	 */
	public void setForceAuthn(boolean forceAuthn);

	/**
	 * Returns the ldap import enabled of this saml sp idp connection.
	 *
	 * @return the ldap import enabled of this saml sp idp connection
	 */
	public boolean getLdapImportEnabled();

	/**
	 * Returns <code>true</code> if this saml sp idp connection is ldap import enabled.
	 *
	 * @return <code>true</code> if this saml sp idp connection is ldap import enabled; <code>false</code> otherwise
	 */
	public boolean isLdapImportEnabled();

	/**
	 * Sets whether this saml sp idp connection is ldap import enabled.
	 *
	 * @param ldapImportEnabled the ldap import enabled of this saml sp idp connection
	 */
	public void setLdapImportEnabled(boolean ldapImportEnabled);

	/**
	 * Returns the metadata updated date of this saml sp idp connection.
	 *
	 * @return the metadata updated date of this saml sp idp connection
	 */
	public Date getMetadataUpdatedDate();

	/**
	 * Sets the metadata updated date of this saml sp idp connection.
	 *
	 * @param metadataUpdatedDate the metadata updated date of this saml sp idp connection
	 */
	public void setMetadataUpdatedDate(Date metadataUpdatedDate);

	/**
	 * Returns the metadata url of this saml sp idp connection.
	 *
	 * @return the metadata url of this saml sp idp connection
	 */
	@AutoEscape
	public String getMetadataUrl();

	/**
	 * Sets the metadata url of this saml sp idp connection.
	 *
	 * @param metadataUrl the metadata url of this saml sp idp connection
	 */
	public void setMetadataUrl(String metadataUrl);

	/**
	 * Returns the metadata xml of this saml sp idp connection.
	 *
	 * @return the metadata xml of this saml sp idp connection
	 */
	@AutoEscape
	public String getMetadataXml();

	/**
	 * Sets the metadata xml of this saml sp idp connection.
	 *
	 * @param metadataXml the metadata xml of this saml sp idp connection
	 */
	public void setMetadataXml(String metadataXml);

	/**
	 * Returns the name of this saml sp idp connection.
	 *
	 * @return the name of this saml sp idp connection
	 */
	@AutoEscape
	public String getName();

	/**
	 * Sets the name of this saml sp idp connection.
	 *
	 * @param name the name of this saml sp idp connection
	 */
	public void setName(String name);

	/**
	 * Returns the name ID format of this saml sp idp connection.
	 *
	 * @return the name ID format of this saml sp idp connection
	 */
	@AutoEscape
	public String getNameIdFormat();

	/**
	 * Sets the name ID format of this saml sp idp connection.
	 *
	 * @param nameIdFormat the name ID format of this saml sp idp connection
	 */
	public void setNameIdFormat(String nameIdFormat);

	/**
	 * Returns the sign authn request of this saml sp idp connection.
	 *
	 * @return the sign authn request of this saml sp idp connection
	 */
	public boolean getSignAuthnRequest();

	/**
	 * Returns <code>true</code> if this saml sp idp connection is sign authn request.
	 *
	 * @return <code>true</code> if this saml sp idp connection is sign authn request; <code>false</code> otherwise
	 */
	public boolean isSignAuthnRequest();

	/**
	 * Sets whether this saml sp idp connection is sign authn request.
	 *
	 * @param signAuthnRequest the sign authn request of this saml sp idp connection
	 */
	public void setSignAuthnRequest(boolean signAuthnRequest);

	/**
	 * Returns the unknown users are strangers of this saml sp idp connection.
	 *
	 * @return the unknown users are strangers of this saml sp idp connection
	 */
	public boolean getUnknownUsersAreStrangers();

	/**
	 * Returns <code>true</code> if this saml sp idp connection is unknown users are strangers.
	 *
	 * @return <code>true</code> if this saml sp idp connection is unknown users are strangers; <code>false</code> otherwise
	 */
	public boolean isUnknownUsersAreStrangers();

	/**
	 * Sets whether this saml sp idp connection is unknown users are strangers.
	 *
	 * @param unknownUsersAreStrangers the unknown users are strangers of this saml sp idp connection
	 */
	public void setUnknownUsersAreStrangers(boolean unknownUsersAreStrangers);

	/**
	 * Returns the user attribute mappings of this saml sp idp connection.
	 *
	 * @return the user attribute mappings of this saml sp idp connection
	 */
	@AutoEscape
	public String getUserAttributeMappings();

	/**
	 * Sets the user attribute mappings of this saml sp idp connection.
	 *
	 * @param userAttributeMappings the user attribute mappings of this saml sp idp connection
	 */
	public void setUserAttributeMappings(String userAttributeMappings);

	/**
	 * Returns the user identifier expression of this saml sp idp connection.
	 *
	 * @return the user identifier expression of this saml sp idp connection
	 */
	@AutoEscape
	public String getUserIdentifierExpression();

	/**
	 * Sets the user identifier expression of this saml sp idp connection.
	 *
	 * @param userIdentifierExpression the user identifier expression of this saml sp idp connection
	 */
	public void setUserIdentifierExpression(String userIdentifierExpression);

	@Override
	public SamlSpIdpConnection cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}