/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.saml.persistence.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the SamlIbSloMessage service. Represents a row in the &quot;SamlIbSloMessage&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.saml.persistence.model.impl.SamlIbSloMessageModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.saml.persistence.model.impl.SamlIbSloMessageImpl</code>.
 * </p>
 *
 * @author Mika Koivisto
 * @see SamlIbSloMessage
 * @generated
 */
@ProviderType
public interface SamlIbSloMessageModel
	extends BaseModel<SamlIbSloMessage>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a saml ib slo message model instance should use the {@link SamlIbSloMessage} interface instead.
	 */

	/**
	 * Returns the primary key of this saml ib slo message.
	 *
	 * @return the primary key of this saml ib slo message
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this saml ib slo message.
	 *
	 * @param primaryKey the primary key of this saml ib slo message
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the saml ib slo message ID of this saml ib slo message.
	 *
	 * @return the saml ib slo message ID of this saml ib slo message
	 */
	public long getSamlIbSloMessageId();

	/**
	 * Sets the saml ib slo message ID of this saml ib slo message.
	 *
	 * @param samlIbSloMessageId the saml ib slo message ID of this saml ib slo message
	 */
	public void setSamlIbSloMessageId(long samlIbSloMessageId);

	/**
	 * Returns the company ID of this saml ib slo message.
	 *
	 * @return the company ID of this saml ib slo message
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this saml ib slo message.
	 *
	 * @param companyId the company ID of this saml ib slo message
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the create date of this saml ib slo message.
	 *
	 * @return the create date of this saml ib slo message
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this saml ib slo message.
	 *
	 * @param createDate the create date of this saml ib slo message
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the saml idp entity ID of this saml ib slo message.
	 *
	 * @return the saml idp entity ID of this saml ib slo message
	 */
	@AutoEscape
	public String getSamlIdpEntityId();

	/**
	 * Sets the saml idp entity ID of this saml ib slo message.
	 *
	 * @param samlIdpEntityId the saml idp entity ID of this saml ib slo message
	 */
	public void setSamlIdpEntityId(String samlIdpEntityId);

	/**
	 * Returns the logout request xml of this saml ib slo message.
	 *
	 * @return the logout request xml of this saml ib slo message
	 */
	@AutoEscape
	public String getLogoutRequestXml();

	/**
	 * Sets the logout request xml of this saml ib slo message.
	 *
	 * @param logoutRequestXml the logout request xml of this saml ib slo message
	 */
	public void setLogoutRequestXml(String logoutRequestXml);

	/**
	 * Returns the saml idp session index of this saml ib slo message.
	 *
	 * @return the saml idp session index of this saml ib slo message
	 */
	@AutoEscape
	public String getSamlIdpSessionIndex();

	/**
	 * Sets the saml idp session index of this saml ib slo message.
	 *
	 * @param samlIdpSessionIndex the saml idp session index of this saml ib slo message
	 */
	public void setSamlIdpSessionIndex(String samlIdpSessionIndex);

	@Override
	public SamlIbSloMessage cloneWithOriginalValues();

	public default String toXmlString() {
		return null;
	}

}