/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.transport;

import com.liferay.petra.concurrent.DCLSingleton;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.saml.opensaml.integration.internal.transport.configuration.HttpClientFactoryConfiguration;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.pool.PoolStats;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.liferay.saml.opensaml.integration.internal.transport.configuration.HttpClientFactoryConfiguration"}, service={HttpClientFactory.class})
public class HttpClientFactory {
    private static final Log _log = LogFactoryUtil.getLog(HttpClientFactory.class);
    private final DCLSingleton<CloseableHttpClient> _closeableHttpClientDCLSingleton = new DCLSingleton();
    private HttpClientFactoryConfiguration _httpClientFactoryConfiguration;
    private PoolingHttpClientConnectionManager _poolingClientConnectionManager;

    public HttpClient getHttpClient() {
        return (HttpClient)this._closeableHttpClientDCLSingleton.getSingleton(this::_createCloseableHttpClient);
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._httpClientFactoryConfiguration = (HttpClientFactoryConfiguration)ConfigurableUtil.createConfigurable(HttpClientFactoryConfiguration.class, properties);
    }

    @Deactivate
    protected void deactivate() {
        PoolStats poolStats;
        int availableConnections;
        this._closeableHttpClientDCLSingleton.destroy(closeableHttpClient -> {
            block2: {
                try {
                    closeableHttpClient.close();
                }
                catch (IOException ioException) {
                    if (!_log.isDebugEnabled()) break block2;
                    _log.debug((Throwable)ioException);
                }
            }
        });
        if (_log.isDebugEnabled()) {
            Class<?> clazz = this.getClass();
            _log.debug((Object)("Shutting down " + clazz.getName()));
        }
        if (this._poolingClientConnectionManager == null) {
            return;
        }
        for (int retry = 0; retry < 10 && (availableConnections = (poolStats = this._poolingClientConnectionManager.getTotalStats()).getAvailable()) > 0; ++retry) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((Object[])new Object[]{this.getClass().getName(), " is waiting on ", availableConnections, " connections"}));
            }
            this._poolingClientConnectionManager.closeIdleConnections(200L, TimeUnit.MILLISECONDS);
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)interruptedException);
            }
        }
        this._poolingClientConnectionManager.shutdown();
        this._poolingClientConnectionManager = null;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)(this.toString() + " was shut down"));
        }
    }

    private CloseableHttpClient _createCloseableHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        this._poolingClientConnectionManager = new PoolingHttpClientConnectionManager();
        this._poolingClientConnectionManager.setDefaultMaxPerRoute(this._httpClientFactoryConfiguration.defaultMaxConnectionsPerRoute());
        SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
        socketConfigBuilder.setSoTimeout(this._httpClientFactoryConfiguration.soTimeout());
        this._poolingClientConnectionManager.setDefaultSocketConfig(socketConfigBuilder.build());
        this._poolingClientConnectionManager.setMaxTotal(this._httpClientFactoryConfiguration.maxTotalConnections());
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this._poolingClientConnectionManager);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(this._httpClientFactoryConfiguration.connectionManagerTimeout());
        httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        return httpClientBuilder.build();
    }
}

