/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.helper;

import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.helper.SamlHttpRequestHelper;
import com.liferay.saml.opensaml.integration.internal.metadata.MetadataManagerUtil;
import com.liferay.saml.opensaml.integration.internal.util.OpenSamlUtil;
import com.liferay.saml.runtime.SamlException;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.metadata.LocalEntityManager;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.credential.CredentialResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SamlHttpRequestHelper.class})
public class SamlHttpRequestHelperImpl
implements SamlHttpRequestHelper {
    @Reference
    private CredentialResolver _credentialResolver;
    @Reference
    private LocalEntityManager _localEntityManager;
    @Reference
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;

    public String getEntityDescriptorString(HttpServletRequest httpServletRequest) throws SamlException {
        try {
            return OpenSamlUtil.marshall((XMLObject)MetadataManagerUtil.getEntityDescriptor(httpServletRequest, this._samlProviderConfigurationHelper, this._credentialResolver, this._localEntityManager));
        }
        catch (Exception exception) {
            throw new SamlException((Throwable)exception);
        }
    }

    public String getRequestPath(HttpServletRequest httpServletRequest) {
        String requestURI = httpServletRequest.getRequestURI();
        String contextPath = httpServletRequest.getContextPath();
        if (Validator.isNotNull((String)contextPath) && !contextPath.equals("/")) {
            requestURI = requestURI.substring(contextPath.length());
        }
        return HttpComponentsUtil.removePathParameters((String)requestURI);
    }
}

