/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.portal.kernel.bean.BeanProperties;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.opensaml.integration.resolver.NameIdResolver;
import com.liferay.saml.persistence.model.SamlIdpSpConnection;
import com.liferay.saml.persistence.service.SamlIdpSpConnectionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=-2147483648"}, service={NameIdResolver.class})
public class DefaultNameIdResolver
implements NameIdResolver {
    private static final Log _log = LogFactoryUtil.getLog(DefaultNameIdResolver.class);
    @Reference
    private BeanProperties _beanProperties;
    @Reference
    private SamlIdpSpConnectionLocalService _samlIdpSpConnectionLocalService;

    @Override
    public String resolve(User user, String entityId, String format, String spQualifierName, boolean allowCreate, NameIdResolver.NameIdResolverSAMLContext nameIdResolverSAMLContext) {
        return this._getNameIdValue(user, entityId);
    }

    protected String getNameIdAttributeName(String entityId) {
        String nameIdAttributeName;
        block3: {
            long companyId = CompanyThreadLocal.getCompanyId();
            nameIdAttributeName = "";
            try {
                SamlIdpSpConnection samlIdpSpConnection = this._samlIdpSpConnectionLocalService.getSamlIdpSpConnection(companyId, entityId);
                nameIdAttributeName = samlIdpSpConnection.getNameIdAttribute();
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
        if (Validator.isNotNull((String)nameIdAttributeName)) {
            return nameIdAttributeName;
        }
        return "emailAddress";
    }

    private String _getNameIdValue(User user, String entityId) {
        String nameIdAttributeName = this.getNameIdAttributeName(entityId);
        if (Validator.isNull((String)nameIdAttributeName)) {
            return user.getEmailAddress();
        }
        if (nameIdAttributeName.startsWith("expando:")) {
            String attributeName = nameIdAttributeName.substring(8);
            ExpandoBridge expandoBridge = user.getExpandoBridge();
            return this._toString(expandoBridge.getAttribute(attributeName));
        }
        if (nameIdAttributeName.startsWith("static:")) {
            return nameIdAttributeName.substring(7);
        }
        return this._toString(this._beanProperties.getObject((Object)user, nameIdAttributeName));
    }

    private String _toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

