/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.resolver;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.exportimport.UserImporter;
import com.liferay.saml.opensaml.integration.field.expression.handler.UserFieldExpressionHandler;
import com.liferay.saml.opensaml.integration.field.expression.handler.registry.UserFieldExpressionHandlerRegistry;
import com.liferay.saml.opensaml.integration.field.expression.resolver.UserFieldExpressionResolver;
import com.liferay.saml.opensaml.integration.field.expression.resolver.registry.UserFieldExpressionResolverRegistry;
import com.liferay.saml.opensaml.integration.internal.metadata.MetadataManager;
import com.liferay.saml.opensaml.integration.processor.UserProcessor;
import com.liferay.saml.opensaml.integration.processor.factory.UserProcessorFactory;
import com.liferay.saml.opensaml.integration.resolver.UserResolver;
import com.liferay.saml.persistence.model.SamlPeerBinding;
import com.liferay.saml.persistence.model.SamlSpIdpConnection;
import com.liferay.saml.persistence.service.SamlPeerBindingLocalService;
import com.liferay.saml.persistence.service.SamlSpIdpConnectionLocalService;
import com.liferay.saml.runtime.configuration.SamlProviderConfigurationHelper;
import com.liferay.saml.runtime.exception.SubjectException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-2147483648"}, service={UserResolver.class})
public class DefaultUserResolver
implements UserResolver {
    private static final Log _log = LogFactoryUtil.getLog(DefaultUserResolver.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private MetadataManager _metadataManager;
    @Reference
    private SamlPeerBindingLocalService _samlPeerBindingLocalService;
    @Reference
    private SamlProviderConfigurationHelper _samlProviderConfigurationHelper;
    @Reference
    private SamlSpIdpConnectionLocalService _samlSpIdpConnectionLocalService;
    @Reference
    private UserFieldExpressionHandlerRegistry _userFieldExpressionHandlerRegistry;
    @Reference
    private UserFieldExpressionResolverRegistry _userFieldExpressionResolverRegistry;
    @Reference
    private UserImporter _userImporter;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private UserProcessorFactory _userProcessorFactory;

    @Override
    public User resolveUser(UserResolver.UserResolverSAMLContext userResolverSAMLContext, ServiceContext serviceContext) throws Exception {
        String subjectNameFormat = userResolverSAMLContext.resolveSubjectNameFormat();
        if (_log.isDebugEnabled()) {
            String subjectNameIdentifier = userResolverSAMLContext.resolveSubjectNameIdentifier();
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Resolving user with name ID format ", subjectNameFormat, " and value ", subjectNameIdentifier}));
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        SamlSpIdpConnection samlSpIdpConnection = this._samlSpIdpConnectionLocalService.getSamlSpIdpConnection(companyId, userResolverSAMLContext.resolvePeerEntityId());
        subjectNameFormat = this._getNameIdFormat(userResolverSAMLContext, samlSpIdpConnection.getNameIdFormat());
        return this._importUser(companyId, samlSpIdpConnection, userResolverSAMLContext.resolveSubjectNameIdentifier(), subjectNameFormat, userResolverSAMLContext, serviceContext);
    }

    private User _addUser(long companyId, SamlSpIdpConnection samlSpIdpConnection, Map<String, List<Serializable>> attributesMap, ServiceContext serviceContext) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Adding user with attributes map " + MapUtil.toString(attributesMap)));
        }
        Company company = this._companyLocalService.getCompany(companyId);
        String emailAddress = this._getValueAsString("emailAddress", attributesMap);
        if (samlSpIdpConnection.isUnknownUsersAreStrangers()) {
            if (!company.isStrangers()) {
                throw new SubjectException("User is a stranger and company " + companyId + " does not allow strangers to create accounts");
            }
            if (Validator.isNotNull((String)emailAddress) && !company.isStrangersWithMx() && company.hasCompanyMx(emailAddress)) {
                throw new UserEmailAddressException.MustNotUseCompanyMx(emailAddress);
            }
        }
        User user = this._userLocalService.createUser(0L);
        user.setCompanyId(companyId);
        user = this._processUser(user, attributesMap, serviceContext);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Added user " + user.toString()));
        }
        return user;
    }

    private Map<String, List<Serializable>> _getAttributesMap(SamlSpIdpConnection samlSpIdpConnection, UserResolver.UserResolverSAMLContext userResolverSAMLContext) {
        try {
            return userResolverSAMLContext.resolveBearerAssertionAttributesWithMapping(samlSpIdpConnection.getNormalizedUserAttributeMappings());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception.getMessage(), (Throwable)exception);
            } else if (_log.isWarnEnabled()) {
                _log.warn((Object)exception.getMessage());
            }
            return Collections.emptyMap();
        }
    }

    private String _getNameIdFormat(UserResolver.UserResolverSAMLContext userResolverSAMLContext, String defaultNameIdFormat) {
        String format = userResolverSAMLContext.resolveSubjectNameFormat();
        if (Validator.isNull((String)format)) {
            format = defaultNameIdFormat;
        }
        return format;
    }

    private String _getPrefix(String userFieldExpression) {
        if (userFieldExpression == null) {
            return null;
        }
        int prefixEndIndex = userFieldExpression.indexOf(58);
        if (prefixEndIndex == -1) {
            return "";
        }
        return userFieldExpression.substring(0, prefixEndIndex);
    }

    private UserFieldExpressionResolver _getUserFieldExpressionResolver(String userIdentifierExpression) {
        String userFieldExpressionResolverKey = this._getPrefix(userIdentifierExpression);
        if (Validator.isBlank((String)userFieldExpressionResolverKey)) {
            userFieldExpressionResolverKey = userIdentifierExpression;
        }
        return this._userFieldExpressionResolverRegistry.getUserFieldExpressionResolver(userFieldExpressionResolverKey);
    }

    private String _getValueAsString(String key, Map<String, List<Serializable>> attributesMap) {
        List<Serializable> values = attributesMap.get(key);
        if (ListUtil.isEmpty(values)) {
            return null;
        }
        return String.valueOf(values.get(0));
    }

    private User _importUser(long companyId, SamlSpIdpConnection samlSpIdpConnection, String subjectNameIdentifier, String nameIdFormat, UserResolver.UserResolverSAMLContext userResolverSAMLContext, ServiceContext serviceContext) throws Exception {
        User user;
        Map<String, List<Serializable>> attributesMap;
        UserFieldExpressionResolver userFieldExpressionResolver = this._getUserFieldExpressionResolver(samlSpIdpConnection.getUserIdentifierExpression());
        String userFieldExpression = this._removePrefix("", GetterUtil.getString((String)userFieldExpressionResolver.resolveUserFieldExpression(attributesMap = this._getAttributesMap(samlSpIdpConnection, userResolverSAMLContext), userResolverSAMLContext)));
        if (Validator.isBlank((String)userFieldExpression)) {
            User user2;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"User field expression is null");
            }
            if ((user2 = this._resolveByNameId(companyId, nameIdFormat, userResolverSAMLContext.resolveSubjectNameQualifier(), subjectNameIdentifier, userResolverSAMLContext.resolvePeerEntityId())) != null) {
                return this._updateUser(user2, attributesMap, serviceContext);
            }
            return null;
        }
        String searchFieldValue = subjectNameIdentifier;
        if (attributesMap.containsKey(userFieldExpression)) {
            searchFieldValue = this._getValueAsString(userFieldExpression, attributesMap);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"User identifier expression is mapped to SAML ", "attribute value \"", searchFieldValue, "\""}));
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Resolving user using subject naming identifier ", subjectNameIdentifier, " and name ID format ", nameIdFormat}));
        }
        String prefix = this._getPrefix(userFieldExpression);
        UserFieldExpressionHandler userFieldExpressionHandler = this._userFieldExpressionHandlerRegistry.getFieldExpressionHandler(prefix);
        if (Validator.isNotNull((String)userFieldExpression) && this._samlProviderConfigurationHelper.isLDAPImportEnabled() && (user = userFieldExpressionHandler.getLdapUser(companyId, searchFieldValue, this._removePrefix(prefix, userFieldExpression))) != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Matched and imported LDAP user " + user.toString()));
            }
            return user;
        }
        user = this._resolveByNameId(companyId, nameIdFormat, userResolverSAMLContext.resolveSubjectNameQualifier(), subjectNameIdentifier, userResolverSAMLContext.resolvePeerEntityId());
        if (user == null) {
            user = userFieldExpressionHandler.getUser(companyId, searchFieldValue, this._removePrefix(prefix, userFieldExpression));
        }
        if (user == null) {
            return this._addUser(companyId, samlSpIdpConnection, attributesMap, serviceContext);
        }
        return this._updateUser(user, attributesMap, serviceContext);
    }

    private User _processUser(User user, Map<String, List<Serializable>> attributesMap, ServiceContext serviceContext) throws Exception {
        UserProcessor userProcessor = this._userProcessorFactory.create(user, this._userFieldExpressionHandlerRegistry);
        for (String key : attributesMap.keySet()) {
            userProcessor.setValueArray(key, new String[]{this._getValueAsString(key, attributesMap)});
        }
        return (User)userProcessor.process(serviceContext);
    }

    private String _removePrefix(String prefix, String prefixedUserFieldExpression) {
        if (prefixedUserFieldExpression.length() > prefix.length() && prefixedUserFieldExpression.charAt(prefix.length()) == ':' && prefixedUserFieldExpression.startsWith(prefix)) {
            return prefixedUserFieldExpression.substring(prefix.length() + 1);
        }
        return prefixedUserFieldExpression;
    }

    private User _resolveByNameId(long companyId, String subjectNameFormat, String subjectNameQualifier, String subjectNameIdentifier, String samlIdpEntityId) {
        SamlPeerBinding samlPeerBinding = this._samlPeerBindingLocalService.fetchSamlPeerBinding(companyId, subjectNameFormat, subjectNameQualifier, subjectNameIdentifier, samlIdpEntityId);
        if (samlPeerBinding != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Matched known subject name identifier ", subjectNameIdentifier, " of subject name format ", subjectNameFormat, " with subject name qualifier \"", subjectNameQualifier, "\" for SAML IDP entity ID ", samlIdpEntityId}));
            }
            return this._userLocalService.fetchUserById(samlPeerBinding.getUserId());
        }
        return null;
    }

    private User _updateUser(User user, Map<String, List<Serializable>> attributesMap, ServiceContext serviceContext) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Updating user ", user.getUserId(), " with attributes map ", MapUtil.toString(attributesMap)}));
        }
        return this._processUser(user, attributesMap, serviceContext);
    }
}

