/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.opensaml.integration.internal.identifier;

import com.google.common.escape.Escaper;
import com.google.common.xml.XmlEscapers;
import com.liferay.portal.kernel.security.SecureRandom;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import com.liferay.saml.opensaml.integration.internal.servlet.profile.IdentifierGenerationStrategyFactory;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={IdentifierGenerationStrategyFactory.class})
public class SamlIdentifierGeneratorStrategyFactory
implements IdentifierGenerationStrategyFactory {
    @Override
    public IdentifierGenerationStrategy create(final int length) {
        return new IdentifierGenerationStrategy(){
            private final SecureRandom _secureRandom = new SecureRandom();

            @Override
            @Nonnull
            public String generateIdentifier() {
                return this.generateIdentifier(length, false);
            }

            @Override
            @Nonnull
            public String generateIdentifier(boolean xmlSafe) {
                return this.generateIdentifier(length, xmlSafe);
            }

            public String generateIdentifier(int size, boolean xmlSafe) {
                byte[] bytes = new byte[size];
                this._secureRandom.nextBytes(bytes);
                String identifier = "_".concat(UnicodeFormatter.bytesToHex((byte[])bytes));
                if (xmlSafe) {
                    Escaper escaper = XmlEscapers.xmlAttributeEscaper();
                    return escaper.escape(identifier);
                }
                return identifier;
            }
        };
    }
}

